/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.orbit.term.TermMapCsv;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class TermMapCsvImport {
    private static final String NET_STR = "Net";
    private static final String TERM_STR = "Term";
    private final DeviceTemplate mDevT;
    private boolean mIsCreateNonExist = true;

    public TermMapCsvImport(DeviceTemplate devT) {
        this.mDevT = devT;
    }

    public void setIsCreateNonExist(boolean b) {
        this.mIsCreateNonExist = b;
    }

    public void importCsv(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            for (File f : file.listFiles((FileFilter)AFileFilter.CSV)) {
                this.importCsv(f);
            }
        } else if (file.isFile()) {
            this.importCsv(file);
        }
    }

    private void importCsv(File f) {
        assert (f.isFile());
        try {
            CSVDOMParser parser2 = new CSVDOMParser(true, null);
            CSVDocument csvDoc = parser2.parse(f.getPath());
            if (!parser2.validateHeader(TermMapCsv.CsvHeader.getHeader())) {
                ALog.logError((String)"Unexpected header in input file %s.", (Object[])new Object[]{f});
                ALog.logError((String)"Header should be %s", (Object[])new Object[]{Arrays.toString(TermMapCsv.CsvHeader.getHeader())});
                return;
            }
            for (int i = 0; i != csvDoc.getItemCount(); ++i) {
                this.createTerm(csvDoc, i);
            }
            ALog.logInfo((String)"Import term map complete.");
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problems reading %s", (Object[])new Object[]{f});
        }
    }

    private void createTerm(CSVDocument csvDoc, int index) {
        String childDevName = csvDoc.getItemValue(index, TermMapCsv.CsvHeader.CHILD_DEVICE.getCsvAttributeName());
        String parentNetName = csvDoc.getItemValue(index, TermMapCsv.CsvHeader.PARENT_NET.getCsvAttributeName());
        String childTermName = csvDoc.getItemValue(index, TermMapCsv.CsvHeader.CHILD_TERM.getCsvAttributeName());
        Device childDev = this.getOrCreateChildDev(childDevName);
        APair<Boolean, Term> childTermInfo = this.getOrCreateChildTerm(childDev, childTermName);
        APair<Boolean, Net> parentNetInfo = this.getOrCreateParentNet(parentNetName);
        if (childTermInfo == null || parentNetInfo == null) {
            return;
        }
        boolean isCreateChildTerm = (Boolean)childTermInfo.getFirst();
        Term childTerm = (Term)childTermInfo.getSecond();
        boolean isCreateParentNet = (Boolean)parentNetInfo.getFirst();
        Net parentNet = (Net)parentNetInfo.getSecond();
        if (isCreateChildTerm && !isCreateParentNet) {
            childTerm.syncAttribute(parentNet);
        } else if (!isCreateChildTerm && isCreateParentNet) {
            parentNet.setUse(Net.Use.get((Term.Use)childTerm.getUse()));
            parentNet.setDirection(Net.Direction.get((Term.Type)childTerm.getType()));
        }
        if (childTerm != null && parentNet != null) {
            TermMap.mapChildTerm((Device)childDev, (Term)childTerm, (Net)parentNet);
        }
    }

    public Device getOrCreateChildDev(String childDevName) {
        if (childDevName == null || childDevName.isEmpty()) {
            return null;
        }
        Device childDev = this.mDevT.getChild(childDevName);
        if (childDev == null) {
            ALog.flogWarn((String)"Create the child device '%s'", (Object[])new Object[]{childDevName});
            return this.createChildDev(childDevName);
        }
        return childDev;
    }

    public Device createChildDev(String childDevName) {
        DeviceTemplate childDevT = DeviceTemplate.create((Substrate)this.mDevT.getSubstrate(), (String)childDevName, (boolean)true);
        return Device.create((String)childDevName, (DeviceTemplate)childDevT, (DeviceTemplate)this.mDevT);
    }

    private APair<Boolean, Term> getOrCreateChildTerm(Device childDev, String childTermName) {
        if (childDev == null || childTermName == null || childTermName.isEmpty()) {
            return null;
        }
        Term childTerm = childDev.getTerm(childTermName);
        if (childTerm != null) {
            return APair.create((Object)false, (Object)childTerm);
        }
        if (this.mIsCreateNonExist) {
            return APair.create((Object)true, (Object)this.createChildTerm(childDev, childTermName));
        }
        TermMapCsvImport.flogErrorNonExist(TERM_STR, childTermName, childDev.getName());
        return null;
    }

    private Term createChildTerm(Device childDev, String childTermName) {
        return Term.create((String)childTermName, (DeviceTemplate)childDev.getTemplate());
    }

    private APair<Boolean, Net> getOrCreateParentNet(String parentNetName) {
        if (parentNetName == null || parentNetName.isEmpty()) {
            return null;
        }
        Net parentNet = this.mDevT.getNet(parentNetName);
        if (parentNet != null) {
            return APair.create((Object)false, (Object)parentNet);
        }
        if (this.mIsCreateNonExist) {
            return APair.create((Object)true, (Object)this.createParentNet(parentNetName));
        }
        TermMapCsvImport.flogErrorNonExist(NET_STR, parentNetName, this.mDevT.getName());
        return null;
    }

    private Net createParentNet(String parentNetName) {
        return this.mDevT.createNet(parentNetName);
    }

    private static void flogErrorNonExist(String typeStr, String itemName, String ownerName) {
        ALog.flogError((String)"%s '%s' does not exist in the child device '%s'", (Object[])new Object[]{typeStr, itemName, ownerName});
    }
}

