/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Dimension;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javax.swing.SwingUtilities;

public class TermCreateUI
extends AJFXDesignDialog {
    private static final String TITLE = "Create Term";
    private static final String INVALID_NAME_WARNING_MASSAGE = "A Term name must be sequence of letters(1-9), digits(a-z, A-Z), dollar signs($), and underscores(_). And, The first character must be a letter or an underscore. Use square brackets[] for a bus term.";
    private static final String EXISTING_NAME_WARNING_MASSAGE = "Term name already exists";
    private Net mNet;

    public static TermCreateUI showUI(Window owner, Net devT) {
        TermCreateUI dlg = new TermCreateUI(owner, devT);
        dlg.setVisible(true);
        return dlg;
    }

    protected TermCreateUI(Window owner, Net devT) {
        super(devT.getDb(), owner, TITLE);
        this.mNet = devT;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new TermCreatePanel();
    }

    private class TermCreatePanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 300;
        private static final int PANEL_HEIGHT = 150;
        private TextField mNameTxtField;
        EventHandler<ActionEvent> mOkHandler = e -> {
            String name = this.mNameTxtField.getText();
            String warnMsg = null;
            if (!Term.isValidName((String)name)) {
                warnMsg = TermCreateUI.INVALID_NAME_WARNING_MASSAGE;
            } else if (TermCreateUI.this.mNet.getDeviceTemplate().getTerm(name) != null) {
                warnMsg = TermCreateUI.EXISTING_NAME_WARNING_MASSAGE;
            }
            if (warnMsg != null) {
                String headerTxt = "Invalid Term Name";
                String contactTxt = String.format("Invalid term name %s.", name);
                AJFXAlerts.showErrorAlert((Window)TermCreateUI.this.getOwner(), (String)TermCreateUI.TITLE, (String)headerTxt, (String)contactTxt);
                return;
            }
            SwingUtilities.invokeLater(() -> {
                try (DbHistory.DbTransaction transaction = DbHistory.newDbTransaction((Db)TermCreateUI.this.getDb(), (String)TermCreateUI.TITLE);){
                    Cp.exec((String)"com.sigrity.acl.db.std.Term.create(\"%s\", %s)", (Object[])new Object[]{name, CpHelper.getObjCmdStr(TermCreateUI.this.mNet)});
                    DbExplorerPanel.refreshAll();
                    ALog.logInfo((String)"Create a term '%s' on net '%s' in '%s'", (Object[])new Object[]{name, TermCreateUI.this.mNet.getName(), TermCreateUI.this.mNet.getDeviceTemplate().getName()});
                }
                UIUtil.closeWindow((Window)((Object)TermCreateUI.this));
            });
        };

        public TermCreatePanel() {
            this.setPreferredSize(new Dimension(300, 150));
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            Label nameLabel = new Label("Term Name:");
            grid.add((Node)nameLabel, 0, 2);
            this.mNameTxtField = new TextField(TermCreateUI.this.mNet.getName());
            GridPane.setHgrow((Node)this.mNameTxtField, (Priority)Priority.ALWAYS);
            grid.add((Node)this.mNameTxtField, 1, 2);
            Label devTLabel = new Label("DeviceTemplate:");
            grid.add((Node)devTLabel, 0, 0);
            TextField devTTxtField = new TextField(TermCreateUI.this.mNet.getDeviceTemplate().getName());
            devTTxtField.setDisable(true);
            GridPane.setHgrow((Node)devTTxtField, (Priority)Priority.ALWAYS);
            grid.add((Node)devTTxtField, 1, 0);
            Label netLabel = new Label("Net:");
            grid.add((Node)netLabel, 0, 1);
            TextField netTxtField = new TextField(TermCreateUI.this.mNet.getName());
            netTxtField.setDisable(true);
            GridPane.setHgrow((Node)netTxtField, (Priority)Priority.ALWAYS);
            grid.add((Node)netTxtField, 1, 1);
            pane.setTop((Node)grid);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)TermCreateUI.this), this.mOkHandler);
            pane.setBottom((Node)okCancelHBox);
            return pane;
        }
    }
}

