/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class TermListExportUI {
    public static Action getAction(Device dev) {
        return TermListExportUI.getAction(dev.getTemplate());
    }

    public static Action getAction(final DeviceTemplate devT) {
        return new AbstractAction("Export Term List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermListExportUI.showUI(devT);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(DeviceTemplate devT) {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Export Term List");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fcFilePath = fc.getSelectedFile();
        if (fcFilePath == null) {
            return;
        }
        String fileName = fcFilePath.getPath();
        TermListExportUI.exportTermList(devT, fileName);
    }

    private static void exportTermList(DeviceTemplate devT, String fileName) {
        Cp.exec((String)"unset(\"_termListExport\");", (Object[])new Object[0]);
        Cp.exec((String)"_devT = curDb().getByKeyStr(DeviceTemplate.class, \"%s\");", (Object[])new Object[]{devT.getKeyStr()});
        Cp.exec((String)"_termListExport = new com.sigrity.orbit.term.TermListExport(_devT);", (Object[])new Object[0]);
        Cp.exec((String)"_termListExport.exportCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName)});
        Cp.exec((String)"unset(\"_termListExport\");", (Object[])new Object[0]);
    }

    private TermListExportUI() {
    }
}

