/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class TermListImportUI {
    public static Action getAction(Device dev) {
        return TermListImportUI.getAction(dev.getTemplate());
    }

    public static Action getAction(final DeviceTemplate devT) {
        return new AbstractAction("Import Term List"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermListImportUI.showUI(devT);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(DeviceTemplate devT) {
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileFilter((FileFilter)AFileFilter.CSV);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        fc.setDialogTitle("Import Term List");
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File[] fcFilesPath = fc.getSelectedFiles();
        if (fcFilesPath == null) {
            return;
        }
        for (File file : fcFilesPath) {
            String fileName = file.getPath();
            TermListImportUI.importTermList(devT, fileName);
        }
    }

    private static void importTermList(DeviceTemplate devT, String fileName) {
        Cp.exec((String)"unset(\"_termListImport\");", (Object[])new Object[0]);
        Cp.exec((String)"_devT = curDb().getByKeyStr(DeviceTemplate.class, \"%s\");", (Object[])new Object[]{devT.getKeyStr()});
        Cp.exec((String)"_termListImport = new com.sigrity.orbit.term.TermListImport(_devT);", (Object[])new Object[0]);
        Cp.exec((String)"_termListImport.importCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName)});
        Cp.exec((String)"unset(\"_termListImport\");", (Object[])new Object[0]);
    }

    private TermListImportUI() {
    }
}

