/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class TermMapCsvImportUI
extends DbDialog {
    private static final String TITLE = "Import Term Map";
    private final DeviceTemplate mDevT;
    private AFileChooserControl mFileChooserControl;
    private ExportOptionsPanel mExportOptionsPnl;

    public static Action getAction(Device dev) {
        return TermMapCsvImportUI.getAction(dev.getTemplate());
    }

    public static Action getAction(final DeviceTemplate devT) {
        return new AbstractAction(TITLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermMapCsvImportUI.showUI(OrbitIO.getMainWindow(), devT);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static void showUI(Window owner, DeviceTemplate devT) {
        TermMapCsvImportUI dlg = new TermMapCsvImportUI(owner, devT);
        dlg.setVisible(true);
    }

    private TermMapCsvImportUI(Window owner, DeviceTemplate devPath) {
        super(devPath.getDb(), (Component)owner, TITLE, Dialog.ModalityType.DOCUMENT_MODAL);
        this.mDevT = devPath;
        this.initUI();
    }

    private void initUI() {
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.pushFill("Source");
        l.add("File:");
        this.mFileChooserControl = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX);
        this.mFileChooserControl.addChoosableFileFilter(AFileFilter.CSV);
        this.mFileChooserControl.setMultiple(true);
        this.mFileChooserControl.setFileSelectionMode(2);
        l.newline();
        l.popNl();
        this.mExportOptionsPnl = new ExportOptionsPanel();
        l.pushFillX("Options");
        l.add((Component)this.mExportOptionsPnl, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.pop();
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(this.getOkActionListener());
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        l.pop();
        this.pack();
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    private ActionListener getOkActionListener() {
        return e -> {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.getDb(), (String)TITLE);){
                for (String path : this.mFileChooserControl.getPaths()) {
                    Cp.exec((String)"unset(\"_termMapCsvImport\");", (Object[])new Object[0]);
                    Cp.exec((String)"_termMapCsvImport = new com.sigrity.orbit.term.TermMapCsvImport(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(this.mDevT)});
                    Cp.exec((String)"_termMapCsvImport.setIsCreateNonExist(%b)", (Object[])new Object[]{this.mExportOptionsPnl.isCreateNonExist()});
                    Cp.exec((String)"_termMapCsvImport.importCsv(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
                    Cp.exec((String)"unset(\"_termMapCsvImport\");", (Object[])new Object[0]);
                }
            }
            UIUtil.closeWindow((Window)((Object)this));
        };
    }

    private static class ExportOptionsPanel
    extends JPanel {
        private JCheckBox mCreateNonExist;

        public ExportOptionsPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mCreateNonExist = (JCheckBox)l.add((Component)new JCheckBox("Create non-existent nets/terms"), (GridBagConstraints)GridBagManager.LEFT.noInsets());
            this.mCreateNonExist.setSelected(true);
            l.newline();
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean isCreateNonExist() {
            return this.mCreateNonExist.isSelected();
        }
    }
}

