/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.term.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.jfxui.AJFXAlerts;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Dimension;
import java.awt.Window;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javax.swing.SwingUtilities;

public class TermRenameUI
extends AJFXDesignDialog {
    private static final String TITLE = "Rename Term";
    private static final String INVALID_NAME_WARNING_MASSAGE = "A Term name must be sequence of letters(1-9), digits(a-z, A-Z), dollar signs($), and underscores(_). And, The first character must be a letter or an underscore. Use square brackets[] for a bus term.";
    private static final String EXISTING_NAME_WARNING_MASSAGE = "Term name already exists";
    private Term mTerm;
    private final String mCurrentName;

    public static TermRenameUI showUI(Window owner, Term devT) {
        TermRenameUI dlg = new TermRenameUI(owner, devT);
        dlg.setVisible(true);
        return dlg;
    }

    protected TermRenameUI(Window owner, Term term) {
        super(term.getDb(), owner, TITLE);
        this.mTerm = term;
        this.mCurrentName = term.getName();
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new TermCreatePanel();
    }

    private class TermCreatePanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 300;
        private static final int PANEL_HEIGHT = 120;
        private TextField mNameTxtField;
        EventHandler<ActionEvent> mOkHandler = e -> {
            String name = this.mNameTxtField.getText();
            String warnMsg = null;
            if (!Term.isValidName((String)name)) {
                warnMsg = TermRenameUI.INVALID_NAME_WARNING_MASSAGE;
            } else if (TermRenameUI.this.mTerm.getDeviceTemplate().getTerm(name) != null) {
                warnMsg = TermRenameUI.EXISTING_NAME_WARNING_MASSAGE;
            }
            if (warnMsg != null) {
                String headerTxt = "Invalid Term Name";
                String contactTxt = String.format("Invalid term name %s.", name);
                AJFXAlerts.showErrorAlert((Window)TermRenameUI.this.getOwner(), (String)TermRenameUI.TITLE, (String)headerTxt, (String)contactTxt);
                return;
            }
            SwingUtilities.invokeLater(() -> {
                ALog.logInfo((String)"Rename term from '%s' to '%s'.", (Object[])new Object[]{TermRenameUI.this.mTerm.getName(), name});
                Cp.exec((String)"%s.setName(\"%s\")", (Object[])new Object[]{CpHelper.getObjCmdStr(TermRenameUI.this.mTerm), name});
                DbExplorerPanel.refreshAll();
                UIUtil.closeWindow((Window)((Object)TermRenameUI.this));
            });
        };

        public TermCreatePanel() {
            this.setPreferredSize(new Dimension(300, 120));
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            GridPane grid = new GridPane();
            grid.setHgap(10.0);
            grid.setVgap(10.0);
            Label nameLabel = new Label("New Name:");
            grid.add((Node)nameLabel, 0, 1);
            this.mNameTxtField = new TextField(TermRenameUI.this.mCurrentName);
            GridPane.setHgrow((Node)this.mNameTxtField, (Priority)Priority.ALWAYS);
            grid.add((Node)this.mNameTxtField, 1, 1);
            Label netLabel = new Label("Current Name:");
            grid.add((Node)netLabel, 0, 0);
            TextField netTxtField = new TextField(TermRenameUI.this.mCurrentName);
            netTxtField.setDisable(true);
            GridPane.setHgrow((Node)netTxtField, (Priority)Priority.ALWAYS);
            grid.add((Node)netTxtField, 1, 0);
            pane.setTop((Node)grid);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)TermRenameUI.this), this.mOkHandler);
            pane.setBottom((Node)okCancelHBox);
            return pane;
        }
    }
}

