/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.test;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.util.LinkedHashMap;
import java.util.Map;

public class ViewColorizerDiff {
    private final ViewColorizer a;
    private final ViewColorizer b;

    public ViewColorizerDiff(ViewColorizer a, ViewColorizer b) {
        this.a = a;
        this.b = b;
    }

    private static Map<String, ViewColorizer.LayerKey> getLayerKeyMap(ViewColorizer t) {
        LinkedHashMap<String, ViewColorizer.LayerKey> aLayerKeys = new LinkedHashMap<String, ViewColorizer.LayerKey>();
        for (ViewColorizer.LayerKey lkey : t.getLayerKeys()) {
            aLayerKeys.put(lkey.asString(), lkey);
        }
        return aLayerKeys;
    }

    private static Map<String, ViewColorizer.Key> getColorKeyMap(ViewColorizer t) {
        LinkedHashMap<String, ViewColorizer.Key> aKeys = new LinkedHashMap<String, ViewColorizer.Key>();
        for (ViewColorizer.Key lkey : t.getColorKeys()) {
            aKeys.put(lkey.asString(), lkey);
        }
        return aKeys;
    }

    public boolean sameColor() {
        return this.sameLayerKeys() && this.sameOtherKeys();
    }

    public boolean sameVisible() {
        return this.sameVisibility();
    }

    private boolean sameLayerKeys() {
        Map<String, ViewColorizer.LayerKey> aLayerKeys = ViewColorizerDiff.getLayerKeyMap(this.a);
        Map<String, ViewColorizer.LayerKey> bLayerKeys = ViewColorizerDiff.getLayerKeyMap(this.b);
        ViewColorizer.DisplayInfoMap aInfoMap = this.a.getDisplayInfoMap();
        ViewColorizer.DisplayInfoMap bInfoMap = this.b.getDisplayInfoMap();
        for (Map.Entry<String, ViewColorizer.LayerKey> e : aLayerKeys.entrySet()) {
            if (!bLayerKeys.containsKey(e.getKey())) {
                ALog.flogWarn((String)"Layer Key '%s' was removed", (Object[])new Object[]{e.getKey()});
                return false;
            }
            ViewColorizer.LayerKey aKey = e.getValue();
            ViewColorizer.LayerKey bKey = bLayerKeys.get(e.getKey());
            if (AUtil.equals((Object)aInfoMap.getColor((ViewColorizer.Key)aKey), (Object)bInfoMap.getColor((ViewColorizer.Key)bKey))) continue;
            ALog.flogWarn((String)"Layer Key '%s' is changed", (Object[])new Object[]{e.getKey()});
            return false;
        }
        for (Map.Entry<String, ViewColorizer.LayerKey> e : bLayerKeys.entrySet()) {
            if (aLayerKeys.containsKey(e.getKey())) continue;
            ALog.flogWarn((String)"Layer Key '%s' was added", (Object[])new Object[]{e.getKey()});
            return false;
        }
        return true;
    }

    private boolean sameOtherKeys() {
        ViewColorizer.DisplayInfoMap aInfoMap = this.a.getDisplayInfoMap();
        ViewColorizer.DisplayInfoMap bInfoMap = this.b.getDisplayInfoMap();
        Map<String, ViewColorizer.Key> aColorKeys = ViewColorizerDiff.getColorKeyMap(this.a);
        Map<String, ViewColorizer.Key> bColorKeys = ViewColorizerDiff.getColorKeyMap(this.b);
        for (Map.Entry<String, ViewColorizer.Key> e : aColorKeys.entrySet()) {
            if (!bColorKeys.containsKey(e.getKey())) {
                ALog.flogWarn((String)"Key '%s' was removed", (Object[])new Object[]{e.getKey()});
                return false;
            }
            ViewColorizer.Key aKey = e.getValue();
            ViewColorizer.Key bKey = bColorKeys.get(e.getKey());
            if (AUtil.equals((Object)aInfoMap.getColor(aKey), (Object)bInfoMap.getColor(bKey))) continue;
            ALog.flogWarn((String)"Key '%s' is changed", (Object[])new Object[]{e.getKey()});
            return false;
        }
        for (Map.Entry<String, ViewColorizer.Key> e : bColorKeys.entrySet()) {
            if (aColorKeys.containsKey(e.getKey())) continue;
            ALog.flogWarn((String)"Key '%s' was added", (Object[])new Object[]{e.getKey()});
            return false;
        }
        return true;
    }

    private boolean sameVisibility() {
        ViewColorizer.DisplayInfoMap aInfoMap = this.a.getDisplayInfoMap();
        ViewColorizer.DisplayInfoMap bInfoMap = this.b.getDisplayInfoMap();
        Map<String, ViewColorizer.Key> aColorKeys = ViewColorizerDiff.getColorKeyMap(this.a);
        Map<String, ViewColorizer.Key> bColorKeys = ViewColorizerDiff.getColorKeyMap(this.b);
        for (Map.Entry<String, ViewColorizer.Key> e : aColorKeys.entrySet()) {
            if (!bColorKeys.containsKey(e.getKey())) {
                ALog.flogWarn((String)"Key visibility '%s' was removed", (Object[])new Object[]{e.getKey()});
                return false;
            }
            ViewColorizer.Key aKey = e.getValue();
            ViewColorizer.Key bKey = bColorKeys.get(e.getKey());
            if (AUtil.equals((Object)this.a.getDisplay(null, aKey), (Object)this.b.getDisplay(null, bKey))) continue;
            ALog.flogWarn((String)"Key visibility '%s' is changed", (Object[])new Object[]{e.getKey()});
            return false;
        }
        for (Map.Entry<String, ViewColorizer.Key> e : bColorKeys.entrySet()) {
            if (aColorKeys.containsKey(e.getKey())) continue;
            ALog.flogWarn((String)"Key visibility '%s' was added.", (Object[])new Object[]{e.getKey()});
            return false;
        }
        return true;
    }
}

