/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.canvas_modes.SpotLight;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AddPinsToPersonalityMode
extends AbstractViewMode {
    protected Personality mPersonality;
    protected SpotLight mSpotLight = null;

    public AddPinsToPersonalityMode(Personality p) {
        assert (p.getType() == Personality.Type.PORT);
        this.mPersonality = p;
        if (((Boolean)Settings.get((String)"UserPreferences", (String)"EnableSpotlights", (Object)false)).booleanValue()) {
            this.mSpotLight = new SpotLight();
        }
        DeviceTemplate dt = this.mPersonality.getOwner();
        for (DevicePath dpath : dt.getHierarchicalInstances()) {
            if (this.mSpotLight == null) continue;
            this.mSpotLight.addLight((AGeom)dpath.getBB());
        }
    }

    @Override
    protected void installedMode() {
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    @Override
    public String getName() {
        return "Add Pins to Personality";
    }

    @Override
    protected void paintOverlay(Graphics2D g, Rectangle bounds) {
        super.paintOverlay(g, bounds);
        DesignCanvas2D.XForm xform = this.mView.getCanvas().getXForm();
        if (this.mSpotLight != null) {
            this.mSpotLight.draw(xform, g);
        }
    }
}

