/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.ShapeCommands;
import com.sigrity.orbit.ui.DesignDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AddVertexUI {
    protected AddVertexUI() {
    }

    public static AddVertexDlg createDlg(Window owner, Db db, ShapeCommands.OwnedGeom<?> ownedGeom, int afterVert) {
        return new AddVertexDlg(owner, db, ownedGeom, afterVert);
    }

    public static class AddVertexDlg
    extends DesignDialog {
        protected AGeom mGeom;
        protected APolygon mPoly;
        protected int mAfterVert;
        protected JRadioButton mFromA;
        protected JRadioButton mFromB;
        protected JTextField mOffset;
        protected JButton mBtnApply;
        protected JButton mBtnClose;
        protected DbHistory.DbTransaction mTransaction;

        public AddVertexDlg(Window owner, Db db, ShapeCommands.OwnedGeom<?> ownedGeom, int afterVert) {
            super(db, owner);
            this.mGeom = ownedGeom.getGeom();
            this.mAfterVert = afterVert;
            if (this.mGeom instanceof ARect) {
                this.mGeom = this.mGeom.toPoly();
            }
            if (!(this.mGeom instanceof APolygon)) {
                return;
            }
            this.mPoly = (APolygon)this.mGeom;
            if (afterVert < 0 || afterVert > this.mPoly.getPointCount() - 1) {
                ALog.logError((String)"Attempt to add a vertex to %s after invalid vertex index %d.", (Object[])new Object[]{ownedGeom.getGeom(), afterVert});
                return;
            }
            final APoint2D ptB = this.mPoly.getPoint(afterVert);
            final int newVertIdx = afterVert + 1;
            final APoint2D ptA = afterVert > this.mPoly.getPointCount() - 2 ? this.mPoly.getFirstPoint() : this.mPoly.getPoint(newVertIdx);
            final Design design = Design.getDesign((Db)db);
            if (design == null) {
                return;
            }
            final long lenMic = ptA.distance(ptB) / (long)((int)design.getInternalPerMicron());
            String strLen = String.format("%,.02f", lenMic);
            this.setTitle("Add Vertex");
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.newline();
            l.push("Edge", (GridBagConstraints)GridBagManager.LEFT);
            l.addNl("A: " + ptA.toString());
            l.addNl("B: " + ptB.toString());
            l.newline();
            l.addNl("Length:  " + strLen + " microns");
            l.popNl();
            l.push("New Vertex", (GridBagConstraints)GridBagManager.CENTER);
            l.newline();
            this.mFromA = (JRadioButton)l.add((Component)new JRadioButton("Distance from pt A"));
            this.mFromA.setToolTipText("Distance from first point");
            this.mFromA.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
            this.mFromB = (JRadioButton)l.add((Component)new JRadioButton("Distance from pt B"));
            this.mFromB.setToolTipText("Distance from second point");
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mFromA, this.mFromB});
            l.addFillY();
            l.newline();
            l.add("   Offset (microns):");
            this.mOffset = (JTextField)l.addNl((Component)new JTextField(10));
            this.mOffset.setToolTipText("Offset to create vertex");
            this.mOffset.setEditable(true);
            l.popNl();
            l.push("", (GridBagConstraints)GridBagManager.CENTER);
            this.mBtnApply = (JButton)l.add((Component)new JButton("Apply"));
            this.mBtnApply.setEnabled(true);
            this.mBtnClose = (JButton)l.add((Component)new JButton("Close"));
            this.mBtnApply.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Unit unit = this.getUnitDist();
                    long userLenMic = unit.fromUserString(mOffset.getText()) / (long)((int)design.getInternalPerMicron());
                    if (userLenMic < 0L) {
                        ALog.logInfo((String)"Invalid offset specified.");
                        return;
                    }
                    if (lenMic < userLenMic) {
                        ALog.logInfo((String)"Offset specified cannot be bigger than length of edge.");
                        return;
                    }
                    APoint2D startPt = mFromA.isSelected() ? ptA : ptB;
                    APoint2D endPt = mFromA.isSelected() ? ptB : ptA;
                    Cp.exec((String)"ShapeCommands.insertVertex(iseShape, %dL, %dL, %dL, %dL, %dL, %d)", (Object[])new Object[]{startPt.getX(), startPt.getY(), endPt.getX(), endPt.getY(), userLenMic * (long)((int)design.getInternalPerMicron()), newVertIdx});
                    OrbitIO.getApp().refreshCurrentView(false);
                }
            });
            l.pop();
            this.mFromA.setSelected(true);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnClose, (JButton)this.mBtnApply);
            this.pack();
            this.setVisible(true);
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mTransaction = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Add Vertices");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    mTransaction.close();
                }
            });
        }
    }
}

