/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.DistributeNets;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AssignPwrGndDlg
extends DbDialog {
    protected DevicePath mDevicePath;
    protected JRadioButton mBySelected;
    protected JRadioButton mByFloating;
    protected ButtonGroup mSelectByGroup = new AButtonGroup();
    protected JRadioButton mHorizontalStyle;
    protected JRadioButton mVerticalStyle;
    protected JRadioButton mCheckerboardStyle;
    protected ButtonGroup mStyleGroup = new AButtonGroup();
    protected JTextField mNetsField;
    protected Action mOk = new AbstractAction("OK"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DistributeNets.DISTRIBUTE_STYLE style = DistributeNets.DISTRIBUTE_STYLE.HORIZONTAL;
            if (AssignPwrGndDlg.this.mVerticalStyle.isSelected()) {
                style = DistributeNets.DISTRIBUTE_STYLE.VERTICAL;
            } else if (AssignPwrGndDlg.this.mCheckerboardStyle.isSelected()) {
                style = DistributeNets.DISTRIBUTE_STYLE.CHECKERBOARD;
            }
            DistributeNets.DISTRIBUTE_SOURCE source = DistributeNets.DISTRIBUTE_SOURCE.SELECTED;
            if (AssignPwrGndDlg.this.mByFloating.isSelected()) {
                source = DistributeNets.DISTRIBUTE_SOURCE.UNCONNECTED;
            }
            Cp.exec((String)"com.sigrity.orbit.automation.DistributeNets.go(\"%s\",\"%s\",\"%s\",\"%s\");", (Object[])new Object[]{AssignPwrGndDlg.this.mDevicePath.escapedString(), AssignPwrGndDlg.this.mNetsField.getText(), style.getKeyStr(), source.getKeyStr()});
            DbExplorerPanel.refreshAll();
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };

    public static AssignPwrGndDlg createDialog(Window owner, DevicePath dp) {
        AssignPwrGndDlg dlg = null;
        if (dp == null) {
            return null;
        }
        dlg = new AssignPwrGndDlg(dp.getDb(), owner);
        dlg.init(dp);
        return dlg;
    }

    public static Action getAction(DevicePath path) {
        return new AssignPwrGround(path);
    }

    public AssignPwrGndDlg(Db db, Window owner) {
        super(db, (Component)owner);
    }

    protected void init(DevicePath dp) {
        this.setTitle(String.format("Assign Power Ground Nets (%s)", dp));
        this.mDevicePath = dp;
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push("Pin", (GridBagConstraints)GridBagManager.FILLX);
        this.mBySelected = new JRadioButton("Selected Pins");
        this.mByFloating = new JRadioButton("Unconnected Pins");
        this.mByFloating.setToolTipText("Pin's net have not mapping to any one.");
        this.mSelectByGroup.add(this.mBySelected);
        this.mSelectByGroup.add(this.mByFloating);
        l.add((Component)this.mBySelected, (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
        l.newline();
        l.add((Component)this.mByFloating, (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        l.addFillX();
        l.pop();
        l.newline();
        l.push("Nets", (GridBagConstraints)GridBagManager.FILLX);
        l.add("P/G Nets:");
        this.mNetsField = new JTextField(10);
        this.mNetsField.setToolTipText("<html>Add in comma separated nets to be distributed<br>If the net does not exist, it will be created.</html>");
        l.add((Component)this.mNetsField, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        l.push("Assign Style", (GridBagConstraints)GridBagManager.FILLX);
        this.mHorizontalStyle = new JRadioButton("Horizontal");
        this.mVerticalStyle = new JRadioButton("Vertical");
        this.mCheckerboardStyle = new JRadioButton("Checkerboard");
        this.mStyleGroup.add(this.mHorizontalStyle);
        this.mStyleGroup.add(this.mVerticalStyle);
        this.mStyleGroup.add(this.mCheckerboardStyle);
        l.add((Component)this.mHorizontalStyle, (GridBagConstraints)GridBagManager.LEFT.insetBottom(0));
        l.newline();
        l.add((Component)this.mVerticalStyle, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.newline();
        l.add((Component)this.mCheckerboardStyle, (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        l.addFillX();
        l.pop();
        l.newline();
        l.pushFillX();
        l.addFillX();
        JButton btnOk = new JButton(this.mOk);
        l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = new JButton("Close");
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        l.popNl();
        this.mBySelected.setSelected(true);
        this.mHorizontalStyle.setSelected(true);
        this.mNetsField.setText("vss,vdd");
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnOk);
        this.pack();
        UIUtil.center((Component)((Object)this));
    }

    protected static class AssignPwrGround
    extends AbstractAction {
        protected final DevicePath mDevicePath;

        public AssignPwrGround(DevicePath path) {
            super("Assign Power Ground Nets...");
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AssignPwrGndDlg dlg = AssignPwrGndDlg.createDialog(OrbitIO.getMainWindow(), this.mDevicePath);
            if (dlg != null) {
                dlg.setVisible(true);
            }
        }
    }
}

