/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.DbObjectRatio;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.parsers.CSVDOMParser;
import com.sigrity.acl.parsers.CSVDocument;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.DiffPairFinder;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.PinSpreadOptimizer;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.w3c.dom.Element;

public class AutoBundleDlg
extends DbDialog {
    protected JComboBox<DeviceTemplate> mFromDevice;
    protected JComboBox<DeviceTemplate> mToDevice;
    protected JTextField mNumReqPins;
    protected JTextField mNumAvaPins;
    private JTextField mWireWidth;
    private JTextField mWireClearance;
    protected JLabel mWarnPins;
    protected JTable mTable;
    protected JButton mExportButton;
    protected JButton mImportButton;
    protected JButton mStatsButton;
    protected JButton mClearUnlockedButton;
    protected JButton mRunButton;
    protected JButton mUpButton;
    protected JButton mDownButton;
    protected JCheckBox mAllowSteal;
    protected TableCellRenderer tcr;
    protected InstructionListModel mInstructionListModel;
    static final int lockedColumn = 0;
    static final int bundleItColumn = 1;
    static final int fromFloorplanColumn = 2;
    static final int fromSideColumn = 3;
    static final int toSideColumn = 4;
    static final int toPersonalityColumn = 5;
    static final int signalPinsColumn = 6;
    static final int extraPinsColumn = 7;
    static final int unfilledPinsColumn = 8;
    static final int diffPairColumn = 9;
    static final int spreadColumn = 10;
    public static final String AUTO_BUNDLE_DEFAULT_WIRE_WIDTH = "20";
    public static final String AUTO_BUNDLE_DEFAULT_WIRE_CLEARANCE = "20";
    public static final String AUTO_BUNDLE_TEMP_CSV_FILE = "abt_temp.csv";
    public static final String AUTO_BUNDLE_CSV_FIELD = "ab.csv";
    public static final Icon ICON_ARROW_UP = OrbitIcons.UP;
    public static final Icon ICON_ARROW_DN = OrbitIcons.DOWN;
    static AutoBundleDlg theDialog = null;
    protected static DesignView2D mView = null;
    static DevicePath mBasePath;
    protected final String LOCKALL = "Lock all";
    protected final String UNLOCKALL = "Unlock all";
    protected final String BUNDLEALL = "Bundle all";
    protected final String BUNDLENONE = "Bundle none";
    List<PinSpreadOptimizer.PinSpreadAlgo> mPDList = new LinkedList<PinSpreadOptimizer.PinSpreadAlgo>();
    LinkedList<AutoStats> mStatsList = new LinkedList();
    StatsDisplay mSD = null;
    public static final String PERSONALITY_ANY = "Any";
    protected long numReqPins = 0L;
    protected long numAvaPins = 0L;
    protected HashMap<APair<EscapeSides, Personality>, APair<Long, Long>> mStatsMap = new HashMap();
    protected ActionListener exportToFile = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleDlg.this.stopCellEditing();
            AFileChooser fileChooser = new AFileChooser();
            fileChooser.setDialogTitle("Export Instructions To File");
            fileChooser.addChoosableFileFilter((FileFilter)AFileFilter.CSV);
            fileChooser.setSelectedFile(new File(mBasePath.escapedString()));
            if (fileChooser.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            Object path = f.getAbsolutePath();
            if (!f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            AutoBundleDlg.this.writeToCsv((String)path, false);
        }
    };
    protected ActionListener importFromFile = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleDlg.this.stopCellEditing();
            AFileChooser fileChooser = new AFileChooser();
            fileChooser.setFileFilter((FileFilter)AFileFilter.CSV);
            if (fileChooser.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                return;
            }
            File f = fileChooser.getSelectedFile();
            Object path = f.getPath();
            if (!f.getName().contains(".")) {
                path = (String)path + ".csv";
            }
            AutoBundleDlg.this.loadFromCsv((String)path);
        }
    };
    protected ActionListener showStats = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoBundleDlg.this.stopCellEditing();
            AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
            if (AutoBundleDlg.this.mSD != null) {
                AutoBundleDlg.this.mSD.show(AutoBundleDlg.this.mStatsList);
            } else {
                AutoBundleDlg.this.mSD = new StatsDisplay(AutoBundleDlg.this.mStatsList);
            }
        }
    };
    protected ActionListener clearUnlockedBundles = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Instruction instruction : AutoBundleDlg.this.mInstructionListModel.getInstructions()) {
                if (instruction.locked.booleanValue()) continue;
                DeviceTemplate fromTemplate = instruction.fromPath.getDeviceTemplate();
                DeviceTemplate toTemplate = instruction.toPath.getDeviceTemplate();
                Interface iFace = instruction.fromInterface;
                Floorplan floorplan = iFace.getFloorplan(fromTemplate, false);
                Bundle curBundle = Bundle.getBundle((Db)AutoBundleDlg.this.mDb, (String)floorplan.getMyInterface().toStringPath(), (DeviceTemplate)toTemplate);
                if (curBundle != null) {
                    Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.removeFloorplanPins (curDb(), \"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
                    Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.commandSetFreePinsToUnused (\"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
                    Cp.exec((String)"Bundle.deleteFromDb (curDb(), \"%s\")", (Object[])new Object[]{curBundle.getKeyStr()});
                    continue;
                }
                Floorplan fp = iFace.getFloorplan(toTemplate, false);
                if (fp == null) continue;
                Cp.exec((String)"fp = (Floorplan) OrbitIO.getCurDb().getDbClass(\"Floorplan\").getInstanceByKeyStr(\"%s\");", (Object[])new Object[]{fp.getKeyStr()});
                Cp.exec((String)"fp.removePins(%b);", (Object[])new Object[]{true});
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    };
    protected ActionListener go = e -> {
        this.stopCellEditing();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Auto Bundle");){
            Cp.exec((String)"com.sigrity.orbit.automation.AutoBundleEngine abe = new com.sigrity.orbit.automation.AutoBundleEngine();", (Object[])new Object[0]);
            for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
                String bundle;
                if (instruction.locked.booleanValue()) continue;
                if (instruction.fromDirection == null) {
                    Floorplan fp = instruction.fromInterface.getFloorplan(mBasePath.getDeviceTemplate(), false);
                    int escapeSide = AutoBundleDlg.getSide(fp.getKeyStr());
                    instruction.fromDirection = EscapeSides.fromOct(escapeSide);
                }
                String prefFromSide = "prefFromSide=" + instruction.fromDirection.name();
                if (instruction.toDirection == null) {
                    instruction.toDirection = instruction.fromDirection;
                }
                String prefToSide = "prefToSide=" + instruction.toDirection.name();
                String extraPins = "extraPins=" + instruction.extraPins;
                if (instruction.pinSpread == null) {
                    instruction.pinSpread = this.mPDList.get(0);
                }
                String spreadAlgo = "spreadAlgo=" + instruction.pinSpread.name();
                String optAlgo = "optAlgo=" + instruction.optAlgo.toString();
                String string = bundle = instruction.bundleIt != false ? "bundle=true" : "bundle=false";
                if (instruction.diffPairAlignment == null) {
                    instruction.diffPairAlignment = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog);
                }
                String diffPair = "diffPair=" + instruction.diffPairAlignment;
                String hints = bundle + "," + prefFromSide + "," + prefToSide + ", " + extraPins + "," + diffPair + "," + spreadAlgo + "," + optAlgo;
                String personalilityName = PERSONALITY_ANY;
                if (instruction.toPersonality != null) {
                    personalilityName = instruction.toPersonality.getName();
                }
                Cp.exec((String)"abe.add(%d, %b, \"%s\", \"%s\", \"%s\",\"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{instruction.order, this.mAllowSteal.isSelected(), this.mWireWidth.getText(), this.mWireClearance.getText(), instruction.fromPath.escapedString(), instruction.toPath.escapedString(), instruction.fromInterface.toStringPath(), personalilityName, hints});
            }
            Cp.exec((String)"abe.go();", (Object[])new Object[0]);
            OrbitIO.getApp().refreshCurrentView(false);
            this.tallyPins();
            this.mTable.repaint();
        }
    };
    protected ActionListener mMoveUpAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows;
            for (int selRow : rows = AutoBundleDlg.this.mTable.getSelectedRows()) {
                Instruction prevInst = AutoBundleDlg.this.mInstructionListModel.getRow(selRow - 1);
                Instruction curInst = AutoBundleDlg.this.mInstructionListModel.getRow(selRow);
                prevInst.order = selRow;
                curInst.order = selRow - 1;
                AutoBundleDlg.this.mInstructionListModel.sortTable();
            }
            AutoBundleDlg.this.mTable.setRowSelectionInterval(rows[0] - 1, rows[rows.length - 1] - 1);
        }
    };
    protected ActionListener mMoveDownAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = AutoBundleDlg.this.mTable.getSelectedRows();
            for (int i = rows[rows.length - 1]; i >= rows[0]; --i) {
                Instruction nextInst = AutoBundleDlg.this.mInstructionListModel.getRow(i + 1);
                Instruction curInst = AutoBundleDlg.this.mInstructionListModel.getRow(i);
                nextInst.order = i;
                curInst.order = i + 1;
                AutoBundleDlg.this.mInstructionListModel.sortTable();
            }
            AutoBundleDlg.this.mTable.setRowSelectionInterval(rows[0] + 1, rows[rows.length - 1] + 1);
        }
    };

    public static AutoBundleDlg createDialog(Window owner, Db db, String basePath) {
        AutoBundleDlg dlg = null;
        if (db == null) {
            return null;
        }
        mBasePath = DevicePath.fromString((Db)db, (String)basePath);
        if (mBasePath == null || !mBasePath.getLast().getParent().amIASubstrate()) {
            ALog.logWarn((String)"Selected device with path '%s' does not exist or does not have a valid parent device to bundle to.", (Object[])new Object[]{basePath});
            return null;
        }
        theDialog = dlg = new AutoBundleDlg(db, owner);
        dlg.init(basePath);
        dlg.setVisible(true);
        return dlg;
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public AutoBundleDlg(Db db, Window owner) {
        super(db, (Component)owner);
    }

    protected void init(String basePath) {
        this.setTitle("Auto-Bundle Dashboard");
        Cp.exec((String)"com.sigrity.orbit.automation.PinSpreadOptimizer.registerStandardSpreads()", (Object[])new Object[0]);
        this.mPDList = PinSpreadOptimizer.PinSpreadRegistry.getRegistryList();
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.newline();
        l.push("Devices", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Source:");
        this.mFromDevice = (JComboBox)l.add(new JComboBox());
        this.mFromDevice.setEditable(false);
        this.mFromDevice.setRenderer(new TemplateListRenderer());
        this.mFromDevice.addItem(mBasePath.getLast().getTemplate());
        l.newline();
        l.add("Destination:");
        this.mToDevice = (JComboBox)l.add(new JComboBox());
        this.mToDevice.setEditable(false);
        this.mToDevice.setRenderer(new TemplateListRenderer());
        this.mToDevice.addItem(mBasePath.getLast().getParent());
        l.addFillX();
        l.pop();
        l.push("Pin Status", (GridBagConstraints)GridBagManager.FILLALL);
        l.add("Pins required:", (GridBagConstraints)GridBagManager.LEFT);
        this.mNumReqPins = (JTextField)l.add((Component)new JTextField());
        this.mNumReqPins.setEditable(false);
        this.mNumReqPins.setForeground(Color.BLUE);
        l.newline();
        l.add("Available pins:", (GridBagConstraints)GridBagManager.LEFT);
        this.mNumAvaPins = (JTextField)l.add((Component)new JTextField());
        this.mNumAvaPins.setEditable(false);
        this.mNumAvaPins.setForeground(Color.BLUE);
        l.newline();
        l.addFillX();
        l.newline();
        l.addFillY();
        l.pop();
        this.mWarnPins = (JLabel)l.add((Component)new JLabel("There are not enough available pins on the destination device"));
        this.mWarnPins.setOpaque(true);
        this.mWarnPins.setForeground(Color.RED);
        this.mWarnPins.setVisible(false);
        l.newline();
        l.push("Floorplans", (GridBagConstraints)GridBagManager.FILLALL.width(2));
        l.push((GridBagConstraints)GridBagManager.FILLALL);
        this.mExportButton = new JButton("Export Data");
        l.add((Component)this.mExportButton, (GridBagConstraints)GridBagManager.LEFT);
        this.mExportButton.setBorderPainted(true);
        this.mExportButton.setFont(new Font("Arial", 0, 12));
        this.mExportButton.setForeground(Color.BLUE);
        this.mExportButton.addActionListener(this.exportToFile);
        this.mImportButton = new JButton("Load Data");
        l.add((Component)this.mImportButton, (GridBagConstraints)GridBagManager.LEFT);
        this.mImportButton.setBorderPainted(true);
        this.mImportButton.setFont(new Font("Arial", 0, 12));
        this.mImportButton.setForeground(Color.BLUE);
        this.mImportButton.addActionListener(this.importFromFile);
        this.mStatsButton = new JButton("Allocation Table");
        l.add((Component)this.mStatsButton, (GridBagConstraints)GridBagManager.LEFT);
        this.mStatsButton.setBorderPainted(true);
        this.mStatsButton.setFont(new Font("Arial", 0, 12));
        this.mStatsButton.setForeground(Color.RED);
        this.mStatsButton.addActionListener(this.showStats);
        this.mUpButton = new JButton(ICON_ARROW_UP);
        this.mDownButton = new JButton(ICON_ARROW_DN);
        UIUtil.makeSmallButton((JButton)this.mUpButton);
        UIUtil.makeSmallButton((JButton)this.mDownButton);
        l.add((Component)this.mUpButton);
        l.add((Component)this.mDownButton);
        this.mUpButton.addActionListener(this.mMoveUpAction);
        this.mDownButton.addActionListener(this.mMoveDownAction);
        this.mUpButton.setEnabled(false);
        this.mDownButton.setEnabled(false);
        l.addFillX();
        l.pop();
        l.newline();
        l.push("", (GridBagConstraints)GridBagManager.FILLX);
        l.add("Wire Width:");
        this.mWireWidth = new JTextField(6);
        this.mWireWidth.setHorizontalAlignment(4);
        this.mWireWidth.setText("20");
        l.add((Component)this.mWireWidth, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Wire Clearance:");
        this.mWireClearance = new JTextField(6);
        this.mWireClearance.setHorizontalAlignment(4);
        this.mWireClearance.setText("20");
        l.add((Component)this.mWireClearance, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mAllowSteal = new JCheckBox("Include assigned pins");
        l.add((Component)this.mAllowSteal);
        this.mAllowSteal.setSelected(false);
        this.mAllowSteal.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AutoBundleDlg.this.updatePinCounts(AutoBundleDlg.this.mAllowSteal.isSelected());
                AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
            }
        });
        l.addFillX();
        l.pop();
        l.newline();
        this.mTable = new JTable();
        JTableHeader jth = this.mTable.getTableHeader();
        this.tcr = jth.getDefaultRenderer();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int columnWidth = metrics.charWidth('m');
        int desiredWidth = 90;
        int desiredHeight = 160;
        this.mTable.setPreferredScrollableViewportSize(new Dimension(desiredWidth * columnWidth, desiredHeight));
        this.mTable.setFillsViewportHeight(true);
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setAutoResizeMode(4);
        this.mInstructionListModel = new InstructionListModel();
        this.mTable.setModel(this.mInstructionListModel);
        this.mTable.addMouseListener(new TableButtonMouseListener(this.mTable));
        this.mTable.setSelectionMode(0);
        this.mTable.addMouseMotionListener(new TableMouseMotionListener(this.mTable));
        this.mTable.setRowHeight(this.mTable.getRowHeight() + 8);
        this.mTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        ColumnHeaderRender chr = new ColumnHeaderRender();
        TableColumn col = this.mTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(2 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(2 * columnWidth);
        col.setIdentifier(0);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(1);
        col.setPreferredWidth(2 * columnWidth);
        col.setMinWidth(2 * columnWidth);
        col.setMaxWidth(2 * columnWidth);
        col.setIdentifier(1);
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(2);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(20 * columnWidth);
        col.setIdentifier(2);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(3);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(3);
        col.setCellEditor(new EscapeSideEditor(true));
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(4);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(4);
        col.setCellEditor(new EscapeSideEditor(false));
        col.setResizable(false);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(5);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(10 * columnWidth);
        col.setIdentifier(5);
        col.setResizable(true);
        col.setCellEditor(new ToPersonalityEditor(mBasePath.getParent()));
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(9);
        col.setPreferredWidth(8 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(10 * columnWidth);
        col.setIdentifier(9);
        col.setCellEditor(new DiffPairEditor());
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(6);
        col.setPreferredWidth(4 * columnWidth);
        col.setMinWidth(4 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(6);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(7);
        col.setPreferredWidth(4 * columnWidth);
        col.setMinWidth(4 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(7);
        col.setCellEditor(new ExtraPinsEditor());
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(8);
        col.setPreferredWidth(5 * columnWidth);
        col.setMinWidth(5 * columnWidth);
        col.setMaxWidth(8 * columnWidth);
        col.setIdentifier(8);
        col.setResizable(true);
        col.setHeaderRenderer(chr);
        col = this.mTable.getColumnModel().getColumn(10);
        col.setPreferredWidth(10 * columnWidth);
        col.setMinWidth(8 * columnWidth);
        col.setMaxWidth(12 * columnWidth);
        col.setIdentifier(10);
        col.setResizable(true);
        col.setCellEditor(new SpreadEditor());
        col.setHeaderRenderer(chr);
        this.mTable.setDefaultRenderer(Object.class, new InstructionRenderer());
        this.mTable.setRowSelectionAllowed(true);
        this.mTable.setColumnSelectionAllowed(false);
        HeaderPopupListener headerListener = new HeaderPopupListener();
        this.mTable.getTableHeader().addMouseListener(headerListener);
        this.mTable.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.pop();
        l.newline();
        this.mInstructionListModel.buildTableFromFloorplans();
        this.updatePinCounts(this.mAllowSteal.isSelected());
        this.buildStatsMap(this.mAllowSteal.isSelected());
        l.push((GridBagConstraints)GridBagManager.FILLX.width(2));
        l.addFillX();
        this.mClearUnlockedButton = new JButton("Clear Unlocked Bundles");
        l.add((Component)this.mClearUnlockedButton, (GridBagConstraints)GridBagManager.RIGHT);
        this.mClearUnlockedButton.setBorderPainted(true);
        this.mClearUnlockedButton.setFont(new Font("Arial", 0, 13));
        this.mClearUnlockedButton.setForeground(Color.BLUE);
        this.mClearUnlockedButton.addActionListener(this.clearUnlockedBundles);
        this.mRunButton = new JButton("Run");
        l.add((Component)this.mRunButton, (GridBagConstraints)GridBagManager.RIGHT);
        this.mRunButton.setBorderPainted(true);
        this.mRunButton.setFont(new Font("Arial", 0, 13));
        this.mRunButton.setForeground(Color.red);
        this.mRunButton.addActionListener(this.go);
        l.pop();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AutoBundleDlg.this.stopCellEditing();
                if (OrbitIO.getCurDb() == null) {
                    return;
                }
                for (Instruction instruction : AutoBundleDlg.this.mInstructionListModel.getInstructions()) {
                    Floorplan floorplanTo = instruction.fromInterface.getFloorplan(instruction.toPath.getDeviceTemplate(), false);
                    if (floorplanTo == null) continue;
                    Cp.exec((String)"f=(Floorplan) OrbitIO.getCurDb().getDbClass(\"Floorplan\").getInstanceByKeyStr(\"%s\");", (Object[])new Object[]{floorplanTo.getKeyStr()});
                    Cp.exec((String)"f.setExtraPins(%d);", (Object[])new Object[]{instruction.extraPins});
                }
                for (Floorplan fp : AUtil.linkedList((Iterator)AutoBundleDlg.this.mDb.getObjects(Floorplan.class))) {
                    long extraPins = 0L;
                    Floorplan root = fp.getRootFloorplan();
                    if (fp != root) continue;
                    LinkedList list = Floorplan.selfAndChildren((Interface)fp.getMyInterface(), null, (DeviceTemplate)fp.getDeviceTemplate());
                    for (Floorplan f : list) {
                        extraPins += f.getExtraPins();
                    }
                    Cp.exec((String)"f=(Floorplan) OrbitIO.getCurDb().getDbClass(\"Floorplan\").getInstanceByKeyStr(\"%s\");", (Object[])new Object[]{fp.getKeyStr()});
                    Cp.exec((String)"f.setExtraPins(%d);", (Object[])new Object[]{extraPins});
                }
                AutoBundleDlg.this.attachCsvFile();
            }
        });
    }

    protected void setLockAll(boolean lock) {
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Change Lock Status");){
            for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
                instruction.locked = lock;
            }
            OrbitIO.getApp().refreshCurrentView(false);
            this.mTable.repaint();
        }
    }

    protected void setBundleAll(boolean bundle) {
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Change Bundle Status");){
            for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
                instruction.bundleIt = bundle;
            }
            OrbitIO.getApp().refreshCurrentView(false);
            this.mTable.repaint();
        }
    }

    protected long loadExtraPins(Floorplan fp) {
        long extraPins = 0L;
        if (fp == null) {
            return extraPins;
        }
        extraPins = fp.getExtraPins();
        long extraPinsC = 0L;
        LinkedList list = Floorplan.selfAndChildren((Interface)fp.getMyInterface(), null, (DeviceTemplate)fp.getDeviceTemplate());
        for (Floorplan fpC : list) {
            if (fpC.equals(fp)) continue;
            extraPinsC += fpC.getExtraPins();
        }
        return extraPins -= extraPinsC;
    }

    protected long getRequiredPins() {
        long requiredPins = 0L;
        for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
            requiredPins += instruction.signalPins + instruction.extraPins;
        }
        return requiredPins;
    }

    protected long getAvailablePins(boolean allowUsedNets) {
        long availablePins = 0L;
        Instruction instruction = null;
        LinkedList<Instruction> list = this.mInstructionListModel.getInstructions();
        if (list.isEmpty()) {
            return availablePins;
        }
        instruction = list.get(0);
        DevicePath dp = instruction.toPath;
        Device dev = dp.getLast();
        if (dev != null) {
            Substrate s = dp.getSubstrate();
            for (DevicePath descendent : dp.getDescendants()) {
                if (descendent.getSubstrate() != s) continue;
                for (PinInstance pi : descendent.getLast().getPins()) {
                    if (pi.isOnUsedNet() && !allowUsedNets) continue;
                    ++availablePins;
                }
            }
        }
        return availablePins;
    }

    protected void updatePinCounts(boolean allowUsedNets) {
        long reqPins = this.getRequiredPins();
        long avaPins = this.getAvailablePins(allowUsedNets);
        this.mNumReqPins.setText(String.format("%,8d", reqPins));
        this.mNumAvaPins.setText(String.format("%,8d", avaPins));
        this.mWarnPins.setVisible(avaPins < reqPins);
    }

    public static int getSide(String floorPlanKey) {
        int[] count = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        Floorplan fp = (Floorplan)OrbitIO.getCurDb().getByKeyStr(Floorplan.class, floorPlanKey);
        ARect boundBox = mBasePath.getDevice().getAllWorldBounds();
        for (FloorplanPin fpPin : fp.getIOs()) {
            HierPin hp = fpPin.getAHierPin();
            DevicePath devPath = new DevicePath(mBasePath, (DevicePath)hp.first);
            APoint2D substrateLoc = ((PinInstance)hp.second).getWorldLoc(devPath);
            long distance = boundBox.topEdge().distance(substrateLoc);
            int bestSide = 2;
            if (distance > boundBox.rightEdge().distance(substrateLoc)) {
                distance = boundBox.rightEdge().distance(substrateLoc);
                bestSide = 0;
            }
            if (distance > boundBox.bottomEdge().distance(substrateLoc)) {
                distance = boundBox.bottomEdge().distance(substrateLoc);
                bestSide = 6;
            }
            if (distance > boundBox.leftEdge().distance(substrateLoc)) {
                distance = boundBox.leftEdge().distance(substrateLoc);
                bestSide = 4;
            }
            int n = bestSide;
            count[n] = count[n] + 1;
        }
        int bestDir = 0;
        int bestCount = 0;
        for (int i = 0; i < 8; ++i) {
            if (count[i] <= bestCount) continue;
            bestCount = count[i];
            bestDir = i;
        }
        return bestDir;
    }

    protected void writeToCsv(String filePath, boolean toDb) {
        PrintStream out = null;
        if (this.mDb == null) {
            return;
        }
        if (filePath == null || filePath.isEmpty()) {
            ALog.logError((String)"Target file is invalid");
            return;
        }
        try {
            out = new PrintStream(filePath);
        }
        catch (FileNotFoundException e) {
            ALog.logError((String)("Cannot open " + filePath));
            return;
        }
        for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
            StringBuilder line = new StringBuilder();
            Floorplan fp = instruction.fromInterface.getFloorplan(mBasePath.getParent().getDeviceTemplate(), false);
            String perStr = instruction.toPersonality == null ? PERSONALITY_ANY : instruction.toPersonality.getName();
            line.append(fp.getKeyStr());
            line.append(",");
            line.append(perStr);
            line.append(",");
            if (instruction.fromDirection == null) {
                Floorplan fp1 = instruction.fromInterface.getFloorplan(mBasePath.getDeviceTemplate(), false);
                int escapeSide = AutoBundleDlg.getSide(fp1.getKeyStr());
                instruction.fromDirection = EscapeSides.fromOct(escapeSide);
            }
            line.append(instruction.fromDirection.name());
            line.append(",");
            if (instruction.toDirection == null) {
                instruction.toDirection = instruction.fromDirection;
            }
            line.append(instruction.toDirection.name());
            line.append(",");
            if (!toDb) {
                line.append(instruction.extraPins);
                line.append(",");
            }
            line.append(instruction.pinSpread.name());
            line.append(",");
            line.append(instruction.locked);
            line.append(",");
            line.append(instruction.bundleIt);
            line.append(",");
            line.append(instruction.diffPairAlignment);
            line.append(",");
            line.append(this.mWireWidth.getText());
            line.append(",");
            line.append(this.mWireClearance.getText());
            line.append(",");
            line.append(instruction.order);
            line.append(",");
            line.append(this.mAllowSteal.isSelected());
            out.println(line);
        }
        out.close();
        if (!toDb) {
            ALog.logInfo((String)("Table data written to " + filePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromCsv(String filePath) {
        if (this.mDb == null) {
            return;
        }
        if (filePath == null || filePath.isEmpty()) {
            ALog.logError((String)"Input file is invalid");
            return;
        }
        File inputFile = new File(filePath);
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Import Table from CSV");
             BufferedReader input = new BufferedReader(new FileReader(inputFile));){
            String curLine = input.readLine();
            while (curLine != null) {
                this.processLine(curLine);
                curLine = input.readLine();
            }
            this.doChecksumOrder();
            this.updatePinCounts(this.mAllowSteal.isSelected());
            this.buildStatsMap(this.mAllowSteal.isSelected());
            ALog.logInfo((String)"Table updated from file %s", (Object[])new Object[]{inputFile});
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Cannot import table fomr csv", (Object[])new Object[0]);
        }
        finally {
            this.mTable.repaint();
        }
    }

    protected void processLine(String line) {
        String[] tokens = line.split(",");
        int numTokens = tokens.length;
        if (numTokens == 0) {
            return;
        }
        String fpStr = tokens[0];
        if (fpStr.isEmpty()) {
            return;
        }
        Instruction inst = this.mInstructionListModel.getRow(fpStr);
        if (inst == null) {
            return;
        }
        block14: for (int num = 1; num < numTokens; ++num) {
            String value = tokens[num];
            switch (num) {
                case 1: {
                    if (value.equals(PERSONALITY_ANY)) {
                        inst.toPersonality = null;
                        continue block14;
                    }
                    Optional p = Personality.getPersonality((DeviceTemplate)mBasePath.getParent().getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)value);
                    if (!p.isPresent()) continue block14;
                    inst.toPersonality = (Personality)p.get();
                    continue block14;
                }
                case 2: {
                    inst.fromDirection = value.equals("DEFAULT") ? null : EscapeSides.valueOf(value);
                    continue block14;
                }
                case 3: {
                    inst.toDirection = value.equals("DEFAULT") ? null : EscapeSides.valueOf(value);
                    continue block14;
                }
                case 4: {
                    long ep;
                    if (value == null || value.isEmpty() || (ep = (long)Integer.parseInt(value)) <= 0L) continue block14;
                    inst.extraPins = ep;
                    continue block14;
                }
                case 5: {
                    PinSpreadOptimizer.PinSpreadAlgo pinSpread = PinSpreadOptimizer.PinSpreadRegistry.getPinSpreadAlgo(value);
                    if (pinSpread == null) continue block14;
                    inst.pinSpread = pinSpread;
                    continue block14;
                }
                case 6: {
                    inst.locked = value.equalsIgnoreCase("TRUE");
                    continue block14;
                }
                case 7: {
                    inst.bundleIt = value.equalsIgnoreCase("TRUE");
                    continue block14;
                }
                case 8: {
                    inst.diffPairAlignment = value;
                    continue block14;
                }
                case 9: {
                    this.mWireWidth.setText(value);
                    continue block14;
                }
                case 10: {
                    this.mWireClearance.setText(value);
                    continue block14;
                }
                case 11: {
                    if (value == null || value.isEmpty()) continue block14;
                    inst.order = Integer.parseInt(value);
                    continue block14;
                }
                case 12: {
                    this.mAllowSteal.setSelected(value.equalsIgnoreCase("TRUE"));
                    continue block14;
                }
                default: {
                    ALog.logInfo((String)"Instruction read from file is not supported");
                }
            }
        }
    }

    private void stopCellEditing() {
        this.mTable.getColumnModel().getColumn(3).getCellEditor().stopCellEditing();
        this.mTable.getColumnModel().getColumn(4).getCellEditor().stopCellEditing();
        this.mTable.getColumnModel().getColumn(5).getCellEditor().stopCellEditing();
        this.mTable.getColumnModel().getColumn(9).getCellEditor().stopCellEditing();
        this.mTable.getColumnModel().getColumn(7).getCellEditor().stopCellEditing();
        this.mTable.getColumnModel().getColumn(10).getCellEditor().stopCellEditing();
    }

    protected void tallyPins() {
        for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
            Floorplan floorplanTo;
            if (instruction.locked.booleanValue() || (floorplanTo = instruction.fromInterface.getFloorplan(instruction.toPath.getDeviceTemplate(), false)) == null) continue;
            long actualPins = floorplanTo.getIOs().size();
            long expectedPins = instruction.signalPins + instruction.extraPins;
            instruction.unfilledPins = expectedPins - actualPins;
        }
    }

    protected int getSideOrder(EscapeSides s) {
        if (s.equals((Object)EscapeSides.N)) {
            return 0;
        }
        if (s.equals((Object)EscapeSides.S)) {
            return 1;
        }
        if (s.equals((Object)EscapeSides.E)) {
            return 2;
        }
        if (s.equals((Object)EscapeSides.W)) {
            return 3;
        }
        if (s.equals((Object)EscapeSides.NE)) {
            return 4;
        }
        if (s.equals((Object)EscapeSides.NW)) {
            return 5;
        }
        if (s.equals((Object)EscapeSides.SE)) {
            return 6;
        }
        if (s.equals((Object)EscapeSides.SW)) {
            return 7;
        }
        return 8;
    }

    public long getExtraPinsFromRatios(Instruction instruction) {
        Floorplan fp = instruction.fromInterface.getFloorplan(mBasePath.getParent().getDeviceTemplate(), false);
        int nume = 0;
        int deno = 0;
        long extraPins = 0L;
        for (DbObjectRatio pRatio : fp.getPersonalityRatios()) {
            DbObject obj1 = pRatio.getDbObject1();
            DbObject obj2 = pRatio.getDbObject2();
            if (instruction.toPersonality != null && (!obj1.equals(instruction.toPersonality) || obj2.equals(instruction.toPersonality))) continue;
            nume = pRatio.getRatioNumerator();
            deno = pRatio.getRatioDenominator();
            if (nume == 0) continue;
            extraPins += instruction.signalPins * (long)deno / (long)nume;
        }
        return extraPins;
    }

    protected void buildStatsMap(boolean allowUsedNets) {
        DevicePath destP = mBasePath.getParent();
        DeviceTemplate destT = destP.getDeviceTemplate();
        ArrayList personalityList = new ArrayList();
        Personality.getPersonalities((DeviceTemplate)destT, (Personality.Type)Personality.Type.PORT).forEach(p -> personalityList.add(p));
        Collections.sort(personalityList);
        this.mStatsMap.clear();
        for (EscapeSides es : EscapeSides.values()) {
            if (!es.equals((Object)EscapeSides.N) && !es.equals((Object)EscapeSides.S) && !es.equals((Object)EscapeSides.E) && !es.equals((Object)EscapeSides.W)) continue;
            for (Personality p2 : personalityList) {
                APair key = new APair((Object)es, (Object)p2);
                long avaPins = this.getNumPins(destP, es.name(), p2, allowUsedNets);
                APair val = new APair((Object)avaPins, (Object)0L);
                this.mStatsMap.put((APair<EscapeSides, Personality>)key, (APair<Long, Long>)val);
            }
            long totalPins = 0L;
            totalPins = this.getNumPins(destP, es.name(), null, allowUsedNets);
            APair total = new APair((Object)es, null);
            APair value = new APair((Object)totalPins, (Object)0L);
            this.mStatsMap.put((APair<EscapeSides, Personality>)total, (APair<Long, Long>)value);
        }
        for (Instruction instruction : this.mInstructionListModel.getInstructions()) {
            long neededPins = 0L;
            APair keyPair = new APair((Object)instruction.toDirection, (Object)instruction.toPersonality);
            APair valuePair = this.mStatsMap.get(keyPair);
            if (valuePair == null) continue;
            neededPins = (Long)valuePair.second + instruction.signalPins + instruction.extraPins;
            valuePair = new APair((Object)((Long)valuePair.first), (Object)neededPins);
            this.mStatsMap.put((APair<EscapeSides, Personality>)keyPair, (APair<Long, Long>)valuePair);
            if (instruction.toPersonality == null) continue;
            APair keyPairTotal = new APair((Object)instruction.toDirection, null);
            APair valuePairTotal = this.mStatsMap.get(keyPairTotal);
            long neededPinsTotal = (Long)valuePairTotal.second + instruction.signalPins + instruction.extraPins;
            valuePairTotal = new APair((Object)((Long)valuePairTotal.first), (Object)neededPinsTotal);
            this.mStatsMap.put((APair<EscapeSides, Personality>)keyPairTotal, (APair<Long, Long>)valuePairTotal);
        }
        this.mStatsList.clear();
        for (APair aPair : this.mStatsMap.keySet()) {
            APair<Long, Long> valuePair = this.mStatsMap.get(aPair);
            AutoStats st = new AutoStats((EscapeSides)((Object)aPair.first), (Personality)aPair.second, (Long)valuePair.first, (Long)valuePair.second);
            this.mStatsList.add(st);
        }
        if (this.mSD != null) {
            this.mSD.show(this.mStatsList);
        }
    }

    protected long getNumPins(DevicePath path, String side, Personality p, boolean allowUsedNets) {
        HashSet<PinInstance> toBeRemoved = new HashSet<PinInstance>();
        OrbitIO.getCurDesign().getCurSelection().clear();
        FixedFreePinSelection.selectPortOnPersonality(path, p);
        Selection s = OrbitIO.getCurDesign().getCurSelection();
        for (PinInstance pi : s.get(PinInstance.class)) {
            if (pi.isOnUsedNet() && !allowUsedNets) {
                toBeRemoved.add(pi);
                continue;
            }
            for (DevicePath dp : s.getSelectedPaths((DbObject)pi)) {
                HierPort hp = new HierPort(dp, pi.getPinTemplate().getFirstPortTemplate());
                int thisOct = hp.getSubstrateOctantOfPin();
                if (this.sidesMatch(thisOct, side)) continue;
                toBeRemoved.add(pi);
            }
        }
        for (PinInstance pi : toBeRemoved) {
            s.remove((DbObject)pi);
        }
        long numPins = s.getCountTotal();
        OrbitIO.getCurDesign().getCurSelection().clear();
        return numPins;
    }

    protected boolean sidesMatch(int oct, String compass) {
        if (compass.equals("E")) {
            return oct == 0 || oct == 7;
        }
        if (compass.equals("N")) {
            return oct == 1 || oct == 2;
        }
        if (compass.equals("W")) {
            return oct == 3 || oct == 4;
        }
        if (compass.equals("S")) {
            return oct == 5 || oct == 6;
        }
        return false;
    }

    public CSVDocument attachCsvFile() {
        String[] h = null;
        String[] attr = new String[]{"fpName", "per", "fromS", "toS", "spread", "lock", "bundle", "diffPair", "wireW", "wireC", "order", "steal"};
        CSVDocument attachment = null;
        String tempCsvFile = System.getProperty("java.io.tmpdir") + AUTO_BUNDLE_TEMP_CSV_FILE;
        this.writeToCsv(tempCsvFile, true);
        DeviceTemplate devT = mBasePath.getDeviceTemplate();
        try {
            attachment = CSVDocument.newInstance(h);
            CSVDOMParser parser2 = new CSVDOMParser(false, attr);
            parser2.setDataSepExpression(",");
            attachment.setPath(tempCsvFile);
            attachment = parser2.parse(tempCsvFile);
            this.saveCsvAttachment(attachment, devT);
            AUtil.deleteFile((File)new File(tempCsvFile));
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logWarn((String)"Problem saving table data attachment");
            return null;
        }
        return attachment;
    }

    public void saveCsvAttachment(CSVDocument doc, DeviceTemplate devT) {
        String[] headers;
        Object buffer = "";
        for (String h : headers = doc.getAttributeNames()) {
            buffer = (String)buffer + h;
            buffer = (String)buffer + ",";
        }
        buffer = (String)buffer + "\n";
        for (int i = 0; i < doc.getItemCount(); ++i) {
            Element e = doc.getItem(i);
            for (String h : headers) {
                String val = e.getAttribute(h);
                buffer = (String)buffer + val;
                buffer = (String)buffer + ",";
            }
            buffer = (String)buffer + "\n";
        }
        Cp.exec((String)"dt = (DeviceTemplate) OrbitIO.getCurDb().getDbClass(\"DeviceTemplate\").getInstanceByKeyStr(\"%s\");", (Object[])new Object[]{devT.getKeyStr()});
        Cp.exec((String)"dt.setValue(\"%s\", \"%s\");", (Object[])new Object[]{AUTO_BUNDLE_CSV_FIELD, buffer});
    }

    public CSVDocument loadCsvAttachment() {
        String buffer = (String)mBasePath.getDeviceTemplate().getValue(AUTO_BUNDLE_CSV_FIELD);
        if (buffer == null) {
            return null;
        }
        String[] lines = buffer.split("\n");
        String[] headers = lines[0].split(",");
        try {
            CSVDocument doc = CSVDocument.newInstance((String[])headers);
            for (int i = 1; i < lines.length; ++i) {
                doc.appendItem();
                String thisLine = lines[i];
                String[] attr = thisLine.split(",");
                for (int j = 0; j < headers.length; ++j) {
                    doc.setItemValue(i - 1, headers[j], attr[j]);
                }
            }
            return doc;
        }
        catch (CSVDOMParser.CSVDOMException e) {
            ALog.logError((Throwable)e);
            return null;
        }
    }

    protected int getSidePriority(String side) {
        int priority = 10;
        if (side == null || side.isEmpty()) {
            return priority;
        }
        if (side.equals("N")) {
            return 0;
        }
        if (side.equals("NE")) {
            return 1;
        }
        if (side.equals("E")) {
            return 2;
        }
        if (side.equals("SE")) {
            return 3;
        }
        if (side.equals("S")) {
            return 4;
        }
        if (side.equals("SW")) {
            return 5;
        }
        if (side.equals("W")) {
            return 6;
        }
        if (side.equals("NW")) {
            return 7;
        }
        return priority;
    }

    protected int locPriorityCompare(String side, PortPairOpt.OptimizerAlgo optAlgo, APoint2D loc1, APoint2D loc2, long numPins1, long numPins2) {
        int priority = 0;
        if (side == null || side.isEmpty()) {
            return priority;
        }
        if (side.equals("N") || side.equals("NE")) {
            if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERRB) {
                if (loc1.getX() > loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return -1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return 1;
                }
            } else if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERLT) {
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return -1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return 1;
                }
            } else {
                if (numPins1 < numPins2) {
                    return 1;
                }
                if (numPins1 > numPins2) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
            }
        } else if (side.equals("E") || side.equals("SE")) {
            if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERRB) {
                if (loc1.getY() > loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
            } else if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERLT) {
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
            } else {
                if (numPins1 < numPins2) {
                    return 1;
                }
                if (numPins1 > numPins2) {
                    return -1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
            }
        } else if (side.equals("S") || side.equals("SW")) {
            if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERRB) {
                if (loc1.getX() > loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
            } else if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERLT) {
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
            } else {
                if (numPins1 < numPins2) {
                    return 1;
                }
                if (numPins1 > numPins2) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return -1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return 1;
                }
            }
        } else if (side.equals("W") || side.equals("NW")) {
            if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERRB) {
                if (loc1.getY() > loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return 1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return -1;
                }
            } else if (optAlgo == PortPairOpt.OptimizerAlgo.CORNERLT) {
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
                if (loc1.getX() < loc2.getX()) {
                    return 1;
                }
                if (loc1.getX() > loc2.getX()) {
                    return -1;
                }
            } else {
                if (numPins1 < numPins2) {
                    return 1;
                }
                if (numPins1 > numPins2) {
                    return -1;
                }
                if (loc1.getY() < loc2.getY()) {
                    return 1;
                }
                if (loc1.getY() > loc2.getY()) {
                    return -1;
                }
            }
        }
        return priority;
    }

    public int myDecSum(int i) {
        int sum = 0;
        if (i <= 1) {
            return 0;
        }
        sum = this.myDecSum(i - 1) + i - 1;
        return sum;
    }

    public void doChecksumOrder() {
        int size = this.mInstructionListModel.getInstructions().size();
        int expectedCount = this.myDecSum(size);
        int actualCount = 0;
        for (Instruction inst : this.mInstructionListModel.getInstructions()) {
            actualCount += inst.order;
        }
        if (expectedCount != actualCount) {
            Collections.sort(this.mInstructionListModel.getInstructions(), new InstructionSorterBySide());
            int order = 0;
            for (Instruction inst : this.mInstructionListModel.getInstructions()) {
                inst.order = order++;
            }
        } else {
            Collections.sort(this.mInstructionListModel.getInstructions(), new InstructionSorterByOrder());
        }
    }

    protected PortPairOpt.OptimizerAlgo deriveOptimizerAlgo(DevicePath dPath, APoint2D loc, String side) {
        PortPairOpt.OptimizerAlgo optAlgo = PortPairOpt.OptimizerAlgo.CORNERLT;
        ARect bounds = dPath.getBB();
        long firstMarker = 0L;
        long secondMarker = 0L;
        long splitDistance = 0L;
        if (side.equals(EscapeSides.N.toString())) {
            splitDistance = (long)(0.3 * (double)(bounds.getUR().getX() - bounds.getUL().getX()));
            firstMarker = bounds.getUL().getX() + splitDistance;
            secondMarker = bounds.getUR().getX() - splitDistance;
            if (loc.getX() > firstMarker && loc.getX() < secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CLOSESTPIN;
            } else if (loc.getX() > secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CORNERRB;
            }
        } else if (side.equals(EscapeSides.S.toString())) {
            splitDistance = (long)(0.3 * (double)(bounds.getLR().getX() - bounds.getLL().getX()));
            firstMarker = bounds.getLL().getX() + splitDistance;
            secondMarker = bounds.getLR().getX() - splitDistance;
            if (loc.getX() > firstMarker && loc.getX() < secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CLOSESTPIN;
            } else if (loc.getX() > secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CORNERRB;
            }
        } else if (side.equals(EscapeSides.E.toString())) {
            splitDistance = (long)(0.3 * (double)(bounds.getUR().getY() - bounds.getLR().getY()));
            firstMarker = bounds.getUR().getY() - splitDistance;
            secondMarker = bounds.getLR().getY() + splitDistance;
            if (loc.getY() < firstMarker && loc.getY() > secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CLOSESTPIN;
            } else if (loc.getY() < secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CORNERRB;
            }
        } else if (side.equals(EscapeSides.W.toString())) {
            splitDistance = (long)(0.3 * (double)(bounds.getUL().getY() - bounds.getLL().getY()));
            firstMarker = bounds.getUL().getY() - splitDistance;
            secondMarker = bounds.getLL().getY() + splitDistance;
            if (loc.getY() < firstMarker && loc.getY() > secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CLOSESTPIN;
            } else if (loc.getY() < secondMarker) {
                optAlgo = PortPairOpt.OptimizerAlgo.CORNERRB;
            }
        }
        return optAlgo;
    }

    protected class InstructionSorterByOrder
    implements Comparator<Instruction> {
        protected InstructionSorterByOrder() {
        }

        @Override
        public int compare(Instruction o1, Instruction o2) {
            if (o1.order < o2.order) {
                return -1;
            }
            if (o1.order > o2.order) {
                return 1;
            }
            return 0;
        }
    }

    protected class InstructionSorterBySide
    implements Comparator<Instruction> {
        protected InstructionSorterBySide() {
        }

        @Override
        public int compare(Instruction o1, Instruction o2) {
            int priority2;
            String side1 = o1.toDirection.name();
            String side2 = o2.toDirection.name();
            APoint2D avgLoc1 = o1.avgLoc;
            APoint2D avgLoc2 = o2.avgLoc;
            PortPairOpt.OptimizerAlgo opt1 = o1.optAlgo;
            PortPairOpt.OptimizerAlgo opt2 = o2.optAlgo;
            long numPins1 = o1.signalPins + o1.extraPins;
            long numPins2 = o2.signalPins + o2.extraPins;
            int priority1 = AutoBundleDlg.this.getSidePriority(side1);
            if (priority1 < (priority2 = AutoBundleDlg.this.getSidePriority(side2))) {
                return -1;
            }
            if (priority1 > priority2) {
                return 1;
            }
            if (opt1.priority() < opt2.priority()) {
                return -1;
            }
            if (opt1.priority() > opt2.priority()) {
                return 1;
            }
            return AutoBundleDlg.this.locPriorityCompare(side1, opt1, avgLoc1, avgLoc2, numPins1, numPins2);
        }
    }

    public class StatsRenderer
    extends DefaultTableCellRenderer {
        protected long avaPins = 0L;
        protected String side;
        protected Color color;

        public StatsRenderer() {
            this.side = EscapeSides.N.longDescriptor;
            this.color = Color.white;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            long neededPins;
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            this.setForeground(Color.black);
            this.setHorizontalAlignment(0);
            this.setIcon(null);
            if (column == 0) {
                this.setBackground(this.color);
            }
            if (column == 1) {
                if (o == null) {
                    this.setText("Total");
                    this.color = this.color == Color.white ? Color.LIGHT_GRAY : Color.WHITE;
                } else {
                    Personality p = (Personality)o;
                    this.setText(p.getName());
                    this.setIcon((Icon)new AColorIcon(12, 12, p.getColor()));
                }
            } else if (column == 2) {
                this.avaPins = (Long)o;
            } else if (column == 3 && this.avaPins < (neededPins = ((Long)o).longValue())) {
                this.setForeground(Color.red);
            }
            return this;
        }
    }

    protected class StatsDisplay
    extends JFrame {
        public StatsDisplay(LinkedList<AutoStats> statsList) {
            this.show(statsList);
        }

        public void show(LinkedList<AutoStats> statsList) {
            Object[] columns = new String[]{"Side", "Personality", "Available Pins", "Required Pins"};
            Object[][] data = new Object[statsList.size()][];
            int count = 0;
            Collections.sort(AutoBundleDlg.this.mStatsList, new StatsSort());
            for (AutoStats as : statsList) {
                data[count] = new Object[4];
                data[count][0] = as.side.longDescriptor;
                data[count][1] = as.per;
                data[count][2] = as.avaPins;
                data[count][3] = as.neededPins;
                ++count;
            }
            DefaultTableModel model = new DefaultTableModel(data, columns){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            JTable table = new JTable(model);
            table.setDefaultRenderer(Object.class, new StatsRenderer());
            this.add(new JScrollPane(table));
            this.setAlwaysOnTop(true);
            this.setTitle("Pin Allocation");
            this.pack();
            this.setVisible(true);
        }

        @Override
        protected void processWindowEvent(WindowEvent e) {
            super.processWindowEvent(e);
            if (e.getID() == 201) {
                AutoBundleDlg.this.mSD = null;
            }
        }
    }

    protected class StatsSort
    implements Comparator<AutoStats> {
        protected StatsSort() {
        }

        @Override
        public int compare(AutoStats o1, AutoStats o2) {
            int s2;
            int s1 = AutoBundleDlg.this.getSideOrder(o1.side);
            if (s1 < (s2 = AutoBundleDlg.this.getSideOrder(o2.side))) {
                return -1;
            }
            if (s2 < s1) {
                return 1;
            }
            AAlphaNumComp c = AAlphaNumComp.get();
            if (o1.per != null && o2.per != null) {
                return c.compare((Object)o1.per.getName(), (Object)o2.per.getName());
            }
            if (o1.per == null) {
                return 1;
            }
            return -1;
        }
    }

    class TableMouseMotionListener
    implements MouseMotionListener {
        protected JTable table;

        public TableMouseMotionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            AutoBundleDlg.this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public class TableSelectionListener
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoBundleDlg.this.mUpButton.setEnabled(false);
                    AutoBundleDlg.this.mDownButton.setEnabled(false);
                    int[] selRows = AutoBundleDlg.this.mTable.getSelectedRows();
                    int row = selRows[0];
                    boolean firstRow = true;
                    for (int curRow : selRows) {
                        if (firstRow) {
                            firstRow = false;
                            continue;
                        }
                        if (row != curRow - 1) break;
                        row = curRow;
                    }
                    if (row == selRows[selRows.length - 1]) {
                        AutoBundleDlg.this.mUpButton.setEnabled(true);
                        AutoBundleDlg.this.mDownButton.setEnabled(true);
                    }
                    if (selRows[0] == 0) {
                        AutoBundleDlg.this.mUpButton.setEnabled(false);
                    }
                    if (selRows[selRows.length - 1] == AutoBundleDlg.this.mTable.getRowCount() - 1) {
                        AutoBundleDlg.this.mDownButton.setEnabled(false);
                    }
                }
            });
        }
    }

    class TableButtonMouseListener
    extends MouseAdapter {
        protected JTable table;
        JPopupMenu popup = new JPopupMenu();
        EscapeSides fromSide = EscapeSides.N;
        EscapeSides toSide = EscapeSides.N;
        Personality per = null;
        String diffPair = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog);
        PinSpreadOptimizer.PinSpreadAlgo spread;

        public TableButtonMouseListener(JTable table) {
            this.spread = AutoBundleDlg.this.mPDList.get(0);
            this.table = table;
        }

        protected void showPopup(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            final int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            boolean getRatios = false;
            if (row >= this.table.getRowCount()) {
                return;
            }
            final Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(row);
            if (column == 3) {
                this.fromSide = instruction.fromDirection;
            } else if (column == 4) {
                this.toSide = instruction.toDirection;
            } else if (column == 5) {
                this.per = instruction.toPersonality;
            } else if (column == 9) {
                this.diffPair = instruction.diffPairAlignment;
            } else if (column == 10) {
                this.spread = instruction.pinSpread;
            } else if (column == 7) {
                getRatios = true;
            } else {
                return;
            }
            this.popup.removeAll();
            if (getRatios) {
                JMenuItem computeFromRatios = new JMenuItem("Compute from Personality ratios");
                computeFromRatios.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        instruction.extraPins = AutoBundleDlg.this.getExtraPinsFromRatios(instruction);
                        TableButtonMouseListener.this.table.repaint();
                        AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
                    }
                });
                JMenuItem computeFromRatiosAll = new JMenuItem("Compute from Personality ratios (all)");
                computeFromRatiosAll.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Instruction inst : AutoBundleDlg.this.mInstructionListModel.getInstructions()) {
                            inst.extraPins = AutoBundleDlg.this.getExtraPinsFromRatios(inst);
                        }
                        TableButtonMouseListener.this.table.repaint();
                        AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
                    }
                });
                this.popup.add(computeFromRatios);
                this.popup.add(computeFromRatiosAll);
            } else {
                JMenuItem propagate = new JMenuItem("Propagate");
                propagate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Instruction inst : AutoBundleDlg.this.mInstructionListModel.getInstructions()) {
                            if (column == 3) {
                                inst.fromDirection = TableButtonMouseListener.this.fromSide;
                                continue;
                            }
                            if (column == 4) {
                                inst.toDirection = TableButtonMouseListener.this.toSide;
                                continue;
                            }
                            if (column == 5) {
                                inst.toPersonality = TableButtonMouseListener.this.per;
                                continue;
                            }
                            if (column == 9) {
                                inst.diffPairAlignment = TableButtonMouseListener.this.diffPair;
                                continue;
                            }
                            if (column != 10) continue;
                            inst.pinSpread = TableButtonMouseListener.this.spread;
                        }
                        TableButtonMouseListener.this.table.repaint();
                        AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
                    }
                });
                this.popup.add(propagate);
            }
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            } else {
                TableColumnModel columnModel = this.table.getColumnModel();
                int column = columnModel.getColumnIndexAtX(e.getX());
                int row = e.getY() / this.table.getRowHeight();
                if (e.getClickCount() != 2 || e.getButton() != 1 || !e.isConsumed()) {
                    // empty if block
                }
                Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(row);
                if (column == 0) {
                    instruction.locked = instruction.locked == false;
                    OrbitIO.getApp().refreshCurrentView(false);
                    AutoBundleDlg.this.mTable.repaint();
                } else if (column == 1) {
                    instruction.bundleIt = instruction.bundleIt == false;
                    OrbitIO.getApp().refreshCurrentView(false);
                    AutoBundleDlg.this.mTable.repaint();
                }
            }
        }
    }

    class HeaderPopupListener
    extends MouseAdapter {
        HeaderPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        protected int getCol(int x) {
            TableColumnModel columnModel = AutoBundleDlg.this.mTable.getColumnModel();
            int column = columnModel.getColumnIndexAtX(x);
            return column;
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int x = e.getX();
                int col = this.getCol(x);
                if (col == 0) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction("Lock all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AutoBundleDlg.this.setLockAll(true);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction("Unlock all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AutoBundleDlg.this.setLockAll(false);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
                if (col == 1) {
                    JPopupMenu pop = new JPopupMenu();
                    ButtonGroup group = new ButtonGroup();
                    group.add(new JRadioButtonMenuItem(new AbstractAction("Bundle all"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AutoBundleDlg.this.setBundleAll(true);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    group.add(new JRadioButtonMenuItem(new AbstractAction("Bundle none"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AutoBundleDlg.this.setBundleAll(false);
                        }
                    }){

                        @Override
                        public void addNotify() {
                            super.addNotify();
                        }
                    });
                    for (AbstractButton b : AUtil.getIterable(group.getElements())) {
                        pop.add((JMenuItem)b);
                    }
                    pop.show(e.getComponent(), e.getX(), e.getY());
                    return;
                }
            }
        }
    }

    public static class BundleSorter
    implements Comparator<Bundle> {
        @Override
        public int compare(Bundle b0, Bundle b1) {
            String t1;
            String t0;
            AAlphaNumComp c = AAlphaNumComp.get();
            int ct = c.compare((Object)(t0 = b0.getTemplate().getName()), (Object)(t1 = b1.getTemplate().getName()));
            if (ct != 0) {
                return ct;
            }
            return c.compare((Object)b0.getName(), (Object)b1.getName());
        }
    }

    public class InstructionRenderer
    extends DefaultTableCellRenderer {
        protected ArrayList<PinTemplate> ioPorts = null;
        protected DeviceTemplate lastDT = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object o, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(row);
            if (instruction == null) {
                return this;
            }
            this.setIcon(null);
            this.setText(null);
            this.setForeground(Color.black);
            this.setBackground(row % 2 == 0 ? Color.lightGray : Color.white);
            this.setHorizontalAlignment(0);
            this.setToolTipText("");
            if (isSelected) {
                Floorplan.setHighlightedObject(null);
                Floorplan.setHighlightedObject((DbObject)instruction.fromInterface.getFloorplan(mBasePath.getDeviceTemplate(), false));
                this.setBackground(Color.orange);
                OrbitIO.getApp().refreshCurrentView(false);
            }
            if (column == 0) {
                this.setIcon(instruction.locked != false ? OrbitIcons.LOCK : null);
            }
            if (column == 1) {
                this.setIcon(instruction.bundleIt != false ? OrbitIcons.CHECK : OrbitIcons.CROSS);
            } else if (column == 2) {
                this.setHorizontalAlignment(2);
                this.setText(instruction.fromInterface.toStringPath());
                this.setIcon((Icon)new AColorIcon(12, 12, instruction.fromInterface.getColor()));
            } else if (column == 5) {
                Personality p = instruction.toPersonality;
                if (p != null) {
                    this.setText(p.getName());
                    this.setIcon((Icon)new AColorIcon(12, 12, p.getColor()));
                } else {
                    this.setText(AutoBundleDlg.PERSONALITY_ANY);
                }
            } else if (column == 3) {
                this.setText(instruction.fromDirection != null && instruction.fromDirection.longDescriptor != null ? instruction.fromDirection.longDescriptor : EscapeSides.DEFAULT.longDescriptor);
            } else if (column == 4) {
                this.setText(instruction.toDirection != null && instruction.toDirection.longDescriptor != null ? instruction.toDirection.longDescriptor : EscapeSides.DEFAULT.longDescriptor);
            } else if (column == 9) {
                if (instruction.diffPairAlignment != null) {
                    this.setText(DiffPairFinder.costToFunction((String)instruction.diffPairAlignment).getName());
                } else {
                    String opt = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog);
                    this.setText(DiffPairFinder.costToFunction((String)opt).getName());
                }
            } else if (column == 6) {
                this.setText(Long.toString(instruction.signalPins));
            } else if (column == 7) {
                this.setText(Long.toString(instruction.extraPins));
            } else if (column == 8) {
                if (instruction.unfilledPins != 0L) {
                    this.setForeground(Color.red);
                }
                this.setText(Long.toString(instruction.unfilledPins));
            } else if (column == 10) {
                PinSpreadOptimizer.PinSpreadAlgo pdS = instruction.pinSpread;
                this.setText(pdS != null ? pdS.name() : AutoBundleDlg.this.mPDList.get(0).name());
            }
            return this;
        }
    }

    public class ColumnHeaderRender
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (AutoBundleDlg.this.tcr == null) {
                return null;
            }
            Component component = AutoBundleDlg.this.tcr.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = null;
            if (!(component instanceof JLabel)) {
                return null;
            }
            label = (JLabel)component;
            label.setToolTipText("");
            label.setIcon(null);
            if (column == 0) {
                label.setText("");
                label.setIcon(OrbitIcons.LOCK);
                label.setToolTipText("Locking the row will prevent further changes");
            } else if (column == 1) {
                label.setText("<html><b>B");
                label.setToolTipText("Checking this row will bundle the floorplan. Un-checking it will only perform floorplan optimization.");
            } else if (column == 2) {
                label.setText("<html><b>Floorplan");
            } else if (column == 5) {
                label.setText("<html><b>To Personality");
            } else if (column == 3) {
                label.setText("<html><b>From Side");
            } else if (column == 4) {
                label.setText("<html><b>To Side");
            } else if (column == 9) {
                label.setText("<html><b>Diff Pair");
            } else if (column == 6) {
                label.setText("<html><b>Signal Pins");
            } else if (column == 7) {
                label.setText("<html><b>Extra Pins");
            } else if (column == 8) {
                label.setText("<html><b>Unfilled Pins");
            } else if (column == 10) {
                label.setText("<html><b>Spread");
            }
            return component;
        }
    }

    class InstructionListModel
    extends AbstractTableModel {
        protected LinkedList<Instruction> instructionRows = new LinkedList();
        private String[] columnNames = new String[]{"Lock", "Bundle", "From Floorplan", "From Side", "To Side", "To Personality", "Signal Pins", "Extra Pins", "Unfilled Pins", "Diff Pair", "Spread"};

        public LinkedList<Instruction> getInstructions() {
            return this.instructionRows;
        }

        public Instruction getRow(int row) {
            if (row < this.instructionRows.size()) {
                return this.instructionRows.get(row);
            }
            return null;
        }

        public Instruction getRow(String floorplanStr) {
            int rowNum = 0;
            for (Instruction inst : this.getInstructions()) {
                Floorplan fp = inst.fromInterface.getFloorplan(mBasePath.getParent().getDeviceTemplate(), false);
                if (!fp.getKeyStr().equals(floorplanStr)) {
                    ++rowNum;
                    continue;
                }
                return this.getRow(rowNum);
            }
            return null;
        }

        public void sortTable() {
            Collections.sort(this.instructionRows, new InstructionSorterByOrder());
            AutoBundleDlg.this.mTable.repaint();
        }

        public boolean isFloorplanInUse(Floorplan fp, DevicePath fromPath, DevicePath toPath) {
            for (Net net : fp.getMyInterface().getNets(true)) {
                if (!net.getWires().hasNext()) continue;
                return true;
            }
            Interface fromInterface = fp.getMyInterface();
            DeviceTemplate fromTemplate = fromPath.getDeviceTemplate();
            DeviceTemplate toTemplate = toPath.getDeviceTemplate();
            Floorplan floorplan = fromInterface.getFloorplan(fromTemplate, false);
            Bundle curBundle = Bundle.getBundle((Db)AutoBundleDlg.this.mDb, (String)floorplan.getMyInterface().toStringPath(), (DeviceTemplate)toTemplate);
            return curBundle != null;
        }

        public void buildTableFromFloorplans() {
            this.instructionRows.clear();
            AutoBundleDlg.this.mTable.clearSelection();
            Substrate s = mBasePath.getSubstrate();
            LinkedList set = Floorplan.deriveAllFloorplans((Db)s.getDb(), (Substrate)s);
            for (Floorplan fp : AUtil.linkedList((Collection)set)) {
                try {
                    if (fp.getIOCount() != 0 && !fp.getIOs().isEmpty() && fp.getDeviceTemplate() == mBasePath.getDeviceTemplate()) continue;
                    set.remove(fp);
                }
                catch (Floorplan.InvalidDataException invalidDataException) {}
            }
            for (Floorplan fp : set) {
                Floorplan toFp = fp.getMyInterface().getFloorplan(mBasePath.getParent().getDeviceTemplate(), false);
                Instruction instruction = new Instruction();
                instruction.diffPairAlignment = DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog);
                instruction.extraPins = AutoBundleDlg.this.loadExtraPins(toFp);
                instruction.signalPins = fp.getIOs().size();
                instruction.locked = this.isFloorplanInUse(fp, mBasePath, mBasePath.getParent());
                instruction.bundleIt = true;
                int escapeSide = AutoBundleDlg.getSide(fp.getKeyStr());
                instruction.toDirection = instruction.fromDirection = EscapeSides.fromOct(escapeSide);
                LinkedList ioPers = toFp.getIOPersonalities();
                instruction.toPersonality = ioPers.size() == 1 ? (Personality)ioPers.get(0) : null;
                instruction.fromInterface = fp.getMyInterface();
                instruction.fromPath = mBasePath;
                instruction.toPath = mBasePath.getParent();
                instruction.pinSpread = AutoBundleDlg.this.mPDList.get(0);
                instruction.order = 0;
                AGeom geom = fp.getHull(mBasePath, false);
                instruction.avgLoc = geom.getBounds().center();
                instruction.optAlgo = AutoBundleDlg.this.deriveOptimizerAlgo(mBasePath, instruction.avgLoc, instruction.fromDirection.toString());
                this.instructionRows.add(instruction);
            }
            CSVDocument csvDoc = AutoBundleDlg.this.loadCsvAttachment();
            if (csvDoc != null) {
                for (int i = 0; i < csvDoc.getItemCount(); ++i) {
                    String value = csvDoc.getItemValue(i, "fpName");
                    Instruction inst = AutoBundleDlg.this.mInstructionListModel.getRow(value);
                    if (inst == null) continue;
                    value = csvDoc.getItemValue(i, "per");
                    if (value.equals(AutoBundleDlg.PERSONALITY_ANY)) {
                        inst.toPersonality = null;
                    } else {
                        Optional p = Personality.getPersonality((DeviceTemplate)mBasePath.getParent().getDeviceTemplate(), (Personality.Type)Personality.Type.PORT, (String)value);
                        if (p.isPresent()) {
                            inst.toPersonality = (Personality)p.get();
                        }
                    }
                    value = csvDoc.getItemValue(i, "fromS");
                    inst.fromDirection = value.equals("DEFAULT") ? null : EscapeSides.valueOf(value);
                    value = csvDoc.getItemValue(i, "toS");
                    inst.toDirection = value.equals("DEFAULT") ? null : EscapeSides.valueOf(value);
                    value = csvDoc.getItemValue(i, "spread");
                    PinSpreadOptimizer.PinSpreadAlgo pinSpread = PinSpreadOptimizer.PinSpreadRegistry.getPinSpreadAlgo(value);
                    if (pinSpread != null) {
                        inst.pinSpread = pinSpread;
                    }
                    value = csvDoc.getItemValue(i, "lock");
                    inst.locked = value.equalsIgnoreCase("TRUE");
                    value = csvDoc.getItemValue(i, "bundle");
                    inst.bundleIt = value.equalsIgnoreCase("TRUE");
                    inst.diffPairAlignment = value = csvDoc.getItemValue(i, "diffPair");
                    value = csvDoc.getItemValue(i, "wireW");
                    AutoBundleDlg.this.mWireWidth.setText(value);
                    value = csvDoc.getItemValue(i, "wireC");
                    AutoBundleDlg.this.mWireClearance.setText(value);
                    value = csvDoc.getItemValue(i, "order");
                    if (value != null && !value.isEmpty()) {
                        inst.order = Integer.parseInt(value);
                    }
                    value = csvDoc.getItemValue(i, "steal");
                    AutoBundleDlg.this.mAllowSteal.setSelected(value.equalsIgnoreCase("TRUE"));
                }
            }
            AutoBundleDlg.this.doChecksumOrder();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 3 || col == 4 || col == 5 || col == 7 || col == 10 || col == 9;
        }

        @Override
        public int getRowCount() {
            return this.instructionRows.size();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(row);
            if (instruction == null) {
                return;
            }
            if (col == 3) {
                instruction.fromDirection = (EscapeSides)((Object)value);
            } else if (col == 4) {
                instruction.toDirection = (EscapeSides)((Object)value);
                AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
            } else if (col == 5) {
                instruction.toPersonality = (Personality)value;
                instruction.extraPins = AutoBundleDlg.this.getExtraPinsFromRatios(instruction);
                AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
                AutoBundleDlg.this.mTable.repaint();
            } else if (col == 9) {
                instruction.diffPairAlignment = value == null ? DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog) : (String)value;
            } else if (col == 7) {
                instruction.extraPins = Math.abs(Long.valueOf((String)value));
                AutoBundleDlg.this.updatePinCounts(AutoBundleDlg.this.mAllowSteal.isSelected());
                AutoBundleDlg.this.buildStatsMap(AutoBundleDlg.this.mAllowSteal.isSelected());
            } else if (col == 10) {
                instruction.pinSpread = value == null ? AutoBundleDlg.this.mPDList.get(0) : (PinSpreadOptimizer.PinSpreadAlgo)value;
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return null;
        }
    }

    public class SpreadEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private SpreadSelectorCombo comboBox = null;

        public SpreadEditor() {
            this.comboBox = new SpreadSelectorCombo();
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoBundleDlg.this.mTable.getColumnModel().getColumn(10).getCellEditor().stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(rowIndex);
            if (instruction == null) {
                return this.comboBox;
            }
            boolean locked = instruction.locked;
            if (locked) {
                this.comboBox.setEnabled(false);
                this.comboBox.setBorder(null);
            } else {
                this.comboBox.setEnabled(true);
                this.comboBox.setSelectedItem(value);
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, vColIndex);
            }
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    public class SpreadSelectorCombo
    extends JComboBox<PinSpreadOptimizer.PinSpreadAlgo> {
        public SpreadSelectorCombo() {
            this.updateSpreadCombo();
            this.setRenderer(new SpreadRenderer());
        }

        protected void updateSpreadCombo() {
            for (PinSpreadOptimizer.PinSpreadAlgo p : AutoBundleDlg.this.mPDList) {
                this.addItem(p);
            }
        }

        class SpreadRenderer
        extends DefaultListCellRenderer {
            SpreadRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof PinSpreadOptimizer.PinSpreadAlgo) {
                    PinSpreadOptimizer.PinSpreadAlgo p = (PinSpreadOptimizer.PinSpreadAlgo)value;
                    this.setText(p.name());
                }
                if (value == null) {
                    this.setText(AutoBundleDlg.this.mPDList.get(0).name());
                }
                return c;
            }
        }
    }

    public class ExtraPinsEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(rowIndex);
            if (instruction == null) {
                return this.component;
            }
            ((JTextField)this.component).setText(Long.toString(instruction.extraPins));
            boolean locked = instruction.locked;
            if (locked) {
                ((JTextField)this.component).setEditable(false);
                ((JTextField)this.component).setBorder(null);
            } else {
                ((JTextField)this.component).setEditable(true);
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    public class DiffPairEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private DiffPairCombo comboBox = null;

        public DiffPairEditor() {
            this.comboBox = new DiffPairCombo();
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoBundleDlg.this.mTable.getColumnModel().getColumn(9).getCellEditor().stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(rowIndex);
            if (instruction == null) {
                return this.comboBox;
            }
            boolean locked = instruction.locked;
            if (locked) {
                this.comboBox.setEnabled(false);
                this.comboBox.setBorder(null);
            } else {
                this.comboBox.setEnabled(true);
                this.comboBox.setSelectedItem(value);
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, vColIndex);
            }
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    static class DiffPairRenderer
    extends DefaultListCellRenderer {
        DiffPairRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            String opt = value == null ? DiffPairFinder.getInitialDiffPairAlgo((Db)OrbitIO.getCurDb(), null, (String[])DiffPairFinder.CostFunctionCatalog) : (String)value;
            this.setText(DiffPairFinder.costToFunction((String)opt).getName());
            return this;
        }
    }

    public class DiffPairCombo
    extends JComboBox<String> {
        public DiffPairCombo() {
            this.updateDiffPairCombo();
            this.setRenderer(new DiffPairRenderer());
        }

        protected void updateDiffPairCombo() {
            String[] optAlgos;
            for (String st : optAlgos = DiffPairFinder.CostFunctionCatalog) {
                this.addItem(st);
            }
        }
    }

    public class ToPersonalityEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private PersonalitySelectorCombo comboBox = null;

        public ToPersonalityEditor(DevicePath path) {
            this.comboBox = new PersonalitySelectorCombo(path);
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoBundleDlg.this.mTable.getColumnModel().getColumn(5).getCellEditor().stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(rowIndex);
            if (instruction == null) {
                return this.comboBox;
            }
            boolean locked = instruction.locked;
            if (locked) {
                this.comboBox.setEnabled(false);
                this.comboBox.setBorder(null);
            } else {
                this.comboBox.setEnabled(true);
                this.comboBox.setSelectedItem(value);
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, vColIndex);
            }
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    public class PersonalitySelectorCombo
    extends JComboBox<Personality> {
        DevicePath mPath;

        public PersonalitySelectorCombo(DevicePath path) {
            this.mPath = path;
            this.updatePersonalityCombo(path);
            this.setRenderer(new PersonalityRenderer());
        }

        protected void updatePersonalityCombo(DevicePath path) {
            ArrayList personalityList = new ArrayList();
            personalityList.add(null);
            Personality.getPersonalities((DeviceTemplate)path.getDeviceTemplate(), (Personality.Type)Personality.Type.PORT).forEach(p -> personalityList.add(p));
            Collections.sort(personalityList);
            for (Personality p2 : personalityList) {
                this.addItem(p2);
            }
        }

        class PersonalityRenderer
        extends DefaultListCellRenderer {
            PersonalityRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof Personality) {
                    Personality p = (Personality)value;
                    this.setText(p.getName());
                    this.setIcon((Icon)new AColorIcon(12, 12, p.getColor()));
                }
                if (value == null) {
                    this.setText(AutoBundleDlg.PERSONALITY_ANY);
                }
                return c;
            }
        }
    }

    public class EscapeSideEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private EscapeSideCombo comboBox = null;

        public EscapeSideEditor(final boolean fromSide) {
            this.comboBox = new EscapeSideCombo(fromSide);
            this.comboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutoBundleDlg.this.mTable.getColumnModel().getColumn(fromSide ? 3 : 4).getCellEditor().stopCellEditing();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            Instruction instruction = AutoBundleDlg.this.mInstructionListModel.getRow(rowIndex);
            if (instruction == null) {
                return this.comboBox;
            }
            boolean locked = instruction.locked;
            if (locked) {
                this.comboBox.setEnabled(false);
                this.comboBox.setBorder(null);
            } else {
                this.comboBox.setEnabled(true);
                this.comboBox.setSelectedItem(value);
                TableModel model = table.getModel();
                model.setValueAt(value, rowIndex, vColIndex);
            }
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }
    }

    public class EscapeSideCombo
    extends JComboBox<EscapeSides> {
        public EscapeSideCombo(boolean fromSide) {
            this.updateEscapeSideCombo(fromSide);
            this.setRenderer(new EscapeSideRenderer());
        }

        protected void updateEscapeSideCombo(boolean fromSide) {
            for (EscapeSides es : EscapeSides.values()) {
                if (!es.equals((Object)EscapeSides.DEFAULT) && !es.equals((Object)EscapeSides.N) && !es.equals((Object)EscapeSides.S) && !es.equals((Object)EscapeSides.E) && !es.equals((Object)EscapeSides.W)) continue;
                this.addItem(es);
            }
        }

        class EscapeSideRenderer
        extends DefaultListCellRenderer {
            EscapeSideRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof EscapeSides) {
                    EscapeSides p = (EscapeSides)((Object)value);
                    this.setText(p.longDescriptor);
                }
                if (value == null) {
                    this.setText(EscapeSides.DEFAULT.longDescriptor);
                }
                return c;
            }
        }
    }

    protected class Instruction {
        Boolean locked;
        Boolean bundleIt;
        Interface fromInterface;
        DevicePath fromPath;
        DevicePath toPath;
        Personality toPersonality;
        EscapeSides fromDirection;
        EscapeSides toDirection;
        String diffPairAlignment;
        long signalPins;
        long extraPins;
        long unfilledPins;
        PinSpreadOptimizer.PinSpreadAlgo pinSpread;
        int order;
        APoint2D avgLoc;
        PortPairOpt.OptimizerAlgo optAlgo;

        protected Instruction() {
        }
    }

    public static enum EscapeSides {
        N("North"),
        NW("North West"),
        W("West"),
        SW("South West"),
        S("South"),
        SE("South East"),
        E("East"),
        NE("North East"),
        DEFAULT("Default");

        private String longDescriptor;

        public static EscapeSides fromOct(int o) {
            switch (o) {
                case 0: {
                    return E;
                }
                case 1: {
                    return NE;
                }
                case 2: {
                    return N;
                }
                case 3: {
                    return NW;
                }
                case 4: {
                    return W;
                }
                case 5: {
                    return SW;
                }
                case 6: {
                    return S;
                }
                case 7: {
                    return SE;
                }
            }
            return DEFAULT;
        }

        private EscapeSides(String ld) {
            this.longDescriptor = ld;
        }

        public String toString() {
            return this.longDescriptor;
        }
    }

    protected class AutoStats {
        EscapeSides side;
        Personality per;
        long avaPins;
        long neededPins;

        public AutoStats(EscapeSides s, Personality p, long a, long n) {
            this.side = s;
            this.per = p;
            this.avaPins = a;
            this.neededPins = n;
        }
    }
}

