/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.reporter.AReport;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;

public class BrowserUI
extends JFrame
implements HyperlinkListener {
    protected static final String ENAME_PAGE = "page.htm";
    protected static final String ENAME_SNAPSHOT = "SnapShot.png";
    protected File mHtmlFile = null;
    protected File mHtmlImage = null;
    protected AReport mReport = null;
    protected JEditorPane mHtmlPane;
    protected AFileChooserControl mStyleSheet = new AFileChooserControl();
    protected JButton mButLoadPage = new JButton("Go");
    protected JButton mButSave = new JButton("Save");
    protected JButton mButClose = new JButton("Close");
    protected ActionListener mSaveListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)AFileFilter.HTML);
            if (fc.showSaveDialog((Component)BrowserUI.this) != 0) {
                return;
            }
            BrowserUI.this.copyFile(BrowserUI.this.mHtmlFile, fc.getSelectedFile());
            String imgName = BrowserUI.this.getImageFileName(BrowserUI.this.mHtmlFile);
            String n = fc.getSelectedFile().getParent() + File.separatorChar + imgName;
            BrowserUI.this.copyFile(BrowserUI.this.mHtmlImage, new File(n));
        }
    };
    protected ActionListener mListenerLoadPage = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserUI.this.loadReport(BrowserUI.this.mStyleSheet.getPath());
        }
    };
    protected ActionListener mListenerClose = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowserUI.this.onClose();
        }
    };

    public static void showMe(String type, String text) {
        try {
            BrowserUI ui = new BrowserUI(type, text);
            ui.init();
            ui.setVisible(true);
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    public static void showMe(String type, String styleSheet, AReport report) {
        BrowserUI ui = new BrowserUI(type, styleSheet, report);
        ui.init();
        ui.setVisible(true);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.mHtmlPane.setPage(e.getURL());
            }
            catch (IOException ioe) {
                ALog.logError((String)"Can't follow link to %s : %s", (Object[])new Object[]{e.getURL().toExternalForm(), ioe.getMessage()});
            }
        }
    }

    protected BrowserUI(String type, String styleSheet, AReport report) {
        assert (report != null);
        this.mHtmlPane = new JEditorPane();
        this.mHtmlPane.setContentType(type);
        this.mReport = report;
        this.loadReport(styleSheet);
    }

    protected BrowserUI(String type, String text) {
        this.mHtmlPane = new JEditorPane();
        this.mHtmlPane.setContentType(type);
        this.createPage(text);
        this.loadPage();
    }

    protected void loadPage() {
        try {
            this.mHtmlPane.setPage("file:///" + this.mHtmlFile.getAbsolutePath());
        }
        catch (IOException e) {
            ALog.logError((String)e.getMessage());
        }
    }

    protected void createPage(String text) {
        try {
            this.mHtmlFile = File.createTempFile("Report", ".html");
            this.mHtmlFile.deleteOnExit();
            String imgName = this.getImageFileName(this.mHtmlFile);
            Object tagSnapShot = "<h1 align=center> <img src=" + imgName + "> </h1>";
            String regex = "<\\s*body(\"[^\"]*\"|'[^']*'|[^'\">])*>";
            tagSnapShot = new String(((String)tagSnapShot).getBytes(), "UTF-8");
            Pattern p = Pattern.compile("<\\s*body(\"[^\"]*\"|'[^']*'|[^'\">])*>");
            Matcher m = p.matcher((CharSequence)text);
            if (!m.find()) {
                text = (String)tagSnapShot + (String)text;
            } else {
                text = ((String)text).substring(0, m.end() + 1) + (String)tagSnapShot + ((String)text).substring(m.end() + 1);
                while (m.find()) {
                    text = ((String)text).substring(0, m.end() + 1) + (String)tagSnapShot + ((String)text).substring(m.end() + 1);
                }
            }
            try (FileOutputStream os = new FileOutputStream(this.mHtmlFile);){
                ((OutputStream)os).write(((String)text).getBytes("UTF-8"));
            }
            this.mHtmlImage = new File(this.mHtmlFile.getParent() + File.separatorChar + imgName);
            this.mHtmlImage.deleteOnExit();
            os = new FileOutputStream(this.mHtmlImage);
            try {
                OrbitIO.getApp().snapShotCurrentView(os, "");
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e);
        }
    }

    protected void loadReport(String styleSheet) {
        if (styleSheet == null || styleSheet.isEmpty()) {
            return;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            this.mReport.print(styleSheet, (Writer)w);
            String text = out.toString("UTF-8");
            this.createPage(text);
            this.loadPage();
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
        }
    }

    protected void onClose() {
        this.setVisible(false);
    }

    protected void init() {
        this.mHtmlPane.setEditable(false);
        this.mHtmlPane.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane(this.mHtmlPane);
        this.setTitle("Report");
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.pushFillX();
        this.mStyleSheet.getTextField().addActionListener(this.mListenerLoadPage);
        this.mButLoadPage.addActionListener(this.mListenerLoadPage);
        AFileFilter filter = new AFileFilter("xsl", "Extensible Stylesheet Language");
        this.mStyleSheet.addChoosableFileFilter(filter);
        l.add("Style sheet:").setLabelFor((Component)this.mStyleSheet);
        l.add((Component)this.mStyleSheet, (GridBagConstraints)GridBagManager.FILLX);
        Insets i = this.mStyleSheet.getInsets();
        this.remove((Component)this.mStyleSheet);
        l.add((Component)this.mStyleSheet, (GridBagConstraints)GridBagManager.FILLX.insets(0, 0, 0, i.right));
        l.addNl((Component)this.mButLoadPage, (GridBagConstraints)GridBagManager.LEFT.insets(0, i.left, 0, 0));
        l.popNl();
        l.pushFill();
        JScrollPane sp = new JScrollPane(scrollPane);
        sp.setPreferredSize(new Dimension(500, 500));
        l.add((Component)sp, (GridBagConstraints)GridBagManager.FILLALL);
        l.popNl();
        l.pushFillX();
        l.addFillX();
        l.add((Component)this.mButSave, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mButClose, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.popNl();
        this.mButSave.addActionListener(this.mSaveListener);
        this.mButClose.addActionListener(this.mListenerClose);
        this.setResizable(true);
        this.pack();
        UIUtil.center((Component)this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BrowserUI.this.onClose();
            }
        });
    }

    protected String getImageFileName(File htmlFile) {
        String htmlName = htmlFile.getName();
        int i = htmlName.lastIndexOf(".");
        return (i >= 0 ? htmlName.substring(0, i) : htmlName) + "_SnapShot.png";
    }

    protected boolean copyFile(File src, File target) {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(target);){
            byte[] buffer = new byte[256];
            int len = in.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = in.read(buffer);
            }
        }
        catch (Exception e) {
            ALog.logError((String)e.getMessage());
            return false;
        }
        return true;
    }
}

