/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.BumpMappingExport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.filechooser.FileFilter;

public class BumpMappingUI {
    public static Action getAction(DevicePath path) {
        return new AbstractAction("Export Bump Mapping"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BumpMappingUI.showUI();
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitApp.getCurDb() != null;
            }
        };
    }

    public static void showUI() {
        AFileChooser fc = new AFileChooser();
        AFileFilter fileFilter = new AFileFilter("bm", "Bump Mapping");
        fc.addChoosableFileFilter((FileFilter)fileFilter);
        fc.setFileFilter((FileFilter)fileFilter);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Export Bump Mapping file");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File fcFilePath = fc.getSelectedFile();
        if (fcFilePath == null) {
            return;
        }
        String fileName = fcFilePath.getPath();
        BumpMappingUI.exportBumpMapping(fileName);
    }

    private static void exportBumpMapping(String fileName) {
        Cp.exec((String)"unset(\"_bmExport\");", (Object[])new Object[0]);
        Cp.exec((String)"_bmExport = new %s(OrbitIO.getCurDb());", (Object[])new Object[]{AReflection.getJavaClassName(BumpMappingExport.class)});
        Cp.exec((String)"_bmExport.export(%s);", (Object[])new Object[]{Cp.getFileAsArgument((String)fileName)});
        Cp.exec((String)"unset(\"_bmExport\");", (Object[])new Object[0]);
    }

    private BumpMappingUI() {
    }
}

