/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APatternColor;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.NamedGrid;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.PersonalityListRenderer;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.BumpFactoryData;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class BumpPadFeasibilityUI {
    static BumpPadFeasibilityUI theBumpPadFeasibilityUI;
    BumpPadFeasibilityDlg mDlg = null;
    protected String mDesignName;
    protected Db mMyDb;
    protected DeviceTemplate mDieTemplate;
    protected Layer mLayer;
    protected String mGroupName;

    public static void newOne() throws LSession.NoLicenseException {
        theBumpPadFeasibilityUI = new BumpPadFeasibilityUI();
        theBumpPadFeasibilityUI.show(null);
        theBumpPadFeasibilityUI.enableTabs();
    }

    public static void show() {
        if (theBumpPadFeasibilityUI == null) {
            try {
                theBumpPadFeasibilityUI = new BumpPadFeasibilityUI();
            }
            catch (LSession.NoLicenseException e) {
                return;
            }
        }
        theBumpPadFeasibilityUI.show(OrbitIO.getMainWindow());
        theBumpPadFeasibilityUI.enableTabs();
    }

    public void show(Window owner) {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg = new BumpPadFeasibilityDlg(owner);
            BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.setTitle("Bump Feasability");
        }
        BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.setVisible(true);
    }

    protected void enableTabs() {
    }

    protected DeviceTemplate getDieTemplate() {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            return null;
        }
        return BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.bumpCreationPanel.getDeviceTemplate();
    }

    protected DevicePath getDevicePath() {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            return null;
        }
        return BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.bumpCreationPanel.getDevicePath();
    }

    protected String getGroupName() {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            return null;
        }
        return BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.bumpCreationPanel.getGroupName();
    }

    protected Layer getLayer() {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            return null;
        }
        return BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.bumpCreationPanel.getLayer();
    }

    protected Personality getPersonality() {
        if (BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg == null) {
            return null;
        }
        return BumpPadFeasibilityUI.theBumpPadFeasibilityUI.mDlg.bumpCreationPanel.getPersonality();
    }

    class SelectPersonalityPopupListener
    implements ActionListener {
        JPopupMenu menu;
        Substrate substrate;
        Component c;
        ArrayList<Personality> selectedPersonality = new ArrayList();

        SelectPersonalityPopupListener(Component c) {
            this.menu = new JPopupMenu();
            this.c = c;
        }

        public void setSubstrate(Substrate s) {
            this.substrate = s;
        }

        public ArrayList<Personality> getSelectedPersonality() {
            return this.selectedPersonality;
        }

        private void showPopup() {
            this.menu.removeAll();
            for (DeviceTemplate devTemp : this.substrate.getDeviceTemplates()) {
                Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(personality -> {
                    JCheckBoxMenuItem p1 = new JCheckBoxMenuItem(personality.getName());
                    AColorIcon icon = new AColorIcon(16, 16, personality.getColor());
                    p1.setIcon((Icon)icon);
                    p1.addActionListener(new HitPersonality((Personality)personality));
                    this.menu.add(p1);
                    if (this.selectedPersonality.contains(personality)) {
                        p1.setSelected(true);
                    } else {
                        p1.setSelected(false);
                    }
                });
            }
            this.menu.show(this.c, this.c.getWidth(), 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.showPopup();
        }

        public class HitPersonality
        extends AbstractAction {
            protected Personality p;

            public HitPersonality(Personality p) {
                this.p = p;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SelectPersonalityPopupListener.this.selectedPersonality.contains(this.p)) {
                    SelectPersonalityPopupListener.this.selectedPersonality.remove(this.p);
                } else {
                    SelectPersonalityPopupListener.this.selectedPersonality.add(this.p);
                }
            }
        }
    }

    class LayerRenderer
    extends DefaultListCellRenderer {
        DevicePath dp;

        LayerRenderer() {
        }

        public void setDevicePath(DevicePath dp) {
            this.dp = dp;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Layer) {
                Layer l = (Layer)value;
                this.setText(l.getName());
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                DevicePath path = this.dp;
                APatternColor color = colorizer.getColor(path, l);
                if (color != null) {
                    this.setIcon((Icon)new AColorIcon(16, 16, color.getColor()));
                }
            }
            return c;
        }
    }

    protected class BumpPadFeasibilityDlg
    extends ADialog {
        protected JTabbedPane tabPane;
        protected GridPanel gridPanel;
        protected BumpCreationPanel bumpCreationPanel;
        protected PackageEscapeRoute packageEscapeRoutePanel;
        protected RDLRoute rdlRoutePanel;
        Db.DbListener mDbListener;

        public BumpPadFeasibilityDlg(Window owner) throws HeadlessException {
            super(owner);
            this.tabPane = new JTabbedPane(1, 1);
            this.gridPanel = new GridPanel();
            this.bumpCreationPanel = new BumpCreationPanel();
            this.packageEscapeRoutePanel = new PackageEscapeRoute();
            this.rdlRoutePanel = new RDLRoute();
            this.mDbListener = new Db.DbListenerAdapter(){

                public void dbLoaded(Db db) {
                    BumpPadFeasibilityUI.this.mMyDb = db;
                    BumpPadFeasibilityUI.this.enableTabs();
                }

                public void dbClosing(Db db) {
                    BumpPadFeasibilityUI.this.mMyDb = null;
                    BumpPadFeasibilityUI.this.enableTabs();
                }
            };
            GridBagManager l = new GridBagManager(this.getContentPane());
            Icon ICON_DIE = DBEResources.ICON_DIE;
            Icon ICON_PACKAGE = DBEResources.ICON_PACKAGE;
            Icon ICON_COG = DBEResources.ICON_COG_EDIT;
            l.pushFill();
            this.tabPane.addTab("Bump Creation", ICON_DIE, this.bumpCreationPanel, "Create a matrix bump pattern");
            this.tabPane.addTab("Package Route", ICON_PACKAGE, this.packageEscapeRoutePanel, "Route current bump pattern");
            this.tabPane.addTab("RDL Route", ICON_DIE, this.rdlRoutePanel, "Route current bump pattern");
            this.tabPane.addTab("General", ICON_COG, this.gridPanel, "Set Up");
            l.add((Component)this.tabPane, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            l.newline();
            l.pushFillX();
            l.addFillX();
            JButton btnCancel = new JButton("Cancel");
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnCancel);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.setMinimumSize(this.getPreferredSize());
            this.setDefaultCloseOperation(1);
            this.setModal(false);
        }
    }

    public class BumpCreationPanel
    extends JPanel {
        protected Db mDb;
        protected JComboBox<DeviceTemplate> mDevices;
        protected JComboBox<DeviceTemplate> mPatterns;
        protected JRadioButton mCreateNewOption;
        protected JRadioButton mUseExistingOption;
        protected JComboBox<Layer> mLayers;
        protected JComboBox<Personality> mPersonalities;
        protected JTextField mName;
        protected JLabel la;
        protected JLabel lb;
        protected JLabel lc;
        protected JLabel ld;
        protected JLabel le;
        protected JPanel mPnlNetLists;
        protected JTextField mBumpSize;
        protected JTextField mBumpPitchX;
        protected JTextField mBumpPitchY;
        protected JTextField mRows;
        protected JTextField mCols;
        protected JCheckBox mStagger;
        protected JComboBox<String> mBumpShape;
        protected AButtonGroup mCreateGroup = new AButtonGroup();
        protected JRadioButton mByExistingTemplate;
        protected JRadioButton mBySize;
        protected JComboBox<DeviceTemplate> mBumpTemplates;
        protected JButton mCreate;
        protected LayerRenderer layerRenderer;
        protected ActionListener mControlsChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BumpCreationPanel.this.somethingChanged();
            }
        };
        protected ActionListener createAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeviceTemplate dt;
                if (!BumpCreationPanel.this.validateUserInput()) {
                    return;
                }
                APoint2D oldLoc = null;
                Device oldInstance = Device.getChildDevice((DeviceTemplate)BumpCreationPanel.this.getDevicePath().getLast().getTemplate(), (String)BumpCreationPanel.this.getGroupName());
                if (oldInstance != null) {
                    oldLoc = oldInstance.getLoc();
                    dt = oldInstance.getTemplate();
                    oldInstance.deleteFromDb(true);
                    dt.deleteFromDb();
                }
                Cp.exec((String)"com.sigrity.orbit.automation.BumpFactory bf = new com.sigrity.orbit.automation.BumpFactory();", (Object[])new Object[0]);
                Cp.exec((String)"bf.setParentDevicePathString(\"%s\");", (Object[])new Object[]{BumpCreationPanel.this.getDevicePath().toString()});
                Cp.exec((String)"bf.setBumpGroupTemplateName(\"%s\")", (Object[])new Object[]{BumpCreationPanel.this.getGroupName()});
                if (BumpCreationPanel.this.mBySize.isSelected()) {
                    Cp.exec((String)"bf.setBumpParams(%s, \"%s\", \"%s\")", (Object[])new Object[]{BumpCreationPanel.this.mBumpSize.getText(), BumpCreationPanel.this.getLayer().getName(), BumpCreationPanel.this.mBumpShape.getSelectedItem().toString()});
                } else {
                    dt = (DeviceTemplate)BumpCreationPanel.this.mBumpTemplates.getSelectedItem();
                    Cp.exec((String)"bf.setBumpTemplateName(\"%s\");", (Object[])new Object[]{dt.getName()});
                }
                String pName = null;
                if (BumpCreationPanel.this.getPersonality() != null) {
                    pName = BumpCreationPanel.this.getPersonality().getName();
                }
                Cp.exec((String)"bf.setMatrixParams(%s, %s, %s, %s, %s, \"%s\")", (Object[])new Object[]{BumpCreationPanel.this.mBumpPitchX.getText(), BumpCreationPanel.this.mBumpPitchY.getText(), BumpCreationPanel.this.mCols.getText(), BumpCreationPanel.this.mRows.getText(), BumpCreationPanel.this.mStagger.isSelected(), pName});
                if (oldLoc == null) {
                    Cp.exec((String)"bf.goMatrix(0, 0);", (Object[])new Object[0]);
                } else {
                    Cp.exec((String)"bf.goMatrix (%dL, %dL);", (Object[])new Object[]{oldLoc.getX(), oldLoc.getY()});
                }
                OrbitIO.getApp().refreshCurrentView(true);
                BumpCreationPanel.this.updateBumpTemplates();
                BumpCreationPanel.this.updatePatterns();
            }
        };

        public BumpCreationPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushNoFill();
            this.la = new JLabel("Die:");
            l.add((Component)this.la, (GridBagConstraints)GridBagManager.LEFT);
            this.mDevices = new JComboBox();
            l.add(this.mDevices, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            l.pushFill("Create or Edit Pattern");
            this.mCreateNewOption = new JRadioButton("Create New Pattern");
            l.add((Component)this.mCreateNewOption);
            this.mName = new JTextField("BumpGroup", 10);
            l.add((Component)this.mName, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mUseExistingOption = new JRadioButton("Edit Existing Pattern");
            l.add((Component)this.mUseExistingOption);
            this.mPatterns = new JComboBox();
            l.add(this.mPatterns, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mCreateNewOption, this.mUseExistingOption});
            this.mCreateNewOption.setSelected(true);
            this.mPatterns.addActionListener(new itemSelected());
            this.mCreateNewOption.addActionListener(new somethingChanged());
            this.mUseExistingOption.addActionListener(new somethingChanged());
            l.popNl();
            l.pushFill("Bump Parameters");
            JLabel lb = new JLabel("Bump Layer:");
            l.add((Component)lb, (GridBagConstraints)GridBagManager.LEFT);
            this.mLayers = new JComboBox();
            l.add(this.mLayers, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            JLabel lc = new JLabel("Pin Personality:");
            l.add((Component)lc, (GridBagConstraints)GridBagManager.LEFT);
            this.mPersonalities = new JComboBox();
            l.add(this.mPersonalities, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mBySize = new JRadioButton("Parametrically");
            l.add((Component)this.mBySize);
            this.mBySize.addActionListener(this.mControlsChanged);
            l.newline();
            this.la = new JLabel("Bump size:");
            l.add((Component)this.la, (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpSize = new JTextField("", 5);
            this.mBumpSize.setMinimumSize(this.mBumpSize.getPreferredSize());
            l.add((Component)this.mBumpSize);
            this.mBumpSize.addActionListener(this.mControlsChanged);
            l.newline();
            this.mBumpShape = new JComboBox();
            l.add(this.mBumpShape, (GridBagConstraints)GridBagManager.LEFT);
            int n = PadTemplate.PadShapeStyle.valuesOrig().length;
            PadTemplate.PadShapeStyle[] s = PadTemplate.PadShapeStyle.valuesOrig();
            for (int i = 0; i < n; ++i) {
                this.mBumpShape.addItem(s[i].name());
            }
            l.newline();
            this.mByExistingTemplate = new JRadioButton("Template");
            l.add((Component)this.mByExistingTemplate, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mByExistingTemplate.addActionListener(this.mControlsChanged);
            this.ld = new JLabel("Bump Template:");
            this.mBumpTemplates = new JComboBox();
            l.add(this.mBumpTemplates, (GridBagConstraints)GridBagManager.FILLX);
            this.mBumpTemplates.setRenderer(new TemplateListRenderer());
            l.newline();
            this.mCreateGroup.add(this.mBySize);
            this.mCreateGroup.add(this.mByExistingTemplate);
            l.popNl();
            l.pushFillXRemainX("Bump Matrix");
            l.add((Component)new JLabel("Rows:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mRows = new JTextField("", 5);
            l.add((Component)this.mRows, (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new JLabel("Cols:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mCols = new JTextField("", 5);
            l.add((Component)this.mCols, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            l.add((Component)new JLabel("Pitch X:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpPitchX = new JTextField("", 5);
            l.add((Component)this.mBumpPitchX, (GridBagConstraints)GridBagManager.FILLX);
            l.add((Component)new JLabel("Pitch Y:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpPitchY = new JTextField("", 5);
            l.add((Component)this.mBumpPitchY, (GridBagConstraints)GridBagManager.FILLX);
            l.newline();
            this.mStagger = new JCheckBox("Stagger Patern");
            l.add((Component)this.mStagger, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mStagger.setToolTipText("");
            l.pop();
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            this.mRows.addActionListener(this.mControlsChanged);
            this.mCols.addActionListener(this.mControlsChanged);
            this.mBumpPitchX.addActionListener(this.mControlsChanged);
            this.mBumpPitchY.addActionListener(this.mControlsChanged);
            this.mCreate = new JButton("Create Pattern");
            l.add((Component)this.mCreate, (GridBagConstraints)GridBagManager.RIGHT);
            this.mCreate.addActionListener(this.createAction);
            l.pop();
            this.mBySize.setSelected(true);
            this.somethingChanged();
            this.mPersonalities.setRenderer(new PersonalityListRenderer());
            this.mPatterns.setRenderer(new TemplateListRenderer());
            this.mDevices.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                    if (value instanceof DeviceTemplate) {
                        DeviceTemplate dt = (DeviceTemplate)value;
                        StringBuilder deviceList = new StringBuilder();
                        for (Device d : dt.getDeviceInstances()) {
                            if (deviceList.length() > 0) {
                                deviceList.append(", ");
                            }
                            deviceList.append(d.getName());
                        }
                        this.setText(deviceList.toString());
                        this.setIcon(DbExplorerPanel.getIconForTemplate(dt));
                    } else {
                        this.setText("<INVALID>");
                    }
                    return this;
                }
            });
            this.layerRenderer = new LayerRenderer();
            this.mLayers.setRenderer(this.layerRenderer);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            l.pop();
            this.mDevices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BumpCreationPanel.this.enableControls();
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                }
            });
            this.populateSubstrates();
            this.enableControls();
        }

        protected void updateFieldsFromData(DeviceTemplate t) {
            Db db = OrbitIO.getCurDb();
            this.mName.setText(t.getName());
            BumpFactoryData bfd = BumpFactoryData.getForTemplate((DeviceTemplate)t, (boolean)false);
            if (bfd != null) {
                Unit unit = Design.getUnit((Db)db);
                if (bfd.getBumpTemplate() == null) {
                    this.mBumpSize.setText(unit.toUserStr(bfd.getBumpSize()));
                    this.mLayers.setSelectedItem(bfd.getLayer());
                    this.mBySize.setSelected(true);
                    this.mBumpShape.setSelectedItem(bfd.getPadStyle().name());
                } else {
                    this.mBySize.setSelected(false);
                    this.mBumpTemplates.setSelectedItem(bfd.getBumpTemplate());
                }
                this.mPersonalities.setSelectedItem(bfd.getBumpPersonality());
                this.mBumpPitchX.setText(unit.toUserStr(bfd.getDx()));
                this.mBumpPitchY.setText(unit.toUserStr(bfd.getDy()));
                this.mRows.setText(Integer.valueOf(bfd.getRows()).toString());
                this.mCols.setText(Integer.valueOf(bfd.getCols()).toString());
                boolean stagger = bfd.isStagger();
                if (stagger) {
                    this.mStagger.setSelected(true);
                } else {
                    this.mStagger.setSelected(false);
                }
            }
        }

        public DeviceTemplate getDeviceTemplate() {
            return (DeviceTemplate)this.mDevices.getSelectedItem();
        }

        protected void updatePatterns() {
            ArrayList<DeviceTemplate> patterns = new ArrayList<DeviceTemplate>();
            for (DeviceTemplate dt : OrbitIO.getCurDb().getObjects(DeviceTemplate.class)) {
                if (patterns.contains(dt) || dt.getSourceType() != DeviceTemplate.SourceType.BUMPFACTORY) continue;
                patterns.add(dt);
            }
            Collections.sort(patterns);
            this.mPatterns.removeAllItems();
            for (DeviceTemplate dt : patterns) {
                this.mPatterns.addItem(dt);
            }
        }

        protected void populateSubstrates() {
            this.mDevices.removeAllItems();
            ArrayList<DeviceTemplate> dts = new ArrayList<DeviceTemplate>();
            for (Device d : OrbitIO.getCurDb().getObjects(Device.class)) {
                DeviceTemplate dt;
                if (!d.getIsSubstrate() || (dt = d.getTemplate()).getType() != DeviceTemplate.Type.DIE || dts.contains(dt)) continue;
                dts.add(dt);
            }
            Collections.sort(dts);
            for (DeviceTemplate dt : dts) {
                this.mDevices.addItem(dt);
            }
        }

        protected void enableNewSubstrates() {
            this.populateSubstrates();
        }

        protected void enableControls() {
            if (this.layerRenderer != null) {
                this.layerRenderer.setDevicePath(this.getDevicePath());
            }
            this.updateLayers();
            this.updatePersonalities();
            this.updatePatterns();
        }

        protected String getGroupName() {
            return this.mName.getText();
        }

        public DevicePath getDevicePath() {
            if (this.getDeviceTemplate() != null) {
                return this.getDeviceTemplate().getAnInstance().getADevicePath();
            }
            return null;
        }

        protected Layer getLayer() {
            return (Layer)this.mLayers.getSelectedItem();
        }

        protected Personality getPersonality() {
            return (Personality)this.mPersonalities.getSelectedItem();
        }

        protected void updateLayers() {
            this.mLayers.removeAllItems();
            if (OrbitIO.getCurDb() == null) {
                return;
            }
            DeviceTemplate dt = this.getDeviceTemplate();
            if (dt == null) {
                return;
            }
            Substrate s = dt.getSubstrate();
            s.validateLayerOrder();
            for (Layer l : s.getLayers(Layer.TopFirstSort)) {
                this.mLayers.addItem(l);
            }
        }

        protected void updatePersonalities() {
            this.mPersonalities.setModel(new DefaultComboBoxModel());
            if (OrbitIO.getCurDb() == null) {
                return;
            }
            DeviceTemplate dt = this.getDeviceTemplate();
            if (dt == null) {
                return;
            }
            Substrate s = dt.getSubstrate();
            LinkedList elems = new LinkedList();
            for (DeviceTemplate devTemp : s.getDeviceTemplates()) {
                Personality.getPersonalities((DeviceTemplate)devTemp, (Personality.Type)Personality.Type.PORT).forEach(elems::add);
            }
            Collections.sort(elems);
            elems.addFirst(null);
            this.mPersonalities.setModel(new DefaultComboBoxModel<Personality>(elems.toArray(new Personality[elems.size()])));
        }

        protected void updateBumpTemplates() {
            this.mBumpTemplates.setModel(new DefaultComboBoxModel());
            if (OrbitIO.getCurDb() == null) {
                return;
            }
            DeviceTemplate dt = BumpPadFeasibilityUI.this.getDieTemplate();
            if (dt == null) {
                return;
            }
            ArrayList<DeviceTemplate> dts = new ArrayList<DeviceTemplate>();
            Substrate s = dt.getSubstrate();
            for (DeviceTemplate candidate : s.getDeviceTemplates()) {
                if (candidate.getType() != DeviceTemplate.Type.BUMP || candidate.getSourceType() != DeviceTemplate.SourceType.LEFDEF) continue;
                dts.add(candidate);
            }
            Collections.sort(dts);
            this.mBumpTemplates.setModel(new DefaultComboBoxModel<DeviceTemplate>(dts.toArray(new DeviceTemplate[dts.size()])));
        }

        protected boolean validateUserInput() {
            if (this.mBySize.isSelected()) {
                this.mCreate.setEnabled(true);
                try {
                    AFieldValidator.validateDouble((JTextField)this.mBumpSize);
                }
                catch (AFieldValidator.AFieldValidationException ve) {
                    return false;
                }
            }
            try {
                AFieldValidator.validateDouble((JTextField)this.mBumpPitchX);
                AFieldValidator.validateDouble((JTextField)this.mBumpPitchY);
                AFieldValidator.validateInt((JTextField)this.mCols);
                AFieldValidator.validateDouble((JTextField)this.mRows);
            }
            catch (AFieldValidator.AFieldValidationException ve) {
                return false;
            }
            return true;
        }

        protected void somethingChanged() {
            this.updateBumpTemplates();
            if (this.mBySize.isSelected()) {
                this.mBumpShape.setEnabled(true);
                this.mBumpSize.setEnabled(true);
                this.mBumpTemplates.setEnabled(false);
                this.ld.setEnabled(false);
                this.la.setEnabled(true);
            } else {
                this.mBumpShape.setEnabled(false);
                this.mBumpSize.setEnabled(false);
                this.mBumpTemplates.setEnabled(true);
                this.mCreate.setEnabled(true);
                this.ld.setEnabled(true);
                this.la.setEnabled(false);
            }
        }

        protected class somethingChanged
        implements ActionListener {
            protected somethingChanged() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BumpCreationPanel.this.mCreateNewOption.isSelected()) {
                    BumpCreationPanel.this.mPatterns.setEnabled(false);
                    BumpCreationPanel.this.mName.setEnabled(true);
                } else {
                    BumpCreationPanel.this.mPatterns.setEnabled(true);
                    if (BumpCreationPanel.this.mPatterns.getSelectedItem() != null) {
                        DeviceTemplate t = (DeviceTemplate)BumpCreationPanel.this.mPatterns.getSelectedItem();
                        BumpCreationPanel.this.mName.setText(t.getName());
                    }
                    BumpCreationPanel.this.mName.setEnabled(false);
                }
                BumpCreationPanel.this.enableControls();
            }
        }

        public class itemSelected
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (BumpCreationPanel.this.mPatterns.getSelectedItem() != null) {
                    DeviceTemplate t = (DeviceTemplate)BumpCreationPanel.this.mPatterns.getSelectedItem();
                    BumpCreationPanel.this.updateFieldsFromData(t);
                }
            }
        }
    }

    public class PackageEscapeRoute
    extends JPanel {
        JTextField mTraceWidth1;
        JTextField mTraceClr1;
        JTextField mBumpViaSize1;
        JTextField mTraceWidth2;
        JTextField mTraceClr2;
        JTextField mBumpViaSize2;
        JTextField mTraceWidth3;
        JTextField mTraceClr3;
        JTextField mBumpViaSize3;
        JTextField mMinBumpDist1;
        JTextField mMinBumpDist2;
        JTextField mMinBumpDist3;
        JTextField mMaxBumpDist1;
        JTextField mMaxBumpDist2;
        JTextField mMaxBumpDist3;
        JTextField mMaxBumpPushDistance;
        JRadioButton mAllBumps;
        JRadioButton mByPersonality;
        JButton mPersonalities;
        protected SelectPersonalityPopupListener mPopupListener;
        protected ActionListener scheduleAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageEscapeRoute.this.setEnvironment();
                PackageEscapeRoute.this.setActiveRoutePersonalities();
                if (PackageEscapeRoute.this.mTraceWidth1.getText().isEmpty()) {
                    Cp.exec((String)"bf.escapeRouteBumps (\"%s\", \"%s\", \"%s\", true)", (Object[])new Object[]{30, 30, 180});
                } else {
                    Cp.exec((String)"bf.escapeRouteBumps (\"%s\", \"%s\", \"%s\", true)", (Object[])new Object[]{PackageEscapeRoute.this.mTraceWidth1.getText(), PackageEscapeRoute.this.mTraceClr1.getText(), PackageEscapeRoute.this.mBumpViaSize1.getText()});
                }
                OrbitIO.getApp().zoomFitCurrentView();
            }
        };
        protected ActionListener routeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageEscapeRoute.this.setActiveRoutePersonalities();
                Cp.exec((String)"bf.escapeRouteBumps (\"%s\", \"%s\", \"%s\", false)", (Object[])new Object[]{PackageEscapeRoute.this.mTraceWidth1.getText(), PackageEscapeRoute.this.mTraceClr1.getText(), PackageEscapeRoute.this.mBumpViaSize1.getText()});
                OrbitIO.getApp().zoomFitCurrentView();
            }
        };
        protected ActionListener removeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageEscapeRoute.this.setActiveRoutePersonalities();
                Cp.exec((String)"bf.removeTermPackage();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(true);
            }
        };

        public PackageEscapeRoute() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushNoFill("Layer Constraints");
            l.advance();
            JLabel h1 = new JLabel("Layer 1");
            l.add((Component)h1, (GridBagConstraints)GridBagManager.CENTER);
            JRadioButton h2 = new JRadioButton("Layer 2");
            l.add((Component)h2, (GridBagConstraints)GridBagManager.CENTER);
            JRadioButton h3 = new JRadioButton("Layer 3");
            l.add((Component)h3, (GridBagConstraints)GridBagManager.CENTER);
            h2.setEnabled(false);
            h3.setEnabled(false);
            l.newline();
            JLabel la = new JLabel("Trace Width:");
            l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mTraceWidth1 = new JTextField("", 5);
            l.add((Component)this.mTraceWidth1, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceWidth2 = new JTextField("", 5);
            l.add((Component)this.mTraceWidth2, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceWidth3 = new JTextField("", 5);
            l.add((Component)this.mTraceWidth3, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JLabel lb = new JLabel("Trace Clear:");
            l.add((Component)lb, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceClr1 = new JTextField("", 5);
            l.add((Component)this.mTraceClr1, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceClr2 = new JTextField("", 5);
            l.add((Component)this.mTraceClr2, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceClr3 = new JTextField("", 5);
            l.add((Component)this.mTraceClr3, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JLabel lc = new JLabel("Bump Via Diameter:");
            l.add((Component)lc, (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpViaSize1 = new JTextField("", 5);
            l.add((Component)this.mBumpViaSize1, (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpViaSize2 = new JTextField("", 5);
            l.add((Component)this.mBumpViaSize2, (GridBagConstraints)GridBagManager.LEFT);
            this.mBumpViaSize3 = new JTextField("", 5);
            l.add((Component)this.mBumpViaSize3, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JLabel ld = new JLabel("Min Bump Via Distance:");
            l.add((Component)ld, (GridBagConstraints)GridBagManager.LEFT);
            this.mMinBumpDist1 = new JTextField("", 5);
            l.add((Component)this.mMinBumpDist1, (GridBagConstraints)GridBagManager.LEFT);
            this.mMinBumpDist2 = new JTextField("", 5);
            l.add((Component)this.mMinBumpDist2, (GridBagConstraints)GridBagManager.LEFT);
            this.mMinBumpDist3 = new JTextField("", 5);
            l.add((Component)this.mMinBumpDist3, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JLabel le = new JLabel("Max Bump Via Distance:");
            l.add((Component)le, (GridBagConstraints)GridBagManager.LEFT);
            this.mMaxBumpDist1 = new JTextField("", 5);
            l.add((Component)this.mMaxBumpDist1, (GridBagConstraints)GridBagManager.LEFT);
            this.mMaxBumpDist2 = new JTextField("", 5);
            l.add((Component)this.mMaxBumpDist2, (GridBagConstraints)GridBagManager.LEFT);
            this.mMaxBumpDist3 = new JTextField("", 5);
            l.add((Component)this.mMaxBumpDist3, (GridBagConstraints)GridBagManager.LEFT);
            l.pop();
            l.newline();
            l.pushNoFill();
            l.pushRemainX("Connection Strategy");
            this.mAllBumps = new JRadioButton("Connect All Bumps");
            l.add((Component)this.mAllBumps);
            l.newline();
            this.mByPersonality = new JRadioButton("Only Bumps of Selected Personality");
            l.add((Component)this.mByPersonality);
            this.mPersonalities = new JButton("Select Personalities");
            this.mPopupListener = new SelectPersonalityPopupListener(this.mPersonalities);
            this.mPersonalities.addActionListener(this.mPopupListener);
            l.newline();
            l.add((Component)this.mPersonalities);
            this.mAllBumps.setSelected(true);
            this.mPersonalities.setEnabled(false);
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mAllBumps, this.mByPersonality});
            this.mAllBumps.addActionListener(new SomethingChanged());
            this.mByPersonality.addActionListener(new SomethingChanged());
            l.pop();
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton schedule = new JButton("Just Schedule");
            schedule.addActionListener(this.scheduleAction);
            l.add((Component)schedule);
            JButton route = new JButton("Route");
            route.addActionListener(this.routeAction);
            JButton removePackage = new JButton("Remove Test Package");
            removePackage.addActionListener(this.removeAction);
            l.add((Component)route);
            l.add((Component)removePackage);
            l.pop();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    PackageEscapeRoute.this.enableControls();
                }
            });
        }

        protected void enableControls() {
            this.mPopupListener.setSubstrate(BumpPadFeasibilityUI.this.getDieTemplate().getSubstrate());
            if (this.mAllBumps.isSelected()) {
                this.mPersonalities.setEnabled(false);
            } else {
                this.mPersonalities.setEnabled(true);
            }
        }

        protected void setEnvironment() {
            Cp.exec((String)"com.sigrity.orbit.automation.BumpFactory bf = new com.sigrity.orbit.automation.BumpFactory();", (Object[])new Object[0]);
            Cp.exec((String)"bf.setParentDevicePathString(\"%s\");", (Object[])new Object[]{BumpPadFeasibilityUI.this.getDevicePath().toString()});
            Cp.exec((String)"bf.setBumpGroupTemplateName(\"%s\")", (Object[])new Object[]{BumpPadFeasibilityUI.this.getGroupName()});
        }

        protected void setActiveRoutePersonalities() {
            Cp.exec((String)"bf.usePersonalities(%b)", (Object[])new Object[]{!this.mAllBumps.isSelected()});
            Cp.exec((String)"bf.clrActivePersonalities()", (Object[])new Object[0]);
            for (Personality p : this.mPopupListener.getSelectedPersonality()) {
                Cp.exec((String)"bf.addActivePersonality(\"%s\")", (Object[])new Object[]{p.getKeyStr()});
            }
        }

        class SomethingChanged
        implements ActionListener {
            SomethingChanged() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageEscapeRoute.this.enableControls();
            }
        }
    }

    public class RDLRoute
    extends JPanel {
        JTextField mTraceWidth1;
        JTextField mTraceClr1;
        JTextField mTraceWidth2;
        JTextField mTraceClr2;
        JRadioButton mAllIOPads;
        JRadioButton mByPersonality;
        JButton mPersonalities;
        SelectPersonalityPopupListener mPopupListener;
        JButton mStdButton;
        SelectPersonalityPopupListener mStdListener;
        JButton mAltButton;
        SelectPersonalityPopupListener mAltListener;
        JComboBox<Layer> mLayers;
        protected ActionListener scheduleAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDLRoute.this.setActiveRoutePersonalities();
                Cp.exec((String)"bf.scheduleFromDieIOtoBump()", (Object[])new Object[0]);
            }
        };
        protected ActionListener routeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDLRoute.this.setActiveRoutePersonalities();
                Cp.exec((String)"bf.rdlRoute (\"%s\", \"%s\", \"%s\")", (Object[])new Object[]{RDLRoute.this.mTraceWidth1.getText(), RDLRoute.this.mTraceClr1.getText(), BumpPadFeasibilityUI.this.getLayer().getName()});
            }
        };

        public RDLRoute() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFillX("Layer Constraints");
            l.advance();
            this.mStdButton = new JButton("Standard");
            this.mStdListener = new SelectPersonalityPopupListener(this.mStdButton);
            this.mStdButton.addActionListener(this.mStdListener);
            l.add((Component)this.mStdButton);
            this.mAltButton = new JButton("Alternate");
            this.mAltListener = new SelectPersonalityPopupListener(this.mAltButton);
            this.mAltButton.addActionListener(this.mAltListener);
            l.add((Component)this.mAltButton);
            l.newline();
            JLabel lb = new JLabel("Trace Width:");
            l.add((Component)lb, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceWidth1 = new JTextField("", 5);
            l.add((Component)this.mTraceWidth1, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceWidth2 = new JTextField("", 5);
            l.add((Component)this.mTraceWidth2, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            JLabel lc = new JLabel("Trace Clear:");
            l.add((Component)lc, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceClr1 = new JTextField("", 5);
            l.add((Component)this.mTraceClr1, (GridBagConstraints)GridBagManager.LEFT);
            this.mTraceClr2 = new JTextField("", 5);
            l.add((Component)this.mTraceClr2, (GridBagConstraints)GridBagManager.LEFT);
            l.pop();
            l.newline();
            l.pushFillX("Connection Strategy");
            this.mAllIOPads = new JRadioButton("Connect All IO Pads");
            l.add((Component)this.mAllIOPads);
            l.newline();
            this.mByPersonality = new JRadioButton("Only IO Pads of Selected Personality");
            l.add((Component)this.mByPersonality);
            this.mPersonalities = new JButton("Select Personalities");
            this.mPopupListener = new SelectPersonalityPopupListener(this.mPersonalities);
            this.mPersonalities.addActionListener(this.mPopupListener);
            l.newline();
            l.add((Component)this.mPersonalities);
            this.mAllIOPads.setSelected(true);
            this.mPersonalities.setEnabled(false);
            UIUtil.groupButtons((AbstractButton[])new AbstractButton[]{this.mAllIOPads, this.mByPersonality});
            this.mAllIOPads.addActionListener(new SomethingChanged());
            this.mByPersonality.addActionListener(new SomethingChanged());
            l.pop();
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton schedule = new JButton("Just Schedule");
            schedule.addActionListener(this.scheduleAction);
            l.add((Component)schedule);
            JButton route = new JButton("Route");
            route.addActionListener(this.routeAction);
            l.add((Component)route);
            l.pop();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    RDLRoute.this.enableControls();
                }
            });
        }

        protected void setActiveRoutePersonalities() {
            Cp.exec((String)"bf.usePersonalities (%b)", (Object[])new Object[]{!this.mAllIOPads.isSelected()});
            Cp.exec((String)"bf.clrActivePersonalities()", (Object[])new Object[0]);
            for (Personality p : this.mPopupListener.getSelectedPersonality()) {
                Cp.exec((String)"bf.addActivePersonality(\"%s\")", (Object[])new Object[]{p.getKeyStr()});
            }
        }

        protected void enableControls() {
            Substrate s = BumpPadFeasibilityUI.this.getDieTemplate().getSubstrate();
            this.mPopupListener.setSubstrate(s);
            this.mStdListener.setSubstrate(s);
            this.mAltListener.setSubstrate(s);
            if (this.mAllIOPads.isSelected()) {
                this.mPersonalities.setEnabled(false);
            } else {
                this.mPersonalities.setEnabled(true);
            }
        }

        public class SomethingChanged
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                RDLRoute.this.enableControls();
            }
        }
    }

    protected class GridPanel
    extends JPanel {
        protected JTextField mGridDx;
        protected JTextField mGridDy;
        protected JTextField mGridOx;
        protected JTextField mGridOy;
        protected JTextField mMajorGrid;

        protected GridPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFillX("Bump Grid for Die Substrate");
            l.add((Component)new JLabel("X Space:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridDx = new JTextField("10", 4);
            l.add((Component)this.mGridDx, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)new JLabel("Y Space:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridDy = new JTextField("10", 4);
            l.add((Component)this.mGridDy, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)new JLabel("X Offset:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridOx = new JTextField("10", 4);
            l.add((Component)this.mGridOx, (GridBagConstraints)GridBagManager.LEFT);
            l.add((Component)new JLabel("Y Offset:"), (GridBagConstraints)GridBagManager.LEFT);
            this.mGridOy = new JTextField("10", 4);
            l.add((Component)this.mGridOy, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add((Component)new JLabel("Major Grid "), (GridBagConstraints)GridBagManager.LEFT);
            this.mMajorGrid = new JTextField("10", 4);
            l.add((Component)this.mMajorGrid, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton saveGrid = new JButton("Save Grid");
            l.add((Component)saveGrid, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            saveGrid.addActionListener(new saveGridButtonAction());
            l.pop();
            l.pop();
            l.newline();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    GridPanel.this.updateGrids();
                }
            });
        }

        protected void saveGrid() {
            Cp.exec((String)"NamedGrid.create (\"%s\", \"%s\", %f, %f, %f, %f, %d)", (Object[])new Object[]{BumpPadFeasibilityUI.this.getDevicePath(), "Pin Grid", Double.parseDouble(this.mGridDx.getText().replace(",", "")), Double.parseDouble(this.mGridDy.getText().replace(",", "")), Double.parseDouble(this.mGridOx.getText().replace(",", "")), Double.parseDouble(this.mGridOy.getText().replace(",", "")), Integer.parseInt(this.mMajorGrid.getText())});
        }

        protected void updateGrids() {
            DeviceTemplate dt = BumpPadFeasibilityUI.this.getDieTemplate();
            if (dt == null) {
                return;
            }
            Db db = OrbitIO.getCurDb();
            Unit unit = Design.getUnit((Db)db);
            Substrate s = dt.getSubstrate();
            NamedGrid ng = NamedGrid.get((Substrate)s, (String)"Pin Grid");
            if (ng == null) {
                ng = NamedGrid.get((Substrate)s, (String)"Manufacturing Grid");
            }
            if (ng != null) {
                String f = unit.formatUser(unit.toUser(ng.getGrid().getDeltaX()));
                this.mGridDx.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getDeltaY()));
                this.mGridDy.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getOrignX()));
                this.mGridOx.setText(f);
                f = unit.formatUser(unit.toUser(ng.getGrid().getOrignY()));
                this.mGridOy.setText(f);
            }
        }

        class saveGridButtonAction
        implements ActionListener {
            saveGridButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                GridPanel.this.saveGrid();
            }
        }
    }
}

