/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationControllerThread;
import com.sigrity.acl.ui.AHtmlPane;
import com.sigrity.acl.ui.ATabbedPane;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.AutoBundleNetUI;
import com.sigrity.orbit.automation.router.BundleRakeUI;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.wb_route.LayerSelectorDlg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class BundleCreationDlg
extends DbDialog {
    protected static final Icon ICON_BUNDLEEDITOR = OrbitIcons.ROUTE_EDIT;
    protected static final String CFG_SECTION_UI = "ConnectionOptimizationUI";
    protected static final String CFG_ITEM_CLOSE_DIALOG = "CloseConnOptAuto";
    protected static final boolean CFG_ITEM_CLOSE_DIALOG_DFLT = false;
    protected static final String CFG_ITEM_WIRE_WIDTH = "BundleWireWidth";
    protected static final String CFG_ITEM_WIRE_WIDTH_DFLT = "20";
    protected static final String CFG_ITEM_WIRE_CLEARANCE = "BundleWireClearance";
    protected static final String CFG_ITEM_WIRE_CLEARANCE_DFLT = "20";
    protected static final String CFG_ITEM_OPT_FREE_END = "BundleOptFreeEnd";
    protected static final boolean CFG_ITEM_OPT_FREE_END_DFLT = true;
    protected static final String CFG_ITEM_SHOW_KEYS = "BundleShowKeys";
    protected static final boolean CFG_ITEM_SHOW_KEYS_DFLT = true;
    protected static final String CFG_ITEM_SAME_NETS = "BundleSameNets";
    protected static final boolean CFG_ITEM_SAME_NETS_DFLT = false;
    protected static String mPreferredButtonText = "";
    protected static Map<Db, BundleCreationDlg> dialogMap = new WeakHashMap<Db, BundleCreationDlg>();
    private ATabbedPane mTabs;
    private JButton mCreateBundle;
    private JTextField mRouteWidth;
    private JTextField mRouteClr;
    private JCheckBox mOptimizeFreeEnd;
    private JCheckBox mShowKeys;
    private JCheckBox mSameNets;
    private JCheckBox mCloseDialog;
    private JButton mLayerButton;
    protected Set<Layer> mLayerList = new HashSet<Layer>();
    protected final AAppView mView;
    protected JPanel bundlePanel;
    protected JPanel mHtmlPanel;
    protected AGeneticOptimizationControllerThread agoct;
    protected final FixedFreePinSelection pinSelectionPanel = new FixedFreePinSelection();
    protected DbRelationDef.DbRelationListener mFL = null;
    protected DbRelationDef.DbRelationListener mPL = null;
    protected FixedFreePinSelection.SetAAdapter mSetAListener = null;
    protected Substrate mSubstrate = null;
    protected static Db.DbListener mDbListener = null;
    protected static LinkedList<MessageReceiver> sChannels = new LinkedList();
    protected WindowListener mDialogListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            PortPairOpt.clearActive(OrbitIO.getCurDb());
        }
    };

    public static BundleCreationDlg showMeOnTab(Window owner, int tab, String buttonText, String bundleKeyStr) {
        mPreferredButtonText = buttonText;
        BundleCreationDlg theDialog = dialogMap.get(OrbitIO.getCurDb());
        if (theDialog == null) {
            theDialog = new BundleCreationDlg(owner, bundleKeyStr);
            dialogMap.put(OrbitIO.getCurDb(), theDialog);
        } else {
            BundleCreationDlg.resetStatus();
        }
        return theDialog;
    }

    public static BundleCreationDlg getCurrent() {
        return dialogMap.get(OrbitIO.getCurDb());
    }

    public static void showMe(Frame owner) {
        BundleCreationDlg.showMeOnTab(owner, 0, "", null);
    }

    public static boolean addLoadListener(MessageReceiver l) {
        return sChannels.add(l);
    }

    public static boolean removeLoadListener(MessageReceiver l) {
        return sChannels.remove(l);
    }

    protected static void sendMessage(String data) {
        for (MessageReceiver l : sChannels) {
            l.stats(data);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.mFL = new FloorplanListener();
        DbRelationDef rd = this.mDb.getRelation("FloorplanPin-owner");
        assert (rd != null);
        rd.addRelationListener(this.mFL, DbRelationDef.RELATION_UPDATED);
        this.mPL = new PersonalityListener();
        rd = this.mDb.getRelation("Personality-owner");
        assert (rd != null);
        rd.addRelationListener(this.mPL, DbRelationDef.RELATION_UPDATED);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.mDb != null) {
            DbRelationDef rd = this.mDb.getRelation("FloorplanPin-owner");
            if (rd != null) {
                rd.removeRelationListener(this.mFL, DbRelationDef.RELATION_UPDATED);
            }
            if ((rd = this.mDb.getRelation("Personality-owner")) != null) {
                rd.removeRelationListener(this.mPL, DbRelationDef.RELATION_UPDATED);
            }
            this.mFL = null;
            this.mPL = null;
        }
    }

    private BundleCreationDlg(Window owner, String bundleKeyStr) {
        super(OrbitIO.getCurDb(), (Component)owner);
        this.setTitle("Bundle Creation");
        Bundle b = null;
        if (bundleKeyStr != null && !bundleKeyStr.isEmpty()) {
            b = (Bundle)this.mDb.getByKeyStr(Bundle.class, bundleKeyStr);
        }
        final Settings settings = Settings.getSettings((String)CFG_SECTION_UI);
        if (mDbListener == null) {
            mDbListener = new MyDbListener();
            Db.addDbListener((Db.DbListener)mDbListener);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                dialogMap.remove(OrbitIO.getCurDb());
                mPreferredButtonText = "";
                if (!BundleCreationDlg.this.mCloseDialog.isSelected()) {
                    BundleCreationDlg.sendMessage("Closed");
                }
                settings.putSetting(BundleCreationDlg.CFG_ITEM_CLOSE_DIALOG, (Object)BundleCreationDlg.this.mCloseDialog.isSelected());
                settings.putSetting(BundleCreationDlg.CFG_ITEM_WIRE_WIDTH, (Object)BundleCreationDlg.this.mRouteWidth.getText());
                settings.putSetting(BundleCreationDlg.CFG_ITEM_WIRE_CLEARANCE, (Object)BundleCreationDlg.this.mRouteClr.getText());
                settings.putSetting(BundleCreationDlg.CFG_ITEM_OPT_FREE_END, (Object)BundleCreationDlg.this.mOptimizeFreeEnd.isSelected());
                settings.putSetting(BundleCreationDlg.CFG_ITEM_SHOW_KEYS, (Object)BundleCreationDlg.this.mShowKeys.isSelected());
                settings.putSetting(BundleCreationDlg.CFG_ITEM_SAME_NETS, (Object)BundleCreationDlg.this.mSameNets.isSelected());
                settings.save();
                BundleCreationDlg.this.pinSelectionPanel.removeSetAListener(BundleCreationDlg.this.mSetAListener);
            }
        });
        sChannels.clear();
        dialogMap.put(this.getDb(), this);
        this.mView = OrbitIO.getCurView();
        Cp.exec((String)"UserCommands.unselectAll()", (Object[])new Object[0]);
        this.setDefaultCloseOperation(2);
        this.mTabs = new ATabbedPane();
        this.mTabs.addTab("Manual", this.createCreationPanel(owner, b));
        this.mTabs.addTab("Auto Bundle", AutoBundleNetUI.createAutoBundlePanel((JDialog)((Object)this)));
        this.mTabs.addTab("Rake Pattern", BundleRakeUI.createBundleRakePanel((JDialog)((Object)this)));
        this.setLayout(new BorderLayout());
        this.add(this.mTabs, "Center");
        this.updateEnablementForStandardChoice();
        this.setVisible(true);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.addWindowListener(this.mDialogListener);
    }

    private JPanel createCreationPanel(Window owner, Bundle b) {
        Db curDb = OrbitIO.getCurDb();
        Unit unit = Design.getUnit((Db)curDb);
        final Settings settings = Settings.getSettings((String)CFG_SECTION_UI);
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.newline();
        l.add((Component)this.pinSelectionPanel, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.push("Bundle Options", (GridBagConstraints)GridBagManager.FILLX);
        this.mRouteWidth = new JTextField(10);
        String routeWidth = b != null ? unit.toUserStr(b.getWireWidth()) : (String)settings.getSetting(CFG_ITEM_WIRE_WIDTH, (Object)"20");
        this.mRouteWidth.setText(routeWidth);
        this.mRouteClr = new JTextField(10);
        String routeClearance = b != null ? unit.toUserStr(b.getWireClr()) : (String)settings.getSetting(CFG_ITEM_WIRE_CLEARANCE, (Object)"20");
        this.mRouteClr.setText(routeClearance);
        l.add("Wire Width:", (Component)this.mRouteWidth, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add("Wire Clearance:", (Component)this.mRouteClr, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mLayerButton = new JButton("Select Layers...");
        this.mLayerButton.addActionListener(ae -> {
            PortPairOpt ppo = PortPairOpt.getActive();
            if (ppo == null) {
                ALog.logWarn((String)"No pin selected. Select fixed and free pins first");
                return;
            }
            DevicePath dp = FixedFreePinSelection.deriveLeastCommonDevicePath(null, null);
            if (dp != null && !dp.getDeviceTemplate().amIASubstrate()) {
                dp = dp.pathToSubstrate();
            }
            if (dp == null) {
                ALog.logWarn((String)"No pin selected. Select fixed and free pins first.");
                return;
            }
            this.mSubstrate = dp.getSubstrate();
            HashSet<Layer> preSelected = new HashSet<Layer>(this.mLayerList);
            LayerSelectorDlg layerDialog = LayerSelectorDlg.showMe(this.mView, this.mSubstrate, preSelected, Layer.LayerType.Route);
            if (layerDialog.getUserOked()) {
                this.mLayerList.clear();
                layerDialog.getSelected().stream().forEach(this.mLayerList::add);
            }
        });
        this.mLayerButton.setEnabled(this.pinSelectionPanel.getACount() > 0);
        UIUtil.makeSmallButton((JButton)this.mLayerButton);
        l.add("Layers:", (Component)this.mLayerButton, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        l.addFillX();
        l.newline();
        this.mOptimizeFreeEnd = new JCheckBox("Optimize Free End");
        l.add((Component)this.mOptimizeFreeEnd, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        l.newline();
        boolean optFreeEnd = (Boolean)settings.getSetting(CFG_ITEM_OPT_FREE_END, (Object)true);
        this.mOptimizeFreeEnd.setSelected(optFreeEnd);
        this.mCloseDialog = new JCheckBox("Close Dialog Box Automatically");
        l.add((Component)this.mCloseDialog, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        l.newline();
        boolean closeOnOpt = (Boolean)settings.getSetting(CFG_ITEM_CLOSE_DIALOG, (Object)false);
        this.mCloseDialog.setSelected(closeOnOpt);
        this.mSameNets = new JCheckBox("Allow identical nets from Fixed side");
        l.add((Component)this.mSameNets, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        boolean optSameNets = (Boolean)settings.getSetting(CFG_ITEM_SAME_NETS, (Object)false);
        this.mSameNets.setSelected(optSameNets);
        this.mSameNets.addActionListener(ae -> {
            this.pinSelectionPanel.setOnePinOneNet(!this.mSameNets.isSelected());
            this.pinSelectionPanel.updatePPOptions();
        });
        l.newline();
        this.mShowKeys = new JCheckBox("Show Key Shortcuts");
        boolean showKeys = (Boolean)settings.getSetting(CFG_ITEM_SHOW_KEYS, (Object)true);
        this.mShowKeys.setSelected(showKeys);
        this.mShowKeys.addActionListener(ae -> {
            this.mHtmlPanel.setVisible(this.mShowKeys.isSelected());
            Dimension dim = this.getSize();
            Dimension htmlDim = this.mHtmlPanel.getPreferredSize();
            Dimension dimension = dim;
            dimension.height = dimension.height + (this.mShowKeys.isSelected() ? htmlDim.height : -htmlDim.height);
            this.setSize(dim);
            this.pack();
        });
        this.mSetAListener = new FixedFreePinSelection.SetAAdapter(){

            @Override
            public void setAChanged(int count) {
                BundleCreationDlg.this.mLayerButton.setEnabled(count > 0);
            }
        };
        this.pinSelectionPanel.addSetAListener(this.mSetAListener);
        this.pinSelectionPanel.setOnePinOneNet(!this.mSameNets.isSelected());
        l.add((Component)this.mShowKeys, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        l.newline();
        this.mHtmlPanel = new JPanel();
        this.mHtmlPanel.setVisible(this.mShowKeys.isSelected());
        this.mHtmlPanel.setPreferredSize(new Dimension(327, 200));
        AHtmlPane htmlNotes = new AHtmlPane();
        htmlNotes.setEditable(false);
        htmlNotes.setOpaque(false);
        htmlNotes.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = e.getURL();
                ABrowserControl.displayURL((URL)url);
            }
        });
        this.populateHTMLNotes(htmlNotes);
        this.mHtmlPanel.add((Component)new JScrollPane(htmlNotes), GridBagManager.FILLALL_REMAINX);
        l.add((Component)this.mHtmlPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        l.newline();
        l.popNl();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.mCreateBundle = new JButton("Create Bundle");
        this.mCreateBundle.setIcon(ICON_BUNDLEEDITOR);
        this.mCreateBundle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                settings.putSetting(BundleCreationDlg.CFG_ITEM_CLOSE_DIALOG, (Object)BundleCreationDlg.this.mCloseDialog.isSelected());
                settings.save();
                PortPairOpt ppo = PortPairOpt.getActive();
                if (ppo == null) {
                    ALog.logWarn((String)"Nothing selected");
                    return;
                }
                Unit unit = Design.getUnit((Db)OrbitIO.getCurDb());
                Cp.exec((String)"unset(\"_ibr\")", (Object[])new Object[0]);
                Cp.exec((String)"_ibr=com.sigrity.orbit.automation.router.InteractiveBundleCreator.show()", (Object[])new Object[0]);
                long w = unit.fromUserString(BundleCreationDlg.this.mRouteWidth.getText());
                long c = unit.fromUserString(BundleCreationDlg.this.mRouteClr.getText());
                Cp.exec((String)"_ibr.setConstraints(%dL, %dL, \"%s\")", (Object[])new Object[]{w, c, Constraint.RouteAngle.FortyFive.toString()});
                Cp.exec((String)"_ibr.setOptimizeFreeEndFlag(%b)", (Object[])new Object[]{BundleCreationDlg.this.mOptimizeFreeEnd.isSelected()});
                Floorplan floorplan = BundleCreationDlg.this.pinSelectionPanel.getLastFloorPlan();
                if (floorplan != null) {
                    Cp.exec((String)"_ibr.setColorHint(\"%s\")", (Object[])new Object[]{AUtil.colorToString((Color)floorplan.getMyInterface().getColor())});
                    Cp.exec((String)"_ibr.setNameHint(\"%s\")", (Object[])new Object[]{floorplan.getMyInterface().getName()});
                    Cp.exec((String)"_ibr.setInterfaceHint (\"%s\")", (Object[])new Object[]{floorplan.getMyInterface().getKeyStr()});
                }
                if (BundleCreationDlg.this.mCloseDialog.isSelected()) {
                    BundleCreationDlg.this.dispose();
                }
                String mode = InteractiveBundleCreator.UseMode.Create.toString();
                Cp.exec((String)"_ibr.start(null, \"%s\")", (Object[])new Object[]{mode});
            }
        });
        l.add((Component)this.mCreateBundle, (GridBagConstraints)GridBagManager.RIGHT);
        JButton close = new JButton("Close");
        l.add((Component)close, (GridBagConstraints)GridBagManager.RIGHT);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)close, (JButton)this.mCreateBundle);
        return panel;
    }

    protected void populateHTMLNotes(AHtmlPane pane) {
        String text = "<style type='text/css'>\ntable {border-collapse:collapse}\nth {text-align:left;font-weight:bold}\ntd {text-align:left;} \n.key {font-weight:bold;width:1%;white-space:wrap;margin-right:6px}\n.odd {background-color:white}\n</style>\n<table width='100%' cellspacing='0' cellpadding='2'>\n<tr><th class='key'>Key</th><th>Definition</th></tr>\n<tr class='odd'><td class='key'>t</td><td>Zoom around the free (to) end</td></tr>\n<tr><td class='key'>f</td><td>Zoom around the fixed (from) end</td></tr>\n<tr class='odd'><td class='key'>a</td><td>Zoom around both ends</td></tr>\n<tr><td class='key'>s</td><td>Cycle through 8 options of bundle shapes</td></tr>\n<tr class='odd'><td class='key'>e</td><td>End and commit the bundle</td></tr>\n<tr><td class='key'>l</td><td>Lock/Unlock the current selection of pins</td></tr>\n<tr class='odd'><td class='key'>o</td><td>Cycle through various diff pair alignment options</td></tr>\n</table>\n</body>";
        pane.setText(text);
    }

    protected void updateEnablementForStandardChoice() {
        if (mPreferredButtonText.isEmpty()) {
            this.mCreateBundle.setText("Create Bundle");
        } else {
            this.mCreateBundle.setText(mPreferredButtonText);
        }
        this.mCreateBundle.setIcon(ICON_BUNDLEEDITOR);
    }

    public static void resetStatus() {
        PortPairOpt ppo = PortPairOpt.getActive();
        if (ppo == null) {
            ALog.logWarn((String)"Nothing selected");
        } else {
            ppo.setAPorts(new ArrayList<HierPin>());
            ppo.setBPorts(new ArrayList<HierPin>());
        }
        Design design = OrbitIO.getCurDesign();
        Selection selection = design.getCurSelection();
        selection.clear();
        BundleCreationDlg theDialog = BundleCreationDlg.getCurrent();
        if (theDialog != null) {
            theDialog.pinSelectionPanel.mSubstrateTreeA.clearSelection();
            theDialog.pinSelectionPanel.mSubstrateTreeB.clearSelection();
            theDialog.pinSelectionPanel.updateACount();
            theDialog.pinSelectionPanel.updateBCount();
        }
        BundleCreationDlg.getLayers().clear();
    }

    public static Set<Layer> getLayers() {
        BundleCreationDlg theDialog = BundleCreationDlg.getCurrent();
        if (theDialog == null) {
            return new HashSet<Layer>();
        }
        return theDialog.mLayerList;
    }

    public static Substrate getSubstrate() {
        BundleCreationDlg dlg = BundleCreationDlg.getCurrent();
        if (dlg == null) {
            return null;
        }
        return dlg.mSubstrate;
    }

    public void updateCounts() {
        this.pinSelectionPanel.updateCounts();
        if (this.mLayerButton != null) {
            this.mLayerButton.setEnabled(this.pinSelectionPanel.getACount() > 0);
        }
    }

    public static void setOptimizeFreeEnd(Db db, boolean b) {
        BundleCreationDlg dlg = dialogMap.get(db);
        if (dlg != null) {
            dlg.mOptimizeFreeEnd.setSelected(b);
        }
    }

    static class MyDbListener
    extends Db.DbListenerAdapter {
        MyDbListener() {
        }

        public void dbClosing(Db db) {
            Layer l;
            Iterator<Layer> layerItr;
            if (BundleCreationDlg.getLayers() != null && (layerItr = BundleCreationDlg.getLayers().iterator()).hasNext() && (l = layerItr.next()).getDb() != null && l.getDb() == db) {
                BundleCreationDlg.getLayers().clear();
            }
        }
    }

    protected class PersonalityListener
    extends DbRelationDef.DbRelationAdapter {
        protected PersonalityListener() {
        }

        public void related(DbRelationDef.RelationChange change) {
            BundleCreationDlg.this.pinSelectionPanel.refreshTrees();
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            BundleCreationDlg.this.pinSelectionPanel.refreshTrees();
        }
    }

    protected class FloorplanListener
    extends DbRelationDef.DbRelationAdapter {
        protected FloorplanListener() {
        }

        public void related(DbRelationDef.RelationChange change) {
            BundleCreationDlg.this.pinSelectionPanel.refreshTrees();
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            BundleCreationDlg.this.pinSelectionPanel.refreshTrees();
        }
    }

    public static interface MessageReceiver {
        public void stats(String var1);
    }
}

