/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DeviceRegionMap;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.automation.router.InteractiveBundleCreator;
import com.sigrity.orbit.cmd.BundleCommands;
import com.sigrity.orbit.cmd.BundleLengths;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.route_edit.InteractiveRouteEditMode;
import com.sigrity.orbit.ui.wb_route.LayerSelectorDlg;
import com.sigrity.orbit.ui.wb_route.RouteQueueDlg;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class BundleUI {
    public static final ObjectActionRegistry.ActionFactory<HierInst<DbObject>> ActionFactory = (hierObj, constraints) -> {
        LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
        DbObject dbo = hierObj.getDbObject();
        if (!(dbo instanceof Bundle)) {
            return AEmptyItr.create();
        }
        actions.add(new ActionDeleteBundle((Bundle)dbo));
        actions.add(new ActionOptimizeBundle((Bundle)dbo));
        actions.add(new ActionUntangleFixedEnd((Bundle)dbo));
        actions.add(new ActionUntangleFreeEnd((Bundle)dbo));
        actions.add(new ActionEditPath((Bundle)dbo));
        actions.add(new ActionReformBundle((Bundle)dbo));
        actions.add(new ActionOptimizeFreeEndPath((Bundle)dbo));
        actions.add(new ActionRouteFixedSide((Bundle)dbo));
        actions.add(new ActionRouteFreeSide((Bundle)dbo));
        actions.add(new ActionShowBundle((Bundle)dbo));
        actions.add(new ActionEditLayers((Bundle)dbo));
        actions.add(new ActionEditBundles((Bundle)dbo));
        actions.add(new ActionSelectFreePins((Bundle)dbo));
        actions.add(new ActionSelectFreeEnclosedPins((Bundle)dbo));
        actions.add(new ActionEditBundleRake((Bundle)dbo));
        actions.add(new ActionSwapBundleSide((Bundle)dbo));
        return actions.iterator();
    };
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (sel, constraints) -> {
        boolean has = sel.get(Bundle.class).stream().anyMatch(Objects::nonNull);
        if (has) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            actions.add(new ActionBundleSelRouteFixedSide());
            actions.add(new ActionBundleSelRouteFreeSide());
            actions.add(new ActionBundleSelDelete());
            actions.add(new ActionBundleSelOptimizeFreeEnd());
            actions.add(new ActionBundleSelEditLayers());
            return actions.iterator();
        }
        return AEmptyItr.create();
    };
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            Design design = Design.getDesign((Db)db);
            OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
            ObjectActionRegistry oar = gws.getObjectActionRegistry();
            int selBundleCount = selection.getCount(db.getDbClass(Bundle.class));
            LinkedList<JMenuItem> actions = new LinkedList<JMenuItem>();
            if (selBundleCount > 1) {
                IterableIterator<JMenuItem> menuItems = oar.getJMenuItems(selection);
                while (menuItems.hasNext()) {
                    JMenuItem menuItem = (JMenuItem)menuItems.next();
                    String name = menuItem.getText() + " " + String.format("(%d)", selBundleCount);
                    menuItem.setText(name);
                    menuItem.setName(name);
                    actions.add(menuItem);
                }
            } else {
                APoint2D curLoc = worldLoc;
                if (worldLoc == null) {
                    return AEmptyItr.create();
                }
                ArrayList<HierInst> bundles = new ArrayList<HierInst>();
                DeviceRegionMap.ObjectFilter filter = new DeviceRegionMap.ObjectFilter();
                filter.addDbClass(db.getDbClass(Bundle.class));
                for (HierInst hierInst : design.getObjectsAt(curLoc, filter)) {
                    DbObject dbo = hierInst.getDbObject();
                    if (!(dbo instanceof Bundle)) continue;
                    Bundle b = (Bundle)dbo;
                    List layers = b.getLayers();
                    boolean display = false;
                    ViewColorizer colorizer = OrbitIO.getCurColorizer();
                    for (Layer l : layers) {
                        display |= colorizer.getDisplay(l);
                    }
                    if (!display) continue;
                    bundles.add(HierInst.create((DevicePath)hierInst.getPath(), (DbObject)b));
                }
                for (HierInst hierBundle : bundles) {
                    Bundle b = (Bundle)hierBundle.getDbObject();
                    JMenu menu = null;
                    if (bundles.size() > 1) {
                        menu = new JMenu("Bundle - " + b.getName());
                        actions.add(menu);
                    }
                    IterableIterator<JMenuItem> menuItems = oar.getJMenuItems(hierBundle);
                    while (menuItems.hasNext()) {
                        JMenuItem menuItem = (JMenuItem)menuItems.next();
                        String name = menuItem.getText() + " " + String.format("(%s)", b.getName());
                        menuItem.setText(name);
                        menuItem.setName(name);
                        if (menu != null) {
                            menu.add(menuItem);
                            continue;
                        }
                        actions.add(menuItem);
                    }
                    if (menu == null) continue;
                    OrbitIO.getGuiWorkspace().beautify(menu);
                }
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Bundle Actions";
        }
    };

    private BundleUI() {
    }

    public static void selectHierPort(String devicePathString, String pinInstanceKeyStr) {
        Db db = OrbitIO.getCurDb();
        Selection s = Design.getSelection((Db)db);
        DevicePath dp = DevicePath.fromString((Db)db, (String)devicePathString);
        PinInstance pi = (PinInstance)db.getByKeyStr(PinInstance.class, pinInstanceKeyStr);
        s.add(dp, (DbObject)pi);
    }

    public static class ActionSwapBundleSide
    extends AbstractAction {
        private Bundle mBundle;

        public ActionSwapBundleSide(Bundle bundle) {
            super("Swap Fix-Free End");
            this.mBundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Swap Fix-Free End");){
                Cp.exec((String)"Bundle.swapSide(curDb(), \"%s\")", (Object[])new Object[]{this.mBundle.getKeyStr()});
            }
            OrbitIO.getApp().refreshCurrentView();
        }
    }

    public static class ActionZoomBundle
    extends AActionGroup {
        protected Bundle bundle;

        public ActionZoomBundle(Bundle bundle) {
            this.putValue("Name", "Zoom To");
            this.bundle = bundle;
            this.addActions(ActionZoomPartBundle.getActions(bundle));
        }

        public static void zoomTo(Bundle bundle) {
            DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
            if (bundle == null || bundle.getPath() == null) {
                return;
            }
            AffineTransform trans = ((DevicePath)bundle.getTemplate().getHierarchicalInstances().next()).getTransform();
            ARect rc = bundle.getPath().getBounds();
            rc = (ARect)rc.transform(trans);
            dv2d.getXForm().setWorld(rc);
            dv2d.refresh();
        }

        public static void zoomTo(Bundle bundle, List<APoint2D> rakePts) {
            DesignCanvas2D dv2d = ((DesignView2D)OrbitIO.getCurView()).getCanvas();
            if (rakePts == null) {
                return;
            }
            APoint2D pt = rakePts.get(0);
            ARect rc = new ARect(pt, pt);
            for (APoint2D p : rakePts) {
                rc.expand(p);
            }
            AffineTransform trans = ((DevicePath)bundle.getTemplate().getHierarchicalInstances().next()).getTransform();
            rc = (ARect)rc.transform(trans);
            long min = Design.micronToInternal((Db)bundle.getDb(), (double)1.0);
            rc.grow(min);
            rc.expand(1.5);
            dv2d.zoomTo(rc);
        }

        public static class ActionZoomPartBundle
        extends AbstractAction {
            protected Bundle bundle;
            protected ZOOMTYPE ztype;

            public ActionZoomPartBundle(Bundle bundle, ZOOMTYPE ztype) {
                this.bundle = bundle;
                this.ztype = ztype;
                switch (ztype) {
                    case BUNDLE: {
                        this.putValue("Name", "All");
                        break;
                    }
                    case FIXED: {
                        this.putValue("Name", "Fixed End");
                        break;
                    }
                    case FREE: {
                        this.putValue("Name", "Free End");
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (this.ztype) {
                    case BUNDLE: {
                        ActionZoomBundle.zoomTo(this.bundle);
                        break;
                    }
                    case FIXED: {
                        ActionZoomBundle.zoomTo(this.bundle, this.bundle.getFixedRakePtsList());
                        break;
                    }
                    case FREE: {
                        ActionZoomBundle.zoomTo(this.bundle, this.bundle.getFreeRakePtsList());
                    }
                }
            }

            public static Iterator<Action> getActions(Bundle bundle) {
                ArrayList<ActionZoomPartBundle> a = new ArrayList<ActionZoomPartBundle>();
                a.add(new ActionZoomPartBundle(bundle, ZOOMTYPE.BUNDLE));
                a.add(new ActionZoomPartBundle(bundle, ZOOMTYPE.FIXED));
                a.add(new ActionZoomPartBundle(bundle, ZOOMTYPE.FREE));
                return a.iterator();
            }
        }

        public static enum ZOOMTYPE {
            BUNDLE,
            FIXED,
            FREE;

        }
    }

    public static class ActionEditBundleRake
    extends AbstractAction {
        protected Bundle mBundle;

        public ActionEditBundleRake(Bundle bundle) {
            super("Edit Rake Pattern");
            this.mBundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRakeUI.decideRake(OrbitIO.getCurDb(), \"%s\");", (Object[])new Object[]{this.mBundle.getKeyStr()});
        }
    }

    public static class ActionEditBundles
    extends AbstractAction {
        protected Bundle mBundle;

        public ActionEditBundles(Bundle bundle) {
            super("Edit Bundles...");
            this.mBundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.ui.wb_route.BundleEditorDlg.createDialog(OrbitIO.getMainWin(), curDb()).setVisible(true)", (Object[])new Object[0]);
        }
    }

    public static class ActionBundleSelEditLayers
    extends AbstractAction {
        public ActionBundleSelEditLayers() {
            super("Edit Layers Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"UserCommands.bundleSelEditLayers()", (Object[])new Object[0]);
        }
    }

    public static class ActionEditLayers
    extends AbstractAction {
        protected Bundle bundle;

        public ActionEditLayers(Bundle bundle) {
            super("Edit Layers");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<Layer> preSelected = new HashSet<Layer>();
            preSelected.addAll(this.bundle.getLayers());
            LayerSelectorDlg lsd = LayerSelectorDlg.showMe(OrbitIO.getCurView(), this.bundle.getTemplate().getSubstrate(), preSelected);
            if (lsd.getUserOked()) {
                Cp.exec((String)"%s.clearBundleLayer(curDb(), \"%s\")", (Object[])new Object[]{BundleCommands.class.getName(), this.bundle.getKeyStr()});
                lsd.getSelected().forEach(l -> {
                    String layerKeyStr = l.getKeyStr();
                    Cp.exec((String)"%s.addBundleLayer(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{BundleCommands.class.getName(), this.bundle.getKeyStr(), layerKeyStr});
                });
            }
        }
    }

    public static class ActionSelectFreePins
    extends AbstractAction {
        protected Bundle bundle;

        public ActionSelectFreePins(Bundle bundle) {
            super("Select Free Pins");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MutableInteger num = MutableInteger.create((int)0);
            for (HierPin hp : this.bundle.getFreePins()) {
                hp.getPath().getAllFullPaths().forEach(parent -> {
                    DevicePath fullPath = parent;
                    BundleUI.selectHierPort(fullPath.toString(), ((PinInstance)hp.second).getKeyStr());
                    num.increment();
                });
            }
            ALog.logInfo((String)"Selected %d pins", (Object[])new Object[]{num.getValue()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionSelectFreeEnclosedPins
    extends AbstractAction {
        protected Bundle bundle;

        public ActionSelectFreeEnclosedPins(Bundle bundle) {
            super("Select Enclosed Free Pins");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MutableInteger num = MutableInteger.create((int)0);
            for (HierPin hp : this.bundle.getEnclosedFreePins()) {
                hp.getPath().getAllFullPaths().forEach(parent -> {
                    DevicePath fullPath = parent;
                    BundleUI.selectHierPort(fullPath.toString(), ((PinInstance)hp.second).getKeyStr());
                    num.increment();
                });
            }
            ALog.logInfo((String)"Selected %d pins", (Object[])new Object[]{num.getValue()});
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionBundleSelRouteFreeSide
    extends AbstractAction {
        public ActionBundleSelRouteFreeSide() {
            super("Route Free Side of Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"UserCommands.bundleRouteFreeSide()", (Object[])new Object[0]);
        }
    }

    public static class ActionRouteFreeSide
    extends AbstractAction {
        protected Bundle bundle;

        public ActionRouteFreeSide(Bundle bundle) {
            super("Feasibility Route Free Side");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.prepareForRouting (OrbitIO.getCurDb(),  \"%s\", false, true);", (Object[])new Object[]{this.bundle.getKeyStr()});
        }
    }

    public static class ActionBundleSelRouteFixedSide
    extends AbstractAction {
        public ActionBundleSelRouteFixedSide() {
            super("Route Fixed Side of Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"UserCommands.bundleRouteFixedSide()", (Object[])new Object[0]);
        }
    }

    public static class ActionRouteFixedSide
    extends AbstractAction {
        protected Bundle bundle;

        public ActionRouteFixedSide(Bundle bundle) {
            super("Feasibility Route Fixed Side");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.automation.router.BundleRoutePrep.prepareForRouting (OrbitIO.getCurDb(),  \"%s\", true, true);", (Object[])new Object[]{this.bundle.getKeyStr()});
        }
    }

    public static class ActionUntangleFreeEnd
    extends AbstractAction {
        protected Bundle bundle;

        public ActionUntangleFreeEnd(Bundle bundle) {
            super("Untangle Free End ");
            this.bundle = bundle;
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator.show();
        }
    }

    public static class ActionUntangleFixedEnd
    extends AbstractAction {
        protected Bundle bundle;

        public ActionUntangleFixedEnd(Bundle bundle) {
            super("Untangle Fixed End ");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.untangleStart(this.bundle);
        }
    }

    public static class ActionOptimizeBundleD
    extends AbstractAction {
        protected Bundle bundle;

        public ActionOptimizeBundleD(Bundle bundle) {
            super("Optimize Free End Diagonal");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.setConstraints(10000L, 10000L, Constraint.RouteAngle.FortyFive);
            ibr.setOptAlgorithm("d");
            ibr.start(this.bundle, null, null, InteractiveBundleCreator.UseMode.Optimize);
        }
    }

    public static class ActionOptimizeBundleV
    extends AbstractAction {
        protected Bundle bundle;

        public ActionOptimizeBundleV(Bundle bundle) {
            super("Optimize Free End Vertical");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.setConstraints(10000L, 10000L, Constraint.RouteAngle.FortyFive);
            ibr.setOptAlgorithm("v");
            ibr.start(this.bundle, null, null, InteractiveBundleCreator.UseMode.Optimize);
        }
    }

    public static class ActionOptimizeBundleH
    extends AbstractAction {
        protected Bundle bundle;

        public ActionOptimizeBundleH(Bundle bundle) {
            super("Optimize Free End Horizontal");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator ibr = InteractiveBundleCreator.show();
            ibr.setConstraints(10000L, 10000L, Constraint.RouteAngle.FortyFive);
            ibr.setOptAlgorithm("h");
            ibr.start(this.bundle, null, null, InteractiveBundleCreator.UseMode.Optimize);
        }
    }

    public static class ActionBundleSelOptimizeFreeEnd
    extends AbstractAction {
        public ActionBundleSelOptimizeFreeEnd() {
            super("Optimize Free End of Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Optimize Bundle Free End");){
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.optimizeFreeEndOfSelected()", (Object[])new Object[0]);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionOptimizeBundle
    extends AbstractAction {
        protected Bundle bundle;

        public ActionOptimizeBundle(Bundle bundle) {
            super("Optimize Free End ");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"unset(\"_ibr\")", (Object[])new Object[0]);
            Cp.exec((String)"_ibr=com.sigrity.orbit.automation.router.InteractiveBundleCreator.show()", (Object[])new Object[0]);
            Cp.exec((String)"_ibr.optimizeFreeEnd(\"%s\")", (Object[])new Object[]{this.bundle.getKeyStr()});
        }
    }

    public static class ActionEditPath
    extends AbstractAction {
        protected Bundle bundle;

        public ActionEditPath(Bundle bundle) {
            super("Edit Path");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveRouteEditMode.editBundleInit(this.bundle);
        }
    }

    public static class ActionReformBundle
    extends AbstractAction {
        protected Bundle bundle;

        public ActionReformBundle(Bundle bundle) {
            super("Edit Contents");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RouteQueueDlg.getLastDialog() != null) {
                RouteQueueDlg.getLastDialog().removeNotify();
            }
            Cp.exec((String)"unset(\"_ibr\")", (Object[])new Object[0]);
            Cp.exec((String)"_ibr=com.sigrity.orbit.automation.router.InteractiveBundleCreator.show()", (Object[])new Object[0]);
            Cp.exec((String)"_ibr.editContents(\"%s\")", (Object[])new Object[]{this.bundle.getKeyStr()});
        }
    }

    public static class ActionOptimizeFreeEndPath
    extends AbstractAction {
        protected Bundle bundle;

        public ActionOptimizeFreeEndPath(Bundle bundle) {
            super("Optimize Free End Path");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RouteQueueDlg.getLastDialog() != null) {
                RouteQueueDlg.getLastDialog().removeNotify();
            }
            Cp.exec((String)"unset(\"_ibr\")", (Object[])new Object[0]);
            Cp.exec((String)"_ibr=com.sigrity.orbit.automation.router.InteractiveBundleCreator.show()", (Object[])new Object[0]);
            Cp.exec((String)"_ibr.optimizeFreeEndPath(\"%s\")", (Object[])new Object[]{this.bundle.getKeyStr()});
        }
    }

    public static class ActionShowMinLength
    extends AbstractAction {
        protected Bundle b;

        public ActionShowMinLength(Bundle b) {
            super("Show Min Length");
            this.b = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchedConn sc = BundleLengths.getBundleLengths(this.b, null, null).getMinSchedConn();
            PinInstance pA = sc.getDPPA().getPin();
            Device devA = pA.getDevice();
            for (DevicePath devPath : devA.getHierarchicalInstances()) {
                HierPin hpA = new HierPin(devPath, pA);
                ShowMeTheWay.addHierPin(hpA);
            }
            if (sc.getDPPB() != null) {
                PinInstance pB = sc.getDPPB().getPin();
                Device devB = pB.getDevice();
                for (DevicePath devPath : devB.getHierarchicalInstances()) {
                    HierPin hpB = new HierPin(devPath, pB);
                    ShowMeTheWay.addHierPin(hpB);
                }
            }
        }
    }

    public static class ActionShowMaxLength
    extends AbstractAction {
        protected Bundle b;

        public ActionShowMaxLength(Bundle b) {
            super("Show Max Length");
            this.b = b;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SchedConn sc = BundleLengths.getBundleLengths(this.b, null, null).getMaxSchedConn();
            PinInstance pA = sc.getDPPA().getPin();
            Device devA = pA.getDevice();
            for (DevicePath devPath : devA.getHierarchicalInstances()) {
                HierPin hpA = new HierPin(devPath, pA);
                ShowMeTheWay.addHierPin(hpA);
            }
            if (sc.getDPPB() != null) {
                PinInstance pB = sc.getDPPB().getPin();
                Device devB = pB.getDevice();
                for (DevicePath devPath : devB.getHierarchicalInstances()) {
                    HierPin hpB = new HierPin(devPath, pB);
                    ShowMeTheWay.addHierPin(hpB);
                }
            }
        }
    }

    public static class ActionShowBundle
    extends AbstractAction {
        protected Bundle mBundle;

        public ActionShowBundle(Bundle bundle) {
            super("Visible");
            this.mBundle = bundle;
            Design design = Design.getDesign((Db)this.mBundle.getDb());
            if (design != null) {
                this.putValue("SwingSelectedKey", this.mBundle.getIsVisible());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String bundleKeyStr = this.mBundle.getKeyStr();
            Cp.exec((String)"OrbitIO.getCurDb().getByKeyStr(Bundle.class, \"%s\").setIsVisible (%b)", (Object[])new Object[]{bundleKeyStr, !this.mBundle.getIsVisible()});
            OrbitIO.refreshViewsOf(this.mBundle.getDb());
        }
    }

    public static class ActionBundleSelDelete
    extends AbstractAction {
        public ActionBundleSelDelete() {
            super("Delete Selected");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (RouteQueueDlg.getLastDialog() != null) {
                RouteQueueDlg.getLastDialog().removeNotify();
            }
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Delete Bundle");){
                Cp.exec((String)"com.sigrity.orbit.automation.router.InteractiveBundleCreator.delete()", (Object[])new Object[0]);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    public static class ActionDeleteBundle
    extends AbstractAction {
        protected Bundle bundle;

        public ActionDeleteBundle(Bundle bundle) {
            super("Delete");
            this.bundle = bundle;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InteractiveBundleCreator.deleteWithTrans(this.bundle);
        }
    }
}

