/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class CSVNetlistInDlg {
    public static boolean showMe(String devicePathString, boolean netsOnly) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = netsOnly ? AFileFilter.TXT : AFileFilter.CSV;
        ImportOptionsPanel options = new ImportOptionsPanel();
        fc.setAccessory((JComponent)options);
        fc.setFileFilter((FileFilter)filter);
        if (netsOnly) {
            AFileFilter ffCsv = AFileFilter.CSV;
            fc.addChoosableFileFilter((FileFilter)ffCsv);
            fc.setFileFilter((FileFilter)ffCsv);
        }
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        String ext = netsOnly ? ".txt" : ".csv";
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (!f.getName().contains(".")) {
            path = (String)path + ext;
        }
        boolean assignIOPinsToFP = options.getAssignIOPinsToFloorplan();
        Cp.exec((String)"OrbitIO.importCSVNetlist(%s, \"%s\", %b, %b)", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString, netsOnly, assignIOPinsToFP});
        DbExplorerPanel.refreshAll();
        return true;
    }

    private static class ImportOptionsPanel
    extends JPanel {
        JCheckBox mAssignIOPinsToFloorplans;

        public ImportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Import CSV Netlist"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mAssignIOPinsToFloorplans = new JCheckBox("Assign IO Pins to Floorplans");
            l.add((Component)this.mAssignIOPinsToFloorplans, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean getAssignIOPinsToFloorplan() {
            return this.mAssignIOPinsToFloorplans.isSelected();
        }
    }
}

