/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.netlister.NetLister;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class CSVNetlistOutDlg {
    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = AFileFilter.CSV;
        ExportOptionsPanel options = new ExportOptionsPanel();
        fc.setDialogTitle("Export CSV Net List");
        fc.setAccessory((JComponent)options);
        fc.setFileFilter((FileFilter)filter);
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        int depth = 1;
        if (options.exportRecursive()) {
            depth = -1;
        }
        if (options.exportUnused()) {
            Cp.exec((String)"createDefaultNets(\"%s\")", (Object[])new Object[]{devicePathString});
        }
        NetLister.cpExportCSV(devicePathString, (String)path, depth, options.exportOnlySelected(), options.exportOnlySelectedPorts(), options.exportAbsolute());
        return true;
    }

    private static class ExportOptionsPanel
    extends JPanel {
        JCheckBox mExportRecursive;
        JCheckBox mExportOnlySelected;
        JCheckBox mExportPortsOnlySelected;
        JCheckBox mExportAbsolutePathNames;
        JCheckBox mInlcudeUnusedNet;

        public ExportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export options"));
            GridBagManager l = new GridBagManager((Container)this);
            this.mExportRecursive = new JCheckBox("Export all levels below");
            this.mExportRecursive.setToolTipText("<html>By default only pins at the level of the device selected<br>and one level below will be generated.</html>");
            l.add((Component)this.mExportRecursive, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            this.mExportOnlySelected = new JCheckBox("Export only pins of selected devices");
            this.mExportOnlySelected.setToolTipText("<html>Only export pins of devices that are selected.</html>");
            l.add((Component)this.mExportOnlySelected, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            this.mExportPortsOnlySelected = new JCheckBox("Export only nets of selected pins");
            this.mExportPortsOnlySelected.setToolTipText("<html>Only export nets of pins that are selected.</html>");
            l.add((Component)this.mExportPortsOnlySelected, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            this.mExportAbsolutePathNames = new JCheckBox("Export full path names");
            this.mExportAbsolutePathNames.setToolTipText("<html>Generate full path names in the netlist.<br>By default relative path names will be used,<br>which is useful for reuse on different designs.</html>");
            l.add((Component)this.mExportAbsolutePathNames, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            this.mInlcudeUnusedNet = new JCheckBox("Create default nets on all pins prior to export");
            this.mInlcudeUnusedNet.setToolTipText("<html>Nets will be created and mapped all the way to the specified level.</html>");
            l.add((Component)this.mInlcudeUnusedNet, (GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.newline();
            l.addFillY();
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public boolean exportRecursive() {
            return this.mExportRecursive.isSelected();
        }

        public boolean exportOnlySelected() {
            return this.mExportOnlySelected.isSelected();
        }

        public boolean exportOnlySelectedPorts() {
            return this.mExportPortsOnlySelected.isSelected();
        }

        public boolean exportAbsolute() {
            return this.mExportAbsolutePathNames.isSelected();
        }

        public boolean exportUnused() {
            return this.mInlcudeUnusedNet.isSelected();
        }
    }
}

