/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PersonalityCSVIn;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class CSVPersonalityInDlg {
    private CSVPersonalityInDlg() {
    }

    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = AFileFilter.CSV;
        ImportOptionsPanel options = new ImportOptionsPanel();
        fc.setAccessory((JComponent)options);
        fc.setFileFilter((FileFilter)filter);
        fc.setDialogTitle("Import CSV Personalities");
        if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Import Personalities CSV");){
            Cp.exec((String)"unset(\"_personalityIn\")", (Object[])new Object[0]);
            Object path_ = path;
            Cp.exec(() -> CSVPersonalityInDlg.lambda$showMe$0(options, (String)path_, devicePathString), (String)"_personalityIn = new com.sigrity.orbit.export.PersonalityCSVIn()", (Object[])new Object[0]);
            if (options.getImportNetPersonality()) {
                Cp.exec((String)"_personalityIn.setImportNetPersonalities(true)", (Object[])new Object[0]);
            }
            if (options.getImportPinPersonality()) {
                Cp.exec((String)"_personalityIn.setImportPinPersonalities(true)", (Object[])new Object[0]);
            }
            if (options.getImportDevicePersonality()) {
                Cp.exec((String)"_personalityIn.setImportDevicePersonalities(true)", (Object[])new Object[0]);
            }
            if (options.getReferToParentNet()) {
                Cp.exec((String)"_personalityIn.setByParentNetName(true)", (Object[])new Object[0]);
            }
            if (options.getCleanImport()) {
                Cp.exec((String)"_personalityIn.setRemoveExistingPersonalities(true)", (Object[])new Object[0]);
            }
            Cp.exec((String)"_personalityIn.importCSV(curDb(), %s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString});
            Cp.exec((String)"unset(\"_personalityIn\")", (Object[])new Object[0]);
        }
        DbExplorerPanel.refreshAll();
        return true;
    }

    private static /* synthetic */ void lambda$showMe$0(ImportOptionsPanel options, String path_, String devicePathString) {
        PersonalityCSVIn _personalityIn = new PersonalityCSVIn();
        _personalityIn.setImportNetPersonalities(options.getImportNetPersonality());
        _personalityIn.setImportPinPersonalities(options.getImportPinPersonality());
        _personalityIn.setImportDevicePersonalities(options.getImportDevicePersonality());
        _personalityIn.setByParentNetName(options.getReferToParentNet());
        _personalityIn.setRemoveExistingPersonalities(options.getCleanImport());
        _personalityIn.importCSV(OrbitIO.getCurDb(), path_, devicePathString);
    }

    private static class ImportOptionsPanel
    extends JPanel {
        JRadioButton mImportNetPersonality;
        JRadioButton mImportPinPersonality;
        JRadioButton mImportDevicePersonality;
        JCheckBox mReferToParentNet;
        JCheckBox mRemoveExistingPersonalities;

        public ImportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Import Options"));
            GridBagManager l = GridBagManager.layout((Container)this);
            l.pushFillX("Personality");
            this.mImportNetPersonality = (JRadioButton)l.add((Component)new JRadioButton("Net"), (GridBagConstraints)GridBagManager.LEFT);
            this.mImportNetPersonality.setToolTipText("If selected, net personalities will be imported.");
            this.mImportNetPersonality.setSelected(true);
            this.mImportNetPersonality.addActionListener(e -> {
                if (this.mImportNetPersonality.isSelected()) {
                    this.mReferToParentNet.setEnabled(true);
                }
            });
            l.addFillX();
            l.newline();
            this.mImportPinPersonality = (JRadioButton)l.add((Component)new JRadioButton("Pin"), (GridBagConstraints)GridBagManager.LEFT);
            this.mImportPinPersonality.setToolTipText("If selected, pin personalities will be imported.");
            this.mImportPinPersonality.setSelected(false);
            this.mImportPinPersonality.addActionListener(e -> {
                if (this.mImportPinPersonality.isSelected()) {
                    this.mReferToParentNet.setEnabled(false);
                }
            });
            l.addFillX();
            l.newline();
            this.mImportDevicePersonality = (JRadioButton)l.add((Component)new JRadioButton("Device"), (GridBagConstraints)GridBagManager.LEFT);
            this.mImportDevicePersonality.setToolTipText("If selected, device personalities will be imported.");
            this.mImportDevicePersonality.setSelected(false);
            this.mImportDevicePersonality.addActionListener(e -> {
                if (this.mImportDevicePersonality.isSelected()) {
                    this.mReferToParentNet.setEnabled(false);
                }
            });
            l.addFillX();
            l.pop();
            l.newline();
            ButtonGroup group = new ButtonGroup();
            group.add(this.mImportNetPersonality);
            group.add(this.mImportDevicePersonality);
            group.add(this.mImportPinPersonality);
            l.pushFillX("Settings");
            this.mReferToParentNet = (JCheckBox)l.add((Component)new JCheckBox("Refer to parent net name"), (GridBagConstraints)GridBagManager.LEFT);
            this.mReferToParentNet.setToolTipText("If selected, personalities will be classified by parent net name.");
            this.mReferToParentNet.setEnabled(true);
            l.newline();
            this.mRemoveExistingPersonalities = (JCheckBox)l.add((Component)new JCheckBox("Clean import"), (GridBagConstraints)GridBagManager.LEFT);
            this.mRemoveExistingPersonalities.setToolTipText("If selected, all existing personalities will be removed before import.");
            this.mRemoveExistingPersonalities.setEnabled(true);
            this.mRemoveExistingPersonalities.setSelected(true);
            l.addFillX();
            l.newline();
            l.pop();
        }

        boolean getImportNetPersonality() {
            return this.mImportNetPersonality.isSelected();
        }

        boolean getImportPinPersonality() {
            return this.mImportPinPersonality.isSelected();
        }

        boolean getImportDevicePersonality() {
            return this.mImportDevicePersonality.isSelected();
        }

        boolean getReferToParentNet() {
            return this.mReferToParentNet.isSelected();
        }

        boolean getCleanImport() {
            return this.mRemoveExistingPersonalities.isSelected();
        }
    }
}

