/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PersonalityCSVOut;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class CSVPersonalityOutDlg {
    private CSVPersonalityOutDlg() {
    }

    public static boolean showMe(String devicePathString) {
        AFileChooser fc = new AFileChooser();
        ExportOptionsPanel options = new ExportOptionsPanel();
        fc.setAccessory((JComponent)options);
        AFileFilter filter = AFileFilter.CSV;
        fc.setFileFilter((FileFilter)filter);
        fc.setDialogTitle("Export CSV Personalities");
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return false;
        }
        File f = fc.getSelectedFile();
        String path = f.getPath();
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Export Personalities CSV");){
            Cp.exec((String)"unset(\"_personalityOut\")", (Object[])new Object[0]);
            String path_ = path;
            Cp.exec(() -> {
                PersonalityCSVOut _personalityOut = new PersonalityCSVOut();
                _personalityOut.setExportNetPersonalities(options.getExportNetPersonality());
                _personalityOut.setExportPinPersonalities(options.getExportPinPersonality());
                _personalityOut.setExportDevicePersonalities(options.getExportDevicePersonality());
                _personalityOut.exportCSV(OrbitIO.getCurDb(), path_, devicePathString);
            }, (String)"_personalityOut = new com.sigrity.orbit.export.PersonalityCSVOut()", (Object[])new Object[0]);
            if (options.getExportNetPersonality()) {
                Cp.exec((String)"_personalityOut.setExportNetPersonalities(true)", (Object[])new Object[0]);
            }
            if (options.getExportPinPersonality()) {
                Cp.exec((String)"_personalityOut.setExportPinPersonalities(true)", (Object[])new Object[0]);
            }
            if (options.getExportDevicePersonality()) {
                Cp.exec((String)"_personalityOut.setExportDevicePersonalities(true)", (Object[])new Object[0]);
            }
            Cp.exec((String)"_personalityOut.exportCSV(curDb(), %s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)path), devicePathString});
            Cp.exec((String)"unset(\"_personalityOut\")", (Object[])new Object[0]);
        }
        DbExplorerPanel.refreshAll();
        return true;
    }

    private static class ExportOptionsPanel
    extends JPanel {
        JRadioButton mExportNetPersonality;
        JRadioButton mExportPinPersonality;
        JRadioButton mExportDevicePersonality;

        public ExportOptionsPanel() {
            this.setBorder(BorderFactory.createTitledBorder("Export Options"));
            GridBagManager l = GridBagManager.layout((Container)this);
            l.pushFillX("Personality");
            this.mExportNetPersonality = (JRadioButton)l.add((Component)new JRadioButton("Net"), (GridBagConstraints)GridBagManager.LEFT);
            this.mExportNetPersonality.setToolTipText("If selected, net personalities will be exported.");
            this.mExportNetPersonality.setSelected(true);
            l.addFillX();
            l.newline();
            this.mExportPinPersonality = (JRadioButton)l.add((Component)new JRadioButton("Pin"), (GridBagConstraints)GridBagManager.LEFT);
            this.mExportPinPersonality.setToolTipText("If selected, pin personalities will be exported.");
            this.mExportPinPersonality.setSelected(false);
            l.addFillX();
            l.newline();
            this.mExportDevicePersonality = (JRadioButton)l.add((Component)new JRadioButton("Device"), (GridBagConstraints)GridBagManager.LEFT);
            this.mExportDevicePersonality.setToolTipText("If selected, device personalities will be exported.");
            this.mExportDevicePersonality.setSelected(false);
            l.addFillX();
            l.pop();
            l.newline();
            ButtonGroup group = new ButtonGroup();
            group.add(this.mExportNetPersonality);
            group.add(this.mExportDevicePersonality);
            group.add(this.mExportPinPersonality);
        }

        boolean getExportNetPersonality() {
            return this.mExportNetPersonality.isSelected();
        }

        boolean getExportPinPersonality() {
            return this.mExportPinPersonality.isSelected();
        }

        boolean getExportDevicePersonality() {
            return this.mExportDevicePersonality.isSelected();
        }
    }
}

