/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.CSVIOWizard;
import com.sigrity.acl.CSVIOWizardUI;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.CreatePinFactory;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.export.PortCSVIn;
import com.sigrity.orbit.export.PortCSVOut;
import com.sigrity.orbit.ui.DeviceUI;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class CSVPinListUI {
    public static final String EXPORT_CSV_TITLE = "Export CSV Pins...";
    public static final String IMPORT_CSV_TITLE = "Import CSV Pins...";

    public static void showPinOutDlg(DevicePath mpath) {
        DevicePath mDevicePath = mpath;
        AFileChooser fc = new AFileChooser();
        AFileFilter filter = AFileFilter.CSV;
        fc.setFileFilter((FileFilter)filter);
        fc.setDialogTitle(EXPORT_CSV_TITLE);
        JPanel extraControls = new JPanel();
        fc.setAccessory((JComponent)extraControls);
        extraControls.setBorder(BorderFactory.createTitledBorder("Export Options"));
        GridBagManager l = GridBagManager.layout((Container)extraControls);
        JCheckBox cbRelative = (JCheckBox)l.add((Component)new JCheckBox("Use relative locations"), (GridBagConstraints)GridBagManager.LEFT);
        cbRelative.setToolTipText("If selected, output locations are relative to the starting device instead of the design.");
        cbRelative.setSelected(true);
        l.newline();
        JCheckBox cbPortCenter = (JCheckBox)l.add((Component)new JCheckBox("Use pin center locations"), (GridBagConstraints)GridBagManager.LEFT);
        cbPortCenter.setToolTipText("If selected, output the pin center location.");
        cbPortCenter.setSelected(true);
        l.newline();
        l.addFillY();
        CSVIOWizard wiz = new CSVIOWizard(PortCSVOut.getHeader());
        wiz.setSettingsSection(PortCSVOut.SETTINGS_SECTION);
        wiz.loadSettings();
        JButton wizardBtn = (JButton)l.add((Component)new JButton("Pin CSV-Out Wizard"));
        wizardBtn.addActionListener(e -> {
            CSVIOWizardUI wizUI = new CSVIOWizardUI((Component)fc);
            wizUI.setWizard(wiz);
            wizUI.showMe();
        });
        l.newline();
        if (fc.showSaveDialog((Component)OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        Object path = f.getPath();
        if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
            path = (String)path + ".csv";
        }
        Cp.exec((String)"unset(\"_portOut\")", (Object[])new Object[0]);
        Cp.exec((String)"_portOut = new com.sigrity.orbit.export.PortCSVOut()", (Object[])new Object[0]);
        if (cbRelative.isSelected()) {
            Cp.exec((String)"_portOut.setAbsoluteLocations(false)", (Object[])new Object[0]);
        }
        if (cbPortCenter.isSelected()) {
            Cp.exec((String)"_portOut.setPortCenter(true)", (Object[])new Object[0]);
        }
        Cp.exec((String)"unset(\"_outWizard\")", (Object[])new Object[0]);
        Cp.exec((String)"_outWizard = new %s()", (Object[])new Object[]{AReflection.getJavaClassName(CSVIOWizard.class)});
        Cp.exec((String)"_outWizard.setHeader(_portOut.getHeader())", (Object[])new Object[0]);
        Cp.exec((String)"_outWizard.setSettingsSection(\"%s\")", (Object[])new Object[]{PortCSVOut.SETTINGS_SECTION});
        Cp.exec((String)"_outWizard.loadSettings()", (Object[])new Object[0]);
        for (String script : wiz.getScripts()) {
            Cp.exec((String)"_outWizard.%s", (Object[])new Object[]{script});
        }
        Cp.exec((String)"_portOut.setCSVIOWizard(_outWizard)", (Object[])new Object[0]);
        Cp.exec((String)"_portOut.write(curDb(), %s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)path), mDevicePath.escapedString()});
        Cp.exec((String)"unset(\"_outWizard\")", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_portOut\")", (Object[])new Object[0]);
        wiz.saveSettings();
    }

    public static void showPinInDlg(DevicePath path) {
        DbDialog dlg = new DbDialog(path.getDb(), (Component)OrbitIO.getMainWindow(), IMPORT_CSV_TITLE);
        GridBagManager l = GridBagManager.layout((Container)dlg.getContentPane());
        l.pushFillX("Source");
        l.add("File:");
        AFileChooserControl fc = (AFileChooserControl)l.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.FILLX);
        fc.addChoosableFileFilter(AFileFilter.CSV);
        l.popNl();
        l.pushFillX("Import Mode");
        JRadioButton rbReplace = new JRadioButton("Oevrwrite", true);
        JRadioButton rbMerge = new JRadioButton("Merge", false);
        rbReplace.setToolTipText("Delete old contents and add new contents by input file");
        rbMerge.setToolTipText("Reserve old contents and update them by input file");
        ButtonGroup btnGrp = new ButtonGroup();
        btnGrp.add(rbReplace);
        btnGrp.add(rbMerge);
        l.add((Component)rbReplace, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add((Component)rbMerge, (GridBagConstraints)GridBagManager.FILLX);
        l.popNl();
        final JLabel placeLabel = new JLabel("Placement Origin:");
        final JRadioButton rbOrigin = new JRadioButton("Origin", false);
        rbOrigin.setToolTipText("Bump origin");
        final JRadioButton rbPortCenter = new JRadioButton("Pin center", true);
        rbPortCenter.setToolTipText("Pin center");
        placeLabel.setVisible(false);
        rbOrigin.setVisible(false);
        rbPortCenter.setVisible(false);
        l.pushFillX("Options");
        l.add("Pin Style:", (GridBagConstraints)GridBagManager.FILLX);
        final JRadioButton rbBump = new JRadioButton("Device", false);
        JRadioButton rbPin = new JRadioButton("Pin", true);
        rbBump.setToolTipText("Import Bumps");
        rbPin.setToolTipText("Import Pins");
        rbPin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                placeLabel.setVisible(rbBump.isSelected());
                rbOrigin.setVisible(rbBump.isSelected());
                rbPortCenter.setVisible(rbBump.isSelected());
            }
        });
        rbBump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                placeLabel.setVisible(rbBump.isSelected());
                rbOrigin.setVisible(rbBump.isSelected());
                rbPortCenter.setVisible(rbBump.isSelected());
            }
        });
        l.add((Component)rbBump, (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)rbPin, (GridBagConstraints)GridBagManager.FILLX);
        ButtonGroup btnGrp2 = new ButtonGroup();
        btnGrp2.add(rbBump);
        btnGrp2.add(rbPin);
        l.newline();
        l.add((Component)placeLabel, (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)rbOrigin, (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)rbPortCenter, (GridBagConstraints)GridBagManager.FILLX);
        ButtonGroup btnGrp3 = new ButtonGroup();
        btnGrp3.add(rbOrigin);
        btnGrp3.add(rbPortCenter);
        l.popNl();
        l.pushFillX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(e -> {
            try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)IMPORT_CSV_TITLE);){
                Cp.exec((String)"unset(\"_portCsvIn\")", (Object[])new Object[0]);
                Cp.exec((String)"_portCsvIn = new com.sigrity.orbit.export.PortCSVIn(%s, \"%s\")", (Object[])new Object[]{Cp.getFileAsArgument((String)fc.getPath()), path.escapedString()});
                Cp.exec((String)"_portCsvIn.setMode(%s.%s)", (Object[])new Object[]{AReflection.getJavaClassName(PortCSVIn.Mode.class), rbReplace.isSelected() ? PortCSVIn.Mode.REPLACE.name() : PortCSVIn.Mode.MERGE.name()});
                Cp.exec((String)"_portCsvIn.setType(%s.%s)", (Object[])new Object[]{AReflection.getJavaClassName(CreatePinFactory.Type.class), rbBump.isSelected() ? CreatePinFactory.Type.BUMP.name() : CreatePinFactory.Type.PIN.name()});
                if (rbPortCenter.isSelected()) {
                    Cp.exec((String)"_portCsvIn.setPortCenter(true)", (Object[])new Object[0]);
                }
                Cp.exec((String)"_portCsvIn.importPinList()", (Object[])new Object[0]);
                PortCSVIn importer = (PortCSVIn)Cp.getValue((String)"_portCsvIn");
                for (PadTemplate pad : importer.getNeedEditPads()) {
                    PadStackDlg.createDialog((Window)dlg, path.getSubstrate(), pad);
                }
                Cp.exec((String)"unset(\"_portCsvIn\")", (Object[])new Object[0]);
            }
            new DeviceUI.ActionEditDevice(path).actionPerformed(null);
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        l.popNl();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        UIUtil.center((Component)dlg);
        l.pushFillY();
        l.pop();
        dlg.setVisible(true);
    }

    public static AbstractAction getPinOutAction(DevicePath path) {
        return new ActionExportCSVPinList(path);
    }

    public static AbstractAction getPinInAction(DevicePath path) {
        return new ActionImportCSVPinList(path);
    }

    private CSVPinListUI() {
    }

    protected static class ActionImportCSVPinList
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionImportCSVPinList(DevicePath path) {
            super(CSVPinListUI.IMPORT_CSV_TITLE);
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVPinListUI.showPinInDlg(this.mDevicePath);
        }
    }

    protected static class ActionExportCSVPinList
    extends AbstractAction {
        protected DevicePath mDevicePath;

        public ActionExportCSVPinList(DevicePath path) {
            super(CSVPinListUI.EXPORT_CSV_TITLE);
            this.mDevicePath = path;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSVPinListUI.showPinOutDlg(this.mDevicePath);
        }
    }
}

