/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.orbit.HierPin;
import java.awt.Color;
import java.math.BigInteger;
import java.util.LinkedList;
import javax.swing.Icon;

public class CanConnectRegistry {
    protected static CanConnectRegistry sRegistry = new CanConnectRegistry();
    protected LinkedList<CanConnectFunction> registry = new LinkedList();

    public static void addToRegistry(CanConnectFunction efp) {
        CanConnectRegistry.sRegistry.registry.add(efp);
    }

    public static LinkedList<CanConnectFunction> getRegistry() {
        return CanConnectRegistry.sRegistry.registry;
    }

    public static void clearRegistry() {
        CanConnectRegistry.sRegistry.registry.clear();
    }

    public static CanConnectFunction getCCF(String name) {
        for (CanConnectFunction ccf : CanConnectRegistry.sRegistry.registry) {
            if (!ccf.id().equals(name)) continue;
            return ccf;
        }
        return null;
    }

    private static void registerStandardFunctions() {
        CanConnectRegistry.addToRegistry(new AnyConnect());
        CanConnectRegistry.addToRegistry(new SamePinPersonality());
        CanConnectRegistry.addToRegistry(new SameInstruction());
    }

    static {
        CanConnectRegistry.registerStandardFunctions();
    }

    static class SamePinPersonality
    implements CanConnectFunction {
        SamePinPersonality() {
        }

        @Override
        public boolean canConnect(HierPin a, HierPin b) {
            if (a == null || b == null) {
                return false;
            }
            Personality aP = a.getPin().getPersonality();
            Personality bP = b.getPin().getPersonality();
            if (aP == null || bP == null) {
                return false;
            }
            return aP.getName().equals(bP.getName());
        }

        @Override
        public String menuName() {
            return "Personality Names much match";
        }

        @Override
        public String toolTip() {
            return "The name of the pin personality on the fixed pin must be the same as a pin's personality on the free side";
        }

        @Override
        public String id() {
            return "samePersonality";
        }

        @Override
        public Icon icon() {
            return new AColorIcon(10, 10, Color.red);
        }
    }

    static class SameInstruction
    implements CanConnectFunction {
        SameInstruction() {
        }

        @Override
        public boolean canConnect(HierPin a, HierPin b) {
            if (a == null || b == null) {
                return false;
            }
            BigInteger instructionA = (BigInteger)a.getPin().getValue("autobundle.instruction");
            BigInteger instructionB = (BigInteger)b.getPin().getValue("autobundle.instruction");
            if (instructionA == null) {
                return false;
            }
            if (instructionB == null) {
                return false;
            }
            return !instructionA.and(instructionB).equals(BigInteger.ZERO);
        }

        @Override
        public String menuName() {
            return "Auto Bundle Instructions Must Match";
        }

        @Override
        public String toolTip() {
            return "Used Internally for Auto Bundling";
        }

        @Override
        public String id() {
            return "sameInstruction";
        }

        @Override
        public Icon icon() {
            return new AColorIcon(10, 10, Color.red);
        }
    }

    static class AnyConnect
    implements CanConnectFunction {
        AnyConnect() {
        }

        @Override
        public boolean canConnect(HierPin a, HierPin b) {
            return true;
        }

        @Override
        public String menuName() {
            return "Any Connection can Be Made";
        }

        @Override
        public String toolTip() {
            return "Any pin of the fixed set can be connected to any pin of the free set.";
        }

        @Override
        public String id() {
            return "any";
        }

        @Override
        public Icon icon() {
            return new AColorIcon(10, 10, Color.red);
        }
    }

    public static interface CanConnectFunction {
        public boolean canConnect(HierPin var1, HierPin var2);

        public String id();

        public String menuName();

        public String toolTip();

        public Icon icon();
    }
}

