/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ACheckBoxList2;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class CleanupPadTemplateUI
extends DbDialog {
    private DevicePath mDevicePath;
    private Substrate mSubstrate;
    protected Map<PadTemplate, Integer> mPadUses = new HashMap<PadTemplate, Integer>();
    protected JButton mDelete = new JButton("OK");
    protected JButton mCancel = new JButton("Close");
    protected JButton btnNone = UIUtil.makeSmallButton((JButton)new JButton("Select None"));
    protected JButton btnAll = UIUtil.makeSmallButton((JButton)new JButton("Select All"));

    public CleanupPadTemplateUI(Component owner, DevicePath dp) {
        this(owner, dp, dp.getSubstrate());
    }

    public CleanupPadTemplateUI(Component owner, DevicePath dp, Substrate substrate) {
        super(dp.getDb(), owner);
        this.mDevicePath = dp;
        this.mSubstrate = substrate;
        this.init();
    }

    protected void init() {
        PadTemplateComboBox pcb = new PadTemplateComboBox(this.mDevicePath, this.mSubstrate);
        this.mPadUses = pcb.getPadUses();
        this.setTitle("Delete Unused Padstacks");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.initialize();
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        UIUtil.enableDefaultBtn((JDialog)((Object)this), (JButton)this.mDelete);
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        this.setVisible(true);
    }

    public Stream<PadTemplate> findUnusedPadTemplates() {
        String port2PadTRelName = "PortTemplate-padTemplate";
        ArrayList<PadTemplate> unusedPad = new ArrayList<PadTemplate>();
        DbRelationDef rdPortT2PadT = this.getDb().getRelation("PortTemplate-padTemplate");
        if (rdPortT2PadT == null) {
            ALog.logWarn((String)"Unable to get '%s' relation, unable to determine unused PadTemplates.", (Object[])new Object[]{"PortTemplate-padTemplate"});
            return Stream.empty();
        }
        for (PadTemplate pt : AUtil.arrayList((Iterator)this.getDb().getObjects(PadTemplate.class))) {
            if (pt.getSubstrate() != this.mSubstrate || this.mPadUses.containsKey(pt) && (!this.mPadUses.containsKey(pt) || this.mPadUses.get(pt) != null)) continue;
            unusedPad.add(pt);
        }
        return unusedPad.stream();
    }

    public static boolean deletePadTemplate(Db db, String substrateName, String padTemplatename) {
        Substrate s = Substrate.getSubstrate((Db)db, (String)substrateName);
        PadTemplate pt = PadTemplate.get((Db)db, (Substrate)s, (String)padTemplatename);
        if (pt != null) {
            pt.deleteFromDb();
        }
        return true;
    }

    protected void initialize() {
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        Stream<String> unusedPadNames = this.findUnusedPadTemplates().map(PadTemplate::getName).sorted();
        ACheckBoxList2<String> lst = new ACheckBoxList2<String>(unusedPadNames);
        l.add((Component)new JScrollPane(lst), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.insetBottom(0));
        lst.setSelectionMode(2);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        l.add((Component)this.btnAll, (GridBagConstraints)GridBagManager.LEFT);
        this.btnAll.addActionListener(e -> lst.setAllCheck(true));
        l.add((Component)this.btnNone, (GridBagConstraints)GridBagManager.LEFT);
        this.btnNone.addActionListener(e -> lst.setAllCheck(false));
        l.popNl();
        l.pushFillXRemainX();
        l.addFillX();
        l.add((Component)this.mDelete, (GridBagConstraints)GridBagManager.RIGHT);
        this.mDelete.addActionListener(event -> {
            ListModel names = lst.getModel();
            long deletedCount = 0L;
            try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Deleting Pad Template");){
                for (int i = 0; i < names.getSize(); ++i) {
                    if (!lst.isChecked(i)) continue;
                    String name = (String)names.getElementAt(i);
                    Object result = Cp.exec((String)"%s.deletePadTemplate(curDb(), \"%s\", \"%s\")", (Object[])new Object[]{CleanupPadTemplateUI.class.getName(), this.mSubstrate.getName(), name});
                    if (!Boolean.TRUE.equals(result)) continue;
                    ++deletedCount;
                }
            }
            ALog.logInfo((String)"Deleted %d Pad templates", (Object[])new Object[]{deletedCount});
            UIUtil.closeWindow((Window)((Object)this));
        });
        l.add((Component)this.mCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
    }
}

