/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnsAutoSizer {
    protected boolean mDistributeExcessToLastCol = false;
    protected int minWidth = 20;
    protected int maxPrefWidth = 400;
    protected ExcessTracker mExcessDistributed = new ExcessTracker();

    public static ColumnsAutoSizer create() {
        return new ColumnsAutoSizer();
    }

    protected ColumnsAutoSizer() {
    }

    protected ColumnsAutoSizer copy() {
        ColumnsAutoSizer r = new ColumnsAutoSizer();
        r.mDistributeExcessToLastCol = this.mDistributeExcessToLastCol;
        return r;
    }

    public ColumnsAutoSizer setDistributeExcessToLastCol(boolean b) {
        ColumnsAutoSizer r = this.copy();
        r.mDistributeExcessToLastCol = b;
        return r;
    }

    public void sizeColumnsToFit(JTable table) {
        for (int col = 0; col < table.getColumnCount(); ++col) {
            this.sizeColumnToFit(table, col);
        }
        if (this.mDistributeExcessToLastCol) {
            this.distributeExcessToLastCol(table);
        }
    }

    public void sizeColumnToFit(JTable table, int col) {
        int width = this.getPreferredWidth(table, col);
        int minWidth = this.getPreferredWidth(table, col);
        width = Math.max(width, minWidth);
        TableColumn tc = table.getColumnModel().getColumn(col);
        tc.setMinWidth(minWidth);
        tc.setPreferredWidth(Math.min(width, this.maxPrefWidth));
        tc.setMaxWidth(Integer.MAX_VALUE);
    }

    protected int getPreferredWidth(JTable table, int col) {
        TableColumn tc = table.getColumnModel().getColumn(col);
        JTableHeader th = table.getTableHeader();
        int width = 0;
        if (th != null) {
            Object val = tc.getHeaderValue();
            TableCellRenderer renderer = tc.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            Component c = renderer.getTableCellRendererComponent(table, val, false, false, -1, col);
            width = c.getPreferredSize().width + 3;
        }
        for (int row = 0; row < table.getRowCount(); ++row) {
            TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
            Component rendererComponent = table.prepareRenderer(cellRenderer, row, col);
            width = Math.max(width, rendererComponent.getPreferredSize().width + 3);
        }
        return width;
    }

    public int getMinWidth(int col) {
        return this.minWidth;
    }

    public void distributeExcessToLastCol(JTable table) {
        Integer curExcess;
        if (table.getColumnCount() < 1) {
            return;
        }
        Container c = table.getParent();
        if (!(c instanceof JViewport)) {
            return;
        }
        JViewport vp = (JViewport)c;
        vp.doLayout();
        int desiredWidth = vp.getWidth();
        int diff = desiredWidth - table.getWidth();
        TableColumnModel colModel = table.getColumnModel();
        TableColumn lastCol = colModel.getColumn(colModel.getColumnCount() - 1);
        if (diff > 0) {
            int newWidth = lastCol.getPreferredWidth() + diff;
            lastCol.setPreferredWidth(newWidth);
            this.mExcessDistributed.add(lastCol, diff);
        } else if (diff < 0 && (curExcess = Integer.valueOf(this.mExcessDistributed.get(lastCol))) != null) {
            if (curExcess <= -diff) {
                int newWidth = lastCol.getPreferredWidth() - curExcess;
                lastCol.setPreferredWidth(newWidth);
                this.mExcessDistributed.remove(lastCol);
            } else {
                int newWidth = lastCol.getPreferredWidth() + diff;
                lastCol.setPreferredWidth(newWidth);
                this.mExcessDistributed.set(lastCol, curExcess + diff);
            }
        }
    }

    protected static class ExcessTracker {
        protected HashMap<TableColumn, Integer> mCol2Excess = new HashMap();

        protected ExcessTracker() {
        }

        public void set(TableColumn col, int excess) {
            if (excess <= 0) {
                this.remove(col);
            } else {
                this.mCol2Excess.put(col, excess);
            }
        }

        public int get(TableColumn col) {
            Integer i = this.mCol2Excess.get(col);
            return i == null ? 0 : i;
        }

        public void add(TableColumn col, int excess) {
            this.set(col, this.get(col) + excess);
        }

        public void remove(TableColumn col) {
            this.mCol2Excess.remove(col);
        }
    }
}

