/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizationControllerThread;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.WeightedGoalFunction;
import com.sigrity.orbit.automation.WeightedGoalRegistry;
import com.sigrity.orbit.ui.CanConnectRegistry;
import com.sigrity.orbit.ui.FixedFreePinSelection;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConnectionManagerDlg
extends DbDialog {
    public static boolean useAdvancedTab = false;
    protected static final Icon ICON_STANDARD = OrbitIcons.COG;
    protected static final Icon ICON_ADVANCED = OrbitIcons.COG_ADVANCED;
    protected static final String CFG_SECTION_UI = "ConnectionOptimizationUI";
    protected static final String CFG_ITEM_LASTUSEDTABIDX = "LastUsedOptTabIdx";
    protected static final int CFG_ITEM_LASTUSEDTABIDX_DFLT = 2;
    protected static String mPreferredButtonText = "";
    protected static Map<Db, ConnectionManagerDlg> dialogMap = new WeakHashMap<Db, ConnectionManagerDlg>();
    private JRadioButton mSwapNets;
    private JRadioButton mSwapDevices;
    private JButton mOptimize;
    private JTextField mBaseNetNameText;
    private JCheckBox mOnePinPerNet;
    private JCheckBox mRemoveNetMappingOnFreeSide;
    private JComboBox<CanConnectRegistry.CanConnectFunction> mConnectionCriteria;
    protected JPanel advancedPanel;
    private JComboBox<Effort> mTime;
    protected CustomProgressBar mProgressBar = null;
    protected StopButton mStopButton;
    protected final AAppView mView;
    protected JPanel advancedOptionsPanel;
    protected JTabbedPane tabbedPane;
    protected AGeneticOptimizationControllerThread agoct;
    protected final FixedFreePinSelection pinSelectionPanel = new FixedFreePinSelection();
    protected DbRelationDef.DbRelationListener mFL = null;
    protected DbRelationDef.DbRelationListener mPL = null;
    protected static LinkedList<MessageReciever> sChannels = new LinkedList();
    protected ActionListener updateFilter = e -> {
        this.pinSelectionPanel.setOnePinOneNet(this.mOnePinPerNet.isSelected());
        this.pinSelectionPanel.setRemoveNetMapping(this.mRemoveNetMappingOnFreeSide.isSelected());
        this.pinSelectionPanel.doTreeASelectionAction();
        this.pinSelectionPanel.doTreeBSelectionAction();
    };
    protected WindowListener mDialogListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            PortPairOpt.clearActive(OrbitIO.getCurDb());
        }

        @Override
        public void windowClosed(WindowEvent e) {
            mPreferredButtonText = "";
            dialogMap.remove(ConnectionManagerDlg.this.getDb());
        }
    };

    public static ConnectionManagerDlg showMeOnTab(Frame owner, int tab, String buttonText) {
        ConnectionManagerDlg cmd = ConnectionManagerDlg.getCurrent();
        mPreferredButtonText = buttonText;
        if (cmd == null) {
            cmd = new ConnectionManagerDlg(owner);
        }
        if (tab >= 0) {
            cmd.setTab(tab);
        }
        return cmd;
    }

    public static ConnectionManagerDlg getCurrent() {
        Db db = OrbitIO.getCurDb();
        return dialogMap.get(db);
    }

    public static void showMe(Frame owner) {
        ConnectionManagerDlg.showMeOnTab(owner, -1, "");
    }

    public static boolean addLoadListener(MessageReciever l) {
        return sChannels.add(l);
    }

    public static boolean removeLoadListener(MessageReciever l) {
        return sChannels.remove(l);
    }

    protected static void sendMessage(String data) {
        for (MessageReciever l : sChannels) {
            l.stats(data);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.mFL = new FloorplanListener();
        DbRelationDef rd = this.mDb.getRelation("FloorplanPin-owner");
        assert (rd != null);
        rd.addRelationListener(this.mFL, DbRelationDef.RELATION_UPDATED);
        this.mPL = new PersonalityListener();
        rd = this.mDb.getRelation("Personality-owner");
        assert (rd != null);
        rd.addRelationListener(this.mPL, DbRelationDef.RELATION_UPDATED);
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.mDb != null) {
            DbRelationDef rd = this.mDb.getRelation("FloorplanPin-owner");
            if (rd != null) {
                rd.removeRelationListener(this.mFL, DbRelationDef.RELATION_UPDATED);
            }
            if ((rd = this.mDb.getRelation("Personality-owner")) != null) {
                rd.removeRelationListener(this.mPL, DbRelationDef.RELATION_UPDATED);
            }
            this.mFL = null;
            this.mPL = null;
        }
    }

    private ConnectionManagerDlg(Frame owner) {
        super(OrbitIO.getCurDb(), (Component)owner);
        this.setTitle("Connection Optimization");
        this.setDefaultCloseOperation(2);
        Settings settings = Settings.getSettings((String)CFG_SECTION_UI);
        sChannels.clear();
        dialogMap.put(this.getDb(), this);
        this.mView = OrbitIO.getCurView();
        Cp.exec((String)"UserCommands.unselectAll()", (Object[])new Object[0]);
        GridBagManager l = new GridBagManager((Container)((Object)this));
        l.add((Component)this.pinSelectionPanel, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        JPanel standardOptionsPanel = new JPanel();
        GridBagManager mGB1 = new GridBagManager((Container)standardOptionsPanel);
        ButtonGroup optGroup = new ButtonGroup();
        this.mSwapNets = new JRadioButton("Updating Nets or NetMaps");
        this.mSwapDevices = new JRadioButton("Swap Devices");
        optGroup.add(this.mSwapNets);
        optGroup.add(this.mSwapDevices);
        this.mSwapDevices.setSelected(false);
        this.mSwapNets.setSelected(true);
        mGB1.push("Optimize By", (GridBagConstraints)GridBagManager.FILLALL.width(2));
        mGB1.add((Component)this.mSwapNets, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        mGB1.newline();
        mGB1.add((Component)this.mSwapDevices, (GridBagConstraints)GridBagManager.LEFT.insetVert(0));
        mGB1.addFillX();
        mGB1.pop();
        mGB1.newline();
        this.mRemoveNetMappingOnFreeSide = new JCheckBox("Remove Net Mappings on Free Side Before Optimization");
        this.mRemoveNetMappingOnFreeSide.addActionListener(this.updateFilter);
        this.mRemoveNetMappingOnFreeSide.setSelected(PortPairOpt.isRemoveNetMappingOnToSide());
        mGB1.add((Component)this.mRemoveNetMappingOnFreeSide, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        mGB1.newline();
        this.mOnePinPerNet = new JCheckBox("Use One Pin On the Fixed Side For Each Net");
        this.mOnePinPerNet.addActionListener(this.updateFilter);
        this.mOnePinPerNet.setSelected(!PortPairOpt.getTreatFromAsIndividuals());
        this.mOnePinPerNet.setToolTipText("Select only one pin on the Fixed side to represent multi-pin nets");
        mGB1.add((Component)this.mOnePinPerNet, (GridBagConstraints)GridBagManager.LEFT.width(2).insetVert(0));
        mGB1.newline();
        this.mBaseNetNameText = new JTextField(10);
        this.mBaseNetNameText.setText("NewNet_");
        mGB1.add("Base Net Name:", (Component)this.mBaseNetNameText, (GridBagConstraints)GridBagManager.LEFT);
        mGB1.newline();
        this.mConnectionCriteria = new JComboBox();
        this.mConnectionCriteria.setRenderer(new CriteriaBoxRenderer());
        for (CanConnectRegistry.CanConnectFunction ccf : CanConnectRegistry.getRegistry()) {
            this.mConnectionCriteria.addItem(ccf);
        }
        mGB1.add("Connection Criteria:", this.mConnectionCriteria, (GridBagConstraints)GridBagManager.LEFT);
        mGB1.newline();
        mGB1.addFillY();
        this.advancedOptionsPanel = new JPanel();
        GridBagManager mGB2 = new GridBagManager((Container)this.advancedOptionsPanel);
        mGB2.pushFillX();
        mGB2.pushNoFill();
        mGB2.pop();
        mGB2.addFillX();
        mGB2.newline();
        this.advancedPanel = new JPanel();
        mGB2.push((Container)this.advancedPanel, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        mGB2.pushNoFill();
        JLabel label1 = new JLabel("Effort:");
        mGB2.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        this.mTime = new JComboBox();
        for (int i = 0; i < Effort.values().length; ++i) {
            this.mTime.addItem(Effort.values()[i]);
        }
        this.mTime.setRenderer(new EffortComboBoxRender());
        mGB2.add(this.mTime, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        mGB2.pop();
        mGB2.addFillX();
        mGB2.newline();
        mGB2.push((GridBagConstraints)GridBagManager.FILLX_REMAINX);
        for (WeightedGoalFunction f : WeightedGoalRegistry.getRegistry()) {
            JSlider slider = this.addWeightSlider(mGB2, f.name(), f.toolTip(), f.color());
            slider.setForeground(f.color());
            f.setSlider(slider);
            mGB2.newline();
        }
        mGB2.pop();
        mGB2.addFillX();
        mGB2.newline();
        mGB2.pushFillAllRemainX();
        this.mProgressBar = new CustomProgressBar();
        this.mProgressBar.setVisible(true);
        this.mProgressBar.setStringPainted(true);
        mGB2.add((Component)this.mProgressBar, (GridBagConstraints)GridBagManager.FILLALL);
        this.mStopButton = new StopButton();
        mGB2.add((Component)this.mStopButton, (GridBagConstraints)GridBagManager.RIGHT.noInsets());
        this.mStopButton.setEnabled(false);
        mGB2.add((Component)new JLabel());
        mGB2.pop();
        mGB2.newline();
        mGB2.pop();
        mGB2.newline();
        mGB2.addFillY();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Standard Options", ICON_STANDARD, standardOptionsPanel, "Performs a Quick Optimization");
        if (useAdvancedTab) {
            this.tabbedPane.addTab("Advanced Options", ICON_ADVANCED, this.advancedOptionsPanel, "Performs a Genetic Optimization");
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    ConnectionManagerDlg.this.updateEnablementForStandardChoice();
                }
            }
        });
        l.add((Component)this.tabbedPane, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.mOptimize = new JButton("Standard Optimize", ICON_STANDARD);
        this.mOptimize.addActionListener(ae -> {
            int curTab = this.tabbedPane.getSelectedIndex();
            settings.putSetting(CFG_ITEM_LASTUSEDTABIDX, (Object)curTab);
            settings.save();
            if (curTab == 1) {
                if (!this.readyToOptimize()) {
                    return;
                }
                this.mStopButton.setEnabled(true);
                this.tabbedPane.setSelectedComponent(this.advancedOptionsPanel);
                this.mProgressBar.active = true;
                AGeneticOptimizer.removeLoadListers();
                AGeneticOptimizer.addLoadListener(new MyUpdateListener());
                for (WeightedGoalFunction gf : WeightedGoalRegistry.getRegistry()) {
                    double weight = (double)gf.getSlider().getValue() / 100.0;
                    Cp.exec((String)"wgf = com.sigrity.orbit.automation.WeightedGoalRegistry.getFunction (\"%s\");", (Object[])new Object[]{gf.name()});
                    Cp.exec((String)"if (wgf != null) wgf.setWeight(%f)", (Object[])new Object[]{weight});
                }
                Effort e = (Effort)((Object)((Object)this.mTime.getSelectedItem()));
                Cp.exec((String)"com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizerManager gom = new com.sigrity.orbit.automation.connOpt.GeneticConnectionOptimizerManager ();", (Object[])new Object[0]);
                Cp.exec((String)"gom.getConnectionsFromPPO();", (Object[])new Object[0]);
                Cp.exec((String)"gom.setEvolveParameters (%d, %d);", (Object[])new Object[]{e.seconds, e.maxPopulation});
                Cp.exec((String)"gom.setRemoveOriginalConnections (%b);", (Object[])new Object[]{this.mRemoveNetMappingOnFreeSide.isSelected()});
                CanConnectRegistry.CanConnectFunction ccf = (CanConnectRegistry.CanConnectFunction)this.mConnectionCriteria.getSelectedItem();
                String name = ccf.id();
                Cp.exec((String)"gom.setConnectionCriteria (\"%s\");", (Object[])new Object[]{name});
                this.agoct = (AGeneticOptimizationControllerThread)Cp.exec((String)"gom.evolve();", (Object[])new Object[0]);
            } else {
                this.agoct = null;
                if (!this.readyToOptimize()) {
                    return;
                }
                CanConnectRegistry.CanConnectFunction ccf = (CanConnectRegistry.CanConnectFunction)this.mConnectionCriteria.getSelectedItem();
                String name = ccf.id();
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().setCanConnectFunction(\"%s\")", (Object[])new Object[]{name});
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().setRemoveNetMappingOnToSide(%b)", (Object[])new Object[]{this.mRemoveNetMappingOnFreeSide.isSelected()});
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().setTreatFromAsIndividuals(%b)", (Object[])new Object[]{!this.mOnePinPerNet.isSelected()});
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().setUseOnlyUsedPortsOnFixedSide(false);", (Object[])new Object[0]);
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().setUseOnlyUnusedPortsOnFreeSide(false);", (Object[])new Object[0]);
                boolean swapDevices = !this.mSwapNets.isSelected();
                Cp.exec((String)"com.sigrity.acl.optimizer.PortPairOpt.getActive().optimize(%b)", (Object[])new Object[]{swapDevices});
                Cp.exec((String)"UserCommands.createConnections();", (Object[])new Object[0]);
                OrbitIO.getApp().refreshCurrentView(false);
            }
        });
        l.add((Component)this.mOptimize, (GridBagConstraints)GridBagManager.RIGHT);
        JButton close = new JButton("Close");
        l.add((Component)close, (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        this.updateEnablementForStandardChoice();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)close, (JButton)this.mOptimize);
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
        this.addWindowListener(this.mDialogListener);
        int tabIdx = Math.min((Integer)settings.getSetting(CFG_ITEM_LASTUSEDTABIDX, (Object)2), this.tabbedPane.getComponentCount());
        if (this.tabbedPane.getComponentCount() >= tabIdx) {
            tabIdx = this.tabbedPane.getComponentCount() - 1;
        }
        this.tabbedPane.setSelectedIndex(tabIdx);
    }

    public void setTab(int tab) {
        if (tab >= this.tabbedPane.getComponentCount()) {
            tab = this.tabbedPane.getComponentCount() - 1;
        }
        this.tabbedPane.setSelectedIndex(tab);
    }

    protected boolean readyToOptimize() {
        if (PortPairOpt.getActive() == null) {
            ALog.logInfo((String)"No Pins have been selected");
            return false;
        }
        if (PortPairOpt.getActive().getAPorts().isEmpty()) {
            ALog.logInfo((String)"No Fixed Pins have been selected");
            return false;
        }
        if (PortPairOpt.getActive().getBPorts().isEmpty()) {
            ALog.logInfo((String)"No Free Pins have been selected");
            return false;
        }
        return true;
    }

    protected JSlider addWeightSlider(GridBagManager c, String name, String toolTip, Color color) {
        JSlider slider = new JSlider(0, 100);
        JLabel l = new JLabel(name + ":");
        c.add((Component)l);
        l.setFont(l.getFont().deriveFont(1));
        l.setForeground(color);
        l.setToolTipText(toolTip);
        slider.setMajorTickSpacing(1);
        slider.setPaintTicks(false);
        slider.setPaintLabels(false);
        c.add((Component)slider, (GridBagConstraints)GridBagManager.FILLX);
        JTextField f = new JTextField(3);
        slider.addChangeListener(new SliderIsChanging(slider, f));
        return slider;
    }

    protected void recurseComponentsAndSetEnable(Container container, boolean e) {
        Component[] cs;
        for (Component cc : cs = container.getComponents()) {
            if (cc instanceof Container) {
                this.recurseComponentsAndSetEnable((Container)cc, e);
            }
            cc.setEnabled(e);
        }
    }

    protected void updateEnablementForStandardChoice() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            this.mOptimize.setText("Advanced Optimize");
            this.mOptimize.setIcon(ICON_ADVANCED);
            this.recurseComponentsAndSetEnable(this.advancedPanel, true);
            this.mStopButton.setEnabled(false);
        } else {
            this.mOptimize.setText("Standard Optimize");
            this.mOptimize.setIcon(ICON_STANDARD);
            this.recurseComponentsAndSetEnable(this.advancedPanel, false);
        }
    }

    public static void createConnections(String baseName, boolean useOnlyFreeSideWithUsedNets, boolean useOnlyFixedSideWithUnusedNets, boolean swapDevices) {
        PortPairOpt ppo = PortPairOpt.getActive(OrbitIO.getCurDb());
        if (ppo != null) {
            ppo.setUseOnlyUsedPortsOnFixedSide(useOnlyFreeSideWithUsedNets);
            ppo.setUseOnlyUnusedPortsOnFreeSide(useOnlyFixedSideWithUnusedNets);
            ppo.setSwapDevices(swapDevices);
            ppo.setBaseNewNetName(baseName);
            ppo.assign();
        }
    }

    public static void retrieveSelectedPathObjectsOnA() {
        FixedFreePinSelection.retrieveSelectedPathObjectsOnA();
    }

    public static void retrieveSelectedPathObjectsOnB() {
        FixedFreePinSelection.retrieveSelectedPathObjectsOnB();
    }

    public static void selectPortOnPersonality(String devicePath, String pinPersonalityKey) {
        FixedFreePinSelection.selectPortOnPersonality(devicePath, pinPersonalityKey);
    }

    public static void selectBondFingerPorts(String dPathString) {
        FixedFreePinSelection.selectBondFingerPorts(dPathString);
    }

    @Deprecated
    public static void selectPortsOnFloorplan(String floorPlanKey) {
        FixedFreePinSelection.selectPortsOnFloorplan(floorPlanKey);
    }

    public static class EffortComboBoxRender
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(Effort.values()[index].getToolTip());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public static class CriteriaBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CanConnectRegistry.CanConnectFunction ccf = (CanConnectRegistry.CanConnectFunction)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(ccf.toolTip());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : ccf.menuName());
            if (ccf != null) {
                this.setIcon(ccf.icon());
            }
            return this;
        }
    }

    public class SliderIsChanging
    implements ChangeListener {
        JSlider slider;
        JTextField f;

        public SliderIsChanging(JSlider slider, JTextField f) {
            this.slider = slider;
            this.f = f;
            if (ConnectionManagerDlg.this.mProgressBar != null) {
                ConnectionManagerDlg.this.mProgressBar.updateUI();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (ConnectionManagerDlg.this.mProgressBar != null) {
                ConnectionManagerDlg.this.mProgressBar.updateUI();
            }
            if (this.slider.getValueIsAdjusting()) {
                return;
            }
        }
    }

    class MyUpdateListener
    implements AGeneticOptimizer.GeneticOptimizerStatusListener {
        MyUpdateListener() {
        }

        @Override
        public void stats(int percent, boolean done, String data) {
            if (done) {
                ConnectionManagerDlg.this.mProgressBar.setValue(100);
                ConnectionManagerDlg.this.mProgressBar.setString("Done");
                Dimension d = ConnectionManagerDlg.this.mProgressBar.getSize();
                ConnectionManagerDlg.this.mProgressBar.paintImmediately(0, 0, d.width, d.height);
                ConnectionManagerDlg.this.mProgressBar.active = false;
                ConnectionManagerDlg.this.mStopButton.setEnabled(false);
                OrbitIO.getApp().refreshCurrentView(true);
                EventQueue.invokeLater(() -> {
                    if (Design.getDesign((Db)ConnectionManagerDlg.this.mDb, (boolean)false) != null) {
                        ConnectionManagerDlg.this.agoct.getGO().getBestIndividual();
                        Cp.exec((String)"gom.finish();", (Object[])new Object[0]);
                    }
                });
            } else {
                ConnectionManagerDlg.this.mProgressBar.setValue(percent);
                ConnectionManagerDlg.this.mProgressBar.setString(data);
                Dimension d = ConnectionManagerDlg.this.mProgressBar.getSize();
                ConnectionManagerDlg.this.mProgressBar.paintImmediately(0, 0, d.width, d.height);
            }
        }
    }

    static class CustomProgressBar
    extends JProgressBar {
        protected boolean active = false;

        CustomProgressBar() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.active) {
                super.paintComponent(g);
                return;
            }
            int total = 0;
            for (WeightedGoalFunction f : WeightedGoalRegistry.getRegistry()) {
                JSlider slider = f.getSlider();
                if (slider == null) continue;
                total += slider.getValue();
            }
            if (total == 0) {
                g2d.setColor(Color.gray);
                g2d.fillRect(0, 0, w, h);
            }
            int start = 0;
            for (WeightedGoalFunction f : WeightedGoalRegistry.getRegistry()) {
                JSlider slider = f.getSlider();
                if (slider == null) continue;
                Color color = f.color();
                if (!this.isEnabled()) {
                    color = Color.black;
                }
                int v = f.getSlider().getValue();
                double p = total == 0 ? (double)v : (double)v / (double)total;
                int myW = (int)(p * (double)w);
                GradientPaint gp = new GradientPaint(start, 0.0f, color, start + myW, h, Color.white);
                g2d.setPaint(gp);
                g2d.fillRect(start, 0, myW, h);
                start += myW;
            }
        }
    }

    class StopButton
    extends JLabel {
        public StopButton() {
            super(DBEResources.ICON_STOP);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (StopButton.this.isEnabled()) {
                        ConnectionManagerDlg.this.mStopButton.setEnabled(false);
                        ConnectionManagerDlg.this.agoct.stopEvolution();
                    }
                }
            });
        }
    }

    protected class PersonalityListener
    implements DbRelationDef.DbRelationListener {
        protected PersonalityListener() {
        }

        public void related(DbRelationDef.RelationChange change) {
            ConnectionManagerDlg.this.pinSelectionPanel.refreshTrees();
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            ConnectionManagerDlg.this.pinSelectionPanel.refreshTrees();
        }

        public boolean relating(DbRelationDef.RelationChange change) {
            return false;
        }

        public boolean unrelating(DbRelationDef.RelationChange change) {
            return false;
        }
    }

    protected class FloorplanListener
    implements DbRelationDef.DbRelationListener {
        protected FloorplanListener() {
        }

        public void related(DbRelationDef.RelationChange change) {
            ConnectionManagerDlg.this.pinSelectionPanel.refreshTrees();
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            ConnectionManagerDlg.this.pinSelectionPanel.refreshTrees();
        }

        public boolean relating(DbRelationDef.RelationChange change) {
            return false;
        }

        public boolean unrelating(DbRelationDef.RelationChange change) {
            return false;
        }
    }

    public static interface MessageReciever {
        public void stats(String var1);
    }

    public static enum Effort {
        E1("Short (10 seconds)", 10, 1, "A Solution requiring about 2 minutes"),
        E2("Short (2 minutes)", 120, 1, "A Solution requiring about 2 minutes"),
        E3("Medium (5 minutes)", 300, 2, "A Solution requiring about 5 minutes"),
        E4("Long (30 minutes)", 1800, 15, "A Solution requiring about 30 minutes"),
        E5("Exhaustive (2 hours)", 7200, 15, "A Solution requiring about 6 Hours");

        private String longDescriptor;
        private int seconds;
        private String toolTip;
        private int maxPopulation;

        private Effort(String ld, int time, int mp, String tt) {
            this.longDescriptor = ld;
            this.seconds = time;
            this.toolTip = tt;
            this.maxPopulation = mp;
        }

        public String toString() {
            return this.longDescriptor;
        }

        public int getTime() {
            return this.seconds;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public int getMaxPopulation() {
            return this.maxPopulation;
        }
    }
}

