/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AActionGroup;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.AutoBundleNetUI;
import com.sigrity.orbit.ui.OrbitGuiShortcutActionRegistry;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitHotkey;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.NodeIcons;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;

public class ConnectionUI {
    public static final OrbitGuiShortcutActionRegistry.ViewActionFactory ViewActionFactory = new OrbitGuiShortcutActionRegistry.ViewActionFactory(){

        private List<DevicePath> getConnectedDevices(List<Connection> selConn) {
            return selConn.stream().flatMap(c -> {
                APair pair = c.getPins();
                return Stream.of((HierPin)pair.getFirst(), (HierPin)pair.getSecond()).map(HierInst::getPath);
            }).distinct().sorted((a, b) -> Device.CompareName.compare(a.getDevice(), b.getDevice())).collect(Collectors.toList());
        }

        @Override
        public Iterator<Object> getActions(Db db, Selection selection, APoint2D worldLoc) {
            DbClass connClass = db.getDbClass(Connection.class);
            int selConnCount = selection.getCount(connClass);
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (selConnCount > 0) {
                List<Connection> selConn = selection.get(Connection.class).stream().collect(Collectors.toList());
                List<DevicePath> connDevices = this.getConnectedDevices(selConn);
                if (!connDevices.isEmpty()) {
                    actions.add(new ActionSelectPinsOn(selection, connDevices));
                    actions.add(new ActionCreateBundleFromConnection(selConn, connDevices));
                }
                actions.add(new ActionDeleteUnselectConnections(selection));
                actions.add(new ActionZoomToConnections(OrbitIO.getCurView(), selConn));
            }
            return actions.iterator();
        }

        @Override
        public String getGroupName() {
            return "Connection Actions";
        }
    };

    private ConnectionUI() {
    }

    public static void clearSelectedConnections() {
        Selection s = Design.getSelection((Db)OrbitIO.getCurDb());
        List toBeRemoved = s.get(Connection.class).stream().collect(Collectors.toList());
        for (DbObject dbo : toBeRemoved) {
            s.remove(dbo);
            dbo.deleteFromDb();
        }
    }

    public static class ActionZoomToConnections
    extends AbstractAction {
        protected List<Connection> mConns;
        protected DesignView2D mView;

        public ActionZoomToConnections(AAppView view, List<Connection> connections) {
            super("Zoom To");
            this.mConns = connections;
            if (!(view instanceof DesignView2D)) {
                this.setEnabled(false);
                return;
            }
            this.mView = (DesignView2D)view;
            this.putValue("AcceleratorKey", OrbitHotkey.getKeyStroke("UI Zoom"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ARect bounds = null;
            for (Connection c : this.mConns) {
                ARect b = c.getBounds();
                if (bounds == null) {
                    bounds = b;
                    continue;
                }
                bounds = bounds.expandBy(b);
            }
            if (bounds == null) {
                return;
            }
            ARect r = new ARect(bounds);
            this.mView.getCanvas().getXForm().setWorld(r);
            this.mView.getCanvas().refresh();
        }
    }

    private static class ActionSelectConnectionPinAt
    extends AbstractAction {
        protected final Selection mSel;
        protected final DevicePath mAssignDevice;

        public ActionSelectConnectionPinAt(Selection sel, DevicePath devicePath) {
            super(String.format("Select Pins at '%s'", devicePath));
            this.mSel = sel;
            this.mAssignDevice = devicePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mSel == Design.getSelection((Db)this.mAssignDevice.getDb())) {
                Cp.exec((String)"com.sigrity.orbit.cmd.SelectionCmds.selectPinsAtDeviceWithConnections(curDb(), %s)", (Object[])new Object[]{CpHelper.getCmdStr(this.mAssignDevice)});
            } else {
                for (Connection c : this.mSel.get(Connection.class)) {
                    APair pair = c.getPins();
                    HierPin pinA = (HierPin)pair.getFirst();
                    HierPin pinB = (HierPin)pair.getSecond();
                    Stream.of(pinA, pinB).forEach(hierPin -> {
                        if (AUtil.equals((Object)this.mAssignDevice, (Object)hierPin.getPath())) {
                            String className = hierPin.getDbObject().getDbClass().getName();
                            String key = hierPin.getDbObject().getKeyStr();
                            DevicePath path = hierPin.getPath();
                            Cp.exec((String)"com.sigrity.acl.db.Selection.setSelected(\"%s\", \"%s\", %s, %b)", (Object[])new Object[]{className, key, path == null ? "null" : String.format("\"%s\"", path.escapedString()), true});
                        }
                    });
                }
            }
            OrbitIO.getApp().refreshCurrentView();
        }
    }

    private static class ActionSelectConnectionPinOn
    extends AbstractAction {
        protected final Selection mSel;
        protected final DevicePath mAssignDevice;

        public ActionSelectConnectionPinOn(Selection sel, DevicePath devicePath) {
            super(String.format("Select Pins on '%s'", devicePath));
            this.mSel = sel;
            this.mAssignDevice = devicePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.mSel == Design.getSelection((Db)this.mAssignDevice.getDb())) {
                Cp.exec((String)"com.sigrity.orbit.cmd.SelectionCmds.selectPinsOnDeviceWithConnections(curDb(), %s)", (Object[])new Object[]{CpHelper.getCmdStr(this.mAssignDevice)});
            } else {
                for (Connection c : this.mSel.get(Connection.class)) {
                    APair pair = c.getPins();
                    HierPin pinA = (HierPin)pair.getFirst();
                    HierPin pinB = (HierPin)pair.getSecond();
                    Stream.of(pinA, pinB).forEach(hierPin -> {
                        if (this.mAssignDevice.isStartOf(hierPin.getPath())) {
                            String className = hierPin.getDbObject().getDbClass().getName();
                            String key = hierPin.getDbObject().getKeyStr();
                            DevicePath path = hierPin.getPath();
                            Cp.exec((String)"com.sigrity.acl.db.Selection.setSelected(\"%s\", \"%s\", %s, %b)", (Object[])new Object[]{className, key, path == null ? "null" : String.format("\"%s\"", path.escapedString()), true});
                        }
                    });
                }
            }
            OrbitIO.getApp().refreshCurrentView();
        }
    }

    public static class ActionSelectPinsOn
    extends AActionGroup {
        private Selection selection;

        public ActionSelectPinsOn(Selection sel, List<DevicePath> connPaths) {
            super("Select Pins");
            Long n;
            this.selection = sel;
            HashSet<DevicePath> used = new HashSet<DevicePath>();
            HashMultimap childMap = HashMultimap.create();
            HashMap<DevicePath, Long> nodeSize = new HashMap<DevicePath, Long>();
            PriorityQueue<DevicePath> q = new PriorityQueue<DevicePath>((x, y) -> Integer.compare(y.size(), x.size()));
            q.addAll(connPaths);
            Iterator<DevicePath> iterator = connPaths.iterator();
            while (iterator.hasNext()) {
                DevicePath path;
                n = (Long)nodeSize.get(path = iterator.next());
                nodeSize.put(path, n == null ? 1L : n + 1L);
            }
            while (!q.isEmpty()) {
                DevicePath path = (DevicePath)q.poll();
                if (used.contains(path)) continue;
                used.add(path);
                DevicePath parent = path.getParent();
                childMap.put((Object)parent, (Object)path);
                n = (Long)nodeSize.get(parent);
                nodeSize.put(parent, n == null ? (Long)nodeSize.get(path) : n + (Long)nodeSize.get(path));
                if (parent == null) continue;
                q.add(parent);
            }
            Db db = sel.getDb();
            this.addSubmenu(this, Design.getDesignPath((Db)db), (Multimap<DevicePath, DevicePath>)childMap, nodeSize);
        }

        void addSubmenu(AActionGroup g, DevicePath p, Multimap<DevicePath, DevicePath> childMap, Map<DevicePath, Long> nodeSize) {
            Collection children = childMap.get((Object)p);
            if (children == null || children.isEmpty()) {
                g.addAction(new ActionSelectConnectionPinOn(this.selection, p));
                g.addAction(new ActionSelectConnectionPinAt(this.selection, p));
                return;
            }
            if (children.size() == 1) {
                DevicePath childPath = children.stream().findFirst().orElse(null);
                if (AUtil.equals((Object)nodeSize.get(p), (Object)nodeSize.get(childPath))) {
                    this.addSubmenu(g, children.stream().findFirst().orElse(null), childMap, nodeSize);
                    return;
                }
            }
            if (!p.isDesign()) {
                AActionGroup group = new AActionGroup(p.getString());
                g.addAction(group);
                if (g != this) {
                    group.putValue("Name", p.getDevice().getName());
                    group.putValue("SmallIcon", NodeIcons.getIconForDevice(p.getDevice()));
                }
                g.addAction(new ActionSelectConnectionPinOn(this.selection, p));
                g.addAction(new ActionSelectConnectionPinAt(this.selection, p));
                for (DevicePath child : children) {
                    this.addSubmenu(group, child, childMap, nodeSize);
                }
            } else {
                g.addAction(new ActionSelectConnectionPinOn(this.selection, p));
                g.addAction(new ActionSelectConnectionPinAt(this.selection, p));
                for (DevicePath child : children) {
                    this.addSubmenu(g, child, childMap, nodeSize);
                }
            }
        }
    }

    public static class ActionCreateBundleFromConnection
    extends AbstractAction {
        protected List<Connection> mConns;
        protected List<DevicePath> mDevices;

        public ActionCreateBundleFromConnection(List<Connection> conns, List<DevicePath> devices) {
            super(String.format("Create a Bundle (%d)", conns.size()));
            if (devices.size() != 2) {
                this.setEnabled(false);
            }
            this.mConns = conns;
            this.mDevices = devices;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DevicePath deviceFrom = this.mDevices.get(0);
            DevicePath deviceTo = this.mDevices.get(1);
            ArrayList<HierPin> pinFrom = new ArrayList<HierPin>();
            ArrayList<HierPin> pinTo = new ArrayList<HierPin>();
            for (Connection c : this.mConns) {
                APair pair = c.getPins();
                HierPin pinA = (HierPin)pair.getFirst();
                HierPin pinB = (HierPin)pair.getSecond();
                Stream.of(pinA, pinB).forEach(hierPin -> {
                    if (deviceFrom.equals((Object)hierPin.getPath())) {
                        pinFrom.add((HierPin)hierPin);
                    } else if (deviceTo.equals((Object)hierPin.getPath())) {
                        pinTo.add((HierPin)hierPin);
                    }
                });
            }
            AutoBundleNetUI.go(pinFrom, pinTo);
            OrbitIO.getApp().refreshCurrentView();
        }
    }

    private static class ActionDeleteUnselectConnections
    extends AbstractAction {
        ActionDeleteUnselectConnections(Selection selection) {
            super("Remove Unselected Connection");
            this.setEnabled(selection == Design.getSelection((Db)OrbitIO.getCurDb()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db db = OrbitIO.getCurDb();
            try (DbHistory.DbTransaction txt = DbHistory.newDbTransaction((Db)db, (AbstractAction)this);){
                Cp.exec((String)"com.sigrity.orbit.cmd.ConnectionCommands.deleteUnselectedConnections(curDb())", (Object[])new Object[0]);
            }
        }
    }
}

