/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.optimizer.ConstructivePlacement;
import com.sigrity.acl.optimizer.genetic.AGeneticOptimizer;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.SimpleConstraintFrame;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.wb_route.BondRingDefinitionEditDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;

public class ConstructPlaceDlg
extends DbDialog {
    protected static DevicePath mParentPath = null;
    public static final AFileFilter FileFilterCsv = AFileFilter.CSV;
    protected DeviceSelectionListener mSelectionListener;
    static HashMap<Db, ConstructPlaceDlg> mDlgHashmap = new HashMap();
    private JProgressBar mProgressMeter;
    protected AGeneticOptimizer.GeneticOptimizerStatusListener mListener;
    private JTextField mImprovementStatus;
    protected JButton mPlaceButton;
    protected static ArrayList<Device> mChildren;
    protected ConstructivePlacement.LoadListener mImproveListener;
    protected SimpleConstraintFrame mConstraintFrame;
    protected Optional<Personality> mPersonality = null;
    protected boolean selectionChanging = false;
    protected ConstructivePlacement mCp;
    protected MyRunnable mThread;
    protected JButton mBtnClose;
    protected AFileChooserControl mFc;

    public static void showMe(Frame owner, DevicePath path, ArrayList<Device> children) {
        if (mDlgHashmap.get(OrbitIO.getCurDb()) != null) {
            mDlgHashmap.get(OrbitIO.getCurDb()).setVisible(true);
        } else {
            mDlgHashmap.put(OrbitIO.getCurDb(), new ConstructPlaceDlg(owner, path, children));
        }
    }

    protected boolean setPersonality(DeviceTemplate template) {
        String personalityName = "SIP_Placement";
        this.mPersonality = Personality.getPersonality((DeviceTemplate)template, (Personality.Type)Personality.Type.DEVICE, (String)personalityName);
        if (!this.mPersonality.isPresent()) {
            String templateKeyStr = template.getKeyStr();
            Personality personality = (Personality)Cp.exec((String)"com.sigrity.orbit.ui.PersonalityUI.addPersonality(\"%s\", com.sigrity.acl.db.std.Personality.Type.DEVICE, \"%s\", \"%s\")", (Object[])new Object[]{personalityName, templateKeyStr, AUtil.colorToString((Color)Color.green)});
            if (personality == null) {
                return false;
            }
            this.mPersonality = Optional.of(personality);
        }
        return true;
    }

    protected void updateSelectionChange() {
        Selection s = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        int count = 0;
        Db db = OrbitIO.getCurDb();
        for (Device d : db.getObjects(Device.class)) {
            if (!s.contains((DbObject)d)) continue;
            ++count;
        }
        this.mPlaceButton.setText("Place (" + count + ")");
        if (count == 0) {
            this.mPlaceButton.setEnabled(true);
        } else {
            this.mPlaceButton.setEnabled(true);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        Selection s = Selection.getCurrentSelectionForDb((Db)db);
        if (s != null && this.mSelectionListener != null) {
            s.removeSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        }
    }

    private void saveConstraints(DeviceTemplate template) {
        this.mConstraintFrame.doSave(this.mPersonality.orElse(null), template.getSubstrate(), false);
    }

    private ArrayList<Device> getChildren() {
        return mChildren;
    }

    public MyRunnable runThread() {
        MyRunnable t = new MyRunnable();
        Thread thread = new Thread(t);
        thread.start();
        return t;
    }

    private ConstructPlaceDlg(Frame owner, DevicePath path, ArrayList<Device> children) {
        super(path.getDb(), (Component)owner);
        this.setTitle("Automatic Placement");
        mParentPath = path;
        mChildren = children;
        this.setDefaultCloseOperation(0);
        GridBagManager gb = new GridBagManager((Container)((Object)this));
        JLabel label1 = new JLabel("Place  Devices on ");
        gb.add((Component)label1, (GridBagConstraints)GridBagManager.LEFT);
        gb.newline();
        Constraint.DescriptorList descList = new Constraint.DescriptorList();
        descList.add((Object)Constraint.DEVICE_TO_DEVICE_CLEAR);
        descList.add((Object)Constraint.DEVICE_TO_PARENT_CLEAR);
        descList.add((Object)Constraint.TIME_TO_RUN);
        this.setPersonality(path.getDeviceTemplate());
        gb.newline();
        this.mConstraintFrame = new SimpleConstraintFrame(descList, this.mPersonality.orElse(null), path.getLast().getSubstrate(), BondRingDefinitionEditDlg.BondRingDialogType.Edit);
        this.mConstraintFrame.setOpaque(true);
        gb.add((Component)this.mConstraintFrame, (GridBagConstraints)GridBagManager.FILLY);
        gb.newline();
        gb.add("Rules file:", (GridBagConstraints)GridBagManager.LEFT);
        gb.newline();
        this.mFc = (AFileChooserControl)gb.add((Component)new AFileChooserControl(), (GridBagConstraints)GridBagManager.LEFT);
        gb.newline();
        this.mFc.setUseSaveChooser(false);
        this.mFc.addChoosableFileFilter(FileFilterCsv);
        this.mProgressMeter = new JProgressBar(0, 100);
        this.mProgressMeter.setStringPainted(true);
        gb.add((Component)this.mProgressMeter, (GridBagConstraints)GridBagManager.FILLX);
        gb.newline();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ConstructPlaceDlg.this.mThread == null) {
                    ConstructPlaceDlg.this.dispose();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                mDlgHashmap.remove(OrbitIO.getCurDb());
            }
        });
        this.mListener = new AGeneticOptimizer.GeneticOptimizerStatusListener(){

            @Override
            public void stats(int percent, boolean done, String data) {
                if (done) {
                    percent = 100;
                }
                ConstructPlaceDlg.this.mProgressMeter.setValue(percent);
                Object s = done ? data : percent + "% " + data;
                ConstructPlaceDlg.this.mProgressMeter.setString((String)s);
                Dimension d = ConstructPlaceDlg.this.mProgressMeter.getSize();
                ConstructPlaceDlg.this.mProgressMeter.paintImmediately(0, 0, d.width, d.height);
                if (done) {
                    OrbitIO.getApp().zoomFitCurrentView();
                }
            }
        };
        AGeneticOptimizer.addLoadListener(this.mListener);
        gb.pushFill();
        gb.add((Component)new JLabel("Placement Status:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mImprovementStatus = new JTextField(15);
        this.mImprovementStatus.setText(" ");
        gb.add((Component)this.mImprovementStatus, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        gb.pop();
        gb.newline();
        this.mImproveListener = new ConstructivePlacement.LoadListener(){

            @Override
            public void stats(int percent, boolean init, String data) {
                String s = init ? " " : percent + "% " + data;
                ConstructPlaceDlg.this.mImprovementStatus.setText(s);
                Dimension d = ConstructPlaceDlg.this.mImprovementStatus.getSize();
                ConstructPlaceDlg.this.mImprovementStatus.paintImmediately(0, 0, d.width, d.height);
            }
        };
        ConstructivePlacement.addImprovementListener(this.mImproveListener);
        gb.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        this.mPlaceButton = new JButton("Place");
        this.mPlaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConstructPlaceDlg.this.runThread();
            }
        });
        gb.add((Component)this.mPlaceButton, (GridBagConstraints)GridBagManager.RIGHT);
        this.mBtnClose = new JButton("Close");
        this.mBtnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ConstructPlaceDlg.this.mBtnClose != null && ConstructPlaceDlg.this.mCp != null) {
                    if (ConstructPlaceDlg.this.mCp.mGc == null) {
                        UIUtil.closeWindow((Window)((Object)ConstructPlaceDlg.this));
                    } else {
                        ConstructPlaceDlg.this.mCp.mGc.mGeneticOptimizer.setStop(true);
                    }
                }
                UIUtil.closeWindow((Window)((Object)ConstructPlaceDlg.this));
            }
        });
        gb.add((Component)this.mBtnClose, (GridBagConstraints)GridBagManager.RIGHT);
        gb.pop();
        this.mSelectionListener = new DeviceSelectionListener();
        Selection s = Selection.getCurrentSelectionForDb((Db)OrbitIO.getCurDb());
        s.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        this.updateSelectionChange();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)this.mBtnClose, null);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    protected int toBePlacedCount(DevicePath placeOnPath) {
        Design design = Design.getDesign((Db)placeOnPath.getDb());
        Selection selection = design.getCurSelection();
        ArrayList<DevicePath> toBePlaced = new ArrayList<DevicePath>();
        DevicePath parent = placeOnPath.getParent();
        for (DevicePath dp : design.getDescendantDevices()) {
            Device d = dp.getLast();
            if (!selection.contains((DbObject)d)) continue;
            if (placeOnPath.sameAs(dp.getParent()) && toBePlaced.isEmpty()) {
                parent = placeOnPath;
            } else if (!parent.sameAs(dp.getParent())) {
                return 0;
            }
            toBePlaced.add(dp);
        }
        return toBePlaced.size();
    }

    public class MyRunnable
    implements Runnable {
        @Override
        public void run() {
            ArrayList<Device> children = ConstructPlaceDlg.this.getChildren();
            ConstructPlaceDlg.this.saveConstraints(mParentPath.getDeviceTemplate());
            if (mChildren == null) {
                ConstructPlaceDlg.this.mThread = this;
                if (!ConstructPlaceDlg.this.mFc.getTextField().getText().trim().isEmpty()) {
                    try {
                        AFieldValidator.validateFileReadable((JTextField)ConstructPlaceDlg.this.mFc.getTextField());
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
                ConstructPlaceDlg.this.mBtnClose.setText("Stop");
                ConstructPlaceDlg.this.mPlaceButton.setEnabled(false);
                Cp.exec((String)"mCp = new com.sigrity.acl.optimizer.ConstructivePlacement ();", (Object[])new Object[0]);
                Cp.exec((String)"mCp.placeSelectedFromDesign(\"%s\", %s);", (Object[])new Object[]{mParentPath.toString(), Cp.getFileAsArgument((String)ConstructPlaceDlg.this.mFc.getPath())});
                ConstructPlaceDlg.this.mThread = null;
                ConstructPlaceDlg.this.mBtnClose.setText("Close");
                ConstructPlaceDlg.this.mPlaceButton.setEnabled(true);
            } else {
                ConstructPlaceDlg.this.mThread = this;
                ConstructPlaceDlg.this.mCp = new ConstructivePlacement();
                Timer timer = new Timer(50, e -> ((DesignView2D)OrbitIO.getCurView()).getCanvas().repaint());
                if (!ConstructPlaceDlg.this.mFc.getTextField().getText().trim().isEmpty()) {
                    try {
                        AFieldValidator.validateFileReadable((JTextField)ConstructPlaceDlg.this.mFc.getTextField());
                    }
                    catch (Exception ex) {
                        return;
                    }
                }
                ConstructPlaceDlg.this.mBtnClose.setText("Stop");
                ConstructPlaceDlg.this.mPlaceButton.setEnabled(false);
                ArrayList<Device> dlist = new ArrayList<Device>();
                for (Device d : children) {
                    dlist.add(d);
                }
                if (children.isEmpty()) {
                    ALog.logError((String)"No devices selected, please select the devices you want to place.");
                }
                ConstructPlaceDlg.this.mCp.placeSelectedFromNode(mParentPath.escapedString(), dlist, ConstructPlaceDlg.this.mFc.getPath());
                ConstructPlaceDlg.this.mThread = null;
                ConstructPlaceDlg.this.mBtnClose.setText("Close");
                ConstructPlaceDlg.this.mCp = null;
                ConstructPlaceDlg.this.mPlaceButton.setEnabled(true);
                timer.stop();
            }
        }
    }

    class DeviceSelectionListener
    implements Selection.SelectionListener {
        DeviceSelectionListener() {
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (ConstructPlaceDlg.this.selectionChanging) {
                return;
            }
            ConstructPlaceDlg.this.selectionChanging = true;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConstructPlaceDlg.this.updateSelectionChange();
                    ConstructPlaceDlg.this.selectionChanging = false;
                }
            });
        }
    }
}

