/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.jfxui.AJFXButton;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXFileChooserControl;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ATransformableIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class ContactDeviceFactoryUI
extends AJFXDesignDialog {
    private boolean mIsCreateOnDevPathA;
    private ContactLayer mContactLayer;

    public static ContactDeviceFactoryUI createDialog(Window owner, Db db, ContactLayer contactLayer) {
        return ContactDeviceFactoryUI.createDialog(owner, db, contactLayer, false);
    }

    public static ContactDeviceFactoryUI createDialog(Window owner, Db db, ContactLayer contactLayer, boolean isCreateOnDevPathA) {
        if (db == null) {
            return null;
        }
        ContactDeviceFactoryUI dlg = new ContactDeviceFactoryUI(owner, db, contactLayer, isCreateOnDevPathA);
        dlg.setVisible(true);
        return dlg;
    }

    private ContactDeviceFactoryUI(Window owner, Db db, ContactLayer contactLayer, boolean isCreateOnDevPathA) {
        super(db, (Component)owner, "Generate Contact Device", Dialog.ModalityType.APPLICATION_MODAL);
        this.mContactLayer = contactLayer;
        this.mIsCreateOnDevPathA = isCreateOnDevPathA;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ContactDevPanel();
    }

    private class ContactDevPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 600;
        private static final int PANEL_HEIGHT = 570;
        private ContactDevInfoBox mFromContactInfoBox;
        private ContactDevInfoBox mToContactInfoBox;
        private ContactPinPane mContactPinPane;
        private ContactDevPane mContactDevPane;
        private AdvancedOptionsPane mAdvanceOptionsPane;
        EventHandler<ActionEvent> mOkHandler = e -> SwingUtilities.invokeLater(() -> {
            try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)ContactDeviceFactoryUI.this.getDb(), (String)"Generate contact device");){
                this.cpGenerateContactDevice();
            }
            ALog.logInfo((String)"Generate contact device complete.");
            OrbitIO.refreshViewsOf(ContactDeviceFactoryUI.this.mDb);
            DbExplorerPanel.refreshAll();
            UIUtil.closeWindow((Window)((Object)ContactDeviceFactoryUI.this));
        });

        public ContactDevPanel() {
            this.setPreferredSize(new Dimension(600, 570));
        }

        protected Parent initSceneGraph() {
            BorderPane pane = new BorderPane();
            VBox mainBox = new VBox(5.0);
            this.mFromContactInfoBox = new ContactDevInfoBox("From");
            this.mToContactInfoBox = new ContactDevInfoBox("To");
            Button flipBtn = this.createSwapFromToDevBtn();
            HBox contactInfosHBox = new HBox(10.0, new Node[]{this.mFromContactInfoBox, flipBtn, this.mToContactInfoBox});
            contactInfosHBox.setAlignment(Pos.CENTER);
            contactInfosHBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            mainBox.getChildren().add((Object)contactInfosHBox);
            VBox optionsVBox = new VBox(0.0);
            this.mContactPinPane = new ContactPinPane();
            optionsVBox.getChildren().add((Object)this.mContactPinPane);
            this.mContactDevPane = new ContactDevPane();
            optionsVBox.getChildren().add((Object)this.mContactDevPane);
            this.mContactDevPane.refresh();
            this.mAdvanceOptionsPane = new AdvancedOptionsPane();
            optionsVBox.getChildren().add((Object)this.mAdvanceOptionsPane);
            mainBox.getChildren().add((Object)optionsVBox);
            pane.setTop((Node)mainBox);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)ContactDeviceFactoryUI.this), this.mOkHandler);
            pane.setBottom((Node)okCancelHBox);
            this.updateContactDevPane();
            return pane;
        }

        private Button createSwapFromToDevBtn() {
            ATransformableIcon ti = new ATransformableIcon();
            ti.setImageIcon((ImageIcon)OrbitIcons.SWAP);
            ti.setIconRot(90.0f);
            AJFXButton btn = new AJFXButton((Icon)ti, "Swap devices");
            btn.setStyle("-fx-border-color: transparent;");
            btn.setOnAction(event -> {
                ContactDeviceFactoryUI.this.mIsCreateOnDevPathA = !ContactDeviceFactoryUI.this.mIsCreateOnDevPathA;
                this.updateContactDevPane();
            });
            return btn;
        }

        private void updateContactDevPane() {
            if (ContactDeviceFactoryUI.this.mIsCreateOnDevPathA) {
                this.mFromContactInfoBox.updateDevInfo(ContactDeviceFactoryUI.this.mContactLayer.getDevicePathB(), ContactDeviceFactoryUI.this.mContactLayer.getContactLayerB());
                this.mToContactInfoBox.updateDevInfo(ContactDeviceFactoryUI.this.mContactLayer.getDevicePathA(), ContactDeviceFactoryUI.this.mContactLayer.getContactLayerA());
                this.mContactPinPane.updateCandidatePad(ContactDeviceFactoryUI.this.mContactLayer.getContactLayerA());
                this.mContactPinPane.updateDefaultPadType(ContactDeviceFactoryUI.this.mContactLayer.getSubstrateDeviceTemplateA());
            } else {
                this.mFromContactInfoBox.updateDevInfo(ContactDeviceFactoryUI.this.mContactLayer.getDevicePathA(), ContactDeviceFactoryUI.this.mContactLayer.getContactLayerA());
                this.mToContactInfoBox.updateDevInfo(ContactDeviceFactoryUI.this.mContactLayer.getDevicePathB(), ContactDeviceFactoryUI.this.mContactLayer.getContactLayerB());
                this.mContactPinPane.updateCandidatePad(ContactDeviceFactoryUI.this.mContactLayer.getContactLayerB());
                this.mContactPinPane.updateDefaultPadType(ContactDeviceFactoryUI.this.mContactLayer.getSubstrateDeviceTemplateB());
            }
            this.mContactDevPane.refresh();
        }

        private void cpGenerateContactDevice() {
            Cp.exec((String)"unset(\"_ContactDeviceFactory\");", (Object[])new Object[0]);
            Cp.exec((String)"_ContactDeviceFactory = new com.sigrity.orbit.factory.ContactDeviceFactory(curDb(), \"%s\", %b)", (Object[])new Object[]{ContactDeviceFactoryUI.this.mContactLayer.getKeyStr(), ContactDeviceFactoryUI.this.mIsCreateOnDevPathA});
            Cp.exec((String)"_ContactDeviceFactory.setContactPinPrefix(\"%s\")", (Object[])new Object[]{this.mContactPinPane.getSelectedPinPrefix()});
            if (this.mContactPinPane.isPinDev()) {
                Cp.exec((String)"_ContactDeviceFactory.setCreatePinDev(true)", (Object[])new Object[0]);
                if (this.mContactPinPane.getSelectedPinDevTKeyStr() != null) {
                    Cp.exec((String)"_ContactDeviceFactory.setContactPinDevT(\"%s\")", (Object[])new Object[]{this.mContactPinPane.getSelectedPinDevTKeyStr()});
                }
            } else if (this.mContactPinPane.getSelectedPadName() != null) {
                Cp.exec((String)"_ContactDeviceFactory.setContactPadTemplate(\"%s\")", (Object[])new Object[]{this.mContactPinPane.getSelectedPadName()});
            }
            if (this.mContactDevPane.createContactDev()) {
                Cp.exec((String)"_ContactDeviceFactory.setCreateContactDev(true)", (Object[])new Object[0]);
                if (this.mContactDevPane.hasExtents()) {
                    Cp.exec((String)"_ContactDeviceFactory.setContactDeviceScribe(%dL, %dL, %dL, %dL)", (Object[])new Object[]{this.mContactDevPane.getNorthScribe(), this.mContactDevPane.getSouthScribe(), this.mContactDevPane.getEastScribe(), this.mContactDevPane.getWestScribe()});
                }
            }
            if (this.mAdvanceOptionsPane.specifyPinNet()) {
                Cp.exec((String)"_ContactDeviceFactory.setCsvPinMap(\"%s\")", (Object[])new Object[]{this.mAdvanceOptionsPane.getCsvFilePath()});
            }
            if (this.mAdvanceOptionsPane.isOnlySelectedPins()) {
                Cp.exec((String)"_ContactDeviceFactory.setOnlySelectedPins(true)", (Object[])new Object[0]);
            }
            if (this.mAdvanceOptionsPane.isInferHierarchy()) {
                Cp.exec((String)"_ContactDeviceFactory.setInferDeviceHierarchy(true)", (Object[])new Object[0]);
            }
            if (this.mAdvanceOptionsPane.isAutoConnectNets()) {
                Cp.exec((String)"_ContactDeviceFactory.setInferNetMap(true)", (Object[])new Object[0]);
            }
            Cp.exec((String)"_ContactDeviceFactory.execute();", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_ContactDeviceFactory\");", (Object[])new Object[0]);
        }

        private class PinNetBox
        extends HBox {
            private CheckBox mPinNetCheckBox;
            private AJFXFileChooserControl mPinNetFileChooser;

            public PinNetBox() {
                super(10.0);
                this.mPinNetCheckBox = new CheckBox("Pin Net Configuration File");
                this.mPinNetCheckBox.setTooltip(new Tooltip("Specify a configuration file for customized net of pin."));
                HBox.setHgrow((Node)this.mPinNetCheckBox, (Priority)Priority.NEVER);
                this.getChildren().add((Object)this.mPinNetCheckBox);
                this.mPinNetFileChooser = new AJFXFileChooserControl((Window)((Object)ContactDeviceFactoryUI.this));
                this.mPinNetFileChooser.addChoosableFileFilter(AJFXFileChooser.CSV_FILE_FILTER);
                this.mPinNetFileChooser.setUseSaveChooser(false);
                this.mPinNetFileChooser.setDisable(true);
                HBox.setHgrow((Node)this.mPinNetFileChooser, (Priority)Priority.ALWAYS);
                this.getChildren().add((Object)this.mPinNetFileChooser);
                this.mPinNetCheckBox.setOnAction(e -> this.mPinNetFileChooser.setDisable(!this.mPinNetCheckBox.isSelected()));
                this.setAlignment(Pos.CENTER);
                ContactDevPanel.this.setMinimumSize(ContactDevPanel.this.getMinimumSize());
            }

            public boolean specifyPinNet() {
                return this.mPinNetCheckBox.isSelected();
            }

            public String getCsvFilePath() {
                return this.mPinNetFileChooser.getPath();
            }
        }

        private class AdvancedOptionsPane
        extends TitledPane {
            private PinNetBox mPinNetConfigBox;
            private CheckBox mOnlySelectedPinsCheckBox;
            private CheckBox mInferHierarchyCheckBox;
            private CheckBox mAutoConnectNetsCheckBox;

            public AdvancedOptionsPane() {
                VBox box = new VBox(10.0);
                this.mPinNetConfigBox = new PinNetBox();
                box.getChildren().add((Object)this.mPinNetConfigBox);
                this.mOnlySelectedPinsCheckBox = new CheckBox("Only Selected Pins");
                this.mOnlySelectedPinsCheckBox.setTooltip(new Tooltip("Create contact pins onlyfor the selected pins."));
                this.mOnlySelectedPinsCheckBox.setSelected(false);
                box.getChildren().add((Object)this.mOnlySelectedPinsCheckBox);
                this.mInferHierarchyCheckBox = new CheckBox("Infer Device Hierarchy");
                this.mInferHierarchyCheckBox.setTooltip(new Tooltip("Move the reference device under the contact device."));
                this.mInferHierarchyCheckBox.setSelected(false);
                box.getChildren().add((Object)this.mInferHierarchyCheckBox);
                this.mAutoConnectNetsCheckBox = new CheckBox("Auto-Connect Net");
                this.mAutoConnectNetsCheckBox.setTooltip(new Tooltip("Generate net mapping between the contact devices."));
                this.mAutoConnectNetsCheckBox.setSelected(true);
                box.getChildren().add((Object)this.mAutoConnectNetsCheckBox);
                this.setText("Advanced Options");
                this.setContent((Node)box);
                this.setExpanded(false);
            }

            public boolean specifyPinNet() {
                return this.mPinNetConfigBox.specifyPinNet();
            }

            public String getCsvFilePath() {
                return this.mPinNetConfigBox.getCsvFilePath();
            }

            public boolean isOnlySelectedPins() {
                return this.mOnlySelectedPinsCheckBox.isSelected();
            }

            public boolean isInferHierarchy() {
                return this.mInferHierarchyCheckBox.isSelected();
            }

            public boolean isAutoConnectNets() {
                return this.mAutoConnectNetsCheckBox.isSelected();
            }
        }

        private class ContactDevPane
        extends TitledPane {
            private CheckBox mCreateContactDevCheckBox;
            private CheckBox mExtentsCheckBox;
            private TextField mNorthTxtFld;
            private TextField mSouthTxtFld;
            private TextField mEastTxtFld;
            private TextField mWestTxtFld;

            public ContactDevPane() {
                VBox vBox = new VBox(5.0);
                this.mCreateContactDevCheckBox = new CheckBox("Create contact device");
                vBox.getChildren().add((Object)this.mCreateContactDevCheckBox);
                this.mExtentsCheckBox = new CheckBox("Extents");
                this.mExtentsCheckBox.setPadding(new Insets(0.0, 0.0, 0.0, 20.0));
                this.mExtentsCheckBox.setDisable(true);
                vBox.getChildren().add((Object)this.mExtentsCheckBox);
                GridPane extentsPane = new GridPane();
                extentsPane.setPadding(new Insets(0.0, 0.0, 0.0, 40.0));
                extentsPane.setVgap(5.0);
                extentsPane.setHgap(10.0);
                this.mNorthTxtFld = new TextField();
                extentsPane.add((Node)new Label("North scribe"), 0, 0);
                extentsPane.add((Node)this.mNorthTxtFld, 1, 0);
                this.mSouthTxtFld = new TextField();
                extentsPane.add((Node)new Label("South scribe"), 2, 0);
                extentsPane.add((Node)this.mSouthTxtFld, 3, 0);
                this.mEastTxtFld = new TextField();
                extentsPane.add((Node)new Label("East scribe"), 0, 1);
                extentsPane.add((Node)this.mEastTxtFld, 1, 1);
                this.mWestTxtFld = new TextField();
                extentsPane.add((Node)new Label("West scribe"), 2, 1);
                extentsPane.add((Node)this.mWestTxtFld, 3, 1);
                extentsPane.setDisable(true);
                GridPane.setHgrow((Node)this.mNorthTxtFld, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)this.mSouthTxtFld, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)this.mEastTxtFld, (Priority)Priority.ALWAYS);
                GridPane.setHgrow((Node)this.mWestTxtFld, (Priority)Priority.ALWAYS);
                this.mCreateContactDevCheckBox.setOnAction(e -> {
                    this.mExtentsCheckBox.setDisable(!this.mCreateContactDevCheckBox.isSelected());
                    extentsPane.setDisable(!this.mCreateContactDevCheckBox.isSelected() || !this.mExtentsCheckBox.isSelected());
                });
                this.mExtentsCheckBox.setOnAction(e -> extentsPane.setDisable(!this.mCreateContactDevCheckBox.isSelected() || !this.mExtentsCheckBox.isSelected()));
                vBox.getChildren().add((Object)extentsPane);
                this.setText("Contact Device");
                this.setContent((Node)vBox);
            }

            public void refresh() {
                boolean hasAbstractContactDev = this.hasAbstractContactDev();
                String txt = hasAbstractContactDev ? "Contact Device Exist" : "Contact Device";
                this.setText(txt);
                this.setDisable(hasAbstractContactDev);
                this.setExpanded(!hasAbstractContactDev);
            }

            public boolean createContactDev() {
                return this.mCreateContactDevCheckBox.isSelected();
            }

            public boolean hasExtents() {
                return this.mExtentsCheckBox.isSelected();
            }

            public long getNorthScribe() {
                Long value = Long.parseLong(this.mNorthTxtFld.getText());
                return value == null ? 0L : value;
            }

            public long getSouthScribe() {
                Long value = Long.parseLong(this.mSouthTxtFld.getText());
                return value == null ? 0L : value;
            }

            public long getEastScribe() {
                Long value = Long.parseLong(this.mEastTxtFld.getText());
                return value == null ? 0L : value;
            }

            public long getWestScribe() {
                Long value = Long.parseLong(this.mWestTxtFld.getText());
                return value == null ? 0L : value;
            }

            private boolean hasAbstractContactDev() {
                if (ContactDeviceFactoryUI.this.mIsCreateOnDevPathA) {
                    return ContactDeviceFactoryUI.this.mContactLayer.getDeviceTemplateA().getIsAbstractContactDevice();
                }
                return ContactDeviceFactoryUI.this.mContactLayer.getDeviceTemplateB().getIsAbstractContactDevice();
            }
        }

        private class ContactPinPane
        extends TitledPane {
            private RadioButton mPadStackRBtn;
            private RadioButton mDevRBtn;
            private TextField mPinPrefixTxtFld;
            private ComboBox<PadTemplate> mPadTComboBox;
            private ComboBox<DeviceTemplate> mPinDevTComboBox;

            public ContactPinPane() {
                GridPane grid = new GridPane();
                grid.setHgap(10.0);
                grid.setVgap(10.0);
                ToggleGroup group = new ToggleGroup();
                this.mPadStackRBtn = new RadioButton("Padstack");
                this.mPadStackRBtn.setToggleGroup(group);
                this.mPadStackRBtn.setSelected(true);
                GridPane.setHgrow((Node)this.mPadStackRBtn, (Priority)Priority.NEVER);
                grid.add((Node)this.mPadStackRBtn, 0, 0);
                this.mDevRBtn = new RadioButton("Device");
                this.mDevRBtn.setToggleGroup(group);
                GridPane.setHgrow((Node)this.mDevRBtn, (Priority)Priority.NEVER);
                grid.add((Node)this.mDevRBtn, 0, 1);
                this.mPadTComboBox = this.createPadTComboBox();
                GridPane.setHgrow(this.mPadTComboBox, (Priority)Priority.ALWAYS);
                grid.add(this.mPadTComboBox, 1, 0);
                this.mPinDevTComboBox = this.createPinDevTComboBox();
                GridPane.setHgrow(this.mPinDevTComboBox, (Priority)Priority.ALWAYS);
                grid.add(this.mPinDevTComboBox, 1, 1);
                this.mPadStackRBtn.setOnAction(e -> {
                    this.mPadTComboBox.setDisable(!this.mPadStackRBtn.isSelected());
                    this.mPinDevTComboBox.setDisable(this.mPadStackRBtn.isSelected());
                });
                this.mDevRBtn.setOnAction(e -> {
                    this.mPadTComboBox.setDisable(this.mDevRBtn.isSelected());
                    this.mPinDevTComboBox.setDisable(!this.mDevRBtn.isSelected());
                });
                grid.add((Node)new Label("Prefix name"), 0, 2);
                this.mPinPrefixTxtFld = new TextField();
                this.mPinPrefixTxtFld.setTooltip(new Tooltip("Prefix name for each pin/device"));
                grid.add((Node)this.mPinPrefixTxtFld, 1, 2);
                this.setText("Contact Pin");
                this.setContent((Node)grid);
            }

            public boolean isPinDev() {
                return this.mDevRBtn.isSelected();
            }

            public String getSelectedPinDevTKeyStr() {
                DeviceTemplate selectedPadT = (DeviceTemplate)this.mPinDevTComboBox.getSelectionModel().getSelectedItem();
                return selectedPadT == null ? null : selectedPadT.getKeyStr();
            }

            public String getSelectedPinPrefix() {
                return this.mPinPrefixTxtFld.getText().trim();
            }

            public String getSelectedPadName() {
                PadTemplate selectedPadT = (PadTemplate)this.mPadTComboBox.getSelectionModel().getSelectedItem();
                return selectedPadT == null ? null : selectedPadT.getName();
            }

            public void updateCandidatePad(Layer padLayer) {
                this.updateCandidatePadT(padLayer);
                this.updateCandidatePinDevT(padLayer);
            }

            private void updateCandidatePadT(Layer padLayer) {
                this.mPadTComboBox.getItems().clear();
                List<PadTemplate> candidatePadT = this.getCandiatePadT(padLayer);
                this.mPadTComboBox.getItems().add(null);
                this.mPadTComboBox.getItems().addAll(candidatePadT);
            }

            private void updateCandidatePinDevT(Layer padLayer) {
                this.mPinDevTComboBox.getItems().clear();
                List<DeviceTemplate> candidatePadT = this.getCandidatePinDevT(padLayer);
                this.mPinDevTComboBox.getItems().add(null);
                this.mPinDevTComboBox.getItems().addAll(candidatePadT);
            }

            public void updateDefaultPadType(DeviceTemplate devT) {
                boolean isDie = devT.isDie();
                this.mPadStackRBtn.setSelected(!isDie);
                this.mPadTComboBox.setDisable(isDie);
                this.mDevRBtn.setSelected(isDie);
                this.mPinDevTComboBox.setDisable(!isDie);
            }

            private ComboBox<PadTemplate> createPadTComboBox() {
                ComboBox padTComboBox = new ComboBox();
                List<PadTemplate> candidatePadT = this.getCandiatePadT(ContactDeviceFactoryUI.this.mContactLayer.getContactLayerB());
                padTComboBox.getItems().add(null);
                padTComboBox.getItems().addAll(candidatePadT);
                StringConverter<PadTemplate> converter = new StringConverter<PadTemplate>(){

                    public String toString(PadTemplate padT) {
                        return padT == null ? "Match Contact Pad" : padT.getName();
                    }

                    public PadTemplate fromString(String string) {
                        return null;
                    }
                };
                padTComboBox.setConverter((StringConverter)converter);
                padTComboBox.getSelectionModel().select(0);
                padTComboBox.setMaxWidth(Double.MAX_VALUE);
                return padTComboBox;
            }

            private List<PadTemplate> getCandiatePadT(Layer padLayer) {
                return ContactDeviceFactoryUI.this.mDb.getObjects(PadTemplate.class).stream().filter(padT -> padT.getLayerShapes(padLayer).hasNext()).collect(Collectors.toList());
            }

            private ComboBox<DeviceTemplate> createPinDevTComboBox() {
                ComboBox pinDevTComboBox = new ComboBox();
                List<DeviceTemplate> candidatePadT = this.getCandidatePinDevT(ContactDeviceFactoryUI.this.mContactLayer.getContactLayerB());
                pinDevTComboBox.getItems().add(null);
                pinDevTComboBox.getItems().addAll(candidatePadT);
                StringConverter<DeviceTemplate> converter = new StringConverter<DeviceTemplate>(){

                    public String toString(DeviceTemplate padT) {
                        return padT == null ? "Match Contact Pad" : padT.getName();
                    }

                    public DeviceTemplate fromString(String string) {
                        return null;
                    }
                };
                pinDevTComboBox.setConverter((StringConverter)converter);
                pinDevTComboBox.getSelectionModel().select(0);
                pinDevTComboBox.setMaxWidth(Double.MAX_VALUE);
                return pinDevTComboBox;
            }

            private List<DeviceTemplate> getCandidatePinDevT(Layer padLayer) {
                return padLayer.getSubstrate().getDeviceTemplates().stream().filter(pinDevT -> pinDevT.amIAPin() && pinDevT.hasSinglePin() && pinDevT.getPin1().hasShapesOnLayer(padLayer)).collect(Collectors.toList());
            }
        }

        private class ContactDevInfoBox
        extends VBox {
            private GridPane mGridPane;
            private Label mDevLabel;
            private Label mLayerLabel;

            protected ContactDevInfoBox(String title) {
                super(5.0);
                this.mDevLabel = new Label("Device: ");
                this.mLayerLabel = new Label("Layer: ");
                Label titleLabel = new Label(title);
                this.getChildren().add((Object)titleLabel);
                this.getChildren().add((Object)new Separator());
                this.setMinWidth(250.0);
            }

            protected void updateDevInfo(DevicePath devPath, Layer layer) {
                assert (devPath != null && layer != null);
                if (this.mGridPane != null) {
                    this.getChildren().remove((Object)this.mGridPane);
                }
                this.loadDevInfoPane(devPath, layer);
            }

            private void loadDevInfoPane(DevicePath devPath, Layer layer) {
                assert (devPath != null && layer != null);
                this.mGridPane = new GridPane();
                this.mGridPane.setHgap(10.0);
                Label devPathLabel = new Label(this.getFullPathsString(devPath));
                ImageView devImageView = this.getDevImageView(devPath);
                Label contactlayerLabel = new Label(layer.getName());
                ImageView layerImageView = this.getLayerImageView(devPath, layer);
                this.mGridPane.add((Node)this.mDevLabel, 0, 0);
                this.mGridPane.add((Node)devImageView, 1, 0);
                this.mGridPane.add((Node)devPathLabel, 2, 0);
                this.mGridPane.add((Node)this.mLayerLabel, 0, 1);
                this.mGridPane.add((Node)layerImageView, 1, 1);
                this.mGridPane.add((Node)contactlayerLabel, 2, 1);
                this.getChildren().add((Object)this.mGridPane);
            }

            private ImageView getDevImageView(DevicePath devPath) {
                assert (devPath != null);
                Image devImage = JFXUtil.getFxImage((Icon)DbExplorerPanel.getIconForTemplate(devPath.getDeviceTemplate()));
                return new ImageView(devImage);
            }

            private ImageView getLayerImageView(DevicePath devPath, Layer layer) {
                assert (devPath != null && layer != null);
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                APatternColor color = colorizer.getColor(devPath, layer, true);
                Image layerImage = JFXUtil.getFxImage((Icon)new AColorIcon(12, 12, color.getColor()));
                return new ImageView(layerImage);
            }

            private String getFullPathsString(DevicePath devPath) {
                assert (devPath != null);
                return devPath.getAllFullPaths().mapAndNonNull(DevicePath::toString).reduce((pathStr1, pathStr2) -> String.format("%s%n%s", pathStr1, pathStr2)).orElse(devPath.escapedString());
            }
        }
    }
}

