/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.dbui.render.LayerListRenderer;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.EditContactLayerUI;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ContactToParentUI
extends DbDialog {
    DeviceInfoPanel mDeviceInfoPanel;
    EditContactLayerUI.DevPathAndLayerPanel mContactDeviceInfoPanel;
    protected ActionListener addHandler = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String devicePathBStr;
            if (ContactToParentUI.this.mContactDeviceInfoPanel.getDevicePath() == null || ContactToParentUI.this.mContactDeviceInfoPanel.getLayer() == null) {
                return;
            }
            String devicePathAStr = ContactToParentUI.this.mDeviceInfoPanel.getDevicePathStr();
            if (devicePathAStr.equals(devicePathBStr = ContactToParentUI.this.mContactDeviceInfoPanel.getDevicePath().toString())) {
                ALog.logError((String)"Cannot set a contact layer with the same devicePath. Need to Choose two different devicePaths.");
                return;
            }
            String layerAName = ContactToParentUI.this.mDeviceInfoPanel.getLayerName();
            String layerBName = ContactToParentUI.this.mContactDeviceInfoPanel.getLayer().getName();
            Cp.exec((String)"_contactLayer = com.sigrity.acl.db.std.ContactLayer.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{devicePathAStr, layerAName, devicePathBStr, layerBName});
            Cp.exec((String)"if ( _contactLayer != null) com.sigrity.orbit.automation.pinMap.PinMapGenerator.createPinMapFromPhysicalContact(curDb(), _contactLayer)", (Object[])new Object[0]);
            if (ContactToParentUI.this.mContactDeviceInfoPanel.isAbstract()) {
                this.setDevTAbstract(ContactToParentUI.this.mContactDeviceInfoPanel.getDevicePath().getDeviceTemplate());
            }
            this.checkFlipped();
            UIUtil.closeWindow((Window)((Object)ContactToParentUI.this));
            if (!ContactToParentUI.this.mContactDeviceInfoPanel.isAbstract()) {
                this.checkContactPins();
            }
        }

        private void checkFlipped() {
        }

        private void checkContactPins() {
            ContactLayer contactLayer = this.getContactLayer();
            assert (contactLayer != null);
            EditContactLayerUI.ContactDeviceWarning.check((Window)((Object)ContactToParentUI.this), ContactToParentUI.this.mDb, contactLayer);
        }

        private ContactLayer getContactLayer() {
            return ContactLayer.get((DevicePath)ContactToParentUI.this.mDeviceInfoPanel.getDevicePath(), (Layer)ContactToParentUI.this.mDeviceInfoPanel.getLayer(), (DevicePath)ContactToParentUI.this.mContactDeviceInfoPanel.getDevicePath(), (Layer)ContactToParentUI.this.mContactDeviceInfoPanel.getLayer());
        }

        private void setDevTAbstract(DeviceTemplate devT) {
            Cp.exec((String)"if ( _contactLayer != null) curDb().getByKeyStr(DeviceTemplate.class, \"%s\").setIsAbstractContactDevice(true)", (Object[])new Object[]{devT.getKeyStr()});
        }
    };

    public static void showUI(String devPathStr) {
        ContactToParentUI.showUI(DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devPathStr));
    }

    public static void showUI(DevicePath devPath) {
        ContactToParentUI ui = new ContactToParentUI(devPath.getDb(), OrbitIO.getMainWindow(), devPath);
        ui.setVisible(true);
    }

    protected ContactToParentUI(Db db, Window owner, DevicePath devPath) {
        super(db, (Component)owner, "Set Contact Layer", Dialog.ModalityType.DOCUMENT_MODAL);
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.mDeviceInfoPanel = new DeviceInfoPanel(devPath);
        l.add((Component)this.mDeviceInfoPanel, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mContactDeviceInfoPanel = new EditContactLayerUI.DevPathAndLayerPanel(db, "Contact Device");
        l.add((Component)this.mContactDeviceInfoPanel, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("Ok"));
        btnOk.addActionListener(this.addHandler);
        l.pop();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), null, (JButton)btnOk);
        this.pack();
        this.setDefaultContactToParent(devPath);
        this.setMinimumSize(this.getMinimumSize());
        UIUtil.center((Component)((Object)this));
    }

    private void setDefaultContactToParent(DevicePath devPath) {
        DevicePath parent = devPath.getParent();
        this.mContactDeviceInfoPanel.setSelectedPath(parent);
        Layer defaultContactLayer = parent.getDevice().getFlipped() ? parent.getSubstrate().getBottomLayer() : parent.getSubstrate().getTopLayer();
        this.mContactDeviceInfoPanel.setSelectedLayer(defaultContactLayer);
    }

    private class DeviceInfoPanel
    extends JPanel {
        private DevicePath devPath;
        private JComboBox<Layer> layerComboBox;

        public DeviceInfoPanel(DevicePath devPath) {
            this.devPath = devPath;
            GridBagManager l = new GridBagManager((Container)this);
            l.add("Device: ", (GridBagConstraints)GridBagManager.LEFT.insets(10));
            JLabel devLabel = new JLabel(devPath.getAFullPath().toString());
            devLabel.setIcon(DbExplorerPanel.getIconForTemplate(devPath.getDeviceTemplate()));
            l.add((Component)devLabel, (GridBagConstraints)GridBagManager.LEFT);
            l.newline();
            l.add("Layer:", (GridBagConstraints)GridBagManager.LEFT.insets(10));
            this.layerComboBox = new JComboBox();
            this.layerComboBox.setRenderer(new LayerListRenderer());
            this.loadLayers();
            this.setDefaultLayer();
            l.add(this.layerComboBox, (GridBagConstraints)GridBagManager.FILLX);
            l.addFillX();
            this.setMinimumSize(this.getPreferredSize());
        }

        public DevicePath getDevicePath() {
            return this.devPath;
        }

        public String getDevicePathStr() {
            return this.getDevicePath().toString();
        }

        private Layer getLayer() {
            return (Layer)this.layerComboBox.getSelectedItem();
        }

        public String getLayerName() {
            return this.getLayer().getName();
        }

        private void loadLayers() {
            this.devPath.getSubstrate().getLayers().stream().sorted(Collections.reverseOrder()).forEach(layer -> this.layerComboBox.addItem((Layer)layer));
        }

        private void setDefaultLayer() {
            if (this.devPath.getDevice().getFlipped()) {
                this.layerComboBox.setSelectedItem(this.devPath.getSubstrate().getTopLayer());
            } else {
                this.layerComboBox.setSelectedItem(this.devPath.getSubstrate().getBottomLayer());
            }
        }
    }
}

