/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.APatternColor;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CopyPinsAcrossSubstratesDlg
extends DbDialog {
    SubstrateIntanceTree mFromTree;
    SubstrateIntanceTree mToTree;
    Design mDesign;
    JCheckBox justSelected;
    JCheckBox removePrevious;
    JButton btnApply;
    JButton btnClose;
    JLabel messageLabel;
    DevicePath selectedFromDevicePath = null;
    DevicePath selectedToDevicePath = null;
    Layer selectedFromLayer = null;
    Layer selectedToLayer = null;
    protected ActionListener mApply = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Cp.exec((String)"com.sigrity.orbit.factory.PinToDevice _ptd = new com.sigrity.orbit.factory.PinToDevice();_ptd.setJustSelected (%b);", (Object[])new Object[]{CopyPinsAcrossSubstratesDlg.this.justSelected.isSelected()});
            Cp.exec((String)"_ptd.setRemovePreviouslyCreated (%b);", (Object[])new Object[]{CopyPinsAcrossSubstratesDlg.this.removePrevious.isSelected()});
            Cp.exec((String)"_ptd.makePadsOnSubstrate (\"%s\",\"%s\",\"%s\",\"%s\");", (Object[])new Object[]{CopyPinsAcrossSubstratesDlg.this.selectedToDevicePath.toString(), CopyPinsAcrossSubstratesDlg.this.selectedFromDevicePath.toString(), CopyPinsAcrossSubstratesDlg.this.selectedToLayer.getName(), CopyPinsAcrossSubstratesDlg.this.selectedFromLayer.getName()});
        }
    };

    public static void create() {
        new CopyPinsAcrossSubstratesDlg(OrbitIO.getCurDb(), OrbitIO.getMainWindow());
    }

    public CopyPinsAcrossSubstratesDlg(Db db, Component owner) {
        super(db, owner);
        this.setTitle("Copy Pins Across Substrates");
        this.setDefaultCloseOperation(2);
        GridBagManager gb = new GridBagManager((Container)((Object)this));
        gb.pushFill();
        this.mDesign = Design.getDesign((Db)this.mDb);
        this.mFromTree = new SubstrateIntanceTree(this.mDesign);
        this.mToTree = new SubstrateIntanceTree(this.mDesign);
        this.mFromTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                if (evt.getNewLeadSelectionPath() == null) {
                    return;
                }
                SubstrateIntanceTree.AbstractNode mNode = (SubstrateIntanceTree.AbstractNode)((Object)evt.getNewLeadSelectionPath().getLastPathComponent());
                if (mNode instanceof SubstrateIntanceTree.LayerNode) {
                    CopyPinsAcrossSubstratesDlg.this.selectedFromLayer = ((SubstrateIntanceTree.LayerNode)mNode).layer;
                    CopyPinsAcrossSubstratesDlg.this.selectedFromDevicePath = ((SubstrateIntanceTree.LayerNode)mNode).path;
                } else {
                    CopyPinsAcrossSubstratesDlg.this.selectedFromLayer = null;
                }
                CopyPinsAcrossSubstratesDlg.this.updateStatus();
            }
        });
        this.mToTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                if (evt.getNewLeadSelectionPath() == null) {
                    return;
                }
                SubstrateIntanceTree.AbstractNode mNode = (SubstrateIntanceTree.AbstractNode)((Object)evt.getNewLeadSelectionPath().getLastPathComponent());
                if (mNode instanceof SubstrateIntanceTree.LayerNode) {
                    CopyPinsAcrossSubstratesDlg.this.selectedToLayer = ((SubstrateIntanceTree.LayerNode)mNode).layer;
                    CopyPinsAcrossSubstratesDlg.this.selectedToDevicePath = ((SubstrateIntanceTree.LayerNode)mNode).path;
                } else {
                    CopyPinsAcrossSubstratesDlg.this.selectedToLayer = null;
                }
                CopyPinsAcrossSubstratesDlg.this.updateStatus();
            }
        });
        JScrollPane scrollDeviceTreeFrom = new JScrollPane(this.mFromTree);
        JScrollPane scrollDeviceTreeTo = new JScrollPane(this.mToTree);
        scrollDeviceTreeFrom.setBorder(BorderFactory.createTitledBorder("From Layer"));
        gb.add((Component)scrollDeviceTreeFrom, (GridBagConstraints)GridBagManager.FILLALL);
        scrollDeviceTreeTo.setBorder(BorderFactory.createTitledBorder("To Layer"));
        gb.add((Component)scrollDeviceTreeTo, (GridBagConstraints)GridBagManager.FILLALL);
        gb.newline();
        gb.pop();
        gb.newline();
        gb.push("Options", (GridBagConstraints)GridBagManager.LEFT);
        this.justSelected = new JCheckBox("Just Selected");
        gb.add((Component)this.justSelected, (GridBagConstraints)GridBagManager.LEFT);
        this.removePrevious = new JCheckBox("Remove Previously Created");
        gb.add((Component)this.removePrevious, (GridBagConstraints)GridBagManager.LEFT);
        gb.pop();
        gb.newline();
        JPanel btnPanel = new JPanel();
        gb.push((Container)btnPanel, (GridBagConstraints)GridBagManager.RIGHT);
        this.messageLabel = new JLabel("");
        gb.add((Component)this.messageLabel, (GridBagConstraints)GridBagManager.LEFT);
        Font btnFont = this.messageLabel.getFont();
        this.messageLabel.setFont(btnFont.deriveFont((float)btnFont.getSize() - 4.0f));
        this.btnApply = new JButton("Apply");
        gb.add((Component)this.btnApply, (GridBagConstraints)GridBagManager.RIGHT);
        this.btnApply.addActionListener(this.mApply);
        JButton btnClose = new JButton("Close");
        gb.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
        gb.pop();
        this.updateStatus();
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.btnApply);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    protected void updateStatus() {
        boolean ok = true;
        if (this.selectedFromLayer == null) {
            ok = false;
            this.messageLabel.setText("Choose a layer on the from side");
        }
        if (this.selectedToLayer == null) {
            ok = false;
            this.messageLabel.setText("Choose a layer on the to side");
        }
        if (ok) {
            this.messageLabel.setText(this.selectedFromLayer.getName() + "->" + this.selectedToLayer.getName());
        }
        if (ok) {
            this.messageLabel.setForeground(Color.green);
        } else {
            this.messageLabel.setForeground(Color.red);
        }
        this.btnApply.setEnabled(ok);
    }

    protected static class SubstrateIntanceTree
    extends JTree {
        protected PopupMenuHandler mPopupMenuHandler = null;
        protected MouseListener mMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu(e);
                }
            }
        };

        public SubstrateIntanceTree(Design d) {
            super((TreeModel)((Object)new Model(d)));
            this.init();
            UIUtil.expandTreeAll((JTree)this);
        }

        protected void init() {
            this.setCellRenderer((TreeCellRenderer)((Object)new CellRenderer()));
            this.setShowsRootHandles(true);
            this.getSelectionModel().setSelectionMode(1);
            this.addMouseListener(this.mMouseListener);
        }

        public Model getModel() {
            return (Model)((Object)super.getModel());
        }

        public TreePath getTreePath(DevicePath path) {
            if (path.getRoot() != this.getModel().getRoot().getRoot()) {
                return null;
            }
            TreePath tp = new TreePath((Object)this.getModel().getRoot());
            for (Device d : path) {
                AbstractNode n = (AbstractNode)((Object)tp.getLastPathComponent());
                DeviceNode childNode = n.getChild(d);
                if (childNode == null) {
                    return null;
                }
                tp = tp.pathByAddingChild((Object)childNode);
            }
            return tp;
        }

        public Model getDeviceTreeModel() {
            return this.getModel();
        }

        public void setSelectedDevicePath(DevicePath path) {
            TreePath tp = this.getTreePath(path);
            this.setSelectionPath(tp);
        }

        public DevicePath getSelectedDevicePath() {
            TreePath tp = this.getSelectionPath();
            if (tp == null) {
                return null;
            }
            DevicePath res = new DevicePath(((RootNode)((Object)tp.getPathComponent((int)0))).mRoot);
            for (int i = 1; i < tp.getPathCount(); ++i) {
                Object o = tp.getPathComponent(i);
                if (!(o instanceof DeviceNode)) continue;
                res.add(((DeviceNode)((Object)o)).mDevice);
            }
            return res;
        }

        public Layer getSelectedLayer() {
            TreePath tp = this.getSelectionPath();
            if (tp == null) {
                return null;
            }
            for (int i = 1; i < tp.getPathCount(); ++i) {
                Object o = tp.getPathComponent(i);
                if (!(o instanceof LayerNode)) continue;
                return ((LayerNode)((Object)o)).getLayer();
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d;
            RootNode root = this.getModel().getRoot();
            int multiplier = 1;
            if (root instanceof RootNode && root.mPath == null) {
                multiplier = 2;
            }
            if ((d = super.getPreferredSize()) != null) {
                d = new Dimension(d.width * multiplier, d.height);
            }
            return d;
        }

        public void setPopupMenuHandler(PopupMenuHandler h) {
            this.mPopupMenuHandler = h;
        }

        protected void popupMenu(MouseEvent e) {
            int row = this.getRowForLocation(e.getX(), e.getY());
            this.setSelectionRow(row);
            if (this.mPopupMenuHandler != null) {
                this.mPopupMenuHandler.handlePopup(e.getX(), e.getY());
            }
        }

        public static class CellRenderer
        extends ATreeCellRenderer {
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                AbstractNode node = (AbstractNode)((Object)value);
                this.setText(node.getText());
                this.setIcon(node.getIcon());
                this.setToolTipText(node.getToolTipText());
                return this;
            }
        }

        public static class LayerNode
        extends AbstractNode {
            protected Layer layer;
            protected DevicePath path;

            public LayerNode(AbstractNode parent, Layer layer, DevicePath path) {
                super((ATreeNode)parent);
                this.layer = layer;
                this.path = path;
            }

            public Layer getLayer() {
                return this.layer;
            }

            public Icon getIcon() {
                Layer l = this.getLayer();
                ViewColorizer colorizer = OrbitIO.getCurColorizer();
                APatternColor color = colorizer.getColor(this.path, l);
                if (color != null) {
                    return new AColorIcon(16, 16, color.getColor());
                }
                return new AColorIcon(16, 16, Color.white);
            }

            public String getText() {
                return this.getLayer().getName();
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                return new ArrayList();
            }

            @Override
            public String getToolTipText() {
                return null;
            }
        }

        public static class DeviceNode
        extends AbstractNode {
            Device mDevice;
            DevicePath mPath = null;

            public DeviceNode(AbstractNode parent, DevicePath path) {
                super((ATreeNode)parent);
                this.mDevice = path.getLast();
                this.mPath = path;
            }

            public Device getDevice() {
                return this.mDevice;
            }

            public Icon getIcon() {
                return DbExplorerPanel.getIconForDevice(this.getDevice());
            }

            public String getText() {
                return this.getDevice().getName();
            }

            @Override
            public String getToolTipText() {
                return String.format("%s (%s)", this.getDevice().getName(), this.getDevice().getTemplate().getName());
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<AbstractNode> children = new ArrayList<AbstractNode>();
                if (this.mDevice.getIsSubstrate()) {
                    Substrate s = this.mDevice.getSubstrate();
                    for (Layer l : s.getLayers(Layer.OrderComparator)) {
                        children.add(0, new LayerNode(this, l, this.mPath));
                    }
                    for (Device d : this.mDevice.getChildren()) {
                        if (!d.getIsSubstrate()) continue;
                        DevicePath dp = this.mPath.withChild(d);
                        children.add(new DeviceNode(this, dp));
                    }
                }
                return children;
            }
        }

        public static class RootNode
        extends AbstractNode {
            protected DeviceTemplate mRoot;
            protected DevicePath mPath = null;

            public RootNode(Model model, DeviceTemplate root) {
                super(model);
                this.mRoot = root;
            }

            public RootNode(Model model, DevicePath path) {
                super(model);
                this.mRoot = path.getRoot();
                this.mPath = path;
            }

            public DeviceTemplate getRoot() {
                return this.mRoot;
            }

            public Icon getIcon() {
                return DbExplorerPanel.getIconForTemplate(this.mRoot);
            }

            public String getText() {
                return this.mRoot.getName();
            }

            @Override
            public String getToolTipText() {
                if (this.mRoot instanceof Design) {
                    return this.mRoot.getDb().getDescription(true);
                }
                return String.format("DeviceTemplate: %s", this.mRoot.getName());
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<DeviceNode> children = new ArrayList<DeviceNode>();
                for (Device d : this.mRoot.getChildren()) {
                    DevicePath dp = new DevicePath(d);
                    children.add(new DeviceNode(this, dp));
                }
                return children;
            }
        }

        public static abstract class AbstractNode
        extends ALazyTreeNode {
            public AbstractNode(ATreeModel model) {
                super(model);
                this.setSortChildren(false);
            }

            public AbstractNode(ATreeNode parent) {
                super(parent);
                this.setSortChildren(false);
            }

            public abstract String getToolTipText();

            public boolean isLeaf() {
                return this.getChildCount() == 0;
            }

            public DeviceNode getChild(Device d) {
                this.populateChildrenAsNeeded();
                for (ATreeNode n : this.mChildren) {
                    if (!(n instanceof DeviceNode) || ((DeviceNode)n).getDevice() != d) continue;
                    return (DeviceNode)n;
                }
                return null;
            }
        }

        public static class Model
        extends ATreeModel {
            public Model(Design d) {
                this.setRoot((TreeNode)((Object)new RootNode(this, (DeviceTemplate)d)));
            }

            public Model(DevicePath path) {
                this.setRoot((TreeNode)((Object)new RootNode(this, path)));
            }

            public RootNode getRoot() {
                return (RootNode)((Object)super.getRoot());
            }
        }

        public static interface PopupMenuHandler {
            public void handlePopup(int var1, int var2);
        }
    }
}

