/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.BumpFanout;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import com.sigrity.orbit.ui.wb_route.PinDeviceComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CreateFanoutBumpsUI
extends DbDialog {
    protected final Unit mUnit;
    protected final APoint2D mRefWorldLoc;
    protected JCheckBox mIncludeAllInstances;
    protected JCheckBox mIncludeUnassignedPins;
    protected JCheckBox mAutoGenNetForUnassigned;
    protected JComboBox<Layer> mCboStartLayer;
    protected JComboBox<String> mCboShapeSizeFilterOp;
    protected JTextField mTxtMinShapeHeightFilter;
    protected JTextField mTxtShapeWidthFilter;
    protected JTextField mTxtBumpBumpPitch;
    protected JTextField mTxtTermPrefix;
    protected JComboBox<BumpFanout.BumpType> mCboBumpType;
    protected JComboBox<BumpFanout.BumpAlignment> mCboBumpAlign;
    protected JLabel mLbBumpTemplate;
    protected PadTemplateComboBox mCboViaPadstack;
    protected PinDeviceComboBox mCboPinDevice;
    protected JTextField mTxtRotation;
    protected JCheckBox mCbMirror;
    protected JTextField mTxtNamePrefix;
    protected AFileChooserControl mTermListCSV;
    protected JRadioButton mRadioTermNone;
    protected JRadioButton mRadioTermPrefix;
    protected JRadioButton mRadioTermList;
    protected Selection mSelection;
    protected Substrate mSubstrate;
    protected DevicePath mDevicePath;
    protected PinSelectionListener mSelectionListener;
    protected boolean mUpdatePending = false;
    protected boolean mUpdatePadstacksPending = false;
    private ActionListener mIncUnassignedListener = ae -> this.controlOption();
    protected ActionListener mApplyListener = ae -> {
        try {
            this.apply();
        }
        catch (AFieldValidator.AFieldValidationException aFieldValidationException) {
            // empty catch block
        }
    };
    protected ActionListener mCreatePadstackListener = ae -> PadStackDlg.createDialog(OrbitIO.getMainWindow(), this.mDevicePath);
    protected ActionListener mBumpLayerListener = ae -> this.updateBumpList();
    protected ActionListener mBumpTypeListener = ae -> this.controlBumpList();
    protected DbClass.DbObjectListener mDbObjectsListener = new DbClass.DbObjectAdapter(){

        public void removedObject(DbClass.ObjectRemove e) {
            CreateFanoutBumpsUI.this.updateBumpList();
        }

        public boolean removingObject(DbClass.ObjectRemove e) {
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
        }

        public void addedObject(DbClass.ObjectAdd e) {
            CreateFanoutBumpsUI.this.updateBumpList();
        }
    };

    public CreateFanoutBumpsUI(Component uiOwner, Db db, Selection selection, APoint2D refWorldLoc) {
        super(db, uiOwner);
        this.mDb = db;
        this.mUnit = Design.getUnit((Db)db);
        this.mRefWorldLoc = refWorldLoc;
        this.mSelectionListener = new PinSelectionListener();
        this.mSelection = selection;
        if (this.mSelection != null) {
            this.mSelection.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
            this.updateTitle();
            this.updateGrid();
            this.updateDbEvent();
            Layer layer = this.findDefaultStartLayer(this.mSelection, this.mSubstrate);
            this.mCboStartLayer.setSelectedItem(layer);
            this.mSubstrate = this.mDevicePath.getSubstrate();
            if (this.mSubstrate != null) {
                this.updateLayerList(this.mCboStartLayer, true, null);
            }
        } else {
            ALog.logWarn((String)"No Pin is selected.");
        }
    }

    private void updateTitle() {
        this.setTitle("Create Bumps For All Layer Shapes");
    }

    private void updateGrid() {
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.pushFillX("Option");
        this.mIncludeAllInstances = (JCheckBox)l.add((Component)new JCheckBox("Include All Instances", false), (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mIncludeUnassignedPins = (JCheckBox)l.add((Component)new JCheckBox("Include Unassigned Pins"), (GridBagConstraints)GridBagManager.LEFT);
        this.mIncludeUnassignedPins.addActionListener(this.mIncUnassignedListener);
        l.newline();
        this.mAutoGenNetForUnassigned = (JCheckBox)l.add((Component)new JCheckBox("Auto Generate Net For Unassigned Pins"), (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.popNl();
        this.mDevicePath = this.computeCommonDevicePath();
        l.pushFillX("Select");
        l.add("Source Layer:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboStartLayer = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mCboStartLayer.setRenderer(new LayerUI.LayerListCellRenderer());
        this.mCboStartLayer.addActionListener(this.mBumpLayerListener);
        l.newline();
        l.add("Shape Size Filter:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboShapeSizeFilterOp = new JComboBox();
        this.mCboShapeSizeFilterOp.addItem(">=");
        this.mCboShapeSizeFilterOp.addItem("<=");
        this.mCboShapeSizeFilterOp.setSelectedItem(">=");
        l.add(this.mCboShapeSizeFilterOp, (GridBagConstraints)GridBagManager.LEFT);
        l.add("Width:");
        this.mTxtShapeWidthFilter = (JTextField)l.add((Component)new JTextField("0", 5));
        l.add("Height:");
        this.mTxtMinShapeHeightFilter = (JTextField)l.add((Component)new JTextField("0", 5));
        l.popNl();
        l.pushFillX("Bump");
        l.add("Bump Type:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboBumpType = (JComboBox)l.add(new JComboBox<BumpFanout.BumpType>(BumpFanout.BumpType.values()), (GridBagConstraints)GridBagManager.LEFT);
        this.mCboBumpType.addActionListener(this.mBumpTypeListener);
        l.newline();
        this.mLbBumpTemplate = l.add("Device Template:", (GridBagConstraints)GridBagManager.LEFT);
        l.pushNoFill();
        this.mCboViaPadstack = (PadTemplateComboBox)l.add((Component)new PadTemplateComboBox(this.mDevicePath, (Layer)this.mCboStartLayer.getSelectedItem(), (Layer)this.mCboStartLayer.getSelectedItem()), (GridBagConstraints)GridBagManager.LEFT);
        this.mCboPinDevice = (PinDeviceComboBox)l.add((Component)new PinDeviceComboBox(this.mDevicePath, null, null), (GridBagConstraints)GridBagManager.LEFT);
        l.popNl();
        this.mTxtRotation = (JTextField)l.add("Rotate:", (Component)new JTextField(5), (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtRotation.setText("0.00");
        l.newline();
        l.add("Mirror:");
        this.mCbMirror = (JCheckBox)l.add((Component)new JCheckBox(), (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mTxtNamePrefix = (JTextField)l.add("Name Prefix:", (Component)new JTextField(20), (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtNamePrefix.setText("BUMP");
        l.newline();
        JLabel lblAligment = new JLabel("Alignment:");
        lblAligment.setToolTipText("Align <refer shape geometry> to <placed bump>");
        l.add((Component)lblAligment, (GridBagConstraints)GridBagManager.LEFT);
        this.mCboBumpAlign = (JComboBox)l.add(new JComboBox<BumpFanout.BumpAlignment>(BumpFanout.BumpAlignment.values()), (GridBagConstraints)GridBagManager.LEFT);
        this.mCboBumpAlign.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                BumpFanout.BumpAlignment pos = (BumpFanout.BumpAlignment)((Object)value);
                this.setText(pos.getUserText());
                this.setToolTipText(pos.getDesc());
                return this;
            }
        });
        l.newline();
        this.mTxtBumpBumpPitch = new JTextField(5);
        this.mTxtBumpBumpPitch.setText("0.00");
        l.add("Min Bump Pitch:", (Component)this.mTxtBumpBumpPitch, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.popNl();
        l.pushFillX("Term");
        this.mRadioTermNone = new JRadioButton("None");
        this.mRadioTermNone.setToolTipText("Disable pin label creation");
        this.mRadioTermNone.setSelected(true);
        this.mRadioTermPrefix = new JRadioButton("Name Prefix:");
        this.mRadioTermPrefix.setToolTipText("Refer term name prefix to create pin label on bump pins");
        this.mTxtTermPrefix = new JTextField(20);
        this.mRadioTermList = new JRadioButton("Term List CSV:");
        this.mRadioTermList.setToolTipText("Refer term list to create pin label on bump pins");
        this.mTermListCSV = new AFileChooserControl();
        this.mTermListCSV.addChoosableFileFilter(AFileFilter.CSV);
        this.mTermListCSV.setMultiple(false);
        ButtonGroup termOptGroup = new ButtonGroup();
        termOptGroup.add(this.mRadioTermNone);
        termOptGroup.add(this.mRadioTermPrefix);
        termOptGroup.add(this.mRadioTermList);
        l.add((Component)this.mRadioTermNone, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add((Component)this.mRadioTermPrefix, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)this.mTxtTermPrefix, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add((Component)this.mRadioTermList, (GridBagConstraints)GridBagManager.LEFT);
        l.add((Component)this.mTermListCSV, (GridBagConstraints)GridBagManager.FILLX);
        l.addFillX();
        l.popNl();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnApply = (JButton)l.add((Component)new JButton("Apply"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        btnApply.addActionListener(this.mApplyListener);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.controlBumpList();
        this.controlOption();
    }

    private DevicePath computeCommonDevicePath() {
        DevicePath path = null;
        Stream selPaths = Stream.concat(Stream.concat(this.mSelection.getSelSet(this.mDb.getDbClass(PinInstance.class)).getDevicePaths().stream(), this.mSelection.getSelSet(this.mDb.getDbClass(PortTemplate.class)).getDevicePaths().stream()), this.mSelection.getSelSet(this.mDb.getDbClass(LayerShape.class)).getDevicePaths().stream());
        for (DevicePath dp : AUtil.arrayList(selPaths.iterator())) {
            if (path == null) {
                path = dp;
                continue;
            }
            path = path.commonParent(dp);
        }
        return path;
    }

    private void updateDbEvent() {
        DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVED};
        DbClass dbc = this.mDb.getDbClass(PadTemplate.class);
        if (dbc == null) {
            dbc = this.mDb.addDbClass(PadTemplate.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, events);
        dbc = this.mDb.getDbClass(LayerShape.class);
        if (dbc == null) {
            dbc = this.mDb.addDbClass(LayerShape.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, events);
    }

    public void updateLayerList(JComboBox<Layer> cboLayer, boolean selTop, Layer defaultLayer) {
        if (cboLayer == null) {
            return;
        }
        cboLayer.removeAllItems();
        int cnt = 0;
        int defaultLayerIndex = -1;
        if (this.mSubstrate != null) {
            for (Layer l : this.mSubstrate.getLayers(Layer.TopFirstSort)) {
                cboLayer.addItem(l);
                if (defaultLayer == l) {
                    defaultLayerIndex = cnt;
                }
                ++cnt;
            }
        } else {
            cboLayer.addItem(null);
        }
        if (cnt > 0) {
            if (defaultLayerIndex > -1) {
                cboLayer.setSelectedIndex(defaultLayerIndex);
            } else {
                cboLayer.setSelectedIndex(selTop ? 0 : cnt - 1);
            }
        }
        UIUtil.setComponentEnabled(cboLayer, (cnt > 0 ? 1 : 0) != 0);
    }

    public Layer findDefaultStartLayer(Selection selection, Substrate substrate) {
        Layer ans;
        LinkedHashSet layerSet = new LinkedHashSet();
        LinkedHashSet netUnusedLayerSet = new LinkedHashSet();
        boolean bga = false;
        Selection.SelSet selSet = selection.getSelSet(selection.getDb().getDbClass(PinInstance.class));
        for (APair thePair : selSet.getElements()) {
            Net net;
            PinInstance pin = (PinInstance)thePair.second;
            if (pin.getSubstrate() != substrate) continue;
            if (pin.getType() == PinTemplate.Type.BALLPAD || pin.getType() == PinTemplate.Type.BUMPPAD) {
                bga = true;
            }
            if ((net = NetMap.getSubstrateNet((Net)pin.getNet(), (DevicePath)((DevicePath)thePair.first))).isUnused()) {
                netUnusedLayerSet.addAll(pin.getPinTemplate().getLayersInUse().collect(Collectors.toSet()));
                continue;
            }
            layerSet.addAll(pin.getPinTemplate().getLayersInUse().collect(Collectors.toSet()));
        }
        ArrayList layers = new ArrayList(layerSet);
        ArrayList netUnusedLayers = new ArrayList(netUnusedLayerSet);
        if (layers.isEmpty()) {
            if (netUnusedLayers.isEmpty()) {
                return null;
            }
            ans = (Layer)netUnusedLayers.get(0);
            if (netUnusedLayers.size() <= 1) {
                return ans;
            }
            for (Layer layer : netUnusedLayers) {
                if (!(bga ? ans.compareTo((DbObject)layer) < 0 : ans.compareTo((DbObject)layer) > 0)) continue;
                ans = layer;
            }
            return ans;
        }
        ans = (Layer)layers.get(0);
        for (Layer layer : layers) {
            if (!(bga ? ans.compareTo((DbObject)layer) < 0 : ans.compareTo((DbObject)layer) > 0)) continue;
            ans = layer;
        }
        return ans;
    }

    public Layer findDefaultEndLayer(Substrate substrate, Layer startLayer) {
        if (substrate == null) {
            return null;
        }
        for (Layer l : substrate.getLayers(Layer.TopFirstSort)) {
            if (l == startLayer) continue;
            return l;
        }
        return startLayer;
    }

    public Layer currentSelectedLayer(Substrate s, JComboBox<Layer> cboLayer) {
        Layer curSelectedLayer = (Layer)cboLayer.getSelectedItem();
        if (curSelectedLayer == null || curSelectedLayer.getSubstrate() != s) {
            return null;
        }
        return curSelectedLayer;
    }

    protected void apply() throws AFieldValidator.AFieldValidationException {
        if (this.isBumpTypeDevice()) {
            this.applyForDevice();
        } else if (this.isBumpTypePin()) {
            this.applyForPin();
        }
        OrbitIO.refreshViewsOf(this.mDb);
    }

    protected void applyForDevice() throws AFieldValidator.AFieldValidationException {
        DeviceTemplate deviceTemplate = (DeviceTemplate)this.mCboPinDevice.getSelectedItem();
        if (deviceTemplate == null) {
            ALog.logWarn((String)"No Bump selected for fanout.");
        } else {
            this.createBump(BumpFanout.BumpType.DEVICE.name(), deviceTemplate.getKeyStr());
        }
    }

    protected void applyForPin() throws AFieldValidator.AFieldValidationException {
        PadTemplate padTemplate = (PadTemplate)this.mCboViaPadstack.getSelectedItem();
        if (padTemplate == null) {
            ALog.logWarn((String)"No Bump selected for fanout.");
        } else {
            this.createBump(BumpFanout.BumpType.PIN.name(), padTemplate.getKeyStr());
        }
    }

    private void createBump(String bumpType, String bumpKeyStr) throws AFieldValidator.AFieldValidationException {
        String startLayerkeyStr = ((Layer)this.mCboStartLayer.getSelectedItem()).getKeyStr();
        String namePrefix = this.mTxtNamePrefix.getText().trim();
        String shapeSizeFilterOp = (String)this.mCboShapeSizeFilterOp.getSelectedItem();
        float rotate = AUtil.floatFromString((String)AFieldValidator.validateFloat((JTextField)this.mTxtRotation));
        long shapeWidthFilter = this.mUnit.fromUserString(AFieldValidator.validateFloat((JTextField)this.mTxtShapeWidthFilter));
        long shapeHeightFilter = this.mUnit.fromUserString(AFieldValidator.validateFloat((JTextField)this.mTxtMinShapeHeightFilter));
        long bumpBumpPitch = this.mUnit.fromUserString(AFieldValidator.validateFloat((JTextField)this.mTxtBumpBumpPitch));
        boolean includeUnassignedPins = this.mIncludeUnassignedPins.isSelected();
        boolean includeAllInstances = this.mIncludeAllInstances.isSelected();
        boolean autoGenNet = this.mAutoGenNetForUnassigned.isEnabled() && this.mAutoGenNetForUnassigned.isSelected();
        boolean mirror = this.mCbMirror.isSelected();
        BumpFanout.BumpAlignment alignement = (BumpFanout.BumpAlignment)((Object)this.mCboBumpAlign.getSelectedItem());
        try (DbHistory.DbTransaction txn = DbHistory.newDbTransaction((Db)this.getDb(), (String)"Bump Fanout");){
            Cp.exec((String)"_bumpFactory = new com.sigrity.orbit.automation.BumpFanout(curDb(), \"%s\", \"%s\", \"%s\");", (Object[])new Object[]{bumpType, bumpKeyStr, startLayerkeyStr});
            Cp.exec((String)"_bumpFactory.setIncludeUnassignedPins(%b);", (Object[])new Object[]{includeUnassignedPins});
            Cp.exec((String)"_bumpFactory.setIncludeAllInstances(%b);", (Object[])new Object[]{includeAllInstances});
            Cp.exec((String)"_bumpFactory.setAutoGenNet(%b);", (Object[])new Object[]{autoGenNet});
            Cp.exec((String)"_bumpFactory.setRotate(%ff);", (Object[])new Object[]{Float.valueOf(rotate)});
            Cp.exec((String)"_bumpFactory.setMirror(%b);", (Object[])new Object[]{mirror});
            Cp.exec((String)"_bumpFactory.setNamePrefix(\"%s\");", (Object[])new Object[]{namePrefix});
            Cp.exec((String)"_bumpFactory.setShapeSizeFilterOp(\"%s\")", (Object[])new Object[]{shapeSizeFilterOp});
            Cp.exec((String)"_bumpFactory.setShapeWidthFilter(%dL)", (Object[])new Object[]{shapeWidthFilter});
            Cp.exec((String)"_bumpFactory.setShapeHeightFilter(%dL)", (Object[])new Object[]{shapeHeightFilter});
            Cp.exec((String)"_bumpFactory.setBumpAlignment(%s.%s)", (Object[])new Object[]{BumpFanout.BumpAlignment.class.getName(), alignement.name()});
            Cp.exec((String)"_bumpFactory.setMinBumpBumpPitch(%dL)", (Object[])new Object[]{bumpBumpPitch});
            Cp.exec((String)"_bumpFactory.setRefWorldLoc(%s)", (Object[])new Object[]{this.mRefWorldLoc == null ? null : this.mRefWorldLoc.getAsStringArg()});
            if (this.mRadioTermPrefix.isSelected()) {
                Cp.exec((String)"_bumpFactory.setRefTermNamePrefix(\"%s\")", (Object[])new Object[]{this.mTxtTermPrefix.getText()});
            } else if (this.mRadioTermList.isSelected()) {
                Cp.exec((String)"_bumpFactory.setRefTermListFile(%s)", (Object[])new Object[]{Cp.getFileAsArgument((String)this.mTermListCSV.getPath())});
            }
            Cp.exec((String)"_bumpFactory.createBump();", (Object[])new Object[0]);
            Cp.exec((String)"unset(\"_bumpFactory\");", (Object[])new Object[0]);
            Cp.exec((String)"Bundle.fixUpBundles(OrbitIO.getCurDb())", (Object[])new Object[0]);
        }
    }

    protected BumpFanout.BumpType getBumpType() {
        return (BumpFanout.BumpType)((Object)this.mCboBumpType.getSelectedItem());
    }

    protected boolean isBumpTypeDevice() {
        return this.getBumpType() == BumpFanout.BumpType.DEVICE;
    }

    protected boolean isBumpTypePin() {
        return this.getBumpType() == BumpFanout.BumpType.PIN;
    }

    private void updateBumpList() {
        if (!this.mUpdatePadstacksPending) {
            this.mUpdatePadstacksPending = true;
            EventQueue.invokeLater(() -> {
                this.updatePinDeviceListEvent();
                this.updatePadstackListEvent();
            });
            this.mUpdatePadstacksPending = false;
        }
    }

    private void updatePinDeviceListEvent() {
        Object selItem = this.mCboPinDevice.getSelectedItem();
        this.mCboPinDevice.changeDevicePath(this.mDevicePath, null, null);
        if (selItem != null) {
            this.mCboPinDevice.setSelectedItem(selItem);
        }
    }

    private void updatePadstackListEvent() {
        Object selItem = this.mCboViaPadstack.getSelectedItem();
        this.mCboViaPadstack.changeDevicePath(this.mDevicePath, (Layer)this.mCboStartLayer.getSelectedItem(), (Layer)this.mCboStartLayer.getSelectedItem());
        if (selItem != null) {
            this.mCboViaPadstack.setSelectedItem(selItem);
        }
    }

    private void controlOption() {
        boolean isSelected = this.mIncludeUnassignedPins.isSelected();
        this.mAutoGenNetForUnassigned.setEnabled(isSelected);
        if (!isSelected) {
            this.mAutoGenNetForUnassigned.setSelected(false);
        }
    }

    private void controlBumpList() {
        this.mLbBumpTemplate.setText(this.isBumpTypeDevice() ? "Device Template:" : "Pad Template:");
        this.mCboPinDevice.setVisible(this.isBumpTypeDevice());
        this.mCboViaPadstack.setVisible(this.isBumpTypePin());
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.mDb != null) {
            DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVED};
            DbClass clazz = this.mDb.getDbClass("PadTemplate");
            if (clazz != null) {
                clazz.removeObjectListener(this.mDbObjectsListener, events);
            }
            if ((clazz = this.mDb.getDbClass("LayerShape")) != null) {
                clazz.removeObjectListener(this.mDbObjectsListener, events);
            }
        }
    }

    class PinSelectionListener
    implements Selection.SelectionListener {
        PinSelectionListener() {
        }

        private void updateLayerListEvent(Selection s) {
            Layer startLayer;
            Layer selLayerStart = CreateFanoutBumpsUI.this.currentSelectedLayer(CreateFanoutBumpsUI.this.mSubstrate, CreateFanoutBumpsUI.this.mCboStartLayer);
            boolean usingPrevValues = false;
            if (selLayerStart != null) {
                usingPrevValues = true;
            }
            CreateFanoutBumpsUI.this.updateLayerList(CreateFanoutBumpsUI.this.mCboStartLayer, true, selLayerStart);
            if (!usingPrevValues && (startLayer = CreateFanoutBumpsUI.this.findDefaultStartLayer(s, CreateFanoutBumpsUI.this.mSubstrate)) != null) {
                CreateFanoutBumpsUI.this.mCboStartLayer.setSelectedItem(startLayer);
            }
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (!CreateFanoutBumpsUI.this.mUpdatePending) {
                CreateFanoutBumpsUI.this.mUpdatePending = true;
                EventQueue.invokeLater(() -> {
                    Selection s = Selection.getCurrentSelectionForDb((Db)CreateFanoutBumpsUI.this.mDb);
                    CreateFanoutBumpsUI.this.mDevicePath = null;
                    if (s != null) {
                        CreateFanoutBumpsUI.this.mDevicePath = CreateFanoutBumpsUI.this.computeCommonDevicePath();
                    }
                    CreateFanoutBumpsUI.this.mSubstrate = CreateFanoutBumpsUI.this.mDevicePath == null ? null : CreateFanoutBumpsUI.this.mDevicePath.getSubstrate();
                    this.updateLayerListEvent(s);
                    CreateFanoutBumpsUI.this.updatePadstackListEvent();
                    CreateFanoutBumpsUI.this.mUpdatePending = false;
                });
            }
        }
    }
}

