/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AComboBoxUtil;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.LayerUI;
import com.sigrity.orbit.ui.wb_route.PadStackDlg;
import com.sigrity.orbit.ui.wb_route.PadTemplateComboBox;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CreateFanoutsUI
extends DbDialog {
    protected Selection mSelection;
    protected Unit mUnit;
    protected JLabel mLblDesc;
    protected JRadioButton mRbAbsolute;
    protected JRadioButton mRbRelative;
    protected JLabel mLineWidthLabel;
    protected JTextField mTxtLineWidth;
    protected JLabel mPinViaSpaceLabel;
    protected JTextField mPinViaSpace;
    protected JLabel mMinChannelSpaceLabel;
    protected JTextField mMinChannelSpace;
    protected JLabel mLblY;
    protected JTextField mTxtY;
    protected JLabel mViaDirection;
    protected JLabel mViaPadstack;
    protected JTextField mTxtRotation;
    protected PadTemplateComboBox mViaPadstackCB;
    protected AComboBox<AComboBox.AComboBoxItem> mViaDirectionCB;
    protected JLabel mLblMirror = null;
    protected JCheckBox mIncludeUnassignedPins = null;
    protected JCheckBox mIncludeAllSameNetPins = null;
    protected JComboBox<Layer> mCboStartLayer;
    protected JComboBox<Layer> mCboEndLayer;
    protected Substrate mSubstrate;
    protected DevicePath mDevicePath;
    protected PinSelectionListener mSelectionListener;
    protected PadTemplateComboBox mPadTemplateComboBox;
    protected boolean mUpdatePending = false;
    protected boolean mUpdatePadstacksPending = false;
    protected Layer mLastUserStartLayer;
    protected Layer mLastUserEndLayer;
    protected Object mLastUserSelPadstack;
    protected Substrate mLastUserSelSubstrate;
    protected ActionListener mApplyListener = e -> {
        try {
            this.apply();
        }
        catch (AFieldValidator.AFieldValidationException aFieldValidationException) {
            // empty catch block
        }
    };
    protected ActionListener mViaDirectionCBChangedListener = e -> this.updateSpacings();
    protected ActionListener mCreatePadstackListener = e -> PadStackDlg.createDialog(OrbitIO.getMainWindow(), this.mDevicePath);
    protected ActionListener mPadstackLayerListener = e -> this.updatePadstackList();
    protected DbClass.DbObjectListener mDbObjectsListener = new DbClass.DbObjectAdapter(){

        public void removedObject(DbClass.ObjectRemove e) {
            CreateFanoutsUI.this.updatePadstackList();
        }

        public boolean removingObject(DbClass.ObjectRemove e) {
            return true;
        }

        public void changedObject(DbClass.ObjectChange e) {
        }

        public void addedObject(DbClass.ObjectAdd e) {
            CreateFanoutsUI.this.updatePadstackList();
        }
    };

    private void updateLayerAndPadstacks() {
        Layer layer;
        Substrate lastSubstrate = this.mSubstrate;
        this.updateTitle();
        Selection s = this.mSelection;
        this.mDevicePath = s == null ? null : this.computeCommonDevicePath();
        this.mSubstrate = this.mDevicePath == null ? null : this.mDevicePath.getSubstrate();
        Layer selLayerStart = this.currentSelectedLayer(this.mSubstrate, this.mCboStartLayer);
        Layer selLayerEnd = this.currentSelectedLayer(this.mSubstrate, this.mCboEndLayer);
        Object selItem = this.mPadTemplateComboBox.getSelectedItem();
        boolean usingPrevValues = false;
        if (selItem != null || selLayerStart != null || selLayerEnd != null) {
            this.mLastUserSelPadstack = selItem;
            this.mLastUserSelSubstrate = lastSubstrate;
            if (this.mSubstrate != null) {
                this.mLastUserStartLayer = selLayerStart;
                this.mLastUserEndLayer = selLayerEnd;
            }
            usingPrevValues = true;
        } else if (this.mLastUserSelSubstrate == this.mSubstrate) {
            selItem = this.mLastUserSelPadstack;
            selLayerStart = this.mLastUserStartLayer;
            selLayerEnd = this.mLastUserEndLayer;
            usingPrevValues = true;
        }
        this.updateLayerList(this.mSubstrate, this.mCboStartLayer, true, selLayerStart);
        this.updateLayerList(this.mSubstrate, this.mCboEndLayer, false, selLayerEnd);
        if (!usingPrevValues && (layer = this.findDefaultStartLayer(s, this.mSubstrate)) != null) {
            this.mCboStartLayer.setSelectedItem(layer);
            layer = this.findDefaultEndLayer(this.mSubstrate, layer);
            if (layer != null) {
                this.mCboEndLayer.setSelectedItem(layer);
            }
        }
        this.mPadTemplateComboBox.changeDevicePath(this.mDevicePath, (Layer)this.mCboStartLayer.getSelectedItem(), (Layer)this.mCboEndLayer.getSelectedItem());
        if (selItem != null) {
            this.mPadTemplateComboBox.setSelectedItem(selItem);
        }
        this.mUpdatePending = false;
    }

    private void updateTitle() {
        int selPin = this.mSelection.getCount(this.mDb.getDbClass(PinInstance.class));
        int selPort = this.mSelection.getCount(this.mDb.getDbClass(PortTemplate.class));
        int selShape = this.mSelection.getCount(this.mDb.getDbClass(LayerShape.class));
        Object status = "";
        if (selPin > 0) {
            status = (String)status + String.format("%d pins", selPin);
        }
        if (selPort > 0) {
            if (((String)status).length() > 0) {
                status = (String)status + ", ";
            }
            status = (String)status + String.format("%d ports", selPort);
        }
        if (selShape > 0) {
            if (((String)status).length() > 0) {
                status = (String)status + ", ";
            }
            status = (String)status + String.format("%d shapes", selShape);
        }
        this.setTitle(String.format("Create Fanouts (%s)", status));
    }

    private DevicePath computeCommonDevicePath() {
        DevicePath path = null;
        Stream selPaths = Stream.concat(Stream.concat(this.mSelection.getSelSet(this.mDb.getDbClass(PinInstance.class)).getDevicePaths().stream(), this.mSelection.getSelSet(this.mDb.getDbClass(PortTemplate.class)).getDevicePaths().stream()), this.mSelection.getSelSet(this.mDb.getDbClass(LayerShape.class)).getDevicePaths().stream());
        for (DevicePath dp : AUtil.arrayList(selPaths.iterator())) {
            if (path == null) {
                path = dp;
                continue;
            }
            path = path.commonParent(dp);
        }
        return path;
    }

    public CreateFanoutsUI(Component uiOwner, Db db, Selection selection) {
        super(db, uiOwner);
        this.mDb = db;
        this.mLastUserSelPadstack = null;
        this.mLastUserSelSubstrate = null;
        this.mLastUserStartLayer = null;
        this.mLastUserEndLayer = null;
        this.mSelection = selection;
        this.mSelectionListener = new PinSelectionListener();
        this.mDevicePath = null;
        this.mDevicePath = this.computeCommonDevicePath();
        this.mSelection.addSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        this.updateTitle();
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        l.pushFillX("Selected Option");
        this.mIncludeUnassignedPins = (JCheckBox)l.add((Component)new JCheckBox("Include Unassigned Pins"), (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mIncludeAllSameNetPins = (JCheckBox)l.add((Component)new JCheckBox("Include All Same Net Pins"), (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.popNl();
        l.pushFillX("Via");
        this.mSubstrate = this.mDevicePath.getSubstrate();
        l.add("Start", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboStartLayer = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
        this.mCboStartLayer.setRenderer(new LayerUI.LayerListCellRenderer());
        this.mCboStartLayer.addActionListener(this.mPadstackLayerListener);
        l.newline();
        l.add("End", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboEndLayer = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.FILLX);
        this.mCboEndLayer.setRenderer(new LayerUI.LayerListCellRenderer());
        this.mCboEndLayer.addActionListener(this.mPadstackLayerListener);
        l.newline();
        Layer layer = this.findDefaultStartLayer(this.mSelection, this.mSubstrate);
        this.mCboStartLayer.setSelectedItem(layer);
        layer = this.findDefaultEndLayer(this.mSubstrate, layer);
        this.mCboEndLayer.setSelectedItem(layer);
        this.mViaPadstack = l.add("Via/Padstack", (GridBagConstraints)GridBagManager.LEFT);
        this.mPadTemplateComboBox = new PadTemplateComboBox(this.mDevicePath, (Layer)this.mCboStartLayer.getSelectedItem(), (Layer)this.mCboEndLayer.getSelectedItem());
        this.mViaPadstackCB = (PadTemplateComboBox)l.add((Component)this.mPadTemplateComboBox);
        AComboBoxUtil.setupKeySearch((JComboBox)this.mPadTemplateComboBox);
        JButton btnCreatePadstack = (JButton)l.add((Component)new JButton("Create..."), (GridBagConstraints)GridBagManager.RIGHT);
        btnCreatePadstack.addActionListener(this.mCreatePadstackListener);
        l.newline();
        this.mViaDirection = l.add("Via Direction", (GridBagConstraints)GridBagManager.LEFT);
        this.mViaDirectionCB = new AComboBox((Object[])new AComboBox.AComboBoxItem[]{new AComboBox.AComboBoxItem((Object)"Via in Pad", DBEResources.ICON_VIA_IN_PAD, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"BGA Quadrant OutWard", DBEResources.ICON_PACKAGE, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"BGA Quadrant InWard", DBEResources.ICON_PACKAGE, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"N", DBEResources.ICON_VIA_N, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"NE", DBEResources.ICON_VIA_NE, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"E", DBEResources.ICON_VIA_E, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"SE", DBEResources.ICON_VIA_SE, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"S", DBEResources.ICON_VIA_S, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"SW", DBEResources.ICON_VIA_SW, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"W", DBEResources.ICON_VIA_W, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"NW", DBEResources.ICON_VIA_NW, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"Inward", DBEResources.ICON_INWARD, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"Outward", DBEResources.ICON_OUTWARD, (Object)Type.VIA_IN_PAD), new AComboBox.AComboBoxItem((Object)"In/Out", DBEResources.ICON_INWARD_OUTWARD, (Object)Type.VIA_IN_PAD)});
        l.add(this.mViaDirectionCB);
        this.mViaDirectionCB.addActionListener(this.mViaDirectionCBChangedListener);
        l.newline();
        if (this.mSubstrate != null) {
            this.updateLayerList(this.mSubstrate, this.mCboStartLayer, true, null);
            this.updateLayerList(this.mSubstrate, this.mCboEndLayer, false, null);
        }
        l.newline();
        this.mLineWidthLabel = l.add("Line Width:", (GridBagConstraints)GridBagManager.LEFT);
        this.mTxtLineWidth = (JTextField)l.add((Component)new JTextField(10));
        this.mTxtLineWidth.setText("75");
        l.newline();
        this.mPinViaSpaceLabel = l.add("Pin-Via Space:", (GridBagConstraints)GridBagManager.LEFT);
        this.mPinViaSpace = (JTextField)l.add((Component)new JTextField(10));
        this.mPinViaSpace.setText("75");
        l.newline();
        this.mMinChannelSpaceLabel = l.add("Min Channel Space:", (GridBagConstraints)GridBagManager.LEFT);
        this.mMinChannelSpace = (JTextField)l.add((Component)new JTextField(10));
        this.mMinChannelSpace.setText("75");
        l.popNl();
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        JButton btnApply = (JButton)l.add((Component)new JButton("Apply"), (GridBagConstraints)GridBagManager.RIGHT);
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        btnApply.addActionListener(this.mApplyListener);
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)btnApply);
        this.pack();
        UIUtil.center((Component)((Object)this));
        DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVED};
        DbClass dbc = db.getDbClass(PadTemplate.class);
        if (dbc == null) {
            dbc = db.addDbClass(PadTemplate.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, events);
        dbc = db.getDbClass(LayerShape.class);
        if (dbc == null) {
            dbc = db.addDbClass(LayerShape.class);
        }
        dbc.addObjectListener(this.mDbObjectsListener, events);
        this.updateSpacings();
        btnClose.addActionListener(e -> this.close());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                CreateFanoutsUI.this.close();
            }
        });
    }

    public Layer currentSelectedLayer(Substrate s, JComboBox<Layer> cboLayer) {
        Layer curSelectedLayer = (Layer)cboLayer.getSelectedItem();
        if (curSelectedLayer == null || curSelectedLayer.getSubstrate() != s) {
            return null;
        }
        return curSelectedLayer;
    }

    public void updateLayerList(Substrate s, JComboBox<Layer> cboLayer, boolean selTop, Layer defaultLayer) {
        int cnt;
        int defaultLayerIndex = -1;
        this.mSubstrate = s;
        if (cboLayer == null) {
            return;
        }
        cboLayer.removeAllItems();
        int i = 0;
        if (s != null) {
            for (Layer l : s.getLayers(Layer.TopFirstSort)) {
                cboLayer.addItem(l);
                if (defaultLayer == l) {
                    defaultLayerIndex = i;
                }
                ++i;
            }
        }
        if ((cnt = cboLayer.getItemCount()) > 0) {
            cboLayer.setSelectedIndex(defaultLayerIndex > -1 ? defaultLayerIndex : (selTop ? 0 : cnt - 1));
        }
        UIUtil.setComponentEnabled(cboLayer, (cnt > 0 ? 1 : 0) != 0);
    }

    public Layer findDefaultStartLayer(Selection selection, Substrate substrate) {
        Layer ans;
        LinkedList<Layer> layers = new LinkedList<Layer>();
        LinkedList<Layer> netUnusedLayers = new LinkedList<Layer>();
        boolean bga = false;
        Selection.SelSet selSet = selection.getSelSet(selection.getDb().getDbClass(PinInstance.class));
        for (APair thePair : selSet.getElements()) {
            PinInstance pin = (PinInstance)thePair.second;
            Net net = NetMap.getSubstrateNet((Net)pin.getNet(), (DevicePath)((DevicePath)thePair.first));
            if (pin.getPadTemplate().getSubstrate() != substrate) continue;
            if (pin.getPinTemplate().getType() == PinTemplate.Type.BALLPAD || pin.getPinTemplate().getType() == PinTemplate.Type.BUMPPAD) {
                bga = true;
            }
            if (net.isUnused()) {
                for (LayerShape ls : pin.getPinTemplate().getLayerShapes()) {
                    if (netUnusedLayers.contains(ls.getLayer())) continue;
                    netUnusedLayers.add(ls.getLayer());
                }
                continue;
            }
            for (LayerShape ls : pin.getPinTemplate().getLayerShapes()) {
                if (layers.contains(ls.getLayer())) continue;
                layers.add(ls.getLayer());
            }
        }
        if (layers.isEmpty()) {
            if (netUnusedLayers.isEmpty()) {
                return null;
            }
            ans = (Layer)netUnusedLayers.get(0);
            if (netUnusedLayers.size() <= 1) {
                return ans;
            }
            for (Layer lay : netUnusedLayers) {
                if (!(bga ? ans.compareTo((DbObject)lay) < 0 : ans.compareTo((DbObject)lay) > 0)) continue;
                ans = lay;
            }
            return ans;
        }
        ans = (Layer)layers.get(0);
        if (layers.size() <= 1) {
            return ans;
        }
        for (Layer lay : layers) {
            if (!(bga ? ans.compareTo((DbObject)lay) < 0 : ans.compareTo((DbObject)lay) > 0)) continue;
            ans = lay;
        }
        return ans;
    }

    public Layer findDefaultEndLayer(Substrate substrate, Layer startLayer) {
        for (Layer l : substrate.getLayers(Layer.TopFirstSort)) {
            if (l == startLayer) continue;
            return l;
        }
        return startLayer;
    }

    protected void apply() throws AFieldValidator.AFieldValidationException {
        this.mUnit = OrbitIO.getCurView().getUnit();
        PadTemplate padTemplate = this.mViaPadstackCB.getSelectedPad();
        if (padTemplate == null) {
            ALog.logWarn((String)"No Via is selected for fanout. Please create one and try again.");
        } else {
            Cp.exec((String)"UserCommands.createFanoutsForSelected(curDb(), %s, %s, \"%s\", \"%s\", \"%s\", \"%s\", %d, %d, %d);", (Object[])new Object[]{Boolean.toString(this.mIncludeUnassignedPins.isSelected()), Boolean.toString(this.mIncludeAllSameNetPins.isSelected()), ((Layer)this.mCboStartLayer.getSelectedItem()).getKeyStr(), ((Layer)this.mCboEndLayer.getSelectedItem()).getKeyStr(), padTemplate.getKeyStr(), ((AComboBox.AComboBoxItem)this.mViaDirectionCB.getSelectedItem()).getText(), this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mTxtLineWidth)), this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mPinViaSpace)), this.mUnit.fromUserString(AFieldValidator.validateDouble((JTextField)this.mMinChannelSpace))});
        }
        OrbitIO.refreshViewsOf(this.mDb);
    }

    private void updateSpacings() {
        if (((AComboBox.AComboBoxItem)this.mViaDirectionCB.getSelectedItem()).getText().equals("Via in Pad")) {
            this.mLineWidthLabel.setEnabled(false);
            this.mTxtLineWidth.setEnabled(false);
            this.mPinViaSpaceLabel.setEnabled(false);
            this.mPinViaSpace.setEnabled(false);
            this.mMinChannelSpaceLabel.setEnabled(false);
            this.mMinChannelSpace.setEnabled(false);
        } else if (((AComboBox.AComboBoxItem)this.mViaDirectionCB.getSelectedItem()).getText().equals("Inward") || ((AComboBox.AComboBoxItem)this.mViaDirectionCB.getSelectedItem()).getText().equals("Outward") || ((AComboBox.AComboBoxItem)this.mViaDirectionCB.getSelectedItem()).getText().equals("In/Out")) {
            this.mLineWidthLabel.setEnabled(true);
            this.mTxtLineWidth.setEnabled(true);
            this.mPinViaSpaceLabel.setEnabled(true);
            this.mPinViaSpace.setEnabled(true);
            this.mMinChannelSpaceLabel.setEnabled(true);
            this.mMinChannelSpace.setEnabled(true);
        } else {
            this.mLineWidthLabel.setEnabled(true);
            this.mTxtLineWidth.setEnabled(true);
            this.mPinViaSpaceLabel.setEnabled(true);
            this.mPinViaSpace.setEnabled(true);
            this.mMinChannelSpaceLabel.setEnabled(false);
            this.mMinChannelSpace.setEnabled(false);
        }
    }

    private void updatePadstackList() {
        if (!this.mUpdatePadstacksPending) {
            this.mUpdatePadstacksPending = true;
            EventQueue.invokeLater(() -> this.updatePadstackListNow());
        }
    }

    private void updatePadstackListNow() {
        Object selItem = this.mPadTemplateComboBox.getSelectedItem();
        if (selItem != null) {
            this.mLastUserSelPadstack = selItem;
            this.mLastUserSelSubstrate = this.mSubstrate;
        } else if (this.mLastUserSelSubstrate == this.mSubstrate) {
            selItem = this.mLastUserSelPadstack;
        }
        this.mPadTemplateComboBox.changeDevicePath(this.mDevicePath, (Layer)this.mCboStartLayer.getSelectedItem(), (Layer)this.mCboEndLayer.getSelectedItem());
        if (selItem != null) {
            this.mPadTemplateComboBox.setSelectedItem(selItem);
        }
        this.mUpdatePadstacksPending = false;
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.mDb != null) {
            this.close();
        }
    }

    public void close() {
        this.mSelection.removeSelectionListener((Selection.SelectionListener)this.mSelectionListener);
        DbClass.DbObjectEventType[] events = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED, DbClass.DbObjectEventType.REMOVED};
        DbClass clazz = this.mDb.getDbClass(PadTemplate.class);
        if (clazz != null) {
            clazz.removeObjectListener(this.mDbObjectsListener, events);
        }
        if ((clazz = this.mDb.getDbClass(LayerShape.class)) != null) {
            clazz.removeObjectListener(this.mDbObjectsListener, events);
        }
    }

    class PinSelectionListener
    implements Selection.SelectionListener {
        PinSelectionListener() {
        }

        public void selectionChanged(HashMap<DbClass, Selection.SelSet> set) {
            if (!CreateFanoutsUI.this.mUpdatePending) {
                CreateFanoutsUI.this.mUpdatePending = true;
                EventQueue.invokeLater(() -> CreateFanoutsUI.this.updateLayerAndPadstacks());
            }
        }
    }

    public static enum Type {
        VIA_IN_PAD,
        BGA_QUADRANT,
        N,
        S,
        E,
        W,
        NE,
        NW,
        SE,
        SW,
        INWARD,
        OUTWARD,
        IN_OUT;

    }
}

