/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.TemplateListRenderer;
import com.sigrity.acl.ui.AButtonGroup;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.LayerUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CreateFromTemplateOrParametrically
extends JPanel {
    protected Substrate tempSubstrate = null;
    protected boolean mIncludeLayer;
    protected DeviceTemplate mCreateOnDevT = null;
    protected Substrate mSubstrate = null;
    protected AComboBox<AComboBox.AComboBoxItem> mPinInstantationType = null;
    protected Unit mUnit;
    protected JRadioButton mRbTemplate = null;
    protected JPanel mPnlFromTemplate;
    protected JComboBox<DeviceTemplate> mCboBumpTemplate;
    protected JComboBox<PadTemplate> mCboPadTemplate;
    protected JRadioButton mRbParametric;
    protected JPanel mPnlFromParameters;
    protected JComboBox<PadTemplate.PadShapeStyle> mCboShape;
    protected JComboBox<Layer> mCboLayer;
    protected JLabel mLblPadSize;
    protected JTextField mTxtPadSize;
    protected JLabel mTxtPadSize2Label;
    protected JTextField mTxtPadSize2;

    public CreateFromTemplateOrParametrically(Substrate subs, DeviceTemplate devT, Unit unit, boolean includeLayer, DeviceTemplate.Type type) {
        this.mSubstrate = subs;
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mUnit = unit;
        if (this.mUnit == null) {
            this.mUnit = Design.getDefaultUnitDist();
        }
        this.mIncludeLayer = includeLayer;
        this.mCreateOnDevT = devT;
        JLabel la = new JLabel("Create:");
        l.add((Component)la, (GridBagConstraints)GridBagManager.LEFT);
        Object[] pinInstantationTypes = new AComboBox.AComboBoxItem[]{new AComboBox.AComboBoxItem((Object)"pins", null, (Object)PinInstantationType.PINS), new AComboBox.AComboBoxItem((Object)"devices", null, (Object)PinInstantationType.DEVICES)};
        this.mPinInstantationType = new AComboBox(pinInstantationTypes);
        la.setLabelFor((Component)this.mPinInstantationType);
        l.add(this.mPinInstantationType, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        this.mPinInstantationType.addActionListener(e -> this.enableControls());
        this.mRbTemplate = (JRadioButton)l.add((Component)new JRadioButton("Create from template"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        l.newline();
        this.mPnlFromTemplate = l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent().indent());
        this.mCboBumpTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboBumpTemplate.setMinimumSize(new Dimension(200, 24));
        this.mCboBumpTemplate.setPreferredSize(new Dimension(200, 24));
        this.mCboBumpTemplate.setRenderer(new TemplateListRenderer());
        this.mCboPadTemplate = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
        this.mCboPadTemplate.setMinimumSize(new Dimension(200, 24));
        this.mCboPadTemplate.setPreferredSize(new Dimension(200, 24));
        this.mCboPadTemplate.setRenderer(new PadTemplateListCellRenderer());
        l.popNl();
        this.mRbParametric = (JRadioButton)l.addNl((Component)new JRadioButton("Create parametrically"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        this.mPnlFromParameters = l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets().indent().indent());
        l.add("Shape:", (GridBagConstraints)GridBagManager.LEFT);
        this.mCboShape = (JComboBox)l.add(new JComboBox());
        this.mCboShape.removeAllItems();
        for (PadTemplate.PadShapeStyle shape : PadTemplate.PadShapeStyle.values()) {
            this.mCboShape.addItem(shape);
        }
        int numBumpTemps = this.updateTemplates(this.mSubstrate);
        this.mCboShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFromTemplateOrParametrically.this.enableControls();
            }
        });
        this.mLblPadSize = l.add("Size:");
        this.mTxtPadSize = (JTextField)l.add((Component)new JTextField(5));
        this.mTxtPadSize.setText("200");
        this.mTxtPadSize2Label = l.add("x");
        this.mTxtPadSize2 = (JTextField)l.add((Component)new JTextField(5), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        this.mTxtPadSize2.setText("400");
        l.newline();
        if (this.mIncludeLayer) {
            l.add("Layer:");
            this.mCboLayer = (JComboBox)l.add(new JComboBox(), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mCboLayer.setRenderer(new LayerUI.LayerListCellRenderer());
            if (devT != null) {
                this.updateLayerList(devT);
            } else {
                this.updateLayerList(subs, type);
            }
        }
        l.popNl();
        new AButtonGroup(this.mRbParametric, this.mRbTemplate);
        this.mRbTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFromTemplateOrParametrically.this.enableControls();
                CreateFromTemplateOrParametrically.this.ownerNeedsResize();
            }
        });
        this.mRbParametric.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFromTemplateOrParametrically.this.enableControls();
                CreateFromTemplateOrParametrically.this.ownerNeedsResize();
            }
        });
        this.mRbTemplate.setSelected(numBumpTemps > 0);
        this.mRbParametric.setSelected(numBumpTemps == 0);
        this.mRbTemplate.setEnabled(numBumpTemps > 0);
        this.enableControls();
    }

    public void updateLayerList(DeviceTemplate devT) {
        if (this.mIncludeLayer) {
            this.mCboLayer.removeAllItems();
            this.mCreateOnDevT = devT;
            if (this.mCreateOnDevT == null) {
                return;
            }
            Substrate substrate = this.mCreateOnDevT.getSubstrate();
            if (substrate == null) {
                return;
            }
            LinkedList layers = AUtil.linkedList((Iterator)substrate.getLayers());
            Collections.sort(layers);
            for (Layer layer : layers) {
                this.mCboLayer.addItem(layer);
            }
            if (this.mCreateOnDevT.getType() == DeviceTemplate.Type.INTERPOSER) {
                this.mCboLayer.setSelectedIndex(0);
            } else {
                this.mCboLayer.setSelectedIndex(this.mCboLayer.getItemCount() - 1);
            }
            UIUtil.setComponentEnabled(this.mCboLayer, (this.mCboLayer.getItemCount() > 0 ? 1 : 0) != 0);
        }
    }

    public void updateLayerList(Substrate s, DeviceTemplate.Type type) {
        if (this.mCboLayer != null) {
            Layer prevLayer = (Layer)this.mCboLayer.getSelectedItem();
            String layerName = null;
            if (prevLayer != null) {
                layerName = prevLayer.getName();
            }
            this.mCboLayer.removeAllItems();
            if (this.mIncludeLayer) {
                if (s == null) {
                    if (this.tempSubstrate == null) {
                        String mSubstrateName = Substrate.getUniqueName((Db)OrbitIO.getOrbitIO().getCurrentView().getDb(), (String)"Temp_Substrate");
                        Cp.exec((String)"com.sigrity.acl.db.std.Substrate.create(curDb(), \"%s\")", (Object[])new Object[]{mSubstrateName});
                        s = this.tempSubstrate = Substrate.getSubstrate((Db)OrbitIO.getOrbitIO().getCurrentView().getDb(), (String)mSubstrateName);
                    } else {
                        s = this.tempSubstrate;
                    }
                    Cp.exec((String)"com.sigrity.acl.db.std.Substrate.getSubstrate(curDb(), \"%s\").removeAllLayers()", (Object[])new Object[]{this.tempSubstrate.getName()});
                    Cp.exec((String)"com.sigrity.orbit.factory.DeviceFactory.createDefaultLayers(\"%s\", \"%s\", curDb())", (Object[])new Object[]{type.toString(), this.tempSubstrate.getName()});
                }
                prevLayer = null;
                for (Layer l : s.getLayers(Layer.TopFirstSort)) {
                    this.mCboLayer.addItem(l);
                    if (layerName == null || layerName.compareTo(l.getName()) != 0) continue;
                    prevLayer = l;
                }
                UIUtil.setComponentEnabled(this.mCboLayer, (this.mCboLayer.getItemCount() > 0 ? 1 : 0) != 0);
                if (prevLayer != null) {
                    this.mCboLayer.setSelectedItem(prevLayer);
                }
            }
        }
    }

    public int updateTemplates(Substrate subs) {
        this.mSubstrate = subs;
        int numBumpTemps = 0;
        int numPadTemps = 0;
        LinkedList<PadTemplate> padTemplates = new LinkedList<PadTemplate>();
        for (Object t : OrbitIO.getOrbitIO().getCurrentView().getDb().getObjects(PadTemplate.class)) {
            if (subs != null && t.getSubstrate() != this.mSubstrate || t.getBB(null) == null) continue;
            padTemplates.add((PadTemplate)t);
        }
        Collections.sort(padTemplates);
        this.mCboPadTemplate.setModel(new DefaultComboBoxModel<PadTemplate>(padTemplates.toArray(new PadTemplate[padTemplates.size()])));
        numPadTemps = padTemplates.size();
        if (subs == null) {
            this.mRbTemplate.setText("Copy largest geometry of template");
        } else {
            this.mRbTemplate.setText("Create from template");
        }
        LinkedList<DeviceTemplate> bumpTemplates = new LinkedList<DeviceTemplate>();
        if (this.mSubstrate != null) {
            for (DeviceTemplate t : OrbitIO.getOrbitIO().getCurrentView().getDb().getObjects(DeviceTemplate.class)) {
                if (t.getType() != DeviceTemplate.Type.BUMP || t.getSubstrate() != this.mSubstrate) continue;
                bumpTemplates.add(t);
            }
        }
        Collections.sort(bumpTemplates);
        this.mCboBumpTemplate.setModel(new DefaultComboBoxModel<DeviceTemplate>(bumpTemplates.toArray(new DeviceTemplate[bumpTemplates.size()])));
        numBumpTemps = bumpTemplates.size();
        int numTemps = this.instantiateAsPins() ? numPadTemps : numBumpTemps;
        this.mRbTemplate.setEnabled(numTemps > 0);
        if (numTemps == 0 && this.mRbTemplate.isSelected()) {
            this.mRbTemplate.setSelected(false);
            this.mRbParametric.setSelected(true);
            this.enableControls();
        }
        return numTemps;
    }

    protected void enableControls() {
        this.mCboBumpTemplate.setVisible(!this.instantiateAsPins());
        this.mCboPadTemplate.setVisible(this.instantiateAsPins());
        this.mPnlFromTemplate.setVisible(this.mRbTemplate.isSelected());
        this.mPnlFromParameters.setVisible(this.mRbParametric.isSelected());
        this.mTxtPadSize2Label.setVisible(this.getShape() == PadTemplate.PadShapeStyle.Rect);
        this.mTxtPadSize2.setVisible(this.getShape() == PadTemplate.PadShapeStyle.Rect);
        PadTemplate.PadShapeStyle padShape = this.getShape();
        if (padShape == PadTemplate.PadShapeStyle.Circle || padShape == PadTemplate.PadShapeStyle.Octagon) {
            this.mLblPadSize.setText("Diameter:");
        } else {
            this.mLblPadSize.setText("Size:");
        }
        this.updateTemplates(this.mSubstrate);
    }

    protected void ownerNeedsResize() {
        Window w = UIUtil.getParentWindow((Component)this);
        w.invalidate();
        w.pack();
    }

    protected boolean hasValidBumpSetting() {
        boolean validBumpSetting = true;
        if (this.mRbTemplate.isSelected()) {
            if (this.instantiateAsPins()) {
                if (!(this.mCboPadTemplate.getSelectedItem() instanceof PadTemplate)) {
                    validBumpSetting = false;
                }
            } else if (!(this.mCboBumpTemplate.getSelectedItem() instanceof DeviceTemplate)) {
                validBumpSetting = false;
            }
        } else {
            if (!this.validDoubleGreaterThan0(this.mTxtPadSize)) {
                validBumpSetting = false;
            }
            if (this.getShape() == PadTemplate.PadShapeStyle.Rect && !this.validDoubleGreaterThan0(this.mTxtPadSize2)) {
                validBumpSetting = false;
            }
        }
        return validBumpSetting;
    }

    protected boolean validDoubleGreaterThan0(JTextField f) {
        String s = f.getText();
        try {
            NumberFormat nf = NumberFormat.getNumberInstance();
            Number n = nf.parse(s);
            if (n.doubleValue() <= 0.0) {
                if (f.isEnabled()) {
                    f.setBackground(Color.RED);
                } else {
                    f.setBackground(Color.pink);
                }
                return false;
            }
            f.setBackground(Color.WHITE);
            return true;
        }
        catch (ParseException e) {
            if (f.isEnabled()) {
                f.setBackground(Color.RED);
            } else {
                f.setBackground(Color.pink);
            }
            return false;
        }
    }

    protected void validateSettings() throws AFieldValidator.AFieldValidationException {
        if (this.mRbTemplate.isSelected()) {
            if (this.instantiateAsPins()) {
                if (!(this.mCboPadTemplate.getSelectedItem() instanceof PadTemplate)) {
                    throw AFieldValidator.createException(null, (String)"Pad Template", null, this.mCboPadTemplate);
                }
            } else if (!(this.mCboBumpTemplate.getSelectedItem() instanceof DeviceTemplate)) {
                throw AFieldValidator.createException(null, (String)"Bump Template", null, this.mCboBumpTemplate);
            }
        } else {
            AFieldValidator.validateDouble((JTextField)this.mTxtPadSize);
            if (this.getShape() == PadTemplate.PadShapeStyle.Rect && !this.validDoubleGreaterThan0(this.mTxtPadSize2)) {
                AFieldValidator.validateDouble((JTextField)this.mTxtPadSize);
            }
            if (this.mIncludeLayer && this.mCboLayer.isEnabled() && !(this.mCboLayer.getSelectedItem() instanceof Layer)) {
                throw AFieldValidator.createException(null, (String)"Layer", null, this.mCboLayer);
            }
        }
    }

    protected boolean fromTemplate() {
        return this.mRbTemplate.isSelected();
    }

    protected boolean instantiateAsPins() {
        AComboBox.AComboBoxItem item = (AComboBox.AComboBoxItem)this.mPinInstantationType.getSelectedItem();
        return item.getText().equals("pins");
    }

    protected String getTemplateName() {
        if (this.instantiateAsPins()) {
            PadTemplate padTmplt = (PadTemplate)this.mCboPadTemplate.getSelectedItem();
            return padTmplt.getKeyStr();
        }
        DeviceTemplate bumpTmplt = (DeviceTemplate)this.mCboBumpTemplate.getSelectedItem();
        return bumpTmplt.getKeyStr();
    }

    protected void setTemplateName(String val) {
        if (this.instantiateAsPins()) {
            this.mCboPadTemplate.setSelectedItem(val);
        } else {
            this.mCboBumpTemplate.setSelectedItem(val);
        }
    }

    protected String getLayerName() {
        Layer layer = null;
        if (this.mIncludeLayer) {
            layer = (Layer)this.mCboLayer.getSelectedItem();
        }
        return layer == null ? null : String.format("\"%s\"", layer.getName());
    }

    protected void setLayerName(String val) {
        if (this.mIncludeLayer) {
            this.mCboLayer.setSelectedItem(val);
        }
    }

    protected String getShapeName() {
        return this.getShape().name();
    }

    protected void setShapeName(String val) {
        this.mCboShape.setSelectedItem(val);
    }

    public PadTemplate.PadShapeStyle getShape() {
        return (PadTemplate.PadShapeStyle)this.mCboShape.getSelectedItem();
    }

    protected String getSizeStr(Unit unit) {
        return String.format("%dL", unit.fromUserString(this.mTxtPadSize.getText()));
    }

    protected String getSizeStr() {
        return this.mTxtPadSize.getText();
    }

    protected void setSizeStr(String val) {
        this.mTxtPadSize.setText(val);
    }

    protected String getSize2Str(Unit unit) {
        return String.format("%dL", unit.fromUserString(this.mTxtPadSize2.getText()));
    }

    protected String getSize2Str() {
        return this.mTxtPadSize2.getText();
    }

    protected void setSize2Str(String val) {
        this.mTxtPadSize2.setText(val);
    }

    public void close() {
        if (this.tempSubstrate != null && OrbitIO.getCurDb() != null) {
            Cp.exec((String)"com.sigrity.acl.db.std.Substrate.getSubstrate(curDb(), \"%s\").deleteFromDb()", (Object[])new Object[]{this.tempSubstrate.getName()});
        }
        this.tempSubstrate = null;
    }

    public static enum PinInstantationType {
        PINS,
        DEVICES;

    }

    protected static class PadTemplateListCellRenderer
    extends DefaultListCellRenderer {
        protected PadTemplateListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
            if (value instanceof PadTemplate) {
                PadTemplate t = (PadTemplate)value;
                this.setText((String)(t.getSubstrate() != null ? t.getName() + " on " + t.getSubstrate().getName() : t.getName()));
            } else {
                this.setText("<INVALID>");
            }
            return this;
        }
    }
}

