/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.Unit;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.render.SubstrateTemplateListRenderer;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.AComboBox;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SubstrateTemplate;
import com.sigrity.orbit.ui.CreateSubstrateUI;
import com.sigrity.orbit.ui.DesignDialog;
import com.sigrity.orbit.ui.LefDefUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.UserUnitsPanel;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import com.sigrity.tools.dbexplorer.DBEResources;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class CreatePackageWizard
extends DesignDialog {
    static final int UNIFORM_ARRAY_INDEX = 0;
    static final int INNER_RING_INDEX = 1;
    static final int OUTER_RING_INDEX = 2;
    private static final Color ColorOk = Color.WHITE;
    private static final Color ColorWarn = AColor.mix((Color)Color.YELLOW, (Color)Color.WHITE, (float)0.5f);
    protected JButton mButCancel = new JButton("Close");
    protected UserUnitsPanel mUnitsPanel = null;
    protected AComboBox<SubstrateTemplate> mCboSubstrate;
    protected JTextField mPackageName;
    protected JTextField mPackageTemplateName;
    protected JRadioButton mBoundDefaultBtn = new JRadioButton("Default");
    protected JRadioButton mBoundPerimeterBtn = new JRadioButton("Perimeter");
    protected JRadioButton mBoundSpecificBtn = new JRadioButton("Specific");
    protected final CardLayout mCardLayout = new CardLayout();
    private List<StepForm> mForms = new ArrayList<StepForm>();
    private List<JButton> mProgress = new ArrayList<JButton>();
    private List<String> mStepCmds = new ArrayList<String>();
    private String mCurrentStage = "Substrate";
    private final JPanel mContentPanel = new JPanel();
    private final JLabel mWarningTip = new JLabel();
    private final JPanel mFooterPanel = new JPanel();
    private final JButton mPrevBtn = (JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Prev"));
    private final JButton mNextBtn = (JButton)UIUtil.makeFootButton((AbstractButton)new JButton("Next"));
    private static final String CMD_SUBSTRATE = "Substrate";
    private static final String CMD_PACKAGE = "Package";
    private static final String CMD_RING = "Ring";
    private static final String CMD_BOUND = "Bound";
    protected final AComboBox.AComboBoxItem mArray2Rings = new AComboBox.AComboBoxItem((Object)"Center Array with Two Outer Rings", null, (Object)PkgStyleType.ARRAY_2RINGS);
    protected final AComboBox.AComboBoxItem mArray1Ring = new AComboBox.AComboBoxItem((Object)"Center Array with One Outer Ring", null, (Object)PkgStyleType.ARRAY_1RING);
    protected final AComboBox.AComboBoxItem m2Rings = new AComboBox.AComboBoxItem((Object)"Two Rings", null, (Object)PkgStyleType.TWO_RINGS);
    protected final AComboBox.AComboBoxItem m1Ring = new AComboBox.AComboBoxItem((Object)"One Ring", null, (Object)PkgStyleType.ONE_RING);
    protected final AComboBox.AComboBoxItem mUniformArray = new AComboBox.AComboBoxItem((Object)"Uniform Array", null, (Object)PkgStyleType.UNIFORM_ARRAY);
    protected final AComboBox.AComboBoxItem mInheritFromOuter = new AComboBox.AComboBoxItem((Object)"Inherit pin pitch from outer ring", null, (Object)RingSpecType.INHERIT_FROM_OUTER);
    protected final AComboBox.AComboBoxItem mInheritAllFromOuter = new AComboBox.AComboBoxItem((Object)"Inherit pin pitch and pin shape from outer ring", null, (Object)RingSpecType.INHERIT_ALL_FROM_OUTER);
    protected final AComboBox.AComboBoxItem mInheritFromInner = new AComboBox.AComboBoxItem((Object)"Inherit pin pitch from inner ring", null, (Object)RingSpecType.INHERIT_FROM_INNER);
    protected final AComboBox.AComboBoxItem mInheritAllFromInner = new AComboBox.AComboBoxItem((Object)"Inherit pin pitch and pin shape from inner ring", null, (Object)RingSpecType.INHERIT_ALL_FROM_INNER);
    protected final AComboBox.AComboBoxItem mCountAndPitch = new AComboBox.AComboBoxItem((Object)"Specify row/column count and pitch", null, (Object)RingSpecType.COUNT_AND_PITCH);
    protected final AComboBox.AComboBoxItem mSizeAndPitch = new AComboBox.AComboBoxItem((Object)"Specify total width/height (pin centers) and pitch", null, (Object)RingSpecType.SIZE_AND_PITCH);
    protected final AComboBox.AComboBoxItem mSizeAndCount = new AComboBox.AComboBoxItem((Object)"Specify total width/height (pin centers) and row/column count", null, (Object)RingSpecType.SIZE_AND_COUNT);
    protected AComboBox<AComboBox.AComboBoxItem> mPackageStyleType;
    protected Object mPrevPackageStyle;
    protected JTextField mPerimeter;
    protected JTextField mOutlineWidth;
    protected JTextField mOutlineHeight;
    protected AComboBox<AComboBox.AComboBoxItem> mPinCorner;
    protected JLabel mPinCountInformation;
    protected ArrayOrRingInfo[] mArrayOrRingInfos = new ArrayOrRingInfo[3];

    public static void showUI() {
        new CreatePackageWizard(OrbitIO.getMainWindow());
    }

    public CreatePackageWizard(Component owner) {
        super(OrbitIO.getCurDb(), owner);
        this.setTitle("Create Package Parametrically");
        Unit unit = this.getUnitDist();
        this.mUnitsPanel = new UserUnitsPanel(unit);
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        JPanel contentPane = new JPanel();
        this.initContent(contentPane);
        l.add((Component)contentPane, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
        this.setResizable(true);
        l.addFillY();
        l.pushFillX();
        l.add((Component)this.mUnitsPanel, (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
        l.addFillX();
        l.add((Component)this.mButCancel, (GridBagConstraints)GridBagManager.RIGHT);
        l.newline();
        UIUtil.makeFootButton((AbstractButton)this.mButCancel);
        l.pop();
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mButCancel);
        UIUtil.enforceDialogMinSize((Window)((Object)this));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        UIUtil.center((Component)((Object)this));
        this.setVisible(true);
    }

    protected void initContent(JPanel contentPane) {
        contentPane.setLayout(new BorderLayout());
        this.mContentPanel.setLayout(this.mCardLayout);
        this.mForms.add(new SubstrateForm());
        this.mForms.add(new PackageForm());
        this.mForms.add(new RingForm());
        this.mForms.add(new BoundForm());
        for (StepForm form : this.mForms) {
            JPanel p = form.getContentPane();
            this.mContentPanel.add((Component)p, form.getCommand());
            JButton nagBtn = new JButton(form.getCommand());
            nagBtn.setName(form.getCommand());
            this.mProgress.add(nagBtn);
            this.mStepCmds.add(form.getCommand());
        }
        this.mCardLayout.show(this.mContentPanel, this.mForms.get(0).getCommand());
        JPanel headerPanel = new JPanel();
        GridBagManager l = new GridBagManager((Container)headerPanel);
        for (int i = 0; i < this.mProgress.size(); ++i) {
            JButton btn = this.mProgress.get(i);
            btn.setOpaque(false);
            btn.setContentAreaFilled(false);
            btn.setBorderPainted(false);
            btn.setMargin(new Insets(0, 0, 0, 0));
            btn.addActionListener(e -> {
                this.mCurrentStage = btn.getName();
                this.mCardLayout.show(this.mContentPanel, btn.getName());
                this.updateNav();
            });
            l.add((Component)btn, (GridBagConstraints)GridBagManager.LEFT);
            if (i != this.mProgress.size() - 1) {
                l.add(">");
                continue;
            }
            l.addFillX();
        }
        this.initFooter();
        contentPane.add((Component)headerPanel, "North");
        contentPane.add((Component)this.mContentPanel, "Center");
        contentPane.add((Component)this.mFooterPanel, "South");
        this.updateNav();
        this.populateSubstrates();
    }

    private JPanel createSubstrateCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Substrate Definition", (GridBagConstraints)GridBagManager.FILLALL);
        l.add((Component)new JLabel("Substrate:"), (GridBagConstraints)GridBagManager.LEFT);
        this.mCboSubstrate = new AComboBox();
        l.add(this.mCboSubstrate, (GridBagConstraints)GridBagManager.FILLX);
        this.mCboSubstrate.setRenderer((ListCellRenderer)new SubstrateTemplateListRenderer());
        JButton importBtn = new JButton();
        importBtn.setAction(new ActionImportSubstrate(importBtn, (Window)((Object)this)));
        UIUtil.makeToolBarButton((AbstractButton)importBtn);
        importBtn.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.IMPORT, (int)16, (int)16));
        l.add((Component)importBtn);
        JButton refresh = new JButton("");
        refresh.addActionListener(e -> this.populateSubstrates());
        UIUtil.makeToolBarButton((AbstractButton)refresh);
        refresh.setIcon(OrbitIcons.REFRESH);
        l.add((Component)refresh);
        l.newline();
        l.addFillX();
        l.addFillY();
        return panel;
    }

    protected Substrate getSubstrate() {
        SubstrateTemplate subTemp = (SubstrateTemplate)((Object)this.mCboSubstrate.getSelectedItem());
        if (subTemp != null) {
            return (Substrate)subTemp.first;
        }
        return null;
    }

    protected void populateSubstrates() {
        this.mCboSubstrate.removeAllItems();
        LinkedList<SubstrateTemplate> list = SubstrateTemplate.getSubstrateInstances(OrbitIO.getCurDb(), true, false, null);
        if (list.isEmpty()) {
            this.mCboSubstrate.addItem(null);
        }
        for (SubstrateTemplate st : list) {
            this.mCboSubstrate.addItem((Object)st);
        }
        this.optionsChanged();
    }

    protected JPanel createPackageCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Package Definition", (GridBagConstraints)GridBagManager.FILLALL);
        this.mPackageTemplateName = new JTextField("MyPackage", 20);
        l.add("Template:", (GridBagConstraints)GridBagManager.FILLX);
        l.add((Component)this.mPackageTemplateName, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        this.mPackageName = new JTextField("MyPackage", 20);
        l.add("Name:", (Component)this.mPackageName, (GridBagConstraints)GridBagManager.FILLX);
        this.mPackageName.addActionListener(e -> this.optionsChanged());
        l.newline();
        l.addFillX();
        l.addFillY();
        return panel;
    }

    private void updateNav() {
        HashMap<TextAttribute, Serializable> textAttrMap;
        JButton btn;
        int i;
        int index = this.mStepCmds.indexOf(this.mCurrentStage);
        this.mPrevBtn.setEnabled(index > 0);
        if (this.mForms.get(index).hasNextStep()) {
            this.mNextBtn.setText("Next");
        } else {
            this.mNextBtn.setText("Create");
        }
        for (i = 0; i <= index; ++i) {
            btn = this.mProgress.get(i);
            btn.setEnabled(true);
            btn.setText(this.mForms.get(i).getShortDesc());
            textAttrMap = new HashMap<TextAttribute, Serializable>();
            textAttrMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            textAttrMap.put(TextAttribute.FOREGROUND, Color.BLUE);
            btn.setFont(btn.getFont().deriveFont(textAttrMap));
        }
        for (i = index + 1; i < this.mStepCmds.size(); ++i) {
            btn = this.mProgress.get(i);
            btn.setEnabled(false);
            textAttrMap = new HashMap();
            textAttrMap.put(TextAttribute.FOREGROUND, Color.BLACK);
            btn.setFont(btn.getFont().deriveFont(textAttrMap));
        }
    }

    private void initFooter() {
        GridBagManager l = new GridBagManager((Container)this.mFooterPanel);
        this.mWarningTip.setForeground(Color.RED);
        l.add((Component)this.mWarningTip, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.add((Component)this.mPrevBtn, (GridBagConstraints)GridBagManager.RIGHT);
        l.add((Component)this.mNextBtn, (GridBagConstraints)GridBagManager.RIGHT);
        this.mNextBtn.addActionListener(e -> {
            int index = this.mStepCmds.indexOf(this.mCurrentStage);
            if (this.mForms.get(index).next()) {
                this.mCurrentStage = this.mStepCmds.get(index + 1);
                this.mCardLayout.show(this.mContentPanel, this.mCurrentStage);
                this.updateNav();
            } else if (this.mNextBtn.getText().equals("Create")) {
                this.createPackage();
            }
        });
        this.mPrevBtn.addActionListener(e -> {
            int index = this.mStepCmds.indexOf(this.mCurrentStage);
            this.mCurrentStage = this.mStepCmds.get(index - 1);
            this.mCardLayout.show(this.mContentPanel, this.mCurrentStage);
            this.updateNav();
        });
    }

    ARect calculateOutlineBounds() {
        APoint2D pitchVals;
        ARect rect;
        Unit unit = this.getUnitDist();
        if (this.hasOuterRing(this.mPackageStyleType.getSelectedItem())) {
            rect = this.mArrayOrRingInfos[2].calculateBounds();
            pitchVals = this.mArrayOrRingInfos[2].getPitchXAndY();
        } else {
            rect = this.mArrayOrRingInfos[0].calculateBounds();
            pitchVals = this.mArrayOrRingInfos[0].getPitchXAndY();
        }
        if (this.mBoundPerimeterBtn.isSelected()) {
            long calcPerimeter = rect.width() * 2L + rect.height() * 2L;
            long overidePerimeter = unit.fromUserString(this.mPerimeter.getText());
            long extra = overidePerimeter - calcPerimeter;
            if ((extra /= 4L) > 0L) {
                rect.setSize(rect.width() + extra, rect.height() + extra);
                rect.moveCenterTo(0L, 0L);
            }
        } else if (this.mBoundSpecificBtn.isSelected()) {
            rect.setSize(unit.fromUserString(this.mOutlineWidth.getText()).longValue(), unit.fromUserString(this.mOutlineHeight.getText()).longValue());
            rect.moveCenterTo(0L, 0L);
        } else {
            rect.setSize(rect.width() + pitchVals.getX(), rect.height() + pitchVals.getY());
            rect.moveCenterTo(0L, 0L);
        }
        return rect;
    }

    protected boolean confirmQuestionableInput(String msg) {
        ALog.logWarn((String)msg);
        int r = JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Confirm Data", 1, 3);
        return r == 0;
    }

    protected boolean validateInput() {
        try {
            AFieldValidator.validateText((JTextComponent)this.mPackageName);
            String childDeviceName = this.mPackageName.getText();
            Design parent = Design.getDesign((Db)this.mDb);
            if (parent.getChild(childDeviceName) != null) {
                ALog.logError((String)"Duplicate child device name %s", (Object[])new Object[]{childDeviceName});
                return false;
            }
            String templtName = this.mPackageTemplateName.getText();
            Substrate sub = this.getSubstrate();
            if (sub == null || DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)templtName) != null) {
                ALog.logError((String)"Duplicate device template name %s", (Object[])new Object[]{templtName});
                return false;
            }
            if (this.mBoundPerimeterBtn.isSelected()) {
                AFieldValidator.validateDouble((JTextField)this.mPerimeter);
            } else if (this.mBoundSpecificBtn.isSelected()) {
                AFieldValidator.validateDouble((JTextField)this.mOutlineWidth);
                AFieldValidator.validateDouble((JTextField)this.mOutlineHeight);
            }
            if (this.hasOuterRing(this.mPackageStyleType.getSelectedItem()) && !this.mArrayOrRingInfos[2].validateInput()) {
                return false;
            }
            if (this.hasInnerRing(this.mPackageStyleType.getSelectedItem()) && !this.mArrayOrRingInfos[1].validateInput()) {
                return false;
            }
            if (this.hasCenterArray(this.mPackageStyleType.getSelectedItem()) && !this.mArrayOrRingInfos[0].validateInput()) {
                return false;
            }
            if (this.hasOuterRing(this.mPackageStyleType.getSelectedItem()) && (this.hasInnerRing(this.mPackageStyleType.getSelectedItem()) ? !this.getInnerBounds(2).contains((AGeom)this.getBounds(1, true)) && !this.confirmQuestionableInput("Outer Ring and Inner ring may overlap. Proceed with current values?") : this.hasCenterArray(this.mPackageStyleType.getSelectedItem()) && !this.getInnerBounds(2).contains((AGeom)this.getBounds(0, true)) && !this.confirmQuestionableInput("Ring and array may overlap. Proceed with current values?"))) {
                return false;
            }
            return !this.hasInnerRing(this.mPackageStyleType.getSelectedItem()) || !this.hasCenterArray(this.mPackageStyleType.getSelectedItem()) || this.getInnerBounds(1).contains((AGeom)this.getBounds(0, true)) || this.confirmQuestionableInput("Inner Ring and Center Array bounds may overlap. Proceed with current values?");
        }
        catch (AFieldValidator.AFieldValidationException e) {
            return false;
        }
    }

    public void createPackage() {
        this.doCommand();
        OrbitIO o = (OrbitIO)AApp.getApp();
        Db db = o.getCurrentDb();
        Design currentDesign = Design.getDesign((Db)db);
        currentDesign.binAllDevices();
        o.zoomFitCurrentView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCommand() {
        if (!this.validateInput()) {
            return;
        }
        AGeomUtil.CompassCorners corner = (AGeomUtil.CompassCorners)((AComboBox.AComboBoxItem)this.mPinCorner.getSelectedItem()).getKey();
        try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)this.getDb(), (String)"Create Package");){
            RowAndColumn rowsAndCols;
            APoint2D pitchVals;
            this.informNumberOfPins(this.mPackageStyleType.getSelectedItem());
            ARect bounds = this.calculateOutlineBounds();
            Object deviceObj = Cp.exec((String)"com.sigrity.orbit.factory.DeviceFactory.startPackage(%s, \"%s\", \"%s\", %dL, %dL);", (Object[])new Object[]{CpHelper.getObjCmdStr(this.getSubstrate()), this.mPackageTemplateName.getText(), this.mPackageName.getText(), bounds.width(), bounds.height()});
            Device device = (Device)deviceObj;
            String deviceKeyStr = device.getKeyStr();
            Object sel = this.mPackageStyleType.getSelectedItem();
            if (!(sel instanceof AComboBox.AComboBoxItem)) {
                return;
            }
            AComboBox.AComboBoxItem cbi = (AComboBox.AComboBoxItem)sel;
            this.mArrayOrRingInfos[0].getPanel().setVisible(cbi.getKey() == PkgStyleType.UNIFORM_ARRAY || cbi.getKey() == PkgStyleType.ARRAY_1RING || cbi.getKey() == PkgStyleType.ARRAY_2RINGS);
            this.mArrayOrRingInfos[1].getPanel().setVisible(cbi.getKey() == PkgStyleType.ARRAY_2RINGS || cbi.getKey() == PkgStyleType.TWO_RINGS);
            this.mArrayOrRingInfos[2].getPanel().setVisible(cbi.getKey() == PkgStyleType.ARRAY_1RING || cbi.getKey() == PkgStyleType.ARRAY_2RINGS || cbi.getKey() == PkgStyleType.ONE_RING || cbi.getKey() == PkgStyleType.TWO_RINGS);
            if (this.hasOuterRing(sel)) {
                bounds = this.getBounds(2, false);
                pitchVals = this.getPitchXAndY(2);
                rowsAndCols = this.getNumRowsAndColumns(2);
                Cp.exec((String)"com.sigrity.orbit.factory.DeviceFactory.addArrayToPackage(curDb(), \"%s\", %dL, %dL, %dL, %dL, %dL, %dL, %s, %dL, %s, (float) %f);", (Object[])new Object[]{deviceKeyStr, bounds.getLL().getX(), bounds.getLL().getY(), pitchVals.getX(), pitchVals.getY(), rowsAndCols.getColumn(), rowsAndCols.getRow(), this.getShapeStr(2), this.getNumRings(2), Boolean.toString(this.getStagger(2)), this.getRotation(2)});
            }
            if (this.hasInnerRing(sel)) {
                bounds = this.getBounds(1, false);
                pitchVals = this.getPitchXAndY(1);
                rowsAndCols = this.getNumRowsAndColumns(1);
                Cp.exec((String)"com.sigrity.orbit.factory.DeviceFactory.addArrayToPackage(curDb(), \"%s\", %dL, %dL, %dL, %dL, %dL, %dL, %s, %dL, %s, (float) %f);", (Object[])new Object[]{deviceKeyStr, bounds.getLL().getX(), bounds.getLL().getY(), pitchVals.getX(), pitchVals.getY(), rowsAndCols.getColumn(), rowsAndCols.getRow(), this.getShapeStr(1), this.getNumRings(1), Boolean.toString(this.getStagger(1)), this.getRotation(1)});
            }
            if (this.hasCenterArray(sel)) {
                bounds = this.getBounds(0, false);
                pitchVals = this.getPitchXAndY(0);
                rowsAndCols = this.getNumRowsAndColumns(0);
                Cp.exec((String)"com.sigrity.orbit.factory.DeviceFactory.addArrayToPackage(curDb(), \"%s\", %dL, %dL, %dL, %dL, %dL, %dL, %s, 0L, %s, (float) %f);", (Object[])new Object[]{deviceKeyStr, bounds.getLL().getX(), bounds.getLL().getY(), pitchVals.getX(), pitchVals.getY(), rowsAndCols.getColumn(), rowsAndCols.getRow(), this.getShapeStr(0), Boolean.toString(this.getStagger(0)), this.getRotation(0)});
            }
            Cp.exec((String)"_MatrixrenamePackPins = com.sigrity.orbit.util.MatrixRenamePins.create(curDb(), \"%s\");", (Object[])new Object[]{device.getTemplate().getKeyStr()});
            Cp.exec((String)"_MatrixrenamePackPins.rename(false, \"%s\");", (Object[])new Object[]{corner.name()});
            Design currentDesign = Design.getDesign((Db)OrbitIO.getCurDb());
            currentDesign.binAllDevices();
            OrbitIO.getApp().zoomFitCurrentView();
        }
        catch (NumberFormatException err) {
            ALog.logError((Throwable)err, (String)"Invalid string: %s", (Object[])new Object[]{err.getMessage()});
        }
        finally {
            Cp.exec((String)"unset(\"_MatrixrenamePackPins\");", (Object[])new Object[0]);
        }
    }

    private String getShapeStr(int index) {
        if ((index == 1 || index == 0) && this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_ALL_FROM_OUTER) {
            return this.getShapeStr(2);
        }
        if (index == 0 && this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_ALL_FROM_INNER) {
            return this.getShapeStr(1);
        }
        Unit unit = this.getUnitDist();
        return String.format("\"%s\", %dL, %dL", this.mArrayOrRingInfos[index].mCBShape.getSelectedItem().toString(), unit.fromUserString(this.mArrayOrRingInfos[index].mTxtPadSize.getText()), unit.fromUserString(this.mArrayOrRingInfos[index].mTxtPadSize2.getText()));
    }

    private ARect getShapeBounds(int index) {
        if ((index == 1 || index == 0) && this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_ALL_FROM_OUTER) {
            return this.getShapeBounds(2);
        }
        if (index == 0 && this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_ALL_FROM_INNER) {
            return this.getShapeBounds(1);
        }
        return this.mArrayOrRingInfos[index].getShapeBounds();
    }

    private long getNumRings(int index) {
        return this.mArrayOrRingInfos[index].getRingDepth();
    }

    private boolean getSpacingFromOuterRingData(int index) {
        return !(index != 1 && index != 0 || this.mArrayOrRingInfos[index].getRingType() != RingSpecType.INHERIT_FROM_OUTER && this.mArrayOrRingInfos[index].getRingType() != RingSpecType.INHERIT_ALL_FROM_OUTER);
    }

    private boolean getSpacingFromInnerRingData(int index) {
        return index == 0 && (this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_FROM_INNER || this.mArrayOrRingInfos[index].getRingType() == RingSpecType.INHERIT_ALL_FROM_INNER);
    }

    private ARect getBounds(int index, boolean includeShape) {
        ARect bounds = new ARect();
        APoint2D pitchVals = this.getPitchXAndY(index);
        RowAndColumn rowsAndCols = this.getNumRowsAndColumns(index);
        bounds.setSize(pitchVals.getX() * (long)(rowsAndCols.getColumn() - 1), pitchVals.getY() * (long)(rowsAndCols.getRow() - 1));
        bounds.moveCenterTo(0L, 0L);
        if (includeShape) {
            ARect sBnds = this.getShapeBounds(index);
            bounds = bounds.expandBy(sBnds.width() / 2L, sBnds.height() / 2L);
        }
        return bounds;
    }

    private ARect getInnerBounds(int index) {
        if (index == 0) {
            return new ARect();
        }
        ARect sBnds = this.getShapeBounds(index);
        ARect bounds = this.getBounds(index, false);
        APoint2D pitchVals = this.getPitchXAndY(index);
        long offsetX = (this.mArrayOrRingInfos[index].getRingDepth() - 1L) * pitchVals.getX();
        long offsetY = (this.mArrayOrRingInfos[index].getRingDepth() - 1L) * pitchVals.getY();
        return bounds.expandBy(-offsetX - sBnds.width() / 2L, -offsetY - sBnds.height() / 2L);
    }

    private APoint2D getPitchXAndY(int index) {
        if (this.getSpacingFromOuterRingData(index)) {
            return this.mArrayOrRingInfos[2].getPitchXAndY();
        }
        if (this.getSpacingFromInnerRingData(index)) {
            return this.getPitchXAndY(1);
        }
        return this.mArrayOrRingInfos[index].getPitchXAndY();
    }

    private int calculateNumberOfPins(int index) {
        RowAndColumn rowCol = this.getNumRowsAndColumns(index);
        int num = rowCol.getColumn() * rowCol.getRow() - (this.getIncludeRingDepth(index) ? (rowCol.getColumn() - this.getRingDepth(index) * 2) * (rowCol.getRow() - this.getRingDepth(index) * 2) : 0);
        if (!this.getStagger(index)) {
            return num > 0 ? num : 0;
        }
        int total = rowCol.getColumn() * rowCol.getRow() / 2 + (rowCol.getRow() % 2 == 1 ? 1 : 0);
        if (this.getIncludeRingDepth(index)) {
            int numCs = rowCol.getColumn() - this.getRingDepth(index) * 2;
            int numRs = rowCol.getRow() - this.getRingDepth(index) * 2;
            total -= numCs * numRs / 2 + (numRs % 2 == 1 ? 1 : 0);
        }
        return total > 0 ? total : 0;
    }

    private boolean getIncludeRingDepth(int index) {
        return this.mArrayOrRingInfos[index].getIncludeRingDepth();
    }

    private int getRingDepth(int index) {
        return (int)this.mArrayOrRingInfos[index].getRingDepth();
    }

    private RowAndColumn getNumRowsAndColumns(int index) {
        if (this.getSpacingFromOuterRingData(index)) {
            RowAndColumn other = this.mArrayOrRingInfos[2].getNumRowsAndColumns();
            other.setColumn(other.getColumn() - (int)(this.mArrayOrRingInfos[2].getRingDepth() + this.mArrayOrRingInfos[index].getNumRingsToSkip()) * 2);
            other.setRow(other.getRow() - (int)(this.mArrayOrRingInfos[2].getRingDepth() + this.mArrayOrRingInfos[index].getNumRingsToSkip()) * 2);
            return other;
        }
        if (this.getSpacingFromInnerRingData(index)) {
            RowAndColumn other = this.getNumRowsAndColumns(1);
            other.setColumn(other.getColumn() - (int)(this.mArrayOrRingInfos[1].getRingDepth() + this.mArrayOrRingInfos[index].getNumRingsToSkip()) * 2);
            other.setRow(other.getRow() - (int)(this.mArrayOrRingInfos[1].getRingDepth() + this.mArrayOrRingInfos[index].getNumRingsToSkip()) * 2);
            return other;
        }
        return this.mArrayOrRingInfos[index].getNumRowsAndColumns();
    }

    private boolean getStagger(int index) {
        JCheckBox checkbox = this.mArrayOrRingInfos[index].getStaggerCB();
        if (this.getSpacingFromOuterRingData(index)) {
            checkbox = this.mArrayOrRingInfos[2].getStaggerCB();
        } else if (this.getSpacingFromInnerRingData(index)) {
            return this.getStagger(1);
        }
        return checkbox.isSelected();
    }

    private double getRotation(int index) {
        return this.mArrayOrRingInfos[index].getRotation();
    }

    private boolean hasOuterRing(Object sel) {
        if (!(sel instanceof AComboBox.AComboBoxItem)) {
            return false;
        }
        AComboBox.AComboBoxItem cbi = (AComboBox.AComboBoxItem)sel;
        return cbi.getKey() != PkgStyleType.UNIFORM_ARRAY;
    }

    private boolean hasInnerRing(Object sel) {
        if (!(sel instanceof AComboBox.AComboBoxItem)) {
            return false;
        }
        AComboBox.AComboBoxItem cbi = (AComboBox.AComboBoxItem)sel;
        return cbi.getKey() == PkgStyleType.ARRAY_2RINGS || cbi.getKey() == PkgStyleType.TWO_RINGS;
    }

    private boolean hasCenterArray(Object sel) {
        if (!(sel instanceof AComboBox.AComboBoxItem)) {
            return false;
        }
        AComboBox.AComboBoxItem cbi = (AComboBox.AComboBoxItem)sel;
        return cbi.getKey() == PkgStyleType.UNIFORM_ARRAY || cbi.getKey() == PkgStyleType.ARRAY_1RING || cbi.getKey() == PkgStyleType.ARRAY_2RINGS;
    }

    protected void outlineVisibility(Object sel) {
        if (this.mBoundPerimeterBtn.isSelected()) {
            this.mPerimeter.setEnabled(true);
            this.mOutlineWidth.setEnabled(false);
            this.mOutlineHeight.setEnabled(false);
            if (this.hasOuterRing(sel)) {
                this.mPerimeter.setText(this.mArrayOrRingInfos[2].calculateDefaultPerimeterStr());
            } else {
                this.mPerimeter.setText(this.mArrayOrRingInfos[0].calculateDefaultPerimeterStr());
            }
        } else if (this.mBoundSpecificBtn.isSelected()) {
            this.mPerimeter.setEnabled(false);
            this.mOutlineWidth.setEnabled(true);
            this.mOutlineHeight.setEnabled(true);
            if (this.hasOuterRing(sel)) {
                this.mOutlineWidth.setText(this.mArrayOrRingInfos[2].calculateDefaultOutlineWidthStr());
                this.mOutlineHeight.setText(this.mArrayOrRingInfos[2].calculateDefaultOutlineHeightStr());
            } else {
                this.mOutlineWidth.setText(this.mArrayOrRingInfos[0].calculateDefaultOutlineWidthStr());
                this.mOutlineHeight.setText(this.mArrayOrRingInfos[0].calculateDefaultOutlineHeightStr());
            }
        } else {
            this.mPerimeter.setEnabled(false);
            this.mOutlineWidth.setEnabled(false);
            this.mOutlineHeight.setEnabled(false);
            if (this.hasOuterRing(sel)) {
                this.mOutlineWidth.setText(this.mArrayOrRingInfos[2].calculateDefaultOutlineWidthStr());
                this.mOutlineHeight.setText(this.mArrayOrRingInfos[2].calculateDefaultOutlineHeightStr());
            } else {
                this.mOutlineWidth.setText(this.mArrayOrRingInfos[0].calculateDefaultOutlineWidthStr());
                this.mOutlineHeight.setText(this.mArrayOrRingInfos[0].calculateDefaultOutlineHeightStr());
            }
        }
    }

    protected void informNumberOfPins(Object sel) {
        long cur;
        long total = 0L;
        Object ans = "Pin count:   ";
        if (this.hasOuterRing(sel)) {
            cur = this.calculateNumberOfPins(2);
            total += cur;
            ans = (String)ans + "   Outer: " + cur;
        }
        if (this.hasInnerRing(sel)) {
            cur = this.calculateNumberOfPins(1);
            total += cur;
            ans = (String)ans + "   Inner: " + cur;
        }
        if (this.hasCenterArray(sel)) {
            cur = this.calculateNumberOfPins(0);
            total += cur;
            ans = (String)ans + "   Center: " + cur;
        }
        ans = (String)ans + " Total: " + total;
        this.mPinCountInformation.setText((String)ans);
    }

    protected void optionsChanged() {
        Window w;
        this.updateNav();
        if (this.mPackageStyleType != null) {
            Object sel = this.mPackageStyleType.getSelectedItem();
            this.mArrayOrRingInfos[0].getPanel().setVisible(this.hasCenterArray(sel));
            this.mArrayOrRingInfos[1].getPanel().setVisible(this.hasInnerRing(sel));
            this.mArrayOrRingInfos[2].getPanel().setVisible(this.hasOuterRing(sel));
            if (this.hasCenterArray(sel)) {
                this.adjustAllowableRingTypes(0, this.mPrevPackageStyle);
                this.mArrayOrRingInfos[0].visibility();
            }
            if (this.hasInnerRing(sel)) {
                this.adjustAllowableRingTypes(1, this.mPrevPackageStyle);
                this.mArrayOrRingInfos[1].visibility();
            }
            if (this.hasOuterRing(sel)) {
                this.mArrayOrRingInfos[2].visibility();
            }
            if (this.mPrevPackageStyle != sel) {
                this.mPrevPackageStyle = sel;
            }
            this.outlineVisibility(sel);
            this.informNumberOfPins(sel);
        }
        if ((w = UIUtil.getParentWindow((Component)((Object)this))) != null) {
            w.invalidate();
            w.pack();
        }
        this.invalidate();
        this.pack();
    }

    public void adjustAllowableRingTypes(int index, Object prevSel) {
        AComboBox.AComboBoxItem sel = (AComboBox.AComboBoxItem)this.mPackageStyleType.getSelectedItem();
        Object curRingSpecType = this.mArrayOrRingInfos[index].getSpecType().getSelectedItem();
        if (index == 0) {
            if (sel.getKey() == PkgStyleType.ARRAY_1RING) {
                AComboBox.AComboBoxItem[] ringType = new AComboBox.AComboBoxItem[]{this.mInheritAllFromOuter, this.mInheritFromOuter, this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
                this.mArrayOrRingInfos[0].setSpecTypes(ringType);
            } else if (sel.getKey() == PkgStyleType.ARRAY_2RINGS) {
                if (!this.hasInnerRing(prevSel)) {
                    if (curRingSpecType == this.mInheritAllFromOuter) {
                        curRingSpecType = this.mInheritAllFromInner;
                    } else if (curRingSpecType == this.mInheritFromOuter) {
                        curRingSpecType = this.mInheritFromInner;
                    }
                }
                AComboBox.AComboBoxItem[] ringType = new AComboBox.AComboBoxItem[]{this.mInheritAllFromOuter, this.mInheritFromOuter, this.mInheritAllFromInner, this.mInheritFromInner, this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
                this.mArrayOrRingInfos[0].setSpecTypes(ringType);
            } else if (sel.getKey() == PkgStyleType.UNIFORM_ARRAY) {
                AComboBox.AComboBoxItem[] ringType = new AComboBox.AComboBoxItem[]{this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
                this.mArrayOrRingInfos[0].setSpecTypes(ringType);
            }
            this.mArrayOrRingInfos[index].setSpecType(curRingSpecType);
        } else if (index == 1) {
            if (sel.getKey() == PkgStyleType.ARRAY_1RING) {
                AComboBox.AComboBoxItem[] ringType = new AComboBox.AComboBoxItem[]{this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
                this.mArrayOrRingInfos[index].setSpecTypes(ringType);
            } else if (sel.getKey() == PkgStyleType.ARRAY_2RINGS || sel.getKey() == PkgStyleType.TWO_RINGS) {
                AComboBox.AComboBoxItem[] ringType = new AComboBox.AComboBoxItem[]{this.mInheritAllFromOuter, this.mInheritFromOuter, this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
                this.mArrayOrRingInfos[index].setSpecTypes(ringType);
            }
            this.mArrayOrRingInfos[index].setSpecType(curRingSpecType);
        }
    }

    public JPanel createRingCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push("Pin Pattern", (GridBagConstraints)GridBagManager.FILLX);
        l.push((GridBagConstraints)GridBagManager.LEFT.insetHoriz(0).width(2));
        l.add((Component)new JLabel("Pattern Type:"), (GridBagConstraints)GridBagManager.LEFT);
        Object[] pkgType = new AComboBox.AComboBoxItem[]{this.mArray2Rings, this.mArray1Ring, this.m2Rings, this.m1Ring, this.mUniformArray};
        this.mPackageStyleType = new AComboBox(pkgType);
        this.mPackageStyleType.addActionListener(e -> this.optionsChanged());
        this.mPrevPackageStyle = this.mArray2Rings;
        l.add(this.mPackageStyleType);
        l.newline();
        l.add((Component)new JLabel("Start Pin Numbers:"), (GridBagConstraints)GridBagManager.LEFT);
        Object[] corners = new AComboBox.AComboBoxItem[]{new AComboBox.AComboBoxItem((Object)"South-West", DBEResources.ICON_VIA_NE, (Object)AGeomUtil.CompassCorners.SW), new AComboBox.AComboBoxItem((Object)"South-East", DBEResources.ICON_VIA_NW, (Object)AGeomUtil.CompassCorners.SE), new AComboBox.AComboBoxItem((Object)"North-West", DBEResources.ICON_VIA_SE, (Object)AGeomUtil.CompassCorners.NW), new AComboBox.AComboBoxItem((Object)"North-East", DBEResources.ICON_VIA_SW, (Object)AGeomUtil.CompassCorners.NE)};
        this.mPinCorner = new AComboBox(corners);
        l.add(this.mPinCorner);
        l.pop();
        l.addFillX();
        l.newline();
        AComboBox.AComboBoxItem[] centerRingTypes = new AComboBox.AComboBoxItem[]{this.mInheritAllFromInner, this.mInheritFromInner, this.mInheritAllFromOuter, this.mInheritFromOuter, this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
        this.mArrayOrRingInfos[0] = new ArrayOrRingInfo("Center Array", centerRingTypes, "12500.0", "6", "2000.00", false, "2");
        AComboBox.AComboBoxItem[] innerRingTypes = new AComboBox.AComboBoxItem[]{this.mInheritAllFromOuter, this.mInheritFromOuter, this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
        this.mArrayOrRingInfos[1] = new ArrayOrRingInfo("Inner Ring", innerRingTypes, "7500.0", "12", "2000.00", true, "2");
        AComboBox.AComboBoxItem[] outerRingTypes = new AComboBox.AComboBoxItem[]{this.mCountAndPitch, this.mSizeAndPitch, this.mSizeAndCount};
        this.mArrayOrRingInfos[2] = new ArrayOrRingInfo("Outer Ring", outerRingTypes, "7500.0", "20", "2000.00", true, "2");
        DataFocusListener dfl = new DataFocusListener();
        l.push((GridBagConstraints)GridBagManager.FILLX.insetHoriz(0).width(2));
        this.mArrayOrRingInfos[2].initalize(l, e -> this.optionsChanged(), dfl);
        this.mArrayOrRingInfos[1].initalize(l, e -> this.optionsChanged(), dfl);
        this.mArrayOrRingInfos[0].initalize(l, e -> this.optionsChanged(), dfl);
        this.mArrayOrRingInfos[0].getSpecType().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[0].getStaggerCB().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[0].getCBShape().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[1].getSpecType().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[1].getStaggerCB().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[1].getCBShape().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[2].getSpecType().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[2].getStaggerCB().addActionListener(e -> this.optionsChanged());
        this.mArrayOrRingInfos[2].getCBShape().addActionListener(e -> this.optionsChanged());
        l.pop();
        l.pop();
        return panel;
    }

    protected JPanel createBoundCardPanel() {
        JPanel panel = new JPanel();
        GridBagManager l = new GridBagManager((Container)panel);
        l.push(CMD_BOUND, (GridBagConstraints)GridBagManager.FILLALL);
        this.mBoundDefaultBtn.setToolTipText("Calculate default outline, By default a perimeter equal to 1/2 the ball pad pitch will be added");
        this.mBoundPerimeterBtn.setToolTipText("Overide default outline perimeter");
        this.mBoundSpecificBtn.setToolTipText("Overide default outline by width/height");
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreatePackageWizard.this.outlineVisibility(CreatePackageWizard.this.mPackageStyleType.getSelectedItem());
            }
        };
        this.mBoundDefaultBtn.addItemListener(listener);
        this.mBoundPerimeterBtn.addItemListener(listener);
        this.mBoundSpecificBtn.addItemListener(listener);
        this.mPerimeter = new JTextField("200.0", 10);
        this.mUnitsPanel.addTextField(this.mPerimeter);
        this.mOutlineWidth = new JTextField("200.0", 10);
        this.mUnitsPanel.addTextField(this.mOutlineWidth);
        this.mOutlineWidth.setToolTipText("Width of outline.");
        this.mOutlineWidth.setEnabled(false);
        this.mOutlineHeight = new JTextField("200.0", 10);
        this.mUnitsPanel.addTextField(this.mOutlineHeight);
        this.mOutlineHeight.setToolTipText("Height of outline.");
        this.mOutlineHeight.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mBoundDefaultBtn);
        bg.add(this.mBoundPerimeterBtn);
        bg.add(this.mBoundSpecificBtn);
        this.mBoundDefaultBtn.setSelected(true);
        l.add((Component)this.mBoundDefaultBtn, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add((Component)this.mBoundPerimeterBtn, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.indent();
        l.add("Perimeter:", (Component)this.mPerimeter, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.add((Component)this.mBoundSpecificBtn, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.indent();
        l.add("Width", (Component)this.mOutlineWidth, (GridBagConstraints)GridBagManager.LEFT);
        l.newline();
        l.indent();
        l.add("Height", (Component)this.mOutlineHeight, (GridBagConstraints)GridBagManager.LEFT);
        l.addFillX();
        l.newline();
        l.addFillY();
        l.newline();
        l.push((GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.addFillX();
        this.mPinCountInformation = new JLabel("Pin count: 0 + 0 + 10 = 10");
        l.add((Component)this.mPinCountInformation, (GridBagConstraints)GridBagManager.RIGHT);
        l.popNl();
        return panel;
    }

    @Override
    public Unit getUnitDist() {
        if (this.mUnitsPanel != null) {
            return this.mUnitsPanel.getUnit();
        }
        Design d = this.getDesign();
        if (d == null) {
            return Design.getDefaultUnitDist();
        }
        return d.getUnit();
    }

    protected class DataFocusListener
    implements FocusListener {
        protected DataFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            CreatePackageWizard.this.optionsChanged();
        }
    }

    protected class ArrayOrRingInfo {
        protected JPanel mPanel;
        protected String mName;
        protected AComboBox<AComboBox.AComboBoxItem> mSpecType;
        protected JLabel mRowsLabel;
        protected JTextField mRowsVal;
        protected JLabel mColumnsLabel;
        protected JTextField mColumnsVal;
        protected JLabel mPinPitchXLabel;
        protected JTextField mPinPitchXVal;
        protected JLabel mPinPitchYLabel;
        protected JTextField mPinPitchYVal;
        protected JCheckBox mStaggerCB;
        protected boolean mIncludeRingDepth;
        protected JLabel mRingDepthLabel;
        protected JTextField mRingDepthVal;
        protected String mInsetFromStr;
        protected JLabel mInsetLabel;
        protected JTextField mInsetVal;
        protected JLabel mShapeLabel;
        protected JComboBox<PadTemplate.PadShapeStyle> mCBShape;
        protected JLabel mLabelRotation;
        protected JTextField mTxtRotation;
        protected JLabel mLblPadSize;
        protected JTextField mTxtPadSize;
        protected JLabel mTxtPadSize2Label;
        protected JTextField mTxtPadSize2;
        protected JTextField mTxtPadName;
        protected JLabel mWidthLabel;
        protected JLabel mHeightLabel;
        protected JTextField mWidthVal;
        protected JTextField mHeightVal;
        protected AComboBox.AComboBoxItem[] mRingTypes;
        protected String mDefaultWidthStr;
        protected String mDefaultColStr;
        protected String mDefaultPitchStr;

        ArrayOrRingInfo(String name, AComboBox.AComboBoxItem[] ringTypes, String defaultWidthStr, String defaultColStr, String defaultPitchStr, boolean includeRingDepth, String insetFromStr) {
            this.mName = name;
            this.mInsetFromStr = insetFromStr;
            this.mRingTypes = ringTypes;
            this.mDefaultWidthStr = defaultWidthStr;
            this.mDefaultColStr = defaultColStr;
            this.mDefaultPitchStr = defaultPitchStr;
            this.mIncludeRingDepth = includeRingDepth;
        }

        public JPanel getPanel() {
            return this.mPanel;
        }

        public AComboBox<AComboBox.AComboBoxItem> getSpecType() {
            return this.mSpecType;
        }

        public void setSpecType(Object obj) {
            this.mSpecType.setSelectedItem(obj);
        }

        public JCheckBox getStaggerCB() {
            return this.mStaggerCB;
        }

        public JComboBox<PadTemplate.PadShapeStyle> getCBShape() {
            return this.mCBShape;
        }

        private void setSpecTypes(AComboBox.AComboBoxItem[] ringTypes) {
            this.mSpecType.setModel(new DefaultComboBoxModel<AComboBox.AComboBoxItem>(ringTypes));
        }

        public RingSpecType getRingType() {
            return (RingSpecType)((Object)((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey());
        }

        public long getRingDepth() {
            return Integer.parseInt(this.mRingDepthVal.getText());
        }

        public boolean getIncludeRingDepth() {
            return this.mIncludeRingDepth;
        }

        public long getNumRingsToSkip() {
            return Integer.parseInt(this.mInsetVal.getText());
        }

        public void initalize(GridBagManager l, ActionListener actionListener, FocusListener focusListener) {
            this.mPanel = l.push(this.mName, (GridBagConstraints)GridBagManager.FILLX.width(2));
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mSpecType = new AComboBox((Object[])this.mRingTypes);
            this.mSpecType.addActionListener(actionListener);
            l.add(this.mSpecType, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mWidthLabel = new JLabel("Width:");
            l.add((Component)this.mWidthLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mWidthVal = new JTextField(this.mDefaultWidthStr, 10);
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mWidthVal);
            this.mWidthVal.addFocusListener(focusListener);
            this.mWidthLabel.setLabelFor(this.mWidthVal);
            l.add((Component)this.mWidthVal, (GridBagConstraints)GridBagManager.LEFT);
            this.mHeightLabel = new JLabel("Height:");
            l.add((Component)this.mHeightLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mHeightVal = new JTextField(this.mDefaultWidthStr, 10);
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mHeightVal);
            this.mHeightVal.addFocusListener(focusListener);
            this.mHeightLabel.setLabelFor(this.mHeightVal);
            l.add((Component)this.mHeightVal, (GridBagConstraints)GridBagManager.LEFT);
            this.mColumnsLabel = new JLabel("Columns:");
            l.add((Component)this.mColumnsLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mColumnsVal = new JTextField(this.mDefaultColStr, 5);
            this.mColumnsVal.addFocusListener(focusListener);
            this.mColumnsLabel.setLabelFor(this.mColumnsVal);
            l.add((Component)this.mColumnsVal, (GridBagConstraints)GridBagManager.LEFT);
            this.mRowsLabel = new JLabel("Rows:");
            l.add((Component)this.mRowsLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mRowsVal = new JTextField(this.mDefaultColStr, 5);
            this.mRowsVal.addFocusListener(focusListener);
            this.mRowsLabel.setLabelFor(this.mRowsVal);
            l.add((Component)this.mRowsVal, (GridBagConstraints)GridBagManager.LEFT);
            this.mPinPitchXLabel = new JLabel("Pin Pitch: X:");
            l.add((Component)this.mPinPitchXLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mPinPitchXVal = new JTextField(this.mDefaultPitchStr, 10);
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mPinPitchXVal);
            this.mPinPitchXVal.addFocusListener(focusListener);
            this.mPinPitchXVal.setToolTipText("If background color is yellow, the number of columns will be truncated because the width / pitch X is not an integer value.");
            this.mPinPitchXLabel.setLabelFor(this.mPinPitchXVal);
            l.add((Component)this.mPinPitchXVal, (GridBagConstraints)GridBagManager.LEFT);
            this.mPinPitchYLabel = new JLabel("Y:");
            l.add((Component)this.mPinPitchYLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mPinPitchYVal = new JTextField(this.mDefaultPitchStr, 10);
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mPinPitchYVal);
            this.mPinPitchYVal.addFocusListener(focusListener);
            this.mPinPitchYVal.setToolTipText("If background color is yellow, the number of rows will be truncated because the height / pitch Y is not an integer value.");
            this.mPinPitchYLabel.setLabelFor(this.mPinPitchYVal);
            l.add((Component)this.mPinPitchYVal, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            if (this.mIncludeRingDepth) {
                this.mRingDepthLabel = new JLabel("Ring Depth:");
                l.add((Component)this.mRingDepthLabel, (GridBagConstraints)GridBagManager.LEFT);
                this.mRingDepthVal = new JTextField("2", 5);
                this.mRingDepthVal.addFocusListener(focusListener);
                this.mRingDepthLabel.setLabelFor(this.mRingDepthVal);
                l.add((Component)this.mRingDepthVal, (GridBagConstraints)GridBagManager.LEFT);
            }
            if (this.mInsetFromStr != null) {
                String label = "Number of rings to skip from " + this.mInsetFromStr + ":";
                this.mInsetLabel = new JLabel(label);
                label = "Inset from " + this.mInsetFromStr + " by this number of row/columns that get skipped.";
                this.mInsetLabel.setToolTipText(label);
                l.add((Component)this.mInsetLabel, (GridBagConstraints)GridBagManager.LEFT);
                this.mInsetVal = new JTextField("2", 5);
                this.mInsetVal.addFocusListener(focusListener);
                this.mInsetLabel.setLabelFor(this.mInsetVal);
                l.add((Component)this.mInsetVal, (GridBagConstraints)GridBagManager.LEFT);
            }
            this.mStaggerCB = new JCheckBox("Stagger Pins");
            this.mStaggerCB.addFocusListener(focusListener);
            this.mStaggerCB.setToolTipText("If checked, adjacent pins will be offset by the pitch values.");
            l.add((Component)this.mStaggerCB, (GridBagConstraints)GridBagManager.LEFT);
            l.popNl();
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            this.mShapeLabel = new JLabel("Shape:");
            l.add((Component)this.mShapeLabel, (GridBagConstraints)GridBagManager.LEFT);
            this.mCBShape = (JComboBox)l.add(new JComboBox());
            this.mCBShape.removeAllItems();
            for (PadTemplate.PadShapeStyle shape : PadTemplate.PadShapeStyle.values()) {
                this.mCBShape.addItem(shape);
            }
            this.mCBShape.addActionListener(actionListener);
            this.mLblPadSize = l.add("Size:", (GridBagConstraints)GridBagManager.LEFT);
            this.mTxtPadSize = (JTextField)l.add((Component)new JTextField(10));
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mTxtPadSize);
            this.mTxtPadSize.setText("1000");
            this.mTxtPadSize2Label = l.add("x");
            this.mTxtPadSize2 = (JTextField)l.add((Component)new JTextField(10));
            CreatePackageWizard.this.mUnitsPanel.addTextField(this.mTxtPadSize2);
            this.mTxtPadSize2.setText("1500");
            this.mLabelRotation = l.add("Rotation:");
            this.mTxtRotation = (JTextField)l.add((Component)new JTextField(10));
            this.mTxtRotation.setText("0.00");
            l.popNl();
            l.addFillX();
            l.popNl();
        }

        public void visibility() {
            this.mWidthVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH);
            this.mHeightVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH);
            this.mWidthLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH);
            this.mHeightLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH);
            this.mRowsLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT);
            this.mRowsVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT);
            this.mColumnsLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT);
            this.mColumnsVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT);
            this.mPinPitchXLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH);
            this.mPinPitchXVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH);
            this.mPinPitchYLabel.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH);
            this.mPinPitchYVal.setVisible(((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH);
            boolean shapesVisible = ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_OUTER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_INNER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH;
            this.mShapeLabel.setVisible(shapesVisible);
            this.mStaggerCB.setVisible(shapesVisible && ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() != RingSpecType.INHERIT_FROM_OUTER && ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() != RingSpecType.INHERIT_FROM_INNER);
            this.mCBShape.setVisible(shapesVisible);
            this.mLblPadSize.setVisible(shapesVisible);
            this.mTxtPadSize.setVisible(shapesVisible);
            boolean needInsetOuter = ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_ALL_FROM_OUTER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_OUTER;
            boolean needInset = needInsetOuter || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_ALL_FROM_INNER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_INNER;
            this.mInsetLabel.setVisible(needInset);
            this.mInsetVal.setVisible(needInset);
            this.mInsetLabel.setText(needInsetOuter ? "Number of rings to skip from outer ring:" : "Number of rings to skip from inner ring");
            this.mInsetLabel.setToolTipText(needInsetOuter ? "Inset from outer ring by this number of row/columns that get skipped." : "Inset from inner ring by this number of row/columns that get skipped.");
            if (this.getRingType() == RingSpecType.SIZE_AND_PITCH) {
                Unit unit = CreatePackageWizard.this.getUnitDist();
                if (unit.fromUserString(this.mHeightVal.getText(), 0L) % unit.fromUserString(this.mPinPitchYVal.getText(), 1L) == 0L) {
                    this.mPinPitchYVal.setBackground(ColorOk);
                } else {
                    this.mPinPitchYVal.setBackground(ColorWarn);
                }
                if (unit.fromUserString(this.mWidthVal.getText(), 0L) % unit.fromUserString(this.mPinPitchXVal.getText(), 1L) == 0L) {
                    this.mPinPitchXVal.setBackground(ColorOk);
                } else {
                    this.mPinPitchXVal.setBackground(ColorWarn);
                }
            } else {
                this.mPinPitchYVal.setBackground(ColorOk);
                this.mPinPitchXVal.setBackground(ColorOk);
            }
            PadTemplate.PadShapeStyle padShapeStyle = (PadTemplate.PadShapeStyle)this.mCBShape.getSelectedItem();
            boolean need2PadShapeSizes = padShapeStyle == PadTemplate.PadShapeStyle.Rect;
            boolean needRot = padShapeStyle != PadTemplate.PadShapeStyle.Circle;
            this.mLabelRotation.setVisible(shapesVisible && needRot);
            this.mTxtRotation.setVisible(shapesVisible && needRot);
            this.mTxtPadSize.setVisible(shapesVisible);
            this.mTxtPadSize2Label.setVisible(shapesVisible && need2PadShapeSizes);
            this.mTxtPadSize2.setVisible(shapesVisible && need2PadShapeSizes);
            if (padShapeStyle == PadTemplate.PadShapeStyle.Circle || padShapeStyle == PadTemplate.PadShapeStyle.Octagon) {
                this.mLblPadSize.setText("Diameter:");
            } else {
                this.mLblPadSize.setText("Size:");
            }
        }

        RowAndColumn getNumRowsAndColumns() {
            if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH) {
                return new RowAndColumn(AFieldValidator.getInt((String)this.mRowsVal.getText(), (int)1), AFieldValidator.getInt((String)this.mColumnsVal.getText(), (int)1));
            }
            Unit unit = CreatePackageWizard.this.getUnitDist();
            return new RowAndColumn((int)(unit.fromUserString(this.mHeightVal.getText(), 0L) / unit.fromUserString(this.mPinPitchYVal.getText(), 1L)) + 1, (int)(unit.fromUserString(this.mWidthVal.getText(), 0L) / unit.fromUserString(this.mPinPitchXVal.getText(), 1L)) + 1);
        }

        APoint2D getPitchXAndY() {
            Unit unit = CreatePackageWizard.this.getUnitDist();
            if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH) {
                return new APoint2D(unit.fromUserString(this.mPinPitchXVal.getText(), 0L), unit.fromUserString(this.mPinPitchYVal.getText(), 0L));
            }
            return new APoint2D(unit.fromUserString(this.mHeightVal.getText(), 0L) / (long)AFieldValidator.getInt((String)this.mColumnsVal.getText(), (int)1), unit.fromUserString(this.mWidthVal.getText(), 0L) / (long)AFieldValidator.getInt((String)this.mRowsVal.getText(), (int)1));
        }

        ARect calculateBounds() {
            long height;
            long width;
            Unit unit = CreatePackageWizard.this.getUnitDist();
            if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH) {
                width = unit.fromUserString(this.mWidthVal.getText(), 0L);
                height = unit.fromUserString(this.mHeightVal.getText(), 0L);
            } else {
                width = (long)(AFieldValidator.getInt((String)this.mColumnsVal.getText(), (int)1) - 1) * unit.fromUserString(this.mPinPitchXVal.getText(), 0L);
                height = (long)(AFieldValidator.getInt((String)this.mRowsVal.getText(), (int)1) - 1) * unit.fromUserString(this.mPinPitchYVal.getText(), 0L);
            }
            ARect rect = new ARect();
            rect.setSize(width, height);
            rect.moveCenterTo(0L, 0L);
            return rect;
        }

        private ARect getShapeBounds() {
            Unit unit = CreatePackageWizard.this.getUnitDist();
            long width = unit.fromUserString(this.mTxtPadSize.getText());
            long height = unit.fromUserString(this.mTxtPadSize2.getText());
            ARect ans = new ARect();
            if (this.mCBShape.getSelectedItem().toString().contains("Rect")) {
                ans.setSize(width, height);
            } else {
                ans.setSize(width, width);
            }
            ans.moveCenterTo(0L, 0L);
            return ans;
        }

        protected ARect calculateInnerBounds() {
            long height;
            long width;
            Unit unit = CreatePackageWizard.this.getUnitDist();
            if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH) {
                width = unit.fromUserString(this.mWidthVal.getText());
                height = unit.fromUserString(this.mHeightVal.getText());
            } else {
                width = (long)(Integer.parseInt(this.mColumnsVal.getText()) - 1) * unit.fromUserString(this.mPinPitchXVal.getText());
                height = (long)(Integer.parseInt(this.mRowsVal.getText()) - 1) * unit.fromUserString(this.mPinPitchYVal.getText());
            }
            if (this.mIncludeRingDepth) {
                APoint2D pitchVals = this.getPitchXAndY();
                width -= this.getRingDepth() * 2L * pitchVals.getX();
                height -= this.getRingDepth() * 2L * pitchVals.getY();
            } else {
                height = 0L;
                width = 0L;
            }
            ARect rect = new ARect();
            rect.setSize(width, height);
            rect.moveCenterTo(0L, 0L);
            return rect;
        }

        protected boolean validateInput() {
            try {
                boolean need2PadShapeSizes;
                boolean needInset;
                if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH) {
                    AFieldValidator.validateDouble((JTextField)this.mWidthVal);
                    AFieldValidator.validateDouble((JTextField)this.mHeightVal);
                }
                if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH) {
                    AFieldValidator.validateDouble((JTextField)this.mPinPitchXVal);
                    AFieldValidator.validateDouble((JTextField)this.mPinPitchYVal);
                }
                if (((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH) {
                    AFieldValidator.validateLong((JTextField)this.mRowsVal, (long)1L, (long)10000000000L);
                    AFieldValidator.validateLong((JTextField)this.mColumnsVal, (long)1L, (long)10000000000L);
                }
                boolean needInsetOuter = ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_ALL_FROM_OUTER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_OUTER;
                boolean bl = needInset = needInsetOuter || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_ALL_FROM_INNER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_INNER;
                if (needInset) {
                    AFieldValidator.validateLong((JTextField)this.mInsetVal, (long)1L, (long)10000000000L);
                }
                if (this.mIncludeRingDepth) {
                    AFieldValidator.validateLong((JTextField)this.mRingDepthVal, (long)1L, (long)10000000000L);
                }
                boolean shapesVisible = ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_OUTER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.INHERIT_FROM_INNER || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_PITCH || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.SIZE_AND_COUNT || ((AComboBox.AComboBoxItem)this.mSpecType.getSelectedItem()).getKey() == RingSpecType.COUNT_AND_PITCH;
                PadTemplate.PadShapeStyle padShapeStyle = (PadTemplate.PadShapeStyle)this.mCBShape.getSelectedItem();
                boolean bl2 = need2PadShapeSizes = padShapeStyle == PadTemplate.PadShapeStyle.Rect;
                if (shapesVisible) {
                    AFieldValidator.validateDouble((JTextField)this.mTxtPadSize);
                }
                if (shapesVisible && need2PadShapeSizes) {
                    AFieldValidator.validateDouble((JTextField)this.mTxtPadSize2);
                }
                AFieldValidator.validateDouble((JTextField)this.mTxtRotation);
                return true;
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return false;
            }
        }

        protected long calculateDefaultPerimeter() {
            ARect bounds = this.calculateBounds();
            APoint2D pitchVals = this.getPitchXAndY();
            return bounds.width() * 2L + bounds.height() * 2L + pitchVals.getX() * 2L + pitchVals.getY() * 2L;
        }

        protected String calculateDefaultPerimeterStr() {
            Unit unit = CreatePackageWizard.this.getUnitDist();
            return unit.toUserStr(this.calculateDefaultPerimeter());
        }

        protected String calculateDefaultOutlineWidthStr() {
            Unit unit = CreatePackageWizard.this.getUnitDist();
            ARect bounds = this.calculateBounds();
            APoint2D pitchVals = this.getPitchXAndY();
            return unit.toUserStr(bounds.width() + pitchVals.getX());
        }

        protected String calculateDefaultOutlineHeightStr() {
            Unit unit = CreatePackageWizard.this.getUnitDist();
            ARect bounds = this.calculateBounds();
            APoint2D pitchVals = this.getPitchXAndY();
            return unit.toUserStr(bounds.height() + pitchVals.getY());
        }

        public double getRotation() {
            try {
                return AUtil.doubleFromString((String)AFieldValidator.validateDouble((JTextField)this.mTxtRotation));
            }
            catch (AFieldValidator.AFieldValidationException e) {
                return 0.0;
            }
        }
    }

    protected static class RowAndColumn {
        int mRow;
        int mColumn;

        RowAndColumn(int r, int c) {
            this.mRow = r > 0 ? r : 1;
            this.mColumn = c > 0 ? c : 1;
        }

        int getRow() {
            return this.mRow;
        }

        int getColumn() {
            return this.mColumn;
        }

        public void setRow(int i) {
            this.mRow = i;
        }

        public void setColumn(int i) {
            this.mColumn = i;
        }
    }

    private class ActionImportSubstrate
    extends AbstractAction {
        private final AbstractButton mOri;
        private final Window mWindow;

        public ActionImportSubstrate(AbstractButton button, Window window) {
            super("");
            this.mOri = button;
            this.mWindow = window;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            OrbitGuiWS ws = OrbitIO.getApp().getWorkspace();
            AbstractAction newSub = new AbstractAction("New..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateSubstrateUI.showMe(OrbitIO.getCurDb(), ActionImportSubstrate.this.mWindow);
                    CreatePackageWizard.this.populateSubstrates();
                }
            };
            AbstractAction fromLEF = new AbstractAction("From LEF"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LefDefUI.showDialog(ActionImportSubstrate.this.mWindow);
                    CreatePackageWizard.this.populateSubstrates();
                }
            };
            fromLEF.putValue("ShortDescription", AFileFilter.LEF.getDescription());
            AbstractAction fromCSV = new AbstractAction("From Layer CSV"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AFileChooser fc = new AFileChooser();
                    AFileFilter filter = AFileFilter.CSV;
                    fc.setFileFilter((FileFilter)filter);
                    fc.setDialogTitle("Import Layer CSV...");
                    if (fc.showOpenDialog((Component)OrbitIO.getMainWindow()) != 0) {
                        return;
                    }
                    File f = fc.getSelectedFile();
                    String path = f.getPath();
                    if (fc.getFileFilter() == filter && !f.getName().contains(".")) {
                        path = String.format("%s.csv", path);
                    }
                    Cp.exec((String)"com.cadence.orbit.pi.csvio.LayerCsvImport.importCsv(curDb(), %s)", (Object[])new Object[]{Cp.getFileAsArgument((String)path)});
                    CreatePackageWizard.this.populateSubstrates();
                }
            };
            menu.add(newSub);
            menu.add(fromLEF);
            menu.add(fromCSV);
            ws.beautify(menu);
            menu.show(this.mOri, 0, this.mOri.getHeight());
        }
    }

    class BoundForm
    implements StepForm {
        BoundForm() {
        }

        @Override
        public String getCommand() {
            return CreatePackageWizard.CMD_BOUND;
        }

        @Override
        public JPanel getContentPane() {
            return CreatePackageWizard.this.createBoundCardPanel();
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public boolean hasNextStep() {
            return false;
        }

        @Override
        public String getShortDesc() {
            return CreatePackageWizard.CMD_BOUND;
        }
    }

    class RingForm
    implements StepForm {
        RingForm() {
        }

        @Override
        public String getCommand() {
            return CreatePackageWizard.CMD_RING;
        }

        @Override
        public JPanel getContentPane() {
            return CreatePackageWizard.this.createRingCardPanel();
        }

        @Override
        public boolean next() {
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return true;
        }

        @Override
        public String getShortDesc() {
            return CreatePackageWizard.CMD_RING;
        }
    }

    class PackageForm
    implements StepForm {
        PackageForm() {
        }

        @Override
        public String getCommand() {
            return CreatePackageWizard.CMD_PACKAGE;
        }

        @Override
        public JPanel getContentPane() {
            return CreatePackageWizard.this.createPackageCardPanel();
        }

        @Override
        public boolean next() {
            if (CreatePackageWizard.this.mPackageName.getText().isBlank()) {
                CreatePackageWizard.this.mWarningTip.setVisible(true);
                CreatePackageWizard.this.mWarningTip.setText("Package name cannot be empty.");
                return false;
            }
            String childDeviceName = CreatePackageWizard.this.mPackageName.getText();
            Design parent = Design.getDesign((Db)CreatePackageWizard.this.mDb);
            if (parent.getChild(childDeviceName) != null) {
                CreatePackageWizard.this.mWarningTip.setVisible(true);
                CreatePackageWizard.this.mWarningTip.setText(String.format("Please check device name '%s'", childDeviceName));
                childDeviceName = Device.getUniqueName((DeviceTemplate)parent, (String)childDeviceName);
                CreatePackageWizard.this.mPackageName.setText(childDeviceName);
                return false;
            }
            String templtName = CreatePackageWizard.this.mPackageTemplateName.getText();
            Substrate sub = CreatePackageWizard.this.getSubstrate();
            if (sub == null || DeviceTemplate.getDeviceTemplate((Substrate)sub, (String)templtName) != null) {
                CreatePackageWizard.this.mWarningTip.setVisible(true);
                CreatePackageWizard.this.mWarningTip.setText(String.format("Please check template name '%s'", templtName));
                templtName = DeviceTemplate.getUniqueName((Substrate)sub, (String)templtName);
                CreatePackageWizard.this.mPackageTemplateName.setText(templtName);
                return false;
            }
            CreatePackageWizard.this.mWarningTip.setVisible(false);
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return true;
        }

        @Override
        public String getShortDesc() {
            return String.format("Package (%s)", CreatePackageWizard.this.mPackageName.getText());
        }
    }

    class SubstrateForm
    implements StepForm {
        SubstrateForm() {
        }

        @Override
        public String getCommand() {
            return CreatePackageWizard.CMD_SUBSTRATE;
        }

        @Override
        public JPanel getContentPane() {
            return CreatePackageWizard.this.createSubstrateCardPanel();
        }

        @Override
        public boolean next() {
            if (CreatePackageWizard.this.getSubstrate() == null) {
                CreatePackageWizard.this.mWarningTip.setVisible(true);
                CreatePackageWizard.this.mWarningTip.setText("Please create substrate first");
                return false;
            }
            CreatePackageWizard.this.mWarningTip.setVisible(false);
            return true;
        }

        @Override
        public boolean hasNextStep() {
            return true;
        }

        @Override
        public String getShortDesc() {
            if (CreatePackageWizard.this.getSubstrate() == null) {
                return CreatePackageWizard.CMD_SUBSTRATE;
            }
            Object name = CreatePackageWizard.this.getSubstrate().getName();
            if (((String)name).length() > 16) {
                name = ((String)name).substring(0, 16) + "...";
            }
            return String.format("Substrate (%s)", name);
        }
    }

    static interface StepForm {
        public String getCommand();

        public boolean next();

        public boolean hasNextStep();

        public JPanel getContentPane();

        public String getShortDesc();
    }

    private static enum RingSpecType {
        SPACING_FROM_COUNT,
        COUNT_FROM_SPACING,
        INHERIT_FROM_OUTER,
        INHERIT_ALL_FROM_OUTER,
        COUNT_AND_PITCH,
        SIZE_AND_PITCH,
        SIZE_AND_COUNT,
        INHERIT_FROM_INNER,
        INHERIT_ALL_FROM_INNER,
        UNKNOWN;

    }

    private static enum PkgStyleType {
        UNIFORM_ARRAY,
        ARRAY_1RING,
        ARRAY_2RINGS,
        ONE_RING,
        TWO_RINGS,
        UNKNOWN;

    }
}

