/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.PrimaryKey;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.GridChooser;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Dimension;
import java.awt.Window;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class CreateSubstrateUI {
    private CreateSubstrateUI() {
    }

    public static CreateSubstrateDialog showMe(Db db, Window owner) {
        CreateSubstrateDialog dialog = new CreateSubstrateDialog(db, owner);
        dialog.setVisible(true);
        dialog.setResizable(false);
        return dialog;
    }

    public static class CreateSubstrateDialog
    extends AJFXDesignDialog {
        public CreateSubstrateDialog(Db db, Window owner) {
            super(db, owner, "Create Substrate");
            this.init();
            this.setModal(true);
        }

        protected AJFXPanel createJfxPanel() {
            return new NewSubstratePanel();
        }

        private class SubstrateInfoForm
        extends GridPane {
            protected ComboBox<DeviceTemplate.Type> mCboType;
            protected TextField mNameField;
            protected ListView<Layer> mLayerList;
            protected ContextMenu mNameValidator;
            protected DeviceTemplate.Type[] mTargetTypes = new DeviceTemplate.Type[]{DeviceTemplate.Type.DIE, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.BOARD, DeviceTemplate.Type.SPACER};

            public SubstrateInfoForm() {
                this.setAlignment(Pos.TOP_LEFT);
                this.setHgap(10.0);
                this.setVgap(10.0);
                this.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                ColumnConstraints column1 = new ColumnConstraints(100.0);
                ColumnConstraints column2 = new ColumnConstraints(50.0, 150.0, 300.0);
                column2.setHgrow(Priority.ALWAYS);
                this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
                Label targetType = new Label("Target Type:");
                this.mCboType = new ComboBox();
                this.mCboType.getItems().addAll((Object[])this.mTargetTypes);
                this.mCboType.setCellFactory((Callback)new Callback<ListView<DeviceTemplate.Type>, ListCell<DeviceTemplate.Type>>(){

                    public ListCell<DeviceTemplate.Type> call(ListView<DeviceTemplate.Type> param) {
                        return new DeviceTypeCell();
                    }
                });
                this.mCboType.setButtonCell((ListCell)new DeviceTypeCell());
                this.mCboType.setValue((Object)DeviceTemplate.Type.values()[0]);
                this.mCboType.setOnAction(e -> this.updateLayers());
                this.add((Node)targetType, 0, 0);
                this.add((Node)this.mCboType, 1, 0);
                Label substrateName = new Label("Substrate Name:");
                this.mNameField = new TextField();
                this.mNameField.textProperty().addListener((observable, oldValue, newValue) -> {
                    if (!PrimaryKey.isValidField((String)newValue)) {
                        ((StringProperty)observable).setValue(PrimaryKey.getValidField((String)newValue));
                    }
                    this.mNameValidator.hide();
                });
                this.mNameValidator = new ContextMenu();
                this.mNameValidator.setAutoHide(false);
                this.add((Node)substrateName, 0, 1);
                this.add((Node)this.mNameField, 1, 1);
                this.mLayerList = new ListView();
                this.mLayerList.setCellFactory((Callback)new Callback<ListView<Layer>, ListCell<Layer>>(){

                    public ListCell<Layer> call(ListView<Layer> param) {
                        return new LayerCell();
                    }
                });
                this.add((Node)new Label("Create Layer:"), 0, 2, 2, 1);
                this.add((Node)this.mLayerList, 0, 3, 2, 1);
                this.updateLayers();
            }

            public boolean validateRules() {
                boolean pass = true;
                if (this.mNameField.getText().isEmpty()) {
                    this.mNameValidator.getItems().clear();
                    this.mNameValidator.getItems().add((Object)new MenuItem("Please enter non-empty name."));
                    this.mNameValidator.show((Node)this.mNameField, Side.RIGHT, 10.0, 0.0);
                    pass = false;
                }
                return pass;
            }

            public String getSubstrateName() {
                return this.mNameField.getText();
            }

            public DeviceTemplate.Type getSourceType() {
                return (DeviceTemplate.Type)this.mCboType.getValue();
            }

            private void updateLayers() {
                Unit unit = Design.getUnit((Db)CreateSubstrateDialog.this.mDb);
                this.mLayerList.getItems().clear();
                Substrate.getDefaultLayers((DeviceTemplate.Type)((DeviceTemplate.Type)this.mCboType.getValue()), (Unit)unit).forEach(layer -> this.mLayerList.getItems().add(layer));
            }
        }

        private class LayerCell
        extends ListCell<Layer> {
            private LayerCell() {
            }

            public void updateItem(Layer item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    Unit unit = Design.getUnit((Db)CreateSubstrateDialog.this.mDb);
                    this.setText(String.format("%s / Height %s", item.getName(), unit.toUserStr(item.getHeight())));
                } else {
                    this.setText(null);
                }
            }
        }

        private class DeviceTypeCell
        extends ListCell<DeviceTemplate.Type> {
            private DeviceTypeCell() {
            }

            public void updateItem(DeviceTemplate.Type item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item != null) {
                    this.setText(item.toString());
                    Image icon = JFXUtil.getFxImage((Icon)DbExplorerPanel.getIconForTemplateType(item));
                    this.setGraphic((Node)new ImageView(icon));
                } else {
                    this.setText(null);
                }
            }
        }

        private class NewSubstratePanel
        extends AJFXPanel {
            private static final int PANEL_WIDTH = 400;
            private static final int PANEL_HEIGHT = 360;
            private SubstrateInfoForm mSubstrateInfoForm;
            EventHandler<ActionEvent> mOkHandler = new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    if (!NewSubstratePanel.this.mSubstrateInfoForm.validateRules()) {
                        return;
                    }
                    SwingUtilities.invokeLater(() -> {
                        DbHistory history = CreateSubstrateDialog.this.getDb().getHistory();
                        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Create Substrate");){
                            this.cpCreateSubstrate();
                        }
                        OrbitIO.refreshViewsOf(CreateSubstrateDialog.this.mDb);
                        DbExplorerPanel.refreshAll();
                        UIUtil.closeWindow((Window)((Object)CreateSubstrateDialog.this));
                    });
                }

                private void cpCreateSubstrate() {
                    String name = NewSubstratePanel.this.mSubstrateInfoForm.getSubstrateName();
                    DeviceTemplate.Type sourceType = NewSubstratePanel.this.mSubstrateInfoForm.getSourceType();
                    String var = "_createSubstrate";
                    Cp.exec((String)"%s = Substrate.create(curDb(), \"%s\")", (Object[])new Object[]{var, name});
                    Cp.exec((String)"%s.createDefaultLayers(DeviceTemplate.Type.%s)", (Object[])new Object[]{var, sourceType.name()});
                    Substrate.SubstrateType subType = Substrate.SubstrateType.get((DeviceTemplate.Type)sourceType);
                    if (subType != null) {
                        Cp.exec((String)"%s.setSubstrateType(Substrate.SubstrateType.%s)", (Object[])new Object[]{var, sourceType.name()});
                    }
                    Substrate substrate = (Substrate)Cp.getValue((String)var);
                    Cp.exec((String)"unset(\"%s\")", (Object[])new Object[]{var});
                    if (sourceType == DeviceTemplate.Type.DIE && substrate != null) {
                        GridChooser.editGrids(OrbitIO.getMainWindow(), substrate);
                    }
                }
            };

            public NewSubstratePanel() {
                this.setPreferredSize(new Dimension(400, 360));
            }

            protected Parent initSceneGraph() {
                VBox root = new VBox(5.0);
                this.mSubstrateInfoForm = new SubstrateInfoForm();
                root.getChildren().add((Object)this.mSubstrateInfoForm);
                OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)CreateSubstrateDialog.this), this.mOkHandler);
                root.getChildren().add((Object)okCancelHBox);
                return root;
            }
        }
    }
}

