/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.google.common.collect.Lists;
import com.sigrity.acl.AColor;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.std.Attachment;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFillLayout;
import com.sigrity.acl.ui.AHorizDivider;
import com.sigrity.acl.ui.ALinkLabel;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.ATreeUtil;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.acl.ui.editors.DbFieldEditor;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.EditDbFieldUI;
import com.sigrity.orbit.ui.ExternalAttachmentUI;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import com.sigrity.tools.dbexplorer.DbObjectTransferable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DbObjectDetailsUI
extends DbDialog {
    public static final Icon iconDelete = OrbitIcons.DELETE;
    public static final Icon iconAdd = OrbitIcons.ADD;
    public static final GridBagManager.GridBagConstraintsEx TCell = GridBagManager.LEFT.insetTop(0).insetBottom(1);
    public static final GridBagManager.GridBagConstraintsEx TCellH = TCell.fill(2);
    public static final GridBagManager.GridBagConstraintsEx TCellFillX = TCellH.weight(1.0, 0.0);
    public static final String NULL_STR = "<null>";
    public static final String NULL_STR2 = "[null]";
    protected ViewMode mMode = ViewMode.SINGLE;
    protected Set<APair<DevicePath, DbObject>> mEditSet;
    protected DbObject mDbObject;
    protected DbClass mDbClass;
    protected DevicePath mPath;
    protected AAppView mView;
    protected CallTree mCallTree;
    protected CallTreeModel mCallTreeModel;
    protected CallTreeNode mDboNode;
    protected JPanel mTreeContent = null;
    protected JPanel mPnlContent = null;
    protected JPanel mCenterContent = null;
    protected JPanel mPnlBottom;
    protected JButton mBtnClose;
    protected TransferHandler mTransferHandler = new TransferHandler(){

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            APair<DevicePath, DbObject> srcAndTgt = this.getSource(support);
            if (srcAndTgt == null) {
                return false;
            }
            if (support.getDropAction() != 2) {
                support.setDropAction(2);
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            APair<DevicePath, DbObject> src = this.getSource(support);
            if (src == null || src.second == null) {
                return false;
            }
            CallTreeNode parent = (CallTreeNode)((Object)DbObjectDetailsUI.this.mCallTreeModel.getRoot());
            CallDboNode tmp = parent.addChild((DbObject)src.getSecond(), (DevicePath)src.getFirst());
            DbObjectDetailsUI.this.setDetialPanel(tmp);
            DbObjectDetailsUI.this.mCallTreeModel.reload();
            DbObjectDetailsUI.this.mCallTree.makeVisible(new TreePath(DbObjectDetailsUI.this.mCallTreeModel.getPathToRoot((TreeNode)((Object)tmp))));
            return true;
        }

        APair<DevicePath, DbObject> getSource(TransferHandler.TransferSupport support) {
            Transferable transferable = support.getTransferable();
            try {
                if (transferable.isDataFlavorSupported(DbObjectTransferable.DeviceTransferable.FLAVOR)) {
                    DbObjectTransferable.DeviceTransferable device = (DbObjectTransferable.DeviceTransferable)transferable.getTransferData(DbObjectTransferable.DeviceTransferable.FLAVOR);
                    return new APair((Object)device.getDevicePath(), (Object)device.getDbObject());
                }
                if (transferable.isDataFlavorSupported(DbObjectTransferable.NetTransferable.NetFlavor)) {
                    DbObjectTransferable.NetTransferable net = (DbObjectTransferable.NetTransferable)transferable.getTransferData(DbObjectTransferable.NetTransferable.NetFlavor);
                    return new APair((Object)net.getDevicePath(), (Object)net.getDbObject());
                }
                if (transferable.isDataFlavorSupported(DbObjectTransferable.HierDboTransferable.FLAVOR)) {
                    DbObjectTransferable.HierDboTransferable dbo = (DbObjectTransferable.HierDboTransferable)transferable.getTransferData(DbObjectTransferable.HierDboTransferable.FLAVOR);
                    return new APair((Object)dbo.getDevicePath(), (Object)dbo.getDbObject());
                }
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error getting transfer data.", (Object[])new Object[0]);
                return null;
            }
            return null;
        }
    };
    protected DbClass.DbObjectListener mDbObjectListener = new DbClass.DbObjectAdapter(){

        public void changedObject(DbClass.ObjectChange change) {
            if (change.getDbObject() == DbObjectDetailsUI.this.mDbObject) {
                DbObjectDetailsUI.this.updateData();
            }
        }

        public void removedObject(DbClass.ObjectRemove remove) {
            if (remove.getDbObject() == DbObjectDetailsUI.this.mDbObject) {
                UIUtil.closeWindow((Window)((Object)DbObjectDetailsUI.this));
            }
        }
    };
    protected DbRelationDef.DbRelationListener mDbRelListener = new DbRelationDef.DbRelationAdapter(){

        public void related(DbRelationDef.RelationChange change) {
            if (change.getRight() == DbObjectDetailsUI.this.mDbObject) {
                DbObjectDetailsUI.this.updateData();
            }
        }

        public void unrelated(DbRelationDef.RelationChange change) {
            if (change.getRight() == DbObjectDetailsUI.this.mDbObject) {
                DbObjectDetailsUI.this.updateData();
            }
        }
    };
    public static final Comparator<DbFieldDef> FIELD_COMPARATOR = (a, b) -> {
        if (a.getIsKey() && b.getIsKey()) {
            return 0;
        }
        if (a.getIsKey() && !b.getIsKey()) {
            return -1;
        }
        if (b.getIsKey() && !a.getIsKey()) {
            return 1;
        }
        if (a.getIsHard() && !b.getIsHard()) {
            return -1;
        }
        if (b.getIsHard() && !a.getIsHard()) {
            return 1;
        }
        if (a.isHidden() != b.isHidden()) {
            return a.isHidden() ? 1 : -1;
        }
        return a.getName().compareTo(b.getName());
    };

    protected DbObjectDetailsUI(Component owner, DbObject dbo, DevicePath path, AAppView view) {
        super(dbo.getDb(), owner);
        this.setRecallBounds(false);
        this.mDbObject = dbo;
        this.mDbClass = dbo.getDbClass();
        this.mPath = path;
        this.mView = view;
        GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
        this.setupToolBar(l);
        this.mPnlContent = new JPanel();
        this.mPnlContent.setLayout(new AFillLayout());
        this.mCallTreeModel = new CallTreeModel();
        this.mDboNode = ((CallRootNode)((Object)this.mCallTreeModel.getRoot())).addChild(this.mDbObject, this.mPath);
        this.mCallTree = new CallTree(this.mCallTreeModel);
        this.mCallTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                Object node;
                if (!e.isPopupTrigger()) {
                    return;
                }
                TreePath p = DbObjectDetailsUI.this.mCallTree.getPathForLocation(e.getX(), e.getY());
                Object object = node = p == null ? null : p.getLastPathComponent();
                if (node instanceof CallTreeNode) {
                    this.showTreeContextMenu((CallTreeNode)((Object)node), e.getX(), e.getY());
                }
            }

            private void showTreeContextMenu(CallTreeNode node, int x, int y) {
                JPopupMenu m = new JPopupMenu();
                DevicePath dp = node.getDevicePath();
                DbObject dbo = node.getDbObject();
                OrbitGuiWS gws = OrbitIO.getOrbitIO().getWorkspace();
                ObjectActionRegistry oar = gws.getObjectActionRegistry();
                HierInst hdbo = HierInst.create((DevicePath)dp, (DbObject)dbo);
                LinkedList objItems = AMenuUtil.groupByFirstWord(oar.getJMenuItems(hdbo));
                AMenuUtil.sort((List)objItems, (boolean)true);
                for (JMenuItem item : objItems) {
                    m.add(item);
                }
                AMenuUtil.setMnemonics((JPopupMenu)m, (boolean)true, (boolean)true);
                if (OrbitIO.getGuiWorkspace() != null) {
                    OrbitIO.getGuiWorkspace().beautify(m);
                }
                m.show((Component)((Object)DbObjectDetailsUI.this.mCallTree), x, y);
            }
        });
        this.mCallTreeModel.initTree(this.mCallTree);
        this.mTreeContent = new JPanel();
        this.mTreeContent.setLayout(new BorderLayout());
        this.mTreeContent.setTransferHandler(this.mTransferHandler);
        this.mTreeContent.add((Component)new JScrollPane((Component)((Object)this.mCallTree)), "Center");
        this.mCenterContent = new JPanel();
        this.mCenterContent.setLayout(new BorderLayout());
        l.add((Component)this.mCenterContent, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
        l.newline();
        this.mPnlBottom = l.pushFillXRemainX();
        l.addFillX();
        this.mBtnClose = (JButton)l.add((Component)new JButton("Close"));
        l.pop();
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
        this.setSize(920, 600);
        this.updateData();
        this.setChangeMonitorEnabled(true);
        UIUtil.center((Component)((Object)this));
        UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
        this.mBtnClose.requestFocusInWindow();
        this.setVisible(true);
    }

    private void setupToolBar(GridBagManager l) {
        l.add("View:");
        JToggleButton singleView = this.makeToggleToolbarButton(new ActionViewMode(ViewMode.SINGLE));
        JToggleButton traceView = this.makeToggleToolbarButton(new ActionViewMode(ViewMode.TRACE));
        JToggleButton diffView = this.makeToggleToolbarButton(new ActionViewMode(ViewMode.DIFF));
        singleView.setIcon(UIUtil.getScaledIcon((Icon)DBEResources.ICON_DBOBJ, (int)16, (int)16));
        traceView.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.ALIGN, (int)16, (int)16));
        diffView.setIcon(UIUtil.getScaledIcon((Icon)OrbitIcons.DIFF, (int)16, (int)16));
        ButtonGroup group = new ButtonGroup();
        group.add(singleView);
        group.add(traceView);
        group.add(diffView);
        l.add((Component)singleView, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.add((Component)traceView, (GridBagConstraints)GridBagManager.LEFT.noInsets());
        l.newline();
    }

    private void setViewMode(ViewMode mode) {
        this.mMode = mode;
        this.updateData();
    }

    private JToggleButton makeToggleToolbarButton(Action a) {
        JToggleButton btn = new JToggleButton(a);
        btn.setOpaque(false);
        btn.setContentAreaFilled(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        return btn;
    }

    public void removeNotify() {
        this.setChangeMonitorEnabled(false);
        super.removeNotify();
    }

    protected void setChangeMonitorEnabled(boolean listen) {
        if (this.mDbClass == null || this.mDbClass.getDb() == null) {
            return;
        }
        try {
            DbRelationDef relAttachment2Owner = this.mDbClass.getDb().getRelation("Attachment-owner");
            if (listen) {
                this.mDbClass.addObjectListener(this.mDbObjectListener, DbClass.DbObjectEventType.getUpdated());
                if (relAttachment2Owner != null) {
                    relAttachment2Owner.addRelationListener(this.mDbRelListener, DbRelationDef.RELATION_UPDATED);
                }
            } else {
                this.mDbClass.removeObjectListener(this.mDbObjectListener, DbClass.DbObjectEventType.getUpdated());
                if (relAttachment2Owner != null) {
                    relAttachment2Owner.removeRelationListener(this.mDbRelListener, DbRelationDef.RELATION_UPDATED);
                }
            }
        }
        catch (Exception e) {
            ALog.logDebug((Throwable)e, (String)"Unexpected exception in DbObjectDetailsUI.setChangeMonitorEnabled().", (Object[])new Object[0]);
        }
    }

    protected void updateData() {
        JScrollPane scrollPane;
        String title;
        this.mPnlContent.removeAll();
        if (this.mDbObject != null) {
            title = this.mDbObject.getDb() == null ? String.format("Details: %s", this.mDbObject.getClass().getName()) : String.format("Details: %s %s", this.mDbObject.getDbClass().getName(), this.mDbObject.getKeyStr());
            scrollPane = new JScrollPane(new DetailsPanel(this.mDbObject, this.mPath, this.mView));
            scrollPane.setSize(800, 600);
            this.mPnlContent.add(scrollPane);
        } else {
            title = String.format("Details: ... (%d)", this.mEditSet.size());
            scrollPane = new JScrollPane(new CoopDetailPanel(this.mEditSet, this.mView));
            scrollPane.setSize(800, 600);
            this.mPnlContent.add(scrollPane);
        }
        this.setTitle(title);
        if (this.mMode == ViewMode.SINGLE) {
            this.mCenterContent.removeAll();
            this.mCenterContent.add((Component)this.mPnlContent, "Center");
            this.resizeDialog(false);
        } else if (this.mMode == ViewMode.TRACE || this.mMode == ViewMode.DIFF) {
            int lastPos = 100;
            if (this.mCenterContent.getComponent(0) instanceof ASplitPane) {
                lastPos = ((ASplitPane)this.mCenterContent.getComponent(0)).getDividerLocation();
            }
            ASplitPane splitPane = new ASplitPane();
            splitPane.setLeftComponent(this.mTreeContent);
            splitPane.setRightComponent(this.mPnlContent);
            splitPane.setDividerLocation(lastPos);
            this.mCenterContent.removeAll();
            this.mCenterContent.add((Component)splitPane, "Center");
        }
        this.revalidate();
        this.repaint();
    }

    protected void setDetialPanel(CallTreeNode node) {
        if (node == null || node.getDbObject() == null) {
            return;
        }
        this.mEditSet = null;
        this.mDboNode = node;
        this.mDbObject = node.getDbObject();
        this.mPath = node.getDevicePath();
        this.updateData();
    }

    protected void setDetialPanel(Set<APair<DevicePath, DbObject>> editSet) {
        this.mEditSet = editSet;
        this.mDboNode = null;
        this.mDbObject = null;
        this.mPath = null;
        this.updateData();
    }

    protected void resizeDialog(boolean forceResize) {
        this.pack();
        this.setMinimumSize(null);
        this.setMinimumSize(this.getMinimumSize());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension max = new Dimension(screen.width * 2 / 3, screen.height * 4 / 5);
        Dimension cur = this.getSize();
        if (cur.width > max.width || cur.height > max.height) {
            Dimension newSize = new Dimension(Math.min(cur.width, max.width), Math.min(cur.height, max.height));
            this.setPreferredSize(newSize);
            this.setMinimumSize(newSize);
            this.setSize(newSize);
        }
        if (forceResize) {
            this.setSize(this.getPreferredSize());
        }
        this.repaint();
    }

    public static void show(Component owner, DbObject dbo, DevicePath path, AAppView view) {
        if (owner == null) {
            owner = OrbitIO.getMainWindow();
        }
        if (path != null && dbo instanceof NetObject && ((NetObject)dbo).getNet().getDeviceTemplate() != path.getDeviceTemplate()) {
            path = null;
        }
        new DbObjectDetailsUI(owner, dbo, path, view);
    }

    protected static DbFieldEditor<?> getDbFieldEditor(DbFieldDef field, DbObject dbo) {
        return DbFieldEditor.getFieldEditor(field, dbo);
    }

    protected JComponent getFieldValueComponent(DbFieldDef field, DbObject dbo, AAppView view, DevicePath path, DbFieldEditor<?> fieldEditor) {
        JLabel lbl;
        JComponent compVal;
        String strVal;
        Object val = field.getValue(dbo);
        String unitName = null;
        if (val == null) {
            strVal = NULL_STR;
        } else if (val instanceof AGeom) {
            strVal = ((AGeom)val).getAsString();
        } else if (fieldEditor != null) {
            strVal = fieldEditor.getOldValueAsString();
            unitName = fieldEditor.getValueUnitName();
        } else {
            strVal = field.getStringValue(dbo);
        }
        if (strVal == null && val instanceof DbObject) {
            strVal = String.format("%s Instance (not in database)", val.getClass().getName());
        }
        if (val instanceof DbObject) {
            ALinkLabel link;
            Action showObject = DbObjectDetailsUI.showRelatedObjectAction((Component)((Object)this), strVal, (DbObject)val, path, view);
            Action showInTree = this.getRelatedObjectInCallTreeAction((Component)((Object)this), strVal, (DbObject)val, path, view);
            if (val instanceof StoredPath) {
                strVal = ((StoredPath)val).toString();
            }
            if (this.mMode == ViewMode.SINGLE) {
                link = new ALinkLabel(strVal, showObject);
                link.enableCopySupport(new Action[0]);
            } else {
                showObject.putValue("Name", "Open Link in New Window");
                link = new ALinkLabel(strVal, showInTree);
                link.enableCopySupport(showObject);
            }
            link.enableCopySupport(showObject);
            compVal = link;
        } else if (val instanceof Color) {
            lbl = new JLabel(strVal);
            UIUtil.addCopySupport((JLabel)lbl);
            lbl.setIcon((Icon)new AColorIcon(10, 10, (Color)val));
            compVal = lbl;
        } else {
            lbl = new JLabel(strVal);
            UIUtil.addCopySupport((JLabel)lbl);
            if (val == null) {
                lbl.setForeground((Color)AColor.withAlpha((Color)lbl.getForeground(), (int)127));
            }
            if (field.getCData()) {
                Font f = lbl.getFont();
                f = new Font("Monospaced", f.getStyle(), f.getSize());
                lbl.setFont(f);
            }
            compVal = lbl;
        }
        if (unitName != null) {
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)compVal, "Center");
            panel.add((Component)new JLabel(String.format("(%s)", unitName)), "East");
            compVal = panel;
        }
        return compVal;
    }

    protected JComponent getFieldNameComponent(DbFieldDef field, Set<DbObject> dbos, AAppView view) {
        Class declaredType;
        JLabel compName;
        String name = field.getUserName();
        DbObject dbo = dbos.iterator().next();
        DbFieldEditor<?> fieldEditor = DbObjectDetailsUI.getDbFieldEditor(field, dbo);
        if (fieldEditor != null) {
            Action a = dbos.size() == 1 ? DbObjectDetailsUI.editFieldAction(name, (Component)((Object)this), dbo, field, view) : DbObjectDetailsUI.editSetFieldAction(name, (Component)((Object)this), dbos, field);
            ALinkLabel link = new ALinkLabel(name, a);
            link.setFont(link.getFont().deriveFont(1));
            link.enableCopySupport(new Action[0]);
            compName = link;
        } else {
            JLabel lbl = new JLabel(name);
            lbl.setFont(lbl.getFont().deriveFont(1));
            UIUtil.addCopySupport((JLabel)lbl);
            compName = lbl;
        }
        if (field.getIsKey()) {
            compName.setBackground((Color)AColor.withAlpha((Color)Color.GREEN, (int)68));
            compName.setOpaque(true);
        }
        String className = (declaredType = field.getFieldClass()) == null ? "<i>&lt;none&gt;</i>" : AReflection.getJavaClassName((Class)declaredType);
        StringBuilder tooltip = new StringBuilder();
        tooltip.append(String.format("<html><p>Declared type: %s</p>", className));
        tooltip.append(String.format("<p>Script Name: %s</p>", field.getName()));
        if (field.isHidden()) {
            tooltip.append("<p>This field will be hidden in production.</p>");
        }
        if (!field.getDescription().isEmpty()) {
            tooltip.append(String.format("<p>Description: %s</p>", field.getDescription()));
        }
        compName.setToolTipText(tooltip.toString());
        return compName;
    }

    public static Action editFieldAction(String text, final Component owner, final DbObject obj, final DbFieldDef field, AAppView view) {
        return new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDbFieldUI.edit(obj, field, owner);
            }
        };
    }

    private static Action editSetFieldAction(String text, final Component owner, final Set<DbObject> objSet, final DbFieldDef field) {
        return new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditDbFieldUI.editSet(objSet, field, owner);
            }
        };
    }

    public static Action showRelatedObjectAction(final Component uiOwner, String text, final DbObject obj, final DevicePath path, final AAppView view) {
        return new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbObjectDetailsUI.show(uiOwner, obj, path, view);
            }
        };
    }

    public Action getRelatedObjectInCallTreeAction(Component uiOwner, String text, final DbObject obj, final DevicePath path, AAppView view) {
        return new AbstractAction(text){

            @Override
            public void actionPerformed(ActionEvent e) {
                CallTreeNode parent = DbObjectDetailsUI.this.mDboNode;
                CallDboNode tmp = parent.addChild(obj, path);
                DbObjectDetailsUI.this.setDetialPanel(tmp);
                DbObjectDetailsUI.this.mCallTreeModel.reload();
                DbObjectDetailsUI.this.mCallTree.makeVisible(new TreePath(DbObjectDetailsUI.this.mCallTreeModel.getPathToRoot((TreeNode)((Object)tmp))));
            }
        };
    }

    public static Action showRelationsAction(final Component uiOwner, final DbObject dbo, final AAppView view) {
        return new AbstractAction("Relations"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DbObjectRelationsUI dlg = new DbObjectRelationsUI(uiOwner, dbo, view);
                dlg.setVisible(true);
            }
        };
    }

    public static Action showAllLeftRelatedAction(final Component uiOwner, final DbObject dboRight, final DbRelationDef rd, final AAppView view) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AllLeftRelatedUI dlg = new AllLeftRelatedUI(uiOwner, dboRight, rd, view);
                dlg.setVisible(true);
            }
        };
    }

    public static Attachment addAttachment(Component uiOwner, DbObject attachmentOwner) {
        ExternalAttachmentUI eaui = ExternalAttachmentUI.create(UIUtil.getParentWindow((Component)uiOwner), attachmentOwner);
        eaui.setVisible(true);
        return eaui.getCreatedAttachment();
    }

    public static boolean deleteAttachment(Attachment a) {
        Object result;
        int response = JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), "Are you sure you want to remove the attachment?", "Confirm Remove", 0, 3);
        return response == 0 && Boolean.TRUE.equals(result = Cp.exec((String)"ExternalAttachment.remove(\"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{a.getOwner().getDbClass().getName(), a.getOwner().getKeyStr(), a.getType(), a.getURI().toString()}));
    }

    protected static JButton smallButton(JButton b) {
        b.setFont(b.getFont().deriveFont(b.getFont().getSize() - 2));
        b.setMargin(new Insets(0, 0, 0, 0));
        return b;
    }

    protected static JLabel listHdr(JLabel l) {
        l.setFont(l.getFont().deriveFont(1));
        l.setBackground((Color)AColor.withAlpha((Color)l.getForeground(), (int)30));
        l.setOpaque(true);
        return l;
    }

    protected static Component minColSize(Component comp) {
        Dimension minSize = comp.getMinimumSize();
        minSize.width = Math.min(minSize.width, 100);
        comp.setMinimumSize(minSize);
        return comp;
    }

    protected class CallDboNode
    extends CallTreeNode {
        private DbObject mDbo;
        private DevicePath mPath;

        public CallDboNode(CallTreeNode parent, DbObject dbo, DevicePath path) {
            super(parent);
            this.mChildren = new ArrayList();
            this.mDbo = dbo;
            this.mPath = path;
        }

        @Override
        public DbObject getDbObject() {
            return this.mDbo;
        }

        @Override
        public DevicePath getDevicePath() {
            return this.mPath;
        }

        public List<? extends ATreeNode> populateChildren() {
            return this.mChildren;
        }

        public String getText() {
            String className = this.mDbo.getDbClass().getName();
            Object name = this.mDbo.getValue("name");
            if (name == null) {
                name = this.mDbo.toString();
            }
            return className + " '" + name + "'";
        }

        public Icon getIcon() {
            return DbExplorerPanel.getIconForDbObject(this.mDbo);
        }
    }

    protected class CallRootNode
    extends CallTreeNode {
        public CallRootNode(CallTreeModel model) {
            super(model);
            this.mChildren = new ArrayList();
        }

        @Override
        public DbObject getDbObject() {
            return null;
        }

        @Override
        public DevicePath getDevicePath() {
            return null;
        }

        public List<? extends ATreeNode> populateChildren() {
            return this.mChildren;
        }

        public String getText() {
            return "+";
        }
    }

    protected abstract class CallTreeNode
    extends ALazyTreeNode {
        public CallTreeNode(CallTreeModel model) {
            super((ATreeModel)model);
        }

        public CallTreeNode(CallTreeNode parent) {
            super((ATreeNode)parent);
        }

        public abstract DbObject getDbObject();

        public abstract DevicePath getDevicePath();

        public CallTreeModel getCallTreeModel() {
            return (CallTreeModel)this.getTreeModel();
        }

        public IterableIterator<CallTreeNode> getChildren() {
            this.populateChildrenAsNeeded();
            if (this.mChildren == null) {
                return AEmptyItr.create();
            }
            return new StreamIterableIterator(this.mChildren.stream().filter(CallTreeNode.class::isInstance).map(CallTreeNode.class::cast));
        }

        public CallDboNode addChild(DbObject dbo, DevicePath path) {
            Object n2;
            if (this.mChildren == null) {
                this.mChildren = new ArrayList();
            }
            for (Object n2 : this.getChildren()) {
                if (n2.getDbObject() != dbo || !n2.getDevicePath().equals((Object)path)) continue;
                return (CallDboNode)((Object)n2);
            }
            ArrayList<CallTreeNode> newChildren = new ArrayList<CallTreeNode>();
            for (CallTreeNode n3 : this.getChildren()) {
                newChildren.add(n3);
            }
            n2 = new CallDboNode(this, dbo, path);
            newChildren.add((CallTreeNode)((Object)n2));
            this.mChildren = newChildren;
            return n2;
        }
    }

    protected class CallTreeModel
    extends ATreeModel {
        CallTreeModel() {
            this.setRoot((TreeNode)((Object)new CallRootNode(this)));
        }

        public void initTree(CallTree tree) {
        }

        public DbObject getDbObject() {
            return ATreeUtil.getBreadthFirstItr((TreeModel)((Object)this)).stream().map(treePath -> treePath.getLastPathComponent()).filter(treeNode -> treeNode instanceof CallTreeNode).map(treeNode -> (CallTreeNode)((Object)((Object)treeNode))).map(diffTreeNode -> diffTreeNode.getDbObject()).findAny().orElse(null);
        }
    }

    protected class CallTree
    extends ATree {
        protected TreeSelectionListener mTreeSelectionListener;

        public CallTree(CallTreeModel model) {
            super((ATreeModel)model);
            this.mTreeSelectionListener = new TreeSelectionListener(){
                CallTreeNode mPrevNode = null;

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath[] paths = CallTree.this.getSelectionPaths();
                    if (paths == null) {
                        return;
                    }
                    if (paths.length == 1) {
                        CallTreeNode selNode = (CallTreeNode)((Object)CallTree.this.getLastSelectedPathComponent());
                        if (selNode == this.mPrevNode) {
                            return;
                        }
                        DbObjectDetailsUI.this.setDetialPanel(selNode);
                        this.mPrevNode = selNode;
                    } else {
                        HashSet<APair<DevicePath, DbObject>> editSet = new HashSet<APair<DevicePath, DbObject>>();
                        for (TreePath path : paths) {
                            Object item = path.getLastPathComponent();
                            if (!(item instanceof CallTreeNode)) continue;
                            CallTreeNode node = (CallTreeNode)((Object)item);
                            editSet.add((APair<DevicePath, DbObject>)new APair((Object)node.getDevicePath(), (Object)node.getDbObject()));
                        }
                        DbObjectDetailsUI.this.setDetialPanel(editSet);
                    }
                }
            };
            this.addTreeSelectionListener(this.mTreeSelectionListener);
            this.setShowsRootHandles(false);
            this.setRootVisible(false);
        }

        public void setSelectionPath(TreePath path) {
            super.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public static class ReferencesList
    extends JList<DbObject> {
        protected LinkedList<DbObject> mReferrers = Lists.newLinkedList();
        protected AAppView mView;
        protected MyCellRenderer mCellRenderer = new MyCellRenderer();
        protected ListModel<DbObject> mModel = new AbstractListModel<DbObject>(){

            @Override
            public int getSize() {
                return mReferrers.size();
            }

            @Override
            public DbObject getElementAt(int index) {
                return mReferrers.get(index);
            }
        };
        protected ListSelectionListener mSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                this.clearSelection();
            }
        };
        protected MouseAdapter mMouseAdapter = new MouseAdapter(){
            int mLastCursor = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                int idx = this.getLinkIndexUnderMouse(e);
                if (idx < 0) {
                    this.setPointer(-1);
                } else {
                    this.setPointer(12);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = this.getLinkIndexUnderMouse(e);
                if (idx < 0) {
                    return;
                }
                DbObject dbo = mModel.getElementAt(idx);
                if (dbo == null) {
                    return;
                }
                DbObjectDetailsUI.show(this, dbo, null, mView);
            }

            protected int getLinkIndexUnderMouse(MouseEvent e) {
                Point loc = e.getPoint();
                int idx = this.locationToIndex(loc);
                Rectangle cellBounds = this.getCellBounds(idx, idx);
                if (idx >= 0 && !cellBounds.contains(loc)) {
                    idx = -1;
                } else {
                    loc.x -= cellBounds.x;
                    loc.y -= cellBounds.y;
                    if (!mCellRenderer.hitLink(idx, loc)) {
                        idx = -1;
                    }
                }
                return idx;
            }

            protected void setPointer(int predefCursor) {
                if (predefCursor == this.mLastCursor) {
                    return;
                }
                Cursor cursor = predefCursor == -1 ? null : Cursor.getPredefinedCursor(predefCursor);
                this.setCursor(cursor);
                this.mLastCursor = predefCursor;
            }
        };

        public ReferencesList(DbObject dboRight, DbRelationDef rd, AAppView view) {
            this.mView = view;
            for (DbObject referrer : rd.getRelated(dboRight, false)) {
                this.mReferrers.add(referrer);
            }
            Collections.sort(this.mReferrers, (a, b) -> this.getLabel((DbObject)a).compareTo(this.getLabel((DbObject)b)));
            this.setModel(this.mModel);
            this.setCellRenderer(this.mCellRenderer);
            this.addListSelectionListener(this.mSelectionListener);
            this.addMouseListener(this.mMouseAdapter);
            this.addMouseMotionListener(this.mMouseAdapter);
        }

        public String getLabel(DbObject dbo) {
            if (dbo == null) {
                return DbObjectDetailsUI.NULL_STR2;
            }
            String type = this.getType(dbo);
            String desc = this.getDesc(dbo);
            return String.format("<html>%s <a href='#'>%s</a>", type, desc);
        }

        protected String getDesc(DbObject dbo) {
            if (dbo == null) {
                return DbObjectDetailsUI.NULL_STR2;
            }
            return dbo.getDb() != null && dbo.getDbClass().hasKeyFields() ? dbo.getKeyStr() : dbo.toString();
        }

        protected String getType(DbObject dbo) {
            if (dbo == null) {
                return DbObjectDetailsUI.NULL_STR2;
            }
            return dbo.getDb() != null ? dbo.getDbClass().getName() : dbo.getClass().getSimpleName();
        }

        protected class MyCellRenderer
        implements ListCellRenderer<DbObject> {
            protected JPanel mPnl = new JPanel();
            protected JLabel mLblType = new JLabel();
            protected ALinkLabel mLinkObj = new ALinkLabel();

            protected MyCellRenderer() {
                this.mPnl.setLayout(new FlowLayout(0, 0, 0));
                this.mPnl.add(this.mLblType);
                this.mPnl.add(this.mLinkObj);
            }

            @Override
            public Component getListCellRendererComponent(JList<? extends DbObject> list, DbObject value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setCurItem(value);
                return this.mPnl;
            }

            protected void setCurItem(DbObject dbo) {
                this.mLblType.setText(ReferencesList.this.getType(dbo) + " ");
                this.mLinkObj.setText(ReferencesList.this.getDesc(dbo));
            }

            public boolean hitLink(int idx, Point loc) {
                DbObject dbo = ReferencesList.this.mModel.getElementAt(idx);
                this.setCurItem(dbo);
                Dimension dimLbl = this.mLblType.getPreferredSize();
                Dimension dimLink = this.mLinkObj.getPreferredSize();
                Rectangle rLink = new Rectangle(dimLink);
                rLink.translate(dimLbl.width, 0);
                return rLink.contains(loc);
            }
        }
    }

    public static class AllLeftRelatedUI
    extends ADialog {
        protected DbObject mDbObjectR;
        protected DbRelationDef mRelation;
        protected AAppView mView;
        protected JPanel mPnlContent;
        protected JPanel mPnlBottom;
        protected JButton mBtnClose;

        public AllLeftRelatedUI(Component uiOwner, DbObject dboRight, DbRelationDef rd, AAppView view) {
            super(uiOwner);
            this.setRecallBounds(false);
            this.mDbObjectR = dboRight;
            this.mRelation = rd;
            this.mView = view;
            String title = dboRight.getDb() == null ? String.format("References to: %s", dboRight.getClass().getName()) : String.format("References to: %s %s", dboRight.getDbClass().getName(), dboRight.getKeyStr());
            this.setTitle(title);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            String strObjR = this.mDbObjectR.getKeyStr();
            if (strObjR == null) {
                strObjR = this.mDbObjectR.toString();
            }
            String strDesc = String.format("%s is referenced in field '%s' for:", strObjR, rd.getFieldL().getName());
            JLabel lblDesc = new JLabel(strDesc);
            lblDesc.setToolTipText(String.format("Relation: %s", rd.getName()));
            l.addNl(strDesc);
            this.mPnlContent = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
            this.mPnlContent.setLayout(new AFillLayout());
            l.newline();
            this.mPnlBottom = l.pushFillXRemainX();
            l.addFillX();
            this.mBtnClose = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
            this.updateData();
            UIUtil.center((Component)((Object)this));
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
        }

        public void updateData() {
            this.mPnlContent.removeAll();
            this.mPnlContent.add(new JScrollPane(new ReferencesList(this.mDbObjectR, this.mRelation, this.mView)));
            this.resizeDialog();
        }

        protected void resizeDialog() {
            this.pack();
            this.setMinimumSize(null);
            this.setMinimumSize(this.getMinimumSize());
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension max = new Dimension(screen.width * 2 / 3, screen.height * 4 / 5);
            Dimension cur = this.getSize();
            if (cur.width > max.width || cur.height > max.height) {
                this.setSize(Math.min(cur.width, max.width), Math.min(cur.height, max.height));
            }
            this.repaint();
        }
    }

    public static class RelationsPanel
    extends JPanel {
        public RelationsPanel(DbObject dbo, AAppView view) {
            GridBagManager l = GridBagManager.layout((Container)this);
            l.push(String.format("Relations (reference %s on left)", dbo.getClass().getSimpleName()), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            DbObjectDetailsUI.listHdr(l.add("Relation", (GridBagConstraints)TCellH));
            DbObjectDetailsUI.listHdr(l.add("Related Object Key", (GridBagConstraints)TCellH));
            DbObjectDetailsUI.listHdr(l.add("Declared Right DbClass", (GridBagConstraints)TCellFillX));
            DbClass dbc = dbo.getDbClass();
            if (dbc == null && OrbitIO.getCurDb() != null) {
                dbc = OrbitIO.getCurDb().getDbClass(dbo.getClass());
            }
            if (dbc != null) {
                for (DbRelationDef rel : dbc.getRelations()) {
                    l.newline();
                    DbObjectDetailsUI.minColSize(l.add(rel.getName(), (GridBagConstraints)TCell));
                    Object s = "";
                    int i = 0;
                    for (DbObject related : rel.getRelated(dbo)) {
                        if (i > 0) {
                            s = (String)s + "\n";
                        }
                        s = (String)s + (related == null ? "{none}" : related.getKeyStr());
                        ++i;
                    }
                    if (i == 0) {
                        s = (String)s + "{none}";
                    }
                    l.add((String)s, (GridBagConstraints)TCell);
                    DbClass dbcr = rel.getDbClassR();
                    String rightClassName = dbcr == null ? "{Unknown}" : dbcr.getName();
                    DbObjectDetailsUI.minColSize(l.add(rightClassName, (GridBagConstraints)TCellH));
                }
            }
            l.pop();
        }
    }

    public static class DbObjectRelationsUI
    extends ADialog {
        protected DbObject mDbObject;
        protected DbClass mDbClass;
        protected AAppView mView;
        protected JPanel mPnlContent;
        protected JPanel mPnlBottom;
        protected JButton mBtnClose;

        protected DbObjectRelationsUI(Component owner, DbObject dbo, AAppView view) {
            super(owner);
            this.setRecallBounds(false);
            this.mDbObject = dbo;
            this.mDbClass = dbo.getDbClass();
            this.mView = view;
            String title = dbo.getDb() == null ? String.format("Relation Definitions: %s", dbo.getClass().getName()) : String.format("Relation Definitions: %s %s", dbo.getDbClass().getName(), dbo.getKeyStr());
            this.setTitle(title);
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            this.mPnlContent = (JPanel)l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mPnlContent.setLayout(new AFillLayout());
            l.newline();
            l.addFillY();
            this.mPnlBottom = l.pushFillXRemainX();
            l.addFillX();
            this.mBtnClose = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            UIUtil.enableEscapeClose((Window)((Object)this), (AbstractButton)this.mBtnClose);
            this.updateData();
            UIUtil.center((Component)((Object)this));
        }

        public void updateData() {
            this.mPnlContent.removeAll();
            this.mPnlContent.add(new RelationsPanel(this.mDbObject, this.mView));
            this.resizeDialog();
        }

        protected void resizeDialog() {
            this.pack();
            this.setMinimumSize(null);
            this.setMinimumSize(this.getMinimumSize());
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension max = new Dimension(screen.width * 2 / 3, screen.height * 4 / 5);
            Dimension cur = this.getSize();
            if (cur.width > max.width || cur.height > max.height) {
                this.setSize(Math.min(cur.width, max.width), Math.min(cur.height, max.height));
            }
            this.repaint();
        }
    }

    protected class ReferencesPanel
    extends JPanel {
        protected long mMaxRelRows;
        protected long mRelatedItemsDisplayed = 0L;

        public ReferencesPanel(DbObject dbo, AAppView view, long maxRelatedDisplayed) {
            this.mMaxRelRows = maxRelatedDisplayed;
            GridBagManager l = GridBagManager.layout((Container)this);
            this.setBorder(BorderFactory.createTitledBorder("References"));
            DbClass dbc = dbo.getDbClass();
            if (dbc == null) {
                return;
            }
            LinkedList rightSideRels = AUtil.linkedList((Iterator)new AggregateIterator((Iterator)dbc.getRightSideRelations(), (Iterator)dbc.getRuntimeRefRelations()));
            Collections.sort(rightSideRels);
            JPanel tablePanel = this.createRelationPanel(rightSideRels, dbo, view);
            JScrollPane scrollPane = new JScrollPane(tablePanel);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setPreferredSize(new Dimension(740, Math.min(120, tablePanel.getPreferredSize().height + 20)));
            l.add((Component)scrollPane);
            l.addFillX();
        }

        private JPanel createRelationPanel(LinkedList<DbRelationDef> rightSideRels, DbObject dbo, AAppView view) {
            JPanel tablePanel = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)tablePanel);
            DbObjectDetailsUI.listHdr(l.add("Class (field)", (GridBagConstraints)TCellH));
            DbObjectDetailsUI.listHdr(l.add("Referring Object", (GridBagConstraints)TCellFillX));
            for (DbRelationDef rd : rightSideRels) {
                int count = 0;
                for (DbObject referrer : rd.getRelated(dbo, false)) {
                    ALinkLabel link;
                    l.newline();
                    if ((long)(++count) > this.mMaxRelRows) continue;
                    String strReferrer = referrer.getKeyStr();
                    if (strReferrer == null) {
                        strReferrer = referrer.toString();
                    }
                    Action showObject = DbObjectDetailsUI.showRelatedObjectAction(this, strReferrer, referrer, null, view);
                    Action showInTree = DbObjectDetailsUI.this.getRelatedObjectInCallTreeAction(this, strReferrer, referrer, null, view);
                    if (DbObjectDetailsUI.this.mMode == ViewMode.SINGLE) {
                        link = new ALinkLabel(showObject);
                        link.enableCopySupport(new Action[0]);
                    } else {
                        showObject.putValue("Name", "Open Link in New Window");
                        link = new ALinkLabel(showInTree);
                        link.enableCopySupport(showObject);
                    }
                    String strDesc = String.format("%s (%s)", referrer.getDbClass().getName(), rd.getFieldL().getName());
                    JLabel lblDesc = new JLabel(strDesc);
                    lblDesc.setToolTipText(String.format("Relation: %s", rd.getName()));
                    DbObjectDetailsUI.minColSize(l.add((Component)lblDesc, (GridBagConstraints)TCell));
                    DbObjectDetailsUI.minColSize(l.add((Component)link, (GridBagConstraints)TCellH));
                    ++this.mRelatedItemsDisplayed;
                }
                if ((long)count <= this.mMaxRelRows) continue;
                l.newline();
                String text = String.format("%s for %d more %ss...", AUtil.capitalizeFirst((String)rd.getFieldL().getName()), (long)count - this.mMaxRelRows, rd.getDbClassL().getName());
                Action a = DbObjectDetailsUI.showAllLeftRelatedAction(this, dbo, rd, view);
                ALinkLabel link = new ALinkLabel(text, a);
                l.add((Component)link, (GridBagConstraints)TCellH.width(0).indent());
            }
            return tablePanel;
        }

        public long getRelatedItemsDisplayed() {
            return this.mRelatedItemsDisplayed;
        }
    }

    protected class CoopFieldsDisplay
    extends JPanel {
        public CoopFieldsDisplay(Set<APair<DevicePath, DbObject>> editSet, AAppView view) {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.setBorder(BorderFactory.createTitledBorder("Fields"));
            DbClass dbc = this.getDbClass(editSet);
            LinkedList fields = dbc == null ? new LinkedList() : AUtil.linkedList((Iterator)dbc.getFields());
            Collections.sort(fields, FIELD_COMPARATOR);
            JPanel fieldTable = this.createFieldPanel(fields, editSet, view);
            JScrollPane scrollPane = new JScrollPane(fieldTable);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setPreferredSize(new Dimension(740, fieldTable.getPreferredSize().height));
            scrollPane.setBorder(null);
            l.add((Component)scrollPane);
            l.addFillX();
        }

        private DbClass getDbClass(Set<APair<DevicePath, DbObject>> editSet) {
            APair<DevicePath, DbObject> e = editSet.iterator().next();
            return ((DbObject)e.getSecond()).getDbClass();
        }

        private JPanel createFieldPanel(LinkedList<DbFieldDef> fields, Set<APair<DevicePath, DbObject>> editSet, AAppView view) {
            JPanel panel = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)panel);
            boolean isProduction = !AUtil.getAclDebugMode();
            APair<DevicePath, DbObject> president = editSet.iterator().next();
            DevicePath path = (DevicePath)president.getFirst();
            DbObject dbo = (DbObject)president.getSecond();
            for (DbFieldDef field : fields) {
                if (isProduction && field.isHidden() || field.getIsKey()) continue;
                l.newline();
                Set<DbObject> dbos = editSet.stream().map(APair::getSecond).collect(Collectors.toSet());
                DbFieldEditor<?> fieldEditor = DbObjectDetailsUI.getDbFieldEditor(field, dbo);
                JComponent compName = DbObjectDetailsUI.this.getFieldNameComponent(field, dbos, view);
                JComponent compVal = DbObjectDetailsUI.this.getFieldValueComponent(field, dbo, view, path, fieldEditor);
                boolean allSame = this.checkSameValue(editSet, field);
                if (!allSame) {
                    compVal = new JPanel();
                    compVal.setBackground(new Color(236, 190, 190));
                    JLabel diff = new JLabel("Difference ...");
                    diff.setBorder(null);
                    diff.setFont(diff.getFont().deriveFont(2));
                    compVal.add(diff);
                }
                DbObjectDetailsUI.minColSize(compVal);
                l.add((Component)compName, (GridBagConstraints)TCell.fill(2));
                l.add((Component)compVal, (GridBagConstraints)TCellFillX);
            }
            l.addFillX();
            return panel;
        }

        private boolean checkSameValue(Set<APair<DevicePath, DbObject>> editSet, DbFieldDef field) {
            boolean first = true;
            Object one = null;
            for (APair<DevicePath, DbObject> e : editSet) {
                Object val = field.getValue((DbObject)e.getSecond());
                if (first) {
                    first = false;
                    one = val;
                    continue;
                }
                if (AUtil.equals(one, (Object)val)) continue;
                return false;
            }
            return true;
        }
    }

    protected class FieldsDisplay
    extends JPanel {
        protected boolean mNullSoftFieldsVisible = false;
        protected boolean mNullHardFieldsVisible = true;
        protected LinkedList<Component> mNullSoftFieldComps = Lists.newLinkedList();
        protected LinkedList<Component> mNullHardFieldComps = Lists.newLinkedList();

        public FieldsDisplay(DbObject dbo, DevicePath path, AAppView view) {
            Settings userPrefs = Settings.getSettings((String)"UserPreferences");
            this.mNullHardFieldsVisible = (Boolean)userPrefs.getSetting("DboDetailsDlgHideNullHardFields", (Object)false) == false;
            GridBagManager l = GridBagManager.layout((Container)this);
            this.setBorder(BorderFactory.createTitledBorder("Fields"));
            DbClass dbc = dbo.getDbClass();
            if (dbc == null && path != null && path.getDb() != null) {
                dbc = path.getDb().getDbClass(dbo.getClass());
            }
            if (dbc == null && OrbitIO.getCurDb() != null) {
                dbc = OrbitIO.getCurDb().getDbClass(dbo.getClass());
            }
            LinkedList fields = dbc == null ? new LinkedList() : AUtil.linkedList((Iterator)dbc.getFields());
            Collections.sort(fields, FIELD_COMPARATOR);
            JPanel fieldTable = this.createFieldPanel(fields, dbo, path, view);
            l.add((Component)fieldTable);
            l.addFillX();
            this.updateNullFieldsVisible();
            JPopupMenu menuFields = new JPopupMenu();
            this.setComponentPopupMenu(menuFields);
            JCheckBoxMenuItem cbmiShowNullSoftFields = new JCheckBoxMenuItem("Show null soft fields", this.mNullSoftFieldsVisible);
            cbmiShowNullSoftFields.addActionListener(e -> {
                this.mNullSoftFieldsVisible = !this.mNullSoftFieldsVisible;
                this.updateNullFieldsVisible();
                cbmiShowNullSoftFields.setSelected(this.mNullSoftFieldsVisible);
            });
            menuFields.add(cbmiShowNullSoftFields);
            JCheckBoxMenuItem cbmiShowNullHardFields = new JCheckBoxMenuItem("Show null hard fields", this.mNullHardFieldsVisible);
            cbmiShowNullHardFields.addActionListener(e -> {
                this.mNullHardFieldsVisible = !this.mNullHardFieldsVisible;
                this.updateNullFieldsVisible();
                cbmiShowNullHardFields.setSelected(this.mNullHardFieldsVisible);
            });
            menuFields.add(cbmiShowNullHardFields);
        }

        private JPanel createFieldPanel(LinkedList<DbFieldDef> fields, DbObject dbo, DevicePath path, AAppView view) {
            JPanel panel = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)panel);
            boolean isProduction = !AUtil.getAclDebugMode();
            for (DbFieldDef field : fields) {
                if (isProduction && field.isHidden()) continue;
                l.newline();
                DbFieldEditor<?> fieldEditor = DbObjectDetailsUI.getDbFieldEditor(field, dbo);
                JComponent compName = DbObjectDetailsUI.this.getFieldNameComponent(field, AUtil.hashSet((Object[])new DbObject[]{dbo}), view);
                JComponent compVal = DbObjectDetailsUI.this.getFieldValueComponent(field, dbo, view, path, fieldEditor);
                Object val = field.getValue(dbo);
                if (!field.getIsHard()) {
                    compName.setFont(compName.getFont().deriveFont(2));
                    if (val == null) {
                        this.mNullSoftFieldComps.add(compName);
                        this.mNullSoftFieldComps.add(compVal);
                    }
                } else if (val == null) {
                    this.mNullHardFieldComps.add(compName);
                    this.mNullHardFieldComps.add(compVal);
                }
                DbObjectDetailsUI.minColSize(compVal);
                l.add((Component)compName, (GridBagConstraints)TCell.fill(2));
                l.add((Component)compVal, (GridBagConstraints)TCellFillX);
            }
            l.addFillX();
            return panel;
        }

        protected void updateNullFieldsVisible() {
            for (Component c : this.mNullSoftFieldComps) {
                c.setVisible(this.mNullSoftFieldsVisible);
            }
            for (Component c : this.mNullHardFieldComps) {
                c.setVisible(this.mNullHardFieldsVisible);
            }
            Window w = UIUtil.getParentWindow((Component)this);
            if (w instanceof DbObjectDetailsUI) {
                ((DbObjectDetailsUI)((Object)w)).resizeDialog(true);
            }
        }
    }

    protected static class AttachmentsPanel
    extends JPanel {
        public AttachmentsPanel(final DbObject dbo) {
            GridBagManager l = GridBagManager.layout((Container)this);
            this.setBorder(BorderFactory.createTitledBorder("External Attachments"));
            IterableIterator attachments = Attachment.getAttachments((DbObject)dbo);
            if (attachments.hasNext()) {
                l.pushFillXRemainX();
                l.advance();
                DbObjectDetailsUI.listHdr(l.add("Type", (GridBagConstraints)TCellH));
                DbObjectDetailsUI.listHdr(l.add("File", (GridBagConstraints)TCellFillX));
                for (final Attachment attachment : attachments) {
                    AbstractAction openAction = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            attachment.open();
                        }
                    };
                    l.newline();
                    ALinkLabel btnDel = new ALinkLabel("");
                    btnDel.setIcon(iconDelete);
                    btnDel.setToolTipText("Delete Attachment");
                    btnDel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DbObjectDetailsUI.deleteAttachment(attachment);
                        }
                    });
                    l.add((Component)btnDel, (GridBagConstraints)TCell);
                    DbObjectDetailsUI.minColSize(l.add(attachment.getType(), (GridBagConstraints)TCell));
                    URI uri = attachment.getURI();
                    JLabel c = uri == null ? new JLabel("<NoFile>") : new ALinkLabel(attachment.getURI().toString(), openAction);
                    DbObjectDetailsUI.minColSize(l.add((Component)c, (GridBagConstraints)TCellH));
                }
                l.pop();
            }
            l.newline();
            final ALinkLabel btnAdd = new ALinkLabel("");
            btnAdd.setIcon(iconAdd);
            btnAdd.setToolTipText("Add Attachment");
            btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DbObjectDetailsUI.addAttachment(btnAdd, dbo);
                }
            });
            l.add((Component)btnAdd, (GridBagConstraints)TCell);
            JLabel lblAdd = l.add("Add attachment...", (GridBagConstraints)TCell);
            lblAdd.setFont(lblAdd.getFont().deriveFont(2));
            l.addFillX();
        }
    }

    public class CoopDetailPanel
    extends JPanel {
        public CoopDetailPanel(Set<APair<DevicePath, DbObject>> editSet, AAppView view) {
            GridBagManager l = GridBagManager.layout((Container)this);
            if (!this.isSameType(editSet)) {
                l.add("No Editable Data");
                return;
            }
            l.add((Component)new CoopFieldsDisplay(editSet, view), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.addFillY();
        }

        private boolean isSameType(Set<APair<DevicePath, DbObject>> editSet) {
            Class<?> type = null;
            for (APair<DevicePath, DbObject> e : editSet) {
                if (type == null) {
                    type = ((DbObject)e.getSecond()).getClass();
                    continue;
                }
                if (type == ((DbObject)e.getSecond()).getClass()) continue;
                return false;
            }
            return true;
        }
    }

    public class DetailsPanel
    extends JPanel {
        public DetailsPanel(DbObject dbObj, DevicePath path, AAppView view) {
            GridBagManager l = GridBagManager.layout((Container)this);
            Db db = dbObj.getDb();
            JPanel headPanel = this.createHead(db, dbObj, path, view);
            JScrollPane scrollPane = new JScrollPane(headPanel);
            scrollPane.setHorizontalScrollBarPolicy(30);
            scrollPane.setVerticalScrollBarPolicy(21);
            scrollPane.setPreferredSize(new Dimension(740, headPanel.getPreferredSize().height));
            scrollPane.setBorder(null);
            l.addNl((Component)scrollPane);
            if (dbObj.getDb() != null && (dbObj instanceof Device || dbObj instanceof DeviceTemplate)) {
                l.addNl((Component)new AttachmentsPanel(dbObj), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            }
            l.add((Component)new FieldsDisplay(dbObj, path, view), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            ReferencesPanel pnlRefs = new ReferencesPanel(dbObj, view, 3L);
            if (pnlRefs.getRelatedItemsDisplayed() > 0L) {
                l.newline();
                l.add((Component)pnlRefs, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            }
            l.newline();
            l.add((Component)new ALinkLabel("Relations...", DbObjectDetailsUI.showRelationsAction(this, DbObjectDetailsUI.this.mDbObject, DbObjectDetailsUI.this.mView)));
            l.addFillX();
            l.addFillY();
        }

        private JPanel createHead(Db db, DbObject dbObj, final DevicePath path, AAppView view) {
            String objType;
            JPanel headPanel = new JPanel();
            GridBagManager l = GridBagManager.layout((Container)headPanel);
            if (db == null) {
                objType = dbObj.getClass().getSimpleName();
                JLabel lbl = l.add(String.format("This %s is not in the database", objType), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                lbl.setFont(lbl.getFont().deriveFont(2));
                lbl.setBackground(Color.YELLOW);
                lbl.setOpaque(true);
                l.newline();
            } else {
                objType = dbObj.getDbClass().getName();
            }
            String keyStr = dbObj.getKeyStr();
            if (keyStr == null) {
                keyStr = "---";
            }
            l.add(objType + ":");
            JTextField lblObjKey = (JTextField)l.add((Component)new JTextField(keyStr));
            lblObjKey.setEditable(false);
            lblObjKey.setBackground(null);
            lblObjKey.setBorder(null);
            lblObjKey.setToolTipText(dbObj.getClass().getName() + "@" + Integer.toHexString(dbObj.hashCode()));
            UIUtil.addCopySupport((JTextComponent)lblObjKey);
            l.newline();
            if (path != null && !(dbObj instanceof StoredPath)) {
                l.add("Path:", (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
                JTextField lbl = new JTextField(path.escapedString());
                lbl.setEditable(false);
                lbl.setBackground(null);
                lbl.setBorder(null);
                l.add((Component)lbl, (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetTop(0));
                UIUtil.addCopySupport((JComponent)lbl, (UIUtil.ATextProvider)new UIUtil.ATextProvider(){

                    public String getText() {
                        return path.escapedString();
                    }
                });
                l.newline();
                if (dbObj instanceof PinTemplate) {
                    Object pinInst;
                    LinkedList instActions = Lists.newLinkedList();
                    Device device = path.getLast();
                    if (dbObj instanceof PinTemplate && (pinInst = device.getPin((PinTemplate)dbObj)) != null) {
                        instActions.add(DbObjectDetailsUI.showRelatedObjectAction(this, "[PinInstance]", (DbObject)pinInst, path, view));
                    }
                    if (instActions.size() > 0) {
                        l.addNl((Component)new AHorizDivider("Instance-specific actions"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
                        l.indent();
                        for (Action action : instActions) {
                            l.add((Component)new ALinkLabel(action));
                        }
                        l.newline();
                    }
                }
            }
            l.add("Last modified:", (GridBagConstraints)GridBagManager.LEFT.insetTop(0));
            long lm = dbObj.getLastModified();
            String lmStr = lm == 0L ? "-" : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSXXX").format(new Date(lm));
            String lmDesc = String.format("%s (%d)", lmStr, lm);
            UIUtil.addCopySupport((JLabel)l.add(lmDesc, (GridBagConstraints)GridBagManager.LEFT.insetTop(0)));
            l.addFillX();
            l.newline();
            return headPanel;
        }
    }

    public class ActionViewMode
    extends AbstractAction {
        private ViewMode setMode;

        public ActionViewMode(ViewMode mode) {
            this.setMode = mode;
            this.putValue("SwingSelectedKey", mode == DbObjectDetailsUI.this.mMode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbObjectDetailsUI.this.setViewMode(this.setMode);
        }
    }

    static enum ViewMode {
        SINGLE,
        TRACE,
        DIFF;

    }
}

