/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.SelectionContext;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.GetDbObjectsByPropertyFilterDlg;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DbObjectListPanel
extends JPanel {
    protected Db mDb = null;
    protected SelectionContext mSelCtx;
    protected DbObjectListListener mListener = null;
    protected AList<DbObject> mLstDBObjects;
    protected AListModel<DbObject> mDBObjects;
    protected JScrollPane mListScroller = null;
    protected ObjectCellRenderer mObjectCellRenderer = null;

    public DbObjectListPanel(Db db, DbObjectListListener listener) {
        this.init(db, listener);
    }

    protected void init(Db db, DbObjectListListener listener) {
        GridBagManager l = GridBagManager.layout((Container)this);
        this.mDb = db;
        this.mListener = listener;
        this.mSelCtx = SelectionContext.create((Db)db);
        this.mDBObjects = new AListModel();
        this.mLstDBObjects = new AList<DbObject>((ListModel<DbObject>)this.mDBObjects);
        this.mLstDBObjects.setSelectionMode(2);
        this.mLstDBObjects.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        this.mObjectCellRenderer = new ObjectCellRenderer();
        this.mLstDBObjects.setCellRenderer(this.mObjectCellRenderer);
        this.mListScroller = new JScrollPane(this.mLstDBObjects);
        this.refresh();
        l.add((Component)this.mListScroller, (GridBagConstraints)GridBagManager.FILLALL);
        this.installObjectListPopupMenu();
    }

    public void refresh() {
        this.mDBObjects.clear();
        List<DbObject> list = this.mListener.getObjects();
        if (list != null) {
            for (DbObject obj : list) {
                this.mDBObjects.addItem(obj);
            }
        }
    }

    protected void installObjectListPopupMenu() {
        class ObjectListButtonMouseListener
        extends MouseAdapter {
            JPopupMenu popup;

            protected void showPopup(MouseEvent e) {
                int row = DbObjectListPanel.this.mLstDBObjects.locationToIndex(e.getPoint());
                this.popup = new JPopupMenu();
                this.popup.add(new ActionAddItems());
                if (row >= 0 && DbObjectListPanel.this.mLstDBObjects.getSelectedIndex() >= 0) {
                    this.popup.add(new ActionDeleteItems());
                    if (DbObjectListPanel.this.mListener.enableCopyPaste()) {
                        this.popup.add(new ActionCopyItems());
                    }
                }
                if (DbObjectListPanel.this.mListener.enableCopyPaste() && DbObjectListPanel.this.mListener.getPasteObjects() != null) {
                    this.popup.add(new ActionPasteItems());
                }
                if (row >= 0) {
                    this.popup.add(new ActionDeleteRow(row));
                    this.popup.add(new ActionDeleteAll());
                }
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e);
                }
            }
        }
        this.mLstDBObjects.addMouseListener(new ObjectListButtonMouseListener());
    }

    protected class ActionDeleteAll
    extends AbstractAction {
        public ActionDeleteAll() {
            super("Delete all");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<DbObject> list = new ArrayList<DbObject>();
            for (int i = 0; i < DbObjectListPanel.this.mDBObjects.getSize(); ++i) {
                list.add(DbObjectListPanel.this.mDBObjects.getElementAt(i));
            }
            for (DbObject obj : list) {
                DbObjectListPanel.this.mListener.removeObject(obj);
            }
            DbObjectListPanel.this.refresh();
        }
    }

    protected class ActionDeleteRow
    extends AbstractAction {
        int row;

        public ActionDeleteRow(int r) {
            super("Delete " + DbObjectListPanel.this.mListener.cellText(DbObjectListPanel.this.mDBObjects.getElementAt(r)));
            this.row = 0;
            this.row = r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbObjectListPanel.this.mListener.removeObject(DbObjectListPanel.this.mDBObjects.getElementAt(this.row));
            DbObjectListPanel.this.refresh();
        }
    }

    protected class ActionPasteItems
    extends AbstractAction {
        public ActionPasteItems() {
            super("Paste");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<DbObject> list = DbObjectListPanel.this.mListener.getPasteObjects();
            for (DbObject obj : list) {
                DbObjectListPanel.this.mListener.addObject(obj);
            }
        }
    }

    protected class ActionCopyItems
    extends AbstractAction {
        public ActionCopyItems() {
            super("Copy picked");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objInds = DbObjectListPanel.this.mLstDBObjects.getSelectedIndices();
            ArrayList<DbObject> list = new ArrayList<DbObject>();
            for (int i : objInds) {
                list.add(DbObjectListPanel.this.mDBObjects.getElementAt(i));
            }
            DbObjectListPanel.this.mListener.copyObjects(list);
        }
    }

    protected class ActionDeleteItems
    extends AbstractAction {
        public ActionDeleteItems() {
            super("Delete picked");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] objInds = DbObjectListPanel.this.mLstDBObjects.getSelectedIndices();
            ArrayList<DbObject> list = new ArrayList<DbObject>();
            for (int i : objInds) {
                list.add(DbObjectListPanel.this.mDBObjects.getElementAt(i));
            }
            Object object = list.iterator();
            while (object.hasNext()) {
                DbObject obj = (DbObject)object.next();
                DbObjectListPanel.this.mListener.removeObject(obj);
            }
            DbObjectListPanel.this.refresh();
        }
    }

    protected class ActionAddItems
    extends AbstractAction {
        public ActionAddItems() {
            super("Add...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GetDbObjectsByPropertyFilterDlg.createDialog(OrbitIO.getMainWindow(), new GetDbObjectsByPropertyFilterAdapter());
        }
    }

    public class GetDbObjectsByPropertyFilterAdapter
    implements GetDbObjectsByPropertyFilterDlg.GetDbObjectsByPropertyFilterListener {
        @Override
        public Db getDb() {
            return DbObjectListPanel.this.mDb;
        }

        @Override
        public String getTitle() {
            return "Add " + DbObjectListPanel.this.mListener.getUserObjectName() + "'s to " + DbObjectListPanel.this.mListener.getTitle();
        }

        @Override
        public String getUserObjectName() {
            return DbObjectListPanel.this.mListener.getUserObjectName();
        }

        @Override
        public Selector.Descriptor<?> getDescriptor() {
            return DbObjectListPanel.this.mListener.getDescriptor();
        }

        @Override
        public void doOkCommand(IterableIterator<Object> filterItems, String propName) {
            for (Object obj : filterItems) {
                if (obj instanceof String && obj.toString().equals("<NONE>")) {
                    DbObjectListPanel.this.mListener.addObject(null);
                    continue;
                }
                if (!(obj instanceof DbObject)) continue;
                DbObjectListPanel.this.mListener.addObject((DbObject)obj);
            }
        }

        @Override
        public List<Selector.Property<?>> getOverridePropertyList() {
            return DbObjectListPanel.this.mListener.getOverridePropertyList();
        }

        @Override
        public List<Object> getOverridePropertyValueList(Selector.Property<?> prop) {
            return DbObjectListPanel.this.mListener.getOverridePropertyValueList(prop);
        }

        @Override
        public Selector.Property<?> getDefaultToSelect() {
            for (Selector.Property<?> prop : DbObjectListPanel.this.mListener.getOverridePropertyList()) {
                if (!prop.getName().equals("name")) continue;
                return prop;
            }
            return null;
        }
    }

    class ObjectCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ObjectCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                this.setText("<NONE>");
                this.setIcon(null);
                if (isSelected) {
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(Color.white);
                }
            } else if (value instanceof DbObject) {
                if (DbObjectListPanel.this.mListener.cellText((DbObject)value) == null) {
                    this.setText(((DbObject)value).asString());
                } else {
                    this.setText(DbObjectListPanel.this.mListener.cellText((DbObject)value));
                }
                if (DbObjectListPanel.this.mListener.cellIconColor((DbObject)value, isSelected) != null) {
                    this.setIcon((Icon)new AColorIcon(16, 16, DbObjectListPanel.this.mListener.cellIconColor((DbObject)value, isSelected)));
                }
                if (isSelected) {
                    this.setBackground(Color.lightGray);
                } else {
                    this.setBackground(Color.white);
                }
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    public static interface DbObjectListListener {
        public String getTitle();

        public String getUserObjectName();

        public Selector.Descriptor<?> getDescriptor();

        public List<DbObject> getObjects();

        public List<Selector.Property<?>> getOverridePropertyList();

        public List<Object> getOverridePropertyValueList(Selector.Property<?> var1);

        public void addObject(DbObject var1);

        public void removeObject(DbObject var1);

        public boolean enableCopyPaste();

        public void copyObjects(List<DbObject> var1);

        public List<DbObject> getPasteObjects();

        public String cellText(DbObject var1);

        public Color cellIconColor(DbObject var1, boolean var2);
    }
}

