/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;

public class DbObjectUI {
    public static final ObjectActionRegistry.ActionFactory<Selection> ActionFactorySelection = (selection, constraints) -> {
        List<DbObject> dbObjs = selection.getAll().stream().collect(Collectors.toList());
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        if (!dbObjs.isEmpty()) {
            actions.add(new ActionRemoveFromDatabase(dbObjs));
            actions.add(new ActionZoomToSelection((Selection)selection));
        }
        return actions.iterator();
    };

    private DbObjectUI() {
    }

    public static ARect getWorldBounds(DbObject dbobj, DevicePath dp) {
        AffineTransform trans;
        assert (dp.getIsAbsolute());
        AffineTransform affineTransform = trans = dp != null ? dp.getTransform() : null;
        if (dbobj instanceof Device) {
            return ((Device)dbobj).getBounds().transform(trans).getBounds();
        }
        if (dbobj instanceof DeviceTemplate) {
            return ((DeviceTemplate)dbobj).getBounds().transform(trans).getBounds();
        }
        if (dbobj instanceof PinTemplate) {
            return ((PinTemplate)dbobj).getBounds().transform(trans).getBounds();
        }
        if (dbobj instanceof PortTemplate) {
            return ((PortTemplate)dbobj).getBounds().transform(trans).getBounds();
        }
        if (dbobj instanceof PadTemplate) {
            return ((PadTemplate)dbobj).getBB(trans);
        }
        if (dbobj instanceof PinInstance) {
            return ((PinInstance)dbobj).getWorldBounds(dp);
        }
        if (dbobj instanceof Wire) {
            return ((Wire)dbobj).getWorldBounds(dp);
        }
        if (dbobj instanceof Metal) {
            return ((Metal)dbobj).getBB().transform(trans).getBounds();
        }
        if (dbobj instanceof Floorplan) {
            return ((Floorplan)dbobj).getBounds(dp);
        }
        if (dbobj instanceof Interface) {
            return ((Interface)dbobj).getGeom().getBounds();
        }
        if (dbobj instanceof Connection) {
            return ((Connection)dbobj).getRect();
        }
        if (dbobj instanceof LayerShape) {
            return ((LayerShape)dbobj).getBounds().transform(trans).getBounds();
        }
        if (dbobj instanceof Bundle) {
            return ((Bundle)dbobj).getPath().getBounds().transform(trans).getBounds();
        }
        return null;
    }

    public static Stream<DevicePath> getInstancePaths(DbObject dbobj) {
        if (dbobj instanceof Device) {
            return ((Device)dbobj).getAllPaths();
        }
        if (dbobj instanceof DeviceTemplate) {
            return ((DeviceTemplate)dbobj).getHierarchicalInstances().stream();
        }
        if (dbobj instanceof PinTemplate) {
            return DbObjectUI.getInstancePaths((DbObject)((PinTemplate)dbobj).getDeviceTemplate());
        }
        if (dbobj instanceof PadTemplate) {
            return ((PadTemplate)dbobj).getPinTemplates().stream().map(PinTemplate::getDeviceTemplate).distinct().flatMap(DbObjectUI::getInstancePaths);
        }
        if (dbobj instanceof PortTemplate) {
            return DbObjectUI.getInstancePaths((DbObject)((PortTemplate)dbobj).getPinTemplate());
        }
        if (dbobj instanceof PinInstance) {
            return DbObjectUI.getInstancePaths((DbObject)((PinInstance)dbobj).getDevice());
        }
        if (dbobj instanceof Wire) {
            return DbObjectUI.getInstancePaths((DbObject)((Wire)dbobj).getNet().getDeviceTemplate());
        }
        if (dbobj instanceof Metal) {
            return DbObjectUI.getInstancePaths((DbObject)((Metal)dbobj).getNet().getDeviceTemplate());
        }
        if (dbobj instanceof Floorplan) {
            return DbObjectUI.getInstancePaths((DbObject)((Floorplan)dbobj).getDeviceTemplate());
        }
        if (dbobj instanceof Interface) {
            return Stream.of(Design.getDesignPath((Db)dbobj.getDb()));
        }
        if (dbobj instanceof Connection) {
            return Stream.of(Design.getDesignPath((Db)dbobj.getDb()));
        }
        if (dbobj instanceof LayerShape) {
            return DbObjectUI.getInstancePaths(((LayerShape)dbobj).getOwner());
        }
        if (dbobj instanceof Bundle) {
            return DbObjectUI.getInstancePaths((DbObject)((Bundle)dbobj).getTemplate());
        }
        return Stream.empty();
    }

    public static class ActionZoomToSelection
    extends AbstractAction {
        protected Selection mSelection;

        public ActionZoomToSelection(Selection selection) {
            super("Zoom To");
            this.mSelection = selection;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ARect bounds = null;
            for (DbObject dbo : this.mSelection.getAll()) {
                List dps = this.mSelection.getSelectedPaths(dbo).stream().collect(Collectors.toList());
                if (dps.isEmpty()) {
                    dps = DbObjectUI.getInstancePaths(dbo).collect(Collectors.toList());
                }
                for (DevicePath dp : dps) {
                    ARect bound = DbObjectUI.getWorldBounds(dbo, dp);
                    if (bound == null) continue;
                    bounds = bound.expandBy(bounds);
                }
            }
            if (bounds == null) {
                return;
            }
            DesignView2D view = (DesignView2D)OrbitIO.getCurView();
            ARect r = new ARect(bounds);
            r.changeSizeBy(0.1);
            view.getCanvas().getXForm().setWorld(r);
            view.getCanvas().refresh();
        }
    }

    public static class ActionRemoveFromDatabase
    extends AbstractAction {
        protected List<DbObject> mDbObjs;

        public ActionRemoveFromDatabase(List<DbObject> dbos) {
            super("Remove from Database");
            this.mDbObjs = dbos;
            boolean canDelete = this.mDbObjs.stream().anyMatch(dbObj -> {
                Method methodDelete = AUtil.getMethod(dbObj.getClass(), (String)"deleteFromDb", (Class[])new Class[0]);
                return methodDelete != null;
            });
            this.setEnabled(canDelete);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (DbObject dbObj : this.mDbObjs) {
                Method methodDelete = AUtil.getMethod(dbObj.getClass(), (String)"deleteFromDb", (Class[])new Class[0]);
                if (methodDelete == null) continue;
                Object dbo = Cp.exec((String)"dbo = %s", (Object[])new Object[]{CpHelper.getObjCmdStr(dbObj)});
                if (dbo == null) {
                    ALog.logError((Throwable)new Throwable(), (String)"Error getting DbObject using command.", (Object[])new Object[0]);
                    return;
                }
                Cp.exec((String)"dbo.deleteFromDb()", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"dbo\")", (Object[])new Object[0]);
            }
        }
    }
}

