/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import java.awt.Dimension;
import java.awt.Window;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.VBox;

public class DbTransactionUI {
    private DbTransactionUI() {
    }

    public static void show(Db db, Window owner, DbHistory.Transaction transaction) {
        TransactionDialog dialog = new TransactionDialog(db, owner, "Transaction Detail", transaction);
        dialog.setVisible(true);
    }

    public static class TransactionDialog
    extends AJFXDesignDialog {
        protected DbHistory.Transaction mTransaction;

        public TransactionDialog(Db db, Window owner, String title, DbHistory.Transaction transaction) {
            super(db, owner, title);
            this.mTransaction = transaction;
            this.init();
            this.setModal(false);
            this.setResizable(false);
        }

        protected AJFXPanel createJfxPanel() {
            return new CMainPanel();
        }

        private class CMainPanel
        extends AJFXPanel {
            private static final int PANEL_WIDTH = 800;
            private static final int PANEL_HEIGHT = 600;

            public CMainPanel() {
                this.setPreferredSize(new Dimension(800, 600));
            }

            protected Parent initSceneGraph() {
                VBox centerContainer = new VBox();
                ListView eventList = new ListView();
                ObservableList items = FXCollections.observableArrayList();
                for (DbHistory.ChangeEvent e : TransactionDialog.this.mTransaction.getEvents()) {
                    items.add((Object)e.toString());
                }
                eventList.setItems(items);
                ScrollPane scrollPane = new ScrollPane();
                scrollPane.setContent((Node)eventList);
                scrollPane.setFitToWidth(true);
                scrollPane.setFitToHeight(true);
                centerContainer.getChildren().add((Object)scrollPane);
                return centerContainer;
            }
        }
    }
}

