/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.ContactLayer;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.PinMap;
import com.sigrity.acl.jfxui.AJFXDesignDialog;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;

public class DeleteContactUI
extends AJFXDesignDialog {
    private DevicePath mDevPath;

    public static Action getAction(final DevicePath devPath) {
        return new AbstractAction("Delete Contact..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeleteContactUI.createDialog(OrbitIO.getMainWindow(), devPath);
            }

            @Override
            public boolean isEnabled() {
                return super.isEnabled() && OrbitIO.getCurDb() != null;
            }
        };
    }

    public static boolean hasContacts(DevicePath devPath) {
        return ContactLayer.getValid((Db)devPath.getDb()).stream().anyMatch(contactLayer -> {
            DevicePath devPathA = contactLayer.getDevicePathA();
            DevicePath devPathB = contactLayer.getDevicePathB();
            return devPath.endsWith(devPathA) || devPath.pathToSubstrate().equals((Object)devPathA.pathToSubstrate()) || devPath.endsWith(devPathB) || devPath.pathToSubstrate().equals((Object)devPathB.pathToSubstrate());
        });
    }

    public static DeleteContactUI createDialog(Window owner, DevicePath db) {
        if (db == null) {
            return null;
        }
        DeleteContactUI dlg = new DeleteContactUI(owner, db);
        dlg.setVisible(true);
        return dlg;
    }

    private DeleteContactUI(Window owner, DevicePath devPath) {
        super(devPath.getDb(), (Component)owner, "Delete Contacts", Dialog.ModalityType.APPLICATION_MODAL);
        this.mDevPath = devPath;
        this.init();
    }

    protected AJFXPanel createJfxPanel() {
        return new ContactInfoPanel();
    }

    private static String getFullPathsString(DevicePath devPath) {
        if (devPath == null) {
            return null;
        }
        return devPath.getAllFullPaths().mapAndNonNull(DevicePath::toString).reduce((pathStr1, pathStr2) -> String.format("%s%n%s", pathStr1, pathStr2)).orElse(null);
    }

    public static void cpDeletePins(String contactLayerKeyStr, boolean isDevPathA) {
        Cp.exec((String)"unset(\"_deleteContactPins\");", (Object[])new Object[0]);
        Cp.exec((String)"_deleteContactPins = new com.sigrity.orbit.factory.ContactsRemover(curDb(), \"%s\", %b);", (Object[])new Object[]{contactLayerKeyStr, isDevPathA});
        Cp.exec((String)"_deleteContactPins.deleteContactPins();", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_deleteContactPins\");", (Object[])new Object[0]);
    }

    public static void cpDeleteDevs(String contactLayerKeyStr, boolean isDevPathA) {
        Cp.exec((String)"unset(\"_deleteContactDev\");", (Object[])new Object[0]);
        Cp.exec((String)"_deleteContactDev = new com.sigrity.orbit.factory.ContactsRemover(curDb(), \"%s\", %b);", (Object[])new Object[]{contactLayerKeyStr, isDevPathA});
        Cp.exec((String)"_deleteContactDev.deleteContactDevice();", (Object[])new Object[0]);
        Cp.exec((String)"unset(\"_deleteContactDev\");", (Object[])new Object[0]);
    }

    public static enum DeleteActionType {
        DEVICE("Delete the contact device"),
        PIN("Delete contact pins");

        String showStr;

        private DeleteActionType(String showStr) {
            this.showStr = showStr;
        }

        public String toString() {
            return this.showStr;
        }
    }

    private static class Info {
        private ContactLayer contactLayer;
        private boolean isDevPathA;

        public Info(ContactLayer contactLayer, boolean isDevPathA) {
            this.contactLayer = contactLayer;
            this.isDevPathA = isDevPathA;
        }

        public String getContactLayerKeyStr() {
            return this.contactLayer.getKeyStr();
        }

        public boolean getIsDevPathA() {
            return this.isDevPathA;
        }

        public DevicePath getDevPath() {
            return this.isDevPathA ? this.contactLayer.getDevicePathA() : this.contactLayer.getDevicePathB();
        }

        public Layer getLayer() {
            return this.isDevPathA ? this.contactLayer.getContactLayerA() : this.contactLayer.getContactLayerB();
        }

        public String getLayerName() {
            return this.getLayer().getName();
        }

        public long getNumContactPin() {
            return PinMap.get((ContactLayer)this.contactLayer).stream().map(pinMap -> this.isDevPathA ? pinMap.getHierPinA() : pinMap.getHierPinB()).distinct().count();
        }

        public String getNumContactPinStr() {
            return Long.toString(this.getNumContactPin());
        }
    }

    private class ContactInfoPanel
    extends AJFXPanel {
        private static final int PANEL_WIDTH = 460;
        private static final int PANEL_HEIGHT = 180;
        private ContactInfoTable mImportInfoTable;
        EventHandler<javafx.event.ActionEvent> mOkHandler = new EventHandler<javafx.event.ActionEvent>(){

            public void handle(javafx.event.ActionEvent arg0) {
                HashMap info2DeleteActionType = new HashMap();
                ContactInfoPanel.this.mImportInfoTable.getSelectionModel().getSelectedItems().forEach(info -> {
                    Optional deleteActionType = Optional.of(DeleteActionType.PIN);
                    if (info.getDevPath().getIsAbstractContactDevice()) {
                        ChoiceDialog dialog = new ChoiceDialog((Object)DeleteActionType.DEVICE, (Object[])DeleteActionType.values());
                        dialog.setTitle("Delete contacts");
                        String msg = String.format("'%s' is a contact device", DeleteContactUI.getFullPathsString(info.getDevPath()));
                        dialog.setHeaderText(msg);
                        deleteActionType = dialog.showAndWait();
                    }
                    if (deleteActionType.isPresent()) {
                        info2DeleteActionType.put(info, deleteActionType.get());
                    }
                });
                SwingUtilities.invokeLater(() -> {
                    try (DbHistory.DbTransaction dbT = DbHistory.newDbTransaction((Db)DeleteContactUI.this.getDb(), (String)"Delete contacts");){
                        info2DeleteActionType.forEach((info, deleteActionType) -> {
                            if (deleteActionType == DeleteActionType.PIN) {
                                this.deletePins((Info)info);
                            } else if (deleteActionType == DeleteActionType.DEVICE) {
                                this.deleteDevs((Info)info);
                            }
                        });
                    }
                    OrbitIO.refreshViewsOf(DeleteContactUI.this.mDb);
                    DbExplorerPanel.refreshAll();
                    UIUtil.closeWindow((Window)((Object)DeleteContactUI.this));
                });
            }

            private void deletePins(Info info) {
                DeleteContactUI.cpDeletePins(info.getContactLayerKeyStr(), info.getIsDevPathA());
            }

            private void deleteDevs(Info info) {
                DeleteContactUI.cpDeleteDevs(info.getContactLayerKeyStr(), info.getIsDevPathA());
            }
        };

        public ContactInfoPanel() {
            this.setPreferredSize(new Dimension(460, 180));
        }

        public void resize(Dimension size) {
            Platform.setImplicitExit((boolean)false);
            Platform.runLater(() -> this.mImportInfoTable.resize(size));
        }

        protected Parent initSceneGraph() {
            VBox root = new VBox(5.0);
            this.mImportInfoTable = new ContactInfoTable();
            root.getChildren().add((Object)this.mImportInfoTable);
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)DeleteContactUI.this), this.mOkHandler);
            root.getChildren().add((Object)okCancelHBox);
            return root;
        }

        private class ContactInfoTable
        extends TableView<Info> {
            private static final int PANEL_WIDTH_INT = 420;
            private static final int PANEL_HEIGHT_INT = 100;

            public ContactInfoTable() {
                this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
                this.setMinSize(420.0, 100.0);
                this.setSelectionModel();
                this.setEditable(true);
                this.initTableColumn();
                this.initTableRow();
            }

            private void setSelectionModel() {
                TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
                selectionModel.setSelectionMode(SelectionMode.MULTIPLE);
            }

            public void initTableColumn() {
                TableColumn devPathColumn = new TableColumn("DevicePath");
                devPathColumn.setPrefWidth(200.0);
                devPathColumn.setCellValueFactory(param -> new SimpleObjectProperty((Object)((Info)param.getValue()).getDevPath()));
                devPathColumn.setCellFactory(column -> this.getDevicePathCellFactory());
                this.getColumns().add((Object)devPathColumn);
                TableColumn layerColumn = new TableColumn("Layer");
                layerColumn.setPrefWidth(100.0);
                layerColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((Info)param.getValue()).getLayerName()));
                this.getColumns().add((Object)layerColumn);
                TableColumn numContactPinColumn = new TableColumn("# Contact Pin");
                numContactPinColumn.setPrefWidth(120.0);
                numContactPinColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((Info)param.getValue()).getNumContactPinStr()));
                this.getColumns().add((Object)numContactPinColumn);
            }

            private TableCell<Info, DevicePath> getDevicePathCellFactory() {
                return new TableCell<Info, DevicePath>(){

                    protected void updateItem(DevicePath devPath, boolean empty) {
                        super.updateItem((Object)devPath, empty);
                        if (devPath == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(DeleteContactUI.getFullPathsString(devPath));
                        }
                    }
                };
            }

            private void initTableRow() {
                ObservableList infos = FXCollections.observableArrayList(this.getContactInfos());
                this.setItems(infos);
            }

            private List<Info> getContactInfos() {
                return ContactLayer.getValid((Db)DeleteContactUI.this.mDevPath.getDb()).stream().map(contactLayer -> {
                    DevicePath devPathA = contactLayer.getDevicePathA();
                    DevicePath devPathB = contactLayer.getDevicePathB();
                    if (DeleteContactUI.this.mDevPath.endsWith(devPathA) || DeleteContactUI.this.mDevPath.pathToSubstrate().equals((Object)devPathA.pathToSubstrate())) {
                        return new Info((ContactLayer)contactLayer, false);
                    }
                    if (DeleteContactUI.this.mDevPath.endsWith(devPathB) || DeleteContactUI.this.mDevPath.pathToSubstrate().equals((Object)devPathB.pathToSubstrate())) {
                        return new Info((ContactLayer)contactLayer, true);
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }

            public void resize(Dimension size) {
                this.setMinSize(size.getWidth() - 40.0, size.getHeight() - 80.0);
                this.setPrefSize(size.getWidth() - 40.0, size.getHeight() - 80.0);
            }
        }
    }
}

