/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.cphelper.CpHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JRadioButton;

public class DeleteDeviceUI {
    public static boolean deleteDevice(Db db, String deviceKey, boolean delAllTemplateInsts, boolean delTemplate, boolean delSubstrate) {
        Device device = (Device)db.getByKeyStr(Device.class, deviceKey);
        if (device == null) {
            ALog.logError((String)"No device '%s' exists in the current database.", (Object[])new Object[]{deviceKey});
            return false;
        }
        return DeleteDeviceUI.deleteDevice(device, delAllTemplateInsts, delTemplate, delSubstrate);
    }

    public static boolean deleteDevice(Device device, boolean delAllTemplateInsts, boolean delTemplate, boolean delSubstrate) {
        if (device == null) {
            ALog.logError((String)"No device exists in the current database.");
            return false;
        }
        Substrate s = device.getSubstrate();
        DeviceTemplate template = device.getTemplate();
        if (delAllTemplateInsts) {
            template.deleteAllTemplateInsts();
        } else {
            device.deleteFromDb();
        }
        if (delTemplate) {
            template.deleteFromDb();
        }
        if (delSubstrate) {
            s.deleteFromDb(true);
        }
        return true;
    }

    public static boolean showUI(Window dlgOwner, Device device) {
        DeleteDeviceDlg dlg = new DeleteDeviceDlg(dlgOwner, device);
        dlg.setVisible(true);
        return dlg.mDeleted;
    }

    private DeleteDeviceUI() {
    }

    static class DeleteDeviceDlg
    extends ADialog {
        private Device mDevice;
        private DeviceTemplate mDeviceTemplate;
        protected boolean mDeleted = false;
        protected JRadioButton mRbDeleteAll;
        protected JCheckBox mCbDeleteTemplate;
        protected JCheckBox mCbDeleteSubstrate = null;
        protected JButton mBtnOk;
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtil.closeWindow((Window)((Object)this));
                Db db = mDevice.getDb();
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)db, (String)"Delete device...");){
                    this.checkContactDevice();
                    this.deleteDevice();
                }
                OrbitIO.getApp().refreshCurrentView(false);
            }

            private void checkContactDevice() {
                assert (mDevice != null);
                Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
                Cp.exec((String)"_sync = new com.sigrity.orbit.automation.contact_sync.ContactObjectSyncEngine(curDb());", (Object[])new Object[0]);
                if (this.isDeleteAllTemplateInsts()) {
                    mDeviceTemplate.getDeviceInstances().forEach(dev -> Cp.exec((String)"_sync.addToSyncDelete(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(dev)}));
                } else {
                    Cp.exec((String)"_sync.addToSyncDelete(%s);", (Object[])new Object[]{CpHelper.getObjCmdStr(mDevice)});
                }
                Cp.exec((String)"_sync.execute();", (Object[])new Object[0]);
                Cp.exec((String)"unset(\"_sync\");", (Object[])new Object[0]);
            }

            private void deleteDevice() {
                if (!mDeviceTemplate.getDeviceInstances().hasNext()) {
                    return;
                }
                String devKeyStr = mDevice.getKeyStr();
                if (devKeyStr == null) {
                    devKeyStr = ((Device)mDeviceTemplate.getDeviceInstances().next()).getKeyStr();
                }
                Cp.exec((String)"com.sigrity.orbit.ui.DeleteDeviceUI.deleteDevice(curDb(), \"%s\", %b, %b, %s)", (Object[])new Object[]{devKeyStr, this.isDeleteAllTemplateInsts(), this.isDeleteTemplate(), this.isDeleteSubstrate()});
            }

            private boolean isDeleteSubstrate() {
                return mCbDeleteSubstrate != null && mCbDeleteSubstrate.isEnabled() && mCbDeleteSubstrate.isSelected();
            }

            private boolean isDeleteTemplate() {
                return mCbDeleteTemplate.isEnabled() && mCbDeleteTemplate.isSelected();
            }

            private boolean isDeleteAllTemplateInsts() {
                return mRbDeleteAll != null && mRbDeleteAll.isSelected();
            }
        };

        public DeleteDeviceDlg(Window owner, Device device) {
            super(owner);
            this.mDevice = device;
            this.mDeviceTemplate = device.getTemplate();
            this.setTitle("Delete Device");
            this.setRecallBounds(false);
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            int instCount = this.mDeviceTemplate.getHierarchicalInstanceCount();
            assert (instCount != 0);
            Substrate substrate = this.mDeviceTemplate.getSubstrate();
            int substRefCount = substrate == null ? 0 : substrate.getDeviceTemplateCount();
            String instCountText = instCount == 1 ? "There is one instance of device template ''{1}''." : "There are {0} instances of device template ''{1}''.";
            l.add(MessageFormat.format(instCountText, instCount, this.mDeviceTemplate.getName()));
            l.newline();
            DevicePath path = device.getADevicePath();
            for (DevicePath descendent : path.getDescendants()) {
                if (!descendent.getSubstrate().equals((Object)device.getSubstrate())) continue;
                --substRefCount;
            }
            if (instCount > 1) {
                ButtonGroup bg = new ButtonGroup();
                String oneInstText = String.format("Delete the selected device '%s'", device.getKeyStr());
                JRadioButton rbDeleteOne = new JRadioButton(oneInstText);
                rbDeleteOne.setSelected(true);
                bg.add(rbDeleteOne);
                l.add((Component)rbDeleteOne, (GridBagConstraints)GridBagManager.LEFT.noInsets());
                l.newline();
                this.mRbDeleteAll = new JRadioButton("Delete all instances of the template");
                bg.add(this.mRbDeleteAll);
                l.add((Component)this.mRbDeleteAll, (GridBagConstraints)GridBagManager.LEFT.noInsets());
                l.newline();
                this.mRbDeleteAll.addChangeListener(e -> this.enableDeleteTemplateAndSubstrate());
            }
            l.newline();
            String strTemplate = String.format("Also delete the device template ('%s')", this.mDeviceTemplate.getName());
            this.mCbDeleteTemplate = new JCheckBox(strTemplate);
            l.add((Component)this.mCbDeleteTemplate, (GridBagConstraints)GridBagManager.LEFT);
            this.mCbDeleteTemplate.addActionListener(e -> this.enableDeleteTemplateAndSubstrate());
            if (substrate != null && substRefCount <= 1) {
                l.newline();
                String strSubst = String.format("Also delete the Substrate definition ('%s')", substrate.getName());
                this.mCbDeleteSubstrate = new JCheckBox(strSubst);
                l.add((Component)this.mCbDeleteSubstrate, (GridBagConstraints)GridBagManager.LEFT);
            }
            this.enableDeleteTemplateAndSubstrate();
            l.addFillY();
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            this.mBtnOk = new JButton("OK");
            l.add((Component)this.mBtnOk, (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        protected void enableDeleteTemplateAndSubstrate() {
            this.mCbDeleteTemplate.setEnabled(this.mRbDeleteAll == null || this.mRbDeleteAll.isSelected());
            if (this.mCbDeleteSubstrate != null) {
                this.mCbDeleteSubstrate.setEnabled(this.mCbDeleteTemplate.isEnabled() && this.mCbDeleteTemplate.isSelected());
                if (!this.mCbDeleteTemplate.isSelected()) {
                    this.mCbDeleteSubstrate.setSelected(false);
                }
            }
        }
    }
}

