/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Timer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DesignCanvasInfoDisplay {
    public static final String CONFIG_FILENAME = "DesignCanvasInfoDisplay.xml";
    protected static Manager theManager = new Manager();

    private DesignCanvasInfoDisplay() {
    }

    public static Manager getManager() {
        return theManager;
    }

    public static Registry getRegistry() {
        return new Registry();
    }

    public static Implementation install(DesignView2D view) {
        return DesignCanvasInfoDisplay.install(view, null);
    }

    public static Implementation install(DesignView2D view, String factoryName) {
        if (view == null) {
            ALog.logWarn((String)"Attempt to install DesignCanvasInfoDisplay on 'null' view, ignoring.");
            return null;
        }
        Registry registry = DesignCanvasInfoDisplay.getRegistry();
        Factory factory = null;
        if (factoryName != null) {
            factory = registry.getByName(factoryName);
            if (factory == null) {
                ALog.logWarn((String)"The specified DesignCanvasInfoFactory name '%s' was not found.");
                return null;
            }
        } else {
            factory = registry.getDefault();
            if (factory == null) {
                ALog.logWarn((String)"No default DesignCanvasInfoFactory not found.", (Object[])new Object[]{factoryName});
                return null;
            }
        }
        return factory.install(view);
    }

    public static abstract class AbstractImplementation
    implements Implementation {
        protected DesignView2D mView;
        protected Thread mActiveSearchThread = null;
        protected MouseAdapter mMouseListener = new MouseAdapter(){
            Timer mRunningTimer;

            @Override
            public void mouseMoved(MouseEvent e) {
                this.displayItemInfo(null);
                if (this.mRunningTimer != null) {
                    this.mRunningTimer.stop();
                }
                this.stopSearch();
                this.mRunningTimer = new Timer(100, event -> this.startSearch());
                this.mRunningTimer.setRepeats(false);
                this.mRunningTimer.start();
            }
        };

        public AbstractImplementation(DesignView2D view) {
            this.mView = view;
            this.mView.getCanvas().addMouseMotionListener(this.mMouseListener);
        }

        @Override
        public void uninstall() {
            if (this.mView != null && this.mView.getCanvas() != null) {
                this.mView.getCanvas().removeMouseMotionListener(this.mMouseListener);
            }
            this.mView = null;
        }

        protected void stopSearch() {
            if (this.mActiveSearchThread == null) {
                return;
            }
            this.mActiveSearchThread.interrupt();
            this.mActiveSearchThread = null;
        }

        protected void startSearch() {
            this.mActiveSearchThread = new Thread(this::search, "DesignCanvasInfoDisplay-Search");
            this.mActiveSearchThread.start();
        }

        protected void search() {
            try {
                String text;
                Design design;
                Db db = this.mView == null ? null : this.mView.getDb();
                Design design2 = design = db == null ? null : Design.getDesign((Db)db);
                if (design == null) {
                    return;
                }
                DesignCanvas2D canvas = this.mView.getCanvas();
                if (canvas == null) {
                    return;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                Point mouseLoc = canvas.getMouseLoc();
                APoint2D worldPt = canvas.getWorldPt(mouseLoc);
                HierInst<DbObject> hdbo = this.getItemAt(design, worldPt);
                if (Thread.currentThread().isInterrupted() || !AUtil.equals((Object)mouseLoc, (Object)canvas.getMouseLoc())) {
                    return;
                }
                String string = text = hdbo == null ? null : this.getTextForItem(hdbo);
                if (Thread.currentThread().isInterrupted() || !AUtil.equals((Object)mouseLoc, (Object)canvas.getMouseLoc())) {
                    return;
                }
                EventQueue.invokeLater(() -> this.displayItemInfo(text));
            }
            catch (Throwable t) {
                ALog.logDebug((Throwable)t, (String)"Exception searching for DesignCanvasInfoDisplay item.", (Object[])new Object[0]);
            }
        }

        protected abstract HierInst<DbObject> getItemAt(Design var1, APoint2D var2);

        protected abstract String getTextForItem(HierInst<DbObject> var1);

        protected abstract void displayItemInfo(String var1);
    }

    public static interface XmlConfig {
        public void loadConfig(Element var1);
    }

    public static interface Implementation {
        public Factory getFactory();

        public void uninstall();
    }

    public static interface Factory {
        public String getName();

        public Implementation install(DesignView2D var1);
    }

    public static class Registry {
        protected LinkedHashMap<String, Factory> mName2Factory = new LinkedHashMap();
        protected Factory mDefaultFactory = null;

        protected Registry() {
            File file = Settings.findConfigFile((String)DesignCanvasInfoDisplay.CONFIG_FILENAME);
            if (file == null) {
                ALog.logWarn((String)"Unable to find configuration file '%s', using default settings.", (Object[])new Object[]{DesignCanvasInfoDisplay.CONFIG_FILENAME});
            } else {
                String confPath;
                try {
                    confPath = file.getCanonicalPath();
                }
                catch (IOException e) {
                    confPath = file.getAbsolutePath();
                }
                Element doc = AXDomUtil.getDocumentElement((File)file);
                String dfltFactoryClass = doc.getAttribute("default");
                for (Element elFactory : AXDomUtil.getChildElems((Node)doc, (String)"Factory")) {
                    Class<?> uncheckedCls;
                    String factoryClassName = elFactory.getAttribute("class");
                    try {
                        uncheckedCls = Class.forName(factoryClassName);
                    }
                    catch (ClassNotFoundException e) {
                        ALog.logWarn((Throwable)e, (String)"Unable to load class '%s' specified as a DesignCanvasDisplayInfo factory in '%s'.", (Object[])new Object[]{factoryClassName, confPath});
                        continue;
                    }
                    if (!Factory.class.isAssignableFrom(uncheckedCls)) {
                        ALog.logWarn((String)"The class '%s' specified as a DesignCanvasDisplayInfo  factory in '%s' does not implement %s, it will no be used.", (Object[])new Object[]{factoryClassName, confPath, Factory.class.getName()});
                        continue;
                    }
                    Class<?> factoryClass = uncheckedCls;
                    try {
                        Element elConfig;
                        Factory factory = (Factory)factoryClass.newInstance();
                        String name = factory.getName();
                        this.mName2Factory.put(name, factory);
                        if (dfltFactoryClass != null && dfltFactoryClass.equals(factoryClassName)) {
                            this.mDefaultFactory = factory;
                        }
                        if (!(factory instanceof XmlConfig) || (elConfig = AXDomUtil.getFirstChildElement((Node)elFactory, (String)"Config")) == null) continue;
                        ((XmlConfig)((Object)factory)).loadConfig(elConfig);
                    }
                    catch (Exception e) {
                        ALog.logError((Throwable)e, (String)"Error instantiating DesignCanvasDisplayInfo factory '%s'.", (Object[])new Object[]{factoryClass.getCanonicalName()});
                    }
                }
                if (this.mName2Factory.size() == 0) {
                    this.mName2Factory.put(this.mDefaultFactory.getName(), this.mDefaultFactory);
                }
                if (this.mDefaultFactory == null && this.mName2Factory.size() > 0) {
                    this.mDefaultFactory = this.mName2Factory.values().iterator().next();
                    ALog.logWarn((String)"A default DesignCanvasDisplayInfo factory class was not specified or the specification was invalid, using '%s'.", (Object[])new Object[]{this.mDefaultFactory.getName()});
                }
            }
        }

        public IterableIterator<Factory> getFactories() {
            return AIterableItr.itr(this.mName2Factory.values());
        }

        public Factory getByName(String factoryName) {
            return this.mName2Factory.get(factoryName);
        }

        public Factory getDefault() {
            return this.mDefaultFactory;
        }
    }

    public static class Manager {
        protected Map<DesignView2D, Implementation> mView2InstalledImpl = new HashMap<DesignView2D, Implementation>();
        protected ViewListener mViewListener = new ViewAdapter(){

            public void viewClosed(AAppView view) {
                if (view instanceof DesignView2D) {
                    this.uninstall((DesignView2D)view);
                }
            }
        };

        public Manager() {
            this.initAsNeeded();
        }

        public Implementation getInstalled(DesignView2D view) {
            return this.mView2InstalledImpl.get(view);
        }

        public Implementation uninstall(DesignView2D view) {
            Implementation cur = this.getInstalled(view);
            if (cur != null) {
                cur.uninstall();
                this.mView2InstalledImpl.remove(view);
            }
            return cur;
        }

        public Implementation install(DesignView2D view, Factory factory) {
            this.uninstall(view);
            Implementation newImpl = factory.install(view);
            this.mView2InstalledImpl.put(view, newImpl);
            return newImpl;
        }

        protected void initAsNeeded() {
            OrbitIO oio = OrbitIO.getApp();
            if (oio == null) {
                return;
            }
            OrbitGuiWS ws = oio.getWorkspace();
            if (ws == null) {
                return;
            }
            ws.addViewListener(this.mViewListener);
        }
    }
}

