/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATriple;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbCompare;
import com.sigrity.acl.jfxui.AJFXDialog;
import com.sigrity.acl.jfxui.AJFXFileChooser;
import com.sigrity.acl.jfxui.AJFXFileChooserControl;
import com.sigrity.acl.jfxui.AJFXPanel;
import com.sigrity.acl.jfxui.JFXUtil;
import com.sigrity.acl.jfxui.OkCancelHBox;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitTest;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;

public class DesignDiffUI {
    private DesignDiffUI() {
    }

    public static Action getAction() {
        return new AbstractAction("Compare Design..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesignDiffUI.showDiffConfigUI();
            }
        };
    }

    private static void showDiffConfigUI() {
        DiffConfigDlg configDlg = new DiffConfigDlg();
        configDlg.setVisible(true);
    }

    private static void showDiffResultUI(String lpath, String rpath, ViewMode mode) {
        File l = new File(lpath);
        File r = new File(rpath);
        if (!l.exists()) {
            ALog.logError((String)"Cannot find design at '%s'.", (Object[])new Object[]{lpath});
            return;
        }
        if (!r.exists()) {
            ALog.logError((String)"Cannot find design at '%s'.", (Object[])new Object[]{rpath});
            return;
        }
        DiffDesignDlg configDlg = new DiffDesignDlg(l, r, mode);
        configDlg.setVisible(true);
    }

    public static abstract class LazyTreeItem<T>
    extends TreeItem<T> {
        protected boolean needToLoadData = true;

        public LazyTreeItem(T value) {
            super(value);
            super.getChildren().add((Object)new TreeItem());
            this.addExpandedListener();
        }

        private void addExpandedListener() {
            this.expandedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.needToLoadData = true;
                    super.getChildren().setAll((Object[])new TreeItem[]{new TreeItem()});
                }
            });
        }

        public ObservableList<TreeItem<T>> getChildren() {
            if (this.needToLoadData) {
                this.needToLoadData = false;
                super.getChildren().setAll(this.populateChildren());
            }
            return super.getChildren();
        }

        public abstract List<? extends TreeItem<T>> populateChildren();
    }

    private static class DiffDesignDlg
    extends AJFXDialog {
        protected final Db mDbCur;
        protected final Db mDbRef;
        protected ViewMode mMode;
        protected DbCompare mCompare;
        protected boolean mOpenedCur;
        protected boolean mOpenedRef;
        protected TreeView<String> mDiffTree;
        protected VBox mWorkspace;
        protected TextArea mSelectInfo;
        EventHandler<javafx.event.ActionEvent> mOkHandler = new EventHandler<javafx.event.ActionEvent>(){

            public void handle(javafx.event.ActionEvent e) {
                UIUtil.closeWindow((Window)((Object)this));
                if (!mOpenedCur) {
                    OrbitIO.getApp().closeDesign(mDbCur);
                }
                if (!mOpenedRef) {
                    OrbitIO.getApp().closeDesign(mDbRef);
                }
            }
        };

        protected DiffDesignDlg(File current, File golden, ViewMode mode) {
            super(OrbitIO.getMainWindow(), "Diff Design");
            this.mOpenedCur = OrbitIO.getApp().getDb(current.getAbsolutePath()) != null;
            this.mOpenedRef = OrbitIO.getApp().getDb(golden.getAbsolutePath()) != null;
            this.mDbCur = OrbitTest.getDesign(current.getAbsolutePath());
            this.mDbRef = OrbitTest.getDesign(golden.getAbsolutePath());
            this.mMode = mode;
            DbCompare.setMaxDiff((long)Long.MAX_VALUE);
            this.mCompare = new DbCompare(this.mDbCur, this.mDbRef, null);
            this.mCompare.setSilence(true);
            this.mCompare.compare();
            this.init();
            this.setModal(false);
        }

        protected AJFXPanel createJfxPanel() {
            return new DiffDesignPanel();
        }

        private Pane getObjectViewPane() {
            BorderPane pane = new BorderPane();
            SplitPane splitPane = new SplitPane();
            this.mDiffTree = new TreeView((TreeItem)new DiffTreeRoot(""));
            this.mDiffTree.setEditable(false);
            this.mDiffTree.setShowRoot(false);
            this.mDiffTree.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<String>>(){

                public void changed(ObservableValue<? extends TreeItem<String>> observable, TreeItem<String> oldValue, TreeItem<String> newValue) {
                    if (newValue instanceof DiffSupport) {
                        DiffSupport diff = (DiffSupport)newValue;
                        this.loadWorkspace(diff.getDiffList());
                    }
                }
            });
            this.mWorkspace = new VBox();
            splitPane.setPrefSize(800.0, 500.0);
            splitPane.getItems().addAll((Object[])new Node[]{this.mDiffTree, this.mWorkspace});
            splitPane.setDividerPositions(new double[]{0.2});
            OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)this), this.mOkHandler);
            pane.setTop((Node)splitPane);
            pane.setBottom((Node)okCancelHBox);
            return pane;
        }

        private void loadWorkspace(List<DbCompare.DiffRecord> diffList) {
            if (diffList == null) {
                return;
            }
            this.mWorkspace.getChildren().clear();
            TableView table = new TableView();
            TableColumn itemCol = new TableColumn("");
            TableColumn leftCol = new TableColumn("Current");
            TableColumn rightCol = new TableColumn("Golden");
            itemCol.setPrefWidth(30.0);
            itemCol.setCellValueFactory(param -> new ReadOnlyStringWrapper(((DbCompare.DiffRecord)param.getValue()).getItem()));
            itemCol.setCellFactory(column -> this.getItemCellFactory());
            table.getColumns().add((Object)itemCol);
            leftCol.setPrefWidth(20.0);
            leftCol.setCellValueFactory(param -> new SimpleObjectProperty((Object)((DbCompare.DiffRecord)param.getValue())));
            leftCol.setCellFactory(column -> this.getLDescCellFactory());
            table.getColumns().add((Object)leftCol);
            rightCol.setPrefWidth(10.0);
            rightCol.setCellValueFactory(param -> new SimpleObjectProperty((Object)((DbCompare.DiffRecord)param.getValue())));
            rightCol.setCellFactory(column -> this.getRDescCellFactory());
            table.getColumns().add((Object)rightCol);
            table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
            table.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
            table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DbCompare.DiffRecord>(){

                public void changed(ObservableValue<? extends DbCompare.DiffRecord> ov, DbCompare.DiffRecord oldValue, DbCompare.DiffRecord newValue) {
                    mSelectInfo.setText(newValue.getDesc());
                }
            });
            ObservableList infos = FXCollections.observableArrayList(diffList);
            table.setItems(infos);
            table.setEditable(true);
            VBox infoBox = new VBox(5.0);
            this.mSelectInfo = new TextArea();
            this.mSelectInfo.setEditable(false);
            infoBox.getChildren().add((Object)this.mSelectInfo);
            HBox.setHgrow((Node)this.mSelectInfo, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)infoBox, (Priority)Priority.ALWAYS);
            this.mWorkspace.getChildren().setAll((Object[])new Node[]{table, infoBox});
            HBox.setHgrow((Node)table, (Priority)Priority.ALWAYS);
        }

        private TableCell<DbCompare.DiffRecord, String> getItemCellFactory() {
            return new TableCell<DbCompare.DiffRecord, String>(){

                protected void updateItem(String name, boolean empty) {
                    super.updateItem((Object)name, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(name);
                    }
                    this.setAlignment(Pos.BOTTOM_RIGHT);
                }
            };
        }

        private TableCell<DbCompare.DiffRecord, DbCompare.DiffRecord> getLDescCellFactory() {
            return new TableCell<DbCompare.DiffRecord, DbCompare.DiffRecord>(){

                protected void updateItem(DbCompare.DiffRecord r, boolean empty) {
                    super.updateItem((Object)r, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(r.getLDesc());
                    }
                    if (r == null) {
                        return;
                    }
                    if (r.getDiffType() == DbCompare.DiffType.REMOVE) {
                        this.setStyle("-fx-background-color: " + AColor.formatColor((Color)DbCompare.COLOR_REMOVE));
                    } else if (r.getDiffType() == DbCompare.DiffType.CHANGE) {
                        this.setStyle("-fx-background-color: " + AColor.formatColor((Color)DbCompare.COLOR_CHANGE));
                    }
                    this.setAlignment(Pos.BOTTOM_LEFT);
                }
            };
        }

        private TableCell<DbCompare.DiffRecord, DbCompare.DiffRecord> getRDescCellFactory() {
            return new TableCell<DbCompare.DiffRecord, DbCompare.DiffRecord>(){

                protected void updateItem(DbCompare.DiffRecord r, boolean empty) {
                    super.updateItem((Object)r, empty);
                    if (empty) {
                        this.setText(null);
                    } else {
                        this.setText(r.getRDesc());
                    }
                    if (r == null) {
                        return;
                    }
                    if (r.getDiffType() == DbCompare.DiffType.ADD) {
                        this.setStyle("-fx-background-color: " + AColor.formatColor((Color)DbCompare.COLOR_ADD));
                    } else if (r.getDiffType() == DbCompare.DiffType.CHANGE) {
                        this.setStyle("-fx-background-color: " + AColor.formatColor((Color)DbCompare.COLOR_CHANGE));
                    }
                    this.setAlignment(Pos.BOTTOM_LEFT);
                }
            };
        }

        public class DiffObjectNode
        extends TreeItem<String>
        implements DiffSupport {
            protected String mObjKey;
            protected DbCompare.DiffType mType;
            protected List<DbCompare.DiffRecord> mDiffList;

            public DiffObjectNode(String name, DbCompare.DiffType type) {
                super((Object)name);
                this.mDiffList = new ArrayList<DbCompare.DiffRecord>();
                this.mType = type;
                this.mObjKey = name;
            }

            public void addDiffRecord(DbCompare.DiffRecord r) {
                this.mDiffList.add(r);
            }

            public void populateChildren() {
                this.setValue(String.format("%s (%d)", this.mObjKey, this.mDiffList.size()));
            }

            @Override
            public List<DbCompare.DiffRecord> getDiffList() {
                return this.mDiffList;
            }
        }

        public class DiffClassNode
        extends TreeItem<String>
        implements DiffSupport {
            protected String mClassName;
            protected DbCompare.DiffType mType;
            protected List<DbCompare.DiffRecord> mDiffList;

            DiffClassNode(String className, DbCompare.DiffType type) {
                super((Object)className);
                this.mDiffList = new ArrayList<DbCompare.DiffRecord>();
                this.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
                this.mClassName = className;
                this.mType = type;
            }

            public void addDiffRecord(DbCompare.DiffRecord r) {
                this.mDiffList.add(r);
            }

            public void populateChildren() {
                ArrayList<DiffObjectNode> children = new ArrayList<DiffObjectNode>();
                HashMap<String, DiffObjectNode> map = new HashMap<String, DiffObjectNode>();
                for (DbCompare.DiffRecord r : this.mDiffList) {
                    String objKeyStr;
                    DiffObjectNode d = null;
                    if (r.getDiffClass() == DbCompare.DiffClass.OBJECT) {
                        objKeyStr = (String)((APair)r.getKey()).second;
                        d = map.computeIfAbsent(objKeyStr, k -> new DiffObjectNode((String)k, DbCompare.DiffType.CHANGE));
                    } else if (r.getDiffClass() == DbCompare.DiffClass.OBJECT_FIELD) {
                        objKeyStr = (String)((ATriple)r.getKey()).second;
                        d = map.computeIfAbsent(objKeyStr, k -> new DiffObjectNode((String)k, DbCompare.DiffType.CHANGE));
                    }
                    if (d == null) continue;
                    d.addDiffRecord(r);
                }
                for (DiffObjectNode d : map.values()) {
                    children.add(d);
                    d.populateChildren();
                }
                children.sort((a, b) -> ((String)a.getValue()).compareTo((String)b.getValue()));
                this.getChildren().setAll(children);
                this.setValue(String.format("%s (%d)", this.mClassName, this.mDiffList.size()));
            }

            @Override
            public List<DbCompare.DiffRecord> getDiffList() {
                return this.mDiffList;
            }
        }

        public class DiffTreeRoot
        extends TreeItem<String>
        implements DiffSupport {
            DiffTreeRoot(String name) {
                super((Object)name);
                this.setGraphic((Node)new ImageView(JFXUtil.getFxImage((Icon)UIUtil.getScaledIcon((Icon)OrbitIcons.FOLDER, (int)14, (int)14))));
                this.setExpanded(true);
                this.populateChildren();
            }

            public void populateChildren() {
                ArrayList<DiffClassNode> children = new ArrayList<DiffClassNode>();
                HashMap<String, DiffClassNode> map = new HashMap<String, DiffClassNode>();
                for (DbCompare.DiffRecord r : DiffDesignDlg.this.mCompare.getDiffList()) {
                    String cls = r.getDbClass();
                    DiffClassNode d = map.computeIfAbsent(cls, k -> new DiffClassNode(cls, DbCompare.DiffType.CHANGE));
                    d.addDiffRecord(r);
                }
                for (DiffClassNode d : map.values()) {
                    children.add(d);
                    d.populateChildren();
                }
                children.sort((a, b) -> ((String)a.getValue()).compareTo((String)b.getValue()));
                this.getChildren().setAll(children);
            }

            @Override
            public List<DbCompare.DiffRecord> getDiffList() {
                return DiffDesignDlg.this.mCompare.getDiffList();
            }
        }

        public static interface DiffSupport {
            public List<DbCompare.DiffRecord> getDiffList();
        }

        private class DiffDesignPanel
        extends AJFXPanel {
            private static final int PANEL_WIDTH = 800;
            private static final int PANEL_HEIGHT = 600;

            public DiffDesignPanel() {
                this.setPreferredSize(new Dimension(800, 600));
            }

            protected Parent initSceneGraph() {
                if (DiffDesignDlg.this.mMode == ViewMode.OBJECT) {
                    return DiffDesignDlg.this.getObjectViewPane();
                }
                return DiffDesignDlg.this.getObjectViewPane();
            }
        }
    }

    private static class DiffConfigDlg
    extends AJFXDialog {
        protected DiffConfigDlg() {
            super(OrbitIO.getMainWindow(), "Diff Design Configuration");
            this.init();
            this.setModal(false);
        }

        protected AJFXPanel createJfxPanel() {
            return new ChooseDesignPanel();
        }

        private class ChooseDesignPanel
        extends AJFXPanel {
            private static final int PANEL_WIDTH = 600;
            private static final int PANEL_HEIGHT = 300;
            AJFXFileChooserControl mLDesign;
            AJFXFileChooserControl mRDesign;
            ViewMode mMode;
            EventHandler<javafx.event.ActionEvent> mOkHandler = new EventHandler<javafx.event.ActionEvent>(){

                public void handle(javafx.event.ActionEvent e) {
                    UIUtil.closeWindow((Window)((Object)DiffConfigDlg.this));
                    DesignDiffUI.showDiffResultUI(ChooseDesignPanel.this.mLDesign.getPath(), ChooseDesignPanel.this.mRDesign.getPath(), ChooseDesignPanel.this.mMode);
                }
            };

            public ChooseDesignPanel() {
                this.setPreferredSize(new Dimension(600, 300));
            }

            protected Parent initSceneGraph() {
                BorderPane pane = new BorderPane();
                VBox main = new VBox(5.0);
                main.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
                this.mLDesign = new AJFXFileChooserControl((Window)((Object)DiffConfigDlg.this));
                this.mLDesign.addChoosableFileFilter(AJFXFileChooser.OIO_FILE_FILTER);
                this.mRDesign = new AJFXFileChooserControl((Window)((Object)DiffConfigDlg.this));
                this.mRDesign.addChoosableFileFilter(AJFXFileChooser.OIO_FILE_FILTER);
                if (OrbitIO.getCurDb() != null && OrbitIO.getCurDb().getFile() != null) {
                    this.mLDesign.setPath(OrbitIO.getCurDb().getFile().getPath());
                }
                main.getChildren().addAll((Object[])new Node[]{new Label("Current Design"), new Separator(), this.mLDesign});
                main.getChildren().addAll((Object[])new Node[]{new Label("Golden Design"), new Separator(), this.mRDesign});
                main.getChildren().addAll((Object[])new Node[]{new Label("Options"), new Separator(), this.getOptionPanel()});
                OkCancelHBox okCancelHBox = new OkCancelHBox((Window)((Object)DiffConfigDlg.this), this.mOkHandler);
                pane.setTop((Node)main);
                pane.setBottom((Node)okCancelHBox);
                return pane;
            }

            VBox getOptionPanel() {
                VBox panel = new VBox(5.0);
                HBox viewOption = new HBox(5.0);
                panel.getChildren().add((Object)viewOption);
                RadioButton objView = new RadioButton("Object");
                RadioButton hierView = new RadioButton("Hierarchy");
                final ToggleGroup viewGroup = new ToggleGroup();
                objView.setToggleGroup(viewGroup);
                objView.setSelected(true);
                objView.setUserData((Object)ViewMode.OBJECT);
                hierView.setToggleGroup(viewGroup);
                hierView.setUserData((Object)ViewMode.HIERARCHY);
                viewGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                    public void changed(ObservableValue<? extends Toggle> ov, Toggle oldVal, Toggle newVal) {
                        if (viewGroup.getSelectedToggle() != null) {
                            ChooseDesignPanel.this.mMode = (ViewMode)((Object)viewGroup.getSelectedToggle().getUserData());
                        }
                    }
                });
                this.mMode = ViewMode.OBJECT;
                viewOption.getChildren().addAll((Object[])new Node[]{new Label("View: "), objView});
                panel.getChildren();
                return panel;
            }
        }
    }

    public static enum ViewMode {
        OBJECT,
        HIERARCHY;

    }
}

