/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.app.ViewAdapter;
import com.sigrity.acl.app.ViewListener;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.ui.ADropDownAction;
import com.sigrity.acl.ui.AImageIcon;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.OrbitImages;
import com.sigrity.orbit.ui.common.KeyBindingUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.plaf.basic.BasicButtonUI;

public class DesignStartPanel
extends JPanel {
    static final String SECTION_START_PAGE = "StartPage";
    static final String PAGE_RECENT_SORT = "RecentSort";
    static final String PAGE_RECENT_SORT_OPEN = "Opening";
    static final String PAGE_RECENT_SORT_LAST = "LastModified";
    static final String PAGE_DEFAULT_RECENT_SORT = "Opening";
    static final Color COLOR_BG = new Color(77, 81, 87);
    static boolean isRegistered = false;
    protected boolean mUseBgImg = (Boolean)Settings.get((String)"GUI", (String)"DesignsStartPanelUseBackgroundImage", (Object)true);
    static final int PADDING_TOP = 30;
    static final int PADDING_LEFT = 30;
    static final int PADDING_LEFT_L1 = 40;
    static final int RIGHT_WIDTH = 250;
    static final int LEFT_WIDTH = 590;
    protected final RecentPanel mRecentPanel = new RecentPanel();
    protected final HomePanel mHomePanel = new HomePanel();

    public static void registerDockingUI() {
        if (isRegistered) {
            return;
        }
        OrbitIO app = OrbitIO.getApp();
        OrbitGuiWS ws = app.getWorkspace();
        if (ws == null) {
            return;
        }
        ViewAdapter viewListener = new ViewAdapter(){

            public boolean viewClosing(AAppView view) {
                if (view instanceof DesignView2D) {
                    DesignView2D v2d = (DesignView2D)view;
                    Image image = v2d.getCanvas().getImage();
                    DesignStartPanel.updateDesignSnapshot(v2d.getDb(), image);
                }
                return true;
            }
        };
        ws.addViewListener((ViewListener)viewListener);
        isRegistered = true;
    }

    public static String encodeToString(BufferedImage image, String type) {
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, type, bos);
            byte[] imageBytes = bos.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            imageString = encoder.encodeToString(imageBytes);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return imageString;
    }

    public static BufferedImage decodeToImage(String imageString) {
        BufferedImage image = null;
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] imageByte = decoder.decode(imageString);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    private static String encodeSnapshot(Image img) {
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return DesignStartPanel.encodeToString(bimage, "png");
    }

    protected static void updateDesignSnapshot(Db db, Image image) {
        if (db == null || db.getFile() == null || image == null) {
            return;
        }
        OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
        if (ws == null) {
            return;
        }
        File f = db.getFile();
        ws.updateSnapshot(f, DesignStartPanel.encodeSnapshot(image));
    }

    static String getFileSubtitle(File f) {
        if (f == null) {
            return "...";
        }
        Object res = "";
        f = f.getParentFile();
        for (int i = 0; i < 3 && f != null; f = f.getParentFile(), ++i) {
            res = ((String)res).isEmpty() ? f.getName() : f.getName() + "/" + (String)res;
        }
        return res;
    }

    public DesignStartPanel() {
        JPanel content = new JPanel(new BorderLayout());
        content.setBackground(COLOR_BG);
        JPanel midContent = new JPanel(new BorderLayout());
        midContent.setBackground(COLOR_BG);
        midContent.add((Component)new GuidePanel(), "North");
        midContent.add((Component)this.mHomePanel, "South");
        content.add((Component)midContent, "Center");
        content.add((Component)this.mRecentPanel, "East");
        JScrollPane pane = new JScrollPane(content);
        pane.getViewport().setBackground(Color.DARK_GRAY);
        GridBagManager l = GridBagManager.layout((Container)this);
        l.add((Component)new JScrollPane(content), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.insets(0));
        this.setBackground(COLOR_BG);
    }

    static JLabel createParagraph(String text) {
        JLabel label = new JLabel("<HTML>" + text + "</HTML>");
        Font font = label.getFont().deriveFont(24.0f);
        label.setForeground(Color.WHITE);
        label.setFont(font);
        return label;
    }

    static JLabel createSubParagraph(String text) {
        JLabel label = new JLabel("<html><p style=\"width:400px\">" + text + "</p></html>");
        Font font = label.getFont().deriveFont(12.0f);
        label.setForeground(Color.GRAY);
        label.setFont(font);
        return label;
    }

    static JButton createParagraphButton(String text) {
        JButton label = new JButton("<HTML>" + text + "</HTML>");
        Font font = label.getFont().deriveFont(24.0f);
        label.setForeground(Color.WHITE);
        label.setFont(font);
        return label;
    }

    static JLabel createTitle(String text) {
        JLabel label = new JLabel("<HTML>" + text + "</HTML>");
        Font font = label.getFont().deriveFont(28.0f);
        label.setForeground(Color.WHITE);
        label.setFont(font);
        return label;
    }

    static JButton createButton(String text) {
        JButton btn = new JButton(text);
        Font btnFont = btn.getFont().deriveFont(18.0f);
        btn.setOpaque(false);
        btn.setContentAreaFilled(false);
        btn.setBorderPainted(false);
        btn.setFont(btnFont);
        btn.setForeground(Color.WHITE);
        btn.setUI(new BasicButtonUI(){

            @Override
            public void update(Graphics g, JComponent c) {
                Color fillColor = Color.WHITE;
                AbstractButton button = (AbstractButton)c;
                ButtonModel model = button.getModel();
                if (model.isPressed()) {
                    fillColor = fillColor.darker();
                } else if (model.isRollover()) {
                    fillColor = fillColor.brighter();
                }
                Graphics2D g2 = (Graphics2D)g;
                RenderingHints oldHints = g2.getRenderingHints();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setColor(fillColor);
                g.drawRoundRect(5, 5, c.getWidth() - 10, c.getHeight() - 10, 20, 20);
                this.paint(g, c);
                g2.setRenderingHints(oldHints);
            }
        });
        return btn;
    }

    public void reload() {
        DesignStartPanel.registerDockingUI();
        this.mRecentPanel.loadDesigns();
        this.mHomePanel.loadWorkspaces();
    }

    public class GuidePanel
    extends JPanel {
        public GuidePanel() {
            OrbitIO app = OrbitIO.getApp();
            String date = new SimpleDateFormat("[M/d/yyyy]").format(app.getBuildTimestamp());
            JLabel versionLabel = DesignStartPanel.createParagraph("Version: " + app.getVersion() + " " + date);
            JLabel startLabel = DesignStartPanel.createTitle("Start Design...");
            JLabel openLabel = DesignStartPanel.createTitle("Open Existing Design...");
            JButton newBtn = DesignStartPanel.createButton("New...");
            JButton openBtn = DesignStartPanel.createButton("Open...");
            newBtn.addActionListener(e -> OrbitIO.getApp().createDesign());
            openBtn.addActionListener(e -> OrbitIO.getApp().getWorkspace().openDesign());
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)versionLabel, (GridBagConstraints)GridBagManager.LEFT.insets(30, 30, 0, 0));
            l.newline();
            l.add((Component)startLabel, (GridBagConstraints)GridBagManager.LEFT.insets(10, 60, 0, 0));
            l.newline();
            l.add((Component)newBtn, (GridBagConstraints)GridBagManager.LEFT.insets(10, 60, 0, 0));
            l.newline();
            l.newline();
            l.add((Component)openLabel, (GridBagConstraints)GridBagManager.LEFT.insets(10, 60, 0, 0));
            l.newline();
            l.add((Component)openBtn, (GridBagConstraints)GridBagManager.LEFT.insets(10, 60, 0, 0));
            l.newline();
            l.addFillY();
            l.newline();
            l.addFillX();
            this.setBackground(COLOR_BG);
            this.setPreferredSize(new Dimension(590, 305));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (!DesignStartPanel.this.mUseBgImg) {
                return;
            }
            Dimension d = this.getSize();
            Image background = OrbitImages.START_PAGE.getScaledInstance((int)d.getWidth(), -1, 4);
            g.drawImage(background, 0, 0, null);
        }
    }

    public class RecentPanel
    extends JPanel {
        final JPanel mRecentPanel = new JPanel();
        final JButton mTitleBtn;

        RecentPanel() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mTitleBtn = DesignStartPanel.createParagraphButton("Recent");
            UIUtil.makeToolBarButton((AbstractButton)this.mTitleBtn);
            this.mTitleBtn.setRolloverEnabled(false);
            JPopupMenu menu = this.createContextMenu();
            JButton dropBtn = ADropDownAction.makeButton((JPopupMenu)menu, (AbstractButton)this.mTitleBtn);
            l.add((Component)this.mTitleBtn, (GridBagConstraints)GridBagManager.LEFT.insets(30, 30, 0, 0));
            l.add((Component)dropBtn, (GridBagConstraints)GridBagManager.LEFT.insets(30, 0, 0, 0));
            l.addFillX();
            l.newline();
            l.add((Component)this.mRecentPanel, (GridBagConstraints)GridBagManager.LEFT.width(3).insets(30, 30, 0, 0));
            l.newline();
            l.addFillY();
            l.newline();
            this.mRecentPanel.setBackground(COLOR_BG);
            this.setBackground(COLOR_BG);
            this.setPreferredSize(new Dimension(300, 900));
            this.updateSort();
        }

        private void updateSort() {
            String sort = (String)Settings.get((String)DesignStartPanel.SECTION_START_PAGE, (String)DesignStartPanel.PAGE_RECENT_SORT, (Object)"Opening");
            if ("Opening".equals(sort)) {
                this.mTitleBtn.setText("Recent");
                this.loadDesigns();
            } else {
                this.mTitleBtn.setText("Recent (Last Modified)");
                this.loadDesigns();
            }
        }

        public JPopupMenu createContextMenu() {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction("Sort By Opening Date", OrbitIcons.EMPTY16x16){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Settings.set((String)DesignStartPanel.SECTION_START_PAGE, (String)DesignStartPanel.PAGE_RECENT_SORT, (Object)"Opening");
                    Settings.save((String)DesignStartPanel.SECTION_START_PAGE);
                    RecentPanel.this.updateSort();
                }
            });
            menu.add(new AbstractAction("Sort By Last Modified Date", OrbitIcons.EMPTY16x16){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Settings.set((String)DesignStartPanel.SECTION_START_PAGE, (String)DesignStartPanel.PAGE_RECENT_SORT, (Object)DesignStartPanel.PAGE_RECENT_SORT_LAST);
                    Settings.save((String)DesignStartPanel.SECTION_START_PAGE);
                    RecentPanel.this.updateSort();
                }
            });
            return menu;
        }

        public void loadDesigns() {
            if (OrbitIO.getGuiWorkspace() == null) {
                return;
            }
            this.mRecentPanel.removeAll();
            GridBagManager l = new GridBagManager((Container)this.mRecentPanel);
            OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
            LinkedList<File> fs = new LinkedList<File>(ws.getMostRecentUsedDesign());
            String sort = (String)Settings.get((String)DesignStartPanel.SECTION_START_PAGE, (String)DesignStartPanel.PAGE_RECENT_SORT, (Object)"Opening");
            if (DesignStartPanel.PAGE_RECENT_SORT_LAST.equals(sort)) {
                fs.sort(Comparator.comparingLong(File::lastModified).reversed());
            }
            String shdb = System.getProperty("shdb_root_dir");
            int count = 0;
            for (File file : fs) {
                if (shdb != null && !file.getAbsolutePath().startsWith(shdb)) continue;
                BufferedImage bimage = DesignStartPanel.decodeToImage(ws.getMostRecentUsedDesignSnapshot(file));
                l.add((Component)new DesignPreviewPanel(file, bimage), (GridBagConstraints)GridBagManager.LEFT.insets(count == 0 ? 0 : 30, -10, 0, 0));
                l.newline();
                if (++count < 5) continue;
                break;
            }
        }
    }

    public class DesignPreviewPanel
    extends JPanel {
        public DesignPreviewPanel(File file, Image img) {
            this.setBackground(COLOR_BG);
            this.setLayout(new BorderLayout());
            String fileName = file.getName();
            JButton preview = new JButton();
            if (img == null) {
                preview.setText("No Preview Available");
                preview.setMinimumSize(new Dimension(250, 100));
                preview.setPreferredSize(new Dimension(250, 100));
            } else {
                AImageIcon icon = new AImageIcon(this.getFitImage(img, 250));
                preview.setIcon((Icon)icon);
                preview.setMinimumSize(new Dimension(250, 160));
                preview.setPreferredSize(new Dimension(250, 160));
            }
            preview.setForeground(Color.WHITE);
            preview.setContentAreaFilled(false);
            ActionListener openDesign = e -> Cp.exec((String)"OrbitIO.openDesign(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)file)});
            preview.addActionListener(openDesign);
            this.add((Component)preview, "Center");
            JButton fileBtn = new JButton(String.format("<html><div text-align:center><font size=2>%s</font><br/>%s</div></html>", DesignStartPanel.getFileSubtitle(file), fileName));
            fileBtn.setMinimumSize(new Dimension(250, 42));
            fileBtn.setPreferredSize(new Dimension(250, 42));
            fileBtn.setForeground(Color.WHITE);
            fileBtn.setContentAreaFilled(false);
            fileBtn.setToolTipText("Open Design " + file.getPath());
            fileBtn.addActionListener(openDesign);
            this.add((Component)fileBtn, "South");
        }

        private Image getFitImage(Image img, int width) {
            return img.getScaledInstance(width, -1, 4);
        }
    }

    public class HomePanel
    extends JPanel {
        private JPanel mWorkspaces = new JPanel();

        HomePanel() {
            this.setPreferredSize(new Dimension(590, 900));
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)this.mWorkspaces, (GridBagConstraints)GridBagManager.FILLX.width(1));
            l.newline();
            JLabel startLabel = DesignStartPanel.createParagraph("Get Started");
            l.add((Component)startLabel, (GridBagConstraints)GridBagManager.LEFT.insets(30, 30, 0, 0));
            l.newline();
            JButton docBtn = this.createListItem("Document");
            docBtn.addActionListener(e -> {
                File docLocation = new File(AApp.getInstallDir(), "docs/OrbitIO_GettingStartedGuide.pdf");
                try {
                    Desktop.getDesktop().open(docLocation);
                }
                catch (IOException err) {
                    ALog.logError((String)"Cannot open '%s'", (Object[])new Object[]{docLocation});
                }
            });
            l.add((Component)docBtn, (GridBagConstraints)GridBagManager.LEFT.insets(10, 30, 0, 0));
            l.newline();
            l.add((Component)new JSeparator(), (GridBagConstraints)GridBagManager.FILLX.insets(2, 40, 2, 60));
            l.newline();
            JButton keyBtn = this.createListItem("Binding Keys");
            keyBtn.addActionListener(e -> KeyBindingUI.showUI());
            l.add((Component)keyBtn, (GridBagConstraints)GridBagManager.LEFT.insets(10, 30, 0, 0));
            l.newline();
            l.add((Component)new JSeparator(), (GridBagConstraints)GridBagManager.FILLX.insets(2, 40, 2, 60));
            l.newline();
            l.addFillY();
            l.newline();
            l.addFillX();
            this.setBackground(new Color(255, 255, 255, 0));
        }

        private JButton createListItem(String text) {
            JButton btn = new JButton(text);
            Font btnFont = btn.getFont().deriveFont(18.0f);
            btn.setOpaque(false);
            btn.setContentAreaFilled(false);
            btn.setBorderPainted(false);
            btn.setFont(btnFont);
            btn.setForeground(Color.WHITE);
            return btn;
        }

        public void loadWorkspaces() {
            this.mWorkspaces.removeAll();
            GridBagManager l = new GridBagManager((Container)this.mWorkspaces);
            this.mWorkspaces.setMaximumSize(new Dimension(9000, 900));
            this.mWorkspaces.setBackground(Color.BLACK);
            this.loadWorkspace(l, System.getProperty("shdb_root_dir"), "SHDB Workspace", true);
            this.loadWorkspace(l, System.getProperty("user.dir"), "Workspace", false);
        }

        private void loadWorkspace(GridBagManager l, String baseDirPath, String title, boolean recursive) {
            if (baseDirPath == null) {
                return;
            }
            File baseDir = new File(baseDirPath);
            ArrayList<File> files = new ArrayList<File>();
            if (recursive) {
                long startTime = System.currentTimeMillis();
                try (Stream<Path> paths2 = Files.walk(baseDir.toPath(), new FileVisitOption[0]);){
                    for (Path p : new StreamIterableIterator(paths2)) {
                        if (AFile.isFileReadable((File)p.toFile()) && AclResources.OIO_FILE_FILTER.isExtFile(p.toFile())) {
                            files.add(p.toFile());
                        }
                        if (System.currentTimeMillis() - startTime <= 10000L) continue;
                        break;
                    }
                }
                catch (IOException paths2) {}
            } else {
                for (File f : baseDir.listFiles()) {
                    if (!AclResources.OIO_FILE_FILTER.isExtFile(f)) continue;
                    files.add(f);
                }
            }
            files.sort(Comparator.comparingLong(File::lastModified).reversed());
            JLabel ws = (JLabel)l.add((Component)DesignStartPanel.createParagraph(title), (GridBagConstraints)GridBagManager.LEFT.insets(30, 30, 0, 0));
            ws.setToolTipText(baseDir.getAbsolutePath());
            l.newline();
            JLabel subTitle = DesignStartPanel.createSubParagraph(baseDirPath);
            l.add((Component)subTitle, (GridBagConstraints)GridBagManager.LEFT.width(2).insets(0, 30, 0, 0));
            l.newline();
            l.addFillX();
            l.addFillX();
            l.newline();
            for (int i = 0; i < 10 && i < files.size(); ++i) {
                File f;
                f = (File)files.get(i);
                String text = f.getName();
                int maxLength = 40 - text.length();
                String subText = DesignStartPanel.getFileSubtitle(f);
                subText = maxLength >= 0 ? (subText.length() <= maxLength ? String.format("(%s)", subText) : String.format("(%s...)", subText.substring(0, maxLength))) : "";
                JButton fileBtn = this.createListItem(text);
                fileBtn.addActionListener(e -> Cp.exec((String)"OrbitIO.openDesign(%s)", (Object[])new Object[]{Cp.getFileAsArgument((File)f)}));
                fileBtn.setToolTipText(f.getPath());
                l.add((Component)fileBtn, (GridBagConstraints)GridBagManager.LEFT.insets(10, 30, 0, 0));
                l.add((Component)this.createListItem(subText), (GridBagConstraints)GridBagManager.RIGHT.insets(10, 0, 0, 60));
                l.newline();
                l.add((Component)new JSeparator(), (GridBagConstraints)GridBagManager.FILLX.insets(2, 40, 2, 60).width(2));
                l.newline();
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, d.width, d.height);
        }
    }
}

