/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.APair;
import com.sigrity.acl.AStream;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selector;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeCellRenderer;
import com.sigrity.acl.ui.atree.ATreeLeaf;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.eda.NetUtil;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.tools.dbexplorer.DBEResources;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DeviceChooser {
    protected static final int COLS_FILTER = 6;
    protected static final String TITLE_SELECT_DEVICE = "Select Device";
    protected static final String TITLE_SELECT_DEVICEINST = "Select Device Instance";

    public static DevicePath getDevicePath(Component owner, Db db) {
        return DeviceChooser.getDevicePath(owner, db, null);
    }

    public static DevicePath getDevicePath(Component owner, Db db, InitHook initHook) {
        DCDialog dlg = DeviceChooser.createDeviceChooserDlg(owner);
        dlg.mChooserPnl.setSelectPath(true);
        dlg.setTitle(TITLE_SELECT_DEVICEINST);
        if (initHook != null) {
            initHook.initDeviceChooser(dlg.mChooserPnl);
        }
        dlg.setDb(db);
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getSelectedDevicePath();
    }

    public static Device getDevice(Component owner, Db db) {
        return DeviceChooser.getDevice(owner, db, (Device)null);
    }

    public static Device getDevice(Component owner, Db db, Device initialDevice) {
        return DeviceChooser.getDevice(owner, db, initialDevice, null);
    }

    public static Device getDevice(Component owner, Db db, Device initialDevice, Device special) {
        return DeviceChooser.getDevice(owner, db, initialDevice, special, null);
    }

    public static Device getDevice(Component owner, Db db, final Device initialDevice, final Device special, final DeviceFilters.DeviceFilter filter) {
        return DeviceChooser.getDevice(owner, db, new InitHook(){

            @Override
            public void initDeviceChooser(DCPanel dc) {
                dc.setSpecial(special);
                dc.setInitialDevice(initialDevice);
                dc.setDeviceFilter(filter);
            }
        });
    }

    public static Device getDevice(Component owner, Db db, InitHook initHook) {
        DCDialog dlg = DeviceChooser.createDeviceChooserDlg(owner);
        if (initHook != null) {
            initHook.initDeviceChooser(dlg.mChooserPnl);
        }
        dlg.setDb(db);
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getSelectedDevice();
    }

    public static DCDialog createDeviceChooserDlg(Component owner) {
        return new DCDialog(UIUtil.getParentWindow((Component)owner));
    }

    public static class DCComponent
    extends JPanel {
        protected Db mDb;
        protected Device mDevice;
        protected APair<String, String> mUserFilter = null;
        protected JTextField mTxtDisplay;
        protected JButton mBtnBrowse;
        GridBagManager.GridBagConstraintsEx FILLX_NOLEFTINSET;
        GridBagManager.GridBagConstraintsEx RIGHT_NORIGHTINSET;
        protected ActionListener mBrowse;
        protected LinkedHashSet<UpdateListener> mUpdateListeners;

        public DCComponent(Db db) {
            this.FILLX_NOLEFTINSET = GridBagManager.FILLX.insets(GridBagManager.FILLX.insets.top, 0, GridBagManager.FILLX.insets.bottom, GridBagManager.FILLX.insets.right);
            this.RIGHT_NORIGHTINSET = GridBagManager.RIGHT.insets(GridBagManager.RIGHT.insets.top, GridBagManager.RIGHT.insets.left, GridBagManager.RIGHT.insets.bottom, 0);
            this.mBrowse = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireInitBrowse();
                    DCDialog dlg = DeviceChooser.createDeviceChooserDlg(this);
                    dlg.setDb(mDb);
                    dlg.setTitle("Choose Device");
                    dlg.setModal(true);
                    if (mUserFilter != null) {
                        dlg.mChooserPnl.setFilter((String)mUserFilter.first, (String)mUserFilter.second);
                    }
                    dlg.setVisible(true);
                    Device selected = dlg.getSelectedDevice();
                    if (selected != null) {
                        mUserFilter = dlg.mChooserPnl.getFilter();
                        if (mDevice != selected) {
                            this.setDevice(selected);
                        }
                    }
                }
            };
            this.mUpdateListeners = new LinkedHashSet();
            this.mDb = db;
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mTxtDisplay = (JTextField)l.add((Component)new JTextField(30), (GridBagConstraints)this.FILLX_NOLEFTINSET);
            this.mTxtDisplay.setEditable(false);
            this.mBtnBrowse = (JButton)l.add((Component)new JButton("Browse"), (GridBagConstraints)this.RIGHT_NORIGHTINSET);
            this.mBtnBrowse.addActionListener(this.mBrowse);
            this.setMinimumSize(this.getPreferredSize());
            this.setDevice(null);
        }

        public void setDevice(Device d) {
            this.mDevice = d;
            this.mTxtDisplay.setText(this.mDevice == null ? "" : this.mDevice.getName());
            this.mTxtDisplay.setToolTipText(this.mDevice == null ? null : this.mDevice.getKeyStr());
            this.fireUpdate();
        }

        public Device getDevice() {
            return this.mDevice;
        }

        public void setUserFilter(APair<String, String> userFilter) {
            this.mUserFilter = userFilter;
        }

        public APair<String, String> getUserFilter() {
            return this.mUserFilter;
        }

        public void addUpdateListener(UpdateListener l) {
            this.mUpdateListeners.add(l);
        }

        public void removeUpdateListener(UpdateListener l) {
            this.mUpdateListeners.remove(l);
        }

        protected void fireUpdate() {
            for (UpdateListener l : this.mUpdateListeners) {
                l.deviceUpdated(this);
            }
        }

        protected void fireInitBrowse() {
            for (UpdateListener l : this.mUpdateListeners) {
                l.initBrowse(this);
            }
        }

        public static interface UpdateListener {
            public void initBrowse(DCComponent var1);

            public void deviceUpdated(DCComponent var1);
        }
    }

    public static class DCTreeModel
    extends ATreeModel {
        protected boolean mSelectPath;

        public DCTreeModel(Iterable<Device> devices, boolean selectPath) {
            this.mSelectPath = selectPath;
            if (devices == null) {
                devices = AEmptyItr.create();
            }
            this.setRoot((TreeNode)((Object)new RootNode(this, (Iterable<Device>)devices)));
        }

        protected class PathNode
        extends ATreeLeaf {
            protected DevicePath mPath;

            public PathNode(DeviceNode parent, DevicePath path) {
                super((ATreeNode)parent);
                this.mPath = path;
            }

            public String getText() {
                return this.mPath.toString();
            }

            public Icon getIcon() {
                return new AColorIcon(0, 0, Color.WHITE);
            }
        }

        protected class DeviceNode
        extends ALazyTreeNode {
            protected Device mDevice;
            protected DevicePath mDevicePath;

            public DeviceNode(RootNode parent, Device d) {
                super((ATreeNode)parent);
                this.mDevice = d;
            }

            public Device getDevice() {
                return this.mDevice;
            }

            public DevicePath getDevicePath() {
                return this.mDevicePath;
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<PathNode> l = new ArrayList<PathNode>();
                if (DCTreeModel.this.mSelectPath) {
                    LinkedList paths = AUtil.linkedList((Iterator)this.mDevice.getHierarchicalInstances());
                    if (paths.size() == 1) {
                        this.mDevicePath = (DevicePath)paths.get(0);
                    } else {
                        for (DevicePath path : paths) {
                            l.add(new PathNode(this, path));
                        }
                    }
                }
                return l;
            }

            public String getText() {
                if (this.mDevice == null) {
                    return "<null>";
                }
                if (this.mDevice.getDb() == null && !"<Design>".equals(this.mDevice.getName())) {
                    return "<invalid>";
                }
                boolean children = this.getChildCount() > 1;
                return String.format("%s%s", this.mDevice.getName(), children ? " +" : "");
            }

            public Icon getIcon() {
                if (this.mDevice == NetUtil.DESIGN_PLACEHOLDER) {
                    return DBEResources.ICON_DESIGN;
                }
                return DbExplorerPanel.getIconForDevice(this.mDevice);
            }

            public String toString() {
                return this.getText();
            }
        }

        protected class RootNode
        extends ATreeNode {
            protected ArrayList<DeviceNode> mChildren;

            public RootNode(DCTreeModel model, Iterable<Device> devices) {
                super((ATreeModel)model);
                this.mChildren = new ArrayList();
                for (Device d : devices) {
                    this.mChildren.add(new DeviceNode(this, d));
                }
            }

            public String getText() {
                return "Devices";
            }

            public Enumeration<DeviceNode> children() {
                return AUtil.getEnumeration(this.mChildren.iterator());
            }

            public TreeNode getChildAt(int childIndex) {
                return (TreeNode)((Object)this.mChildren.get(childIndex));
            }

            public int getChildCount() {
                return this.mChildren.size();
            }

            public int getIndex(TreeNode node) {
                return this.mChildren.indexOf(node);
            }
        }
    }

    public static class DCPanel
    extends JPanel {
        protected boolean mSelectPath = false;
        protected Db mDb = null;
        protected Device mInitialDevice = null;
        protected Device mSelectedDevice = null;
        protected Device mSpecial = null;
        protected DeviceFilters.DeviceFilter mDeviceFilter = null;
        protected Function<Db, ArrayList<Device>> mDeviceListSupplier = null;
        protected JPanel mCustomTopPnl = new JPanel();
        protected APatternHelpButton mPhbHelpPattern;
        protected JComboBox<Selector.Property<Device>> mCboFilterProp;
        protected ATextField mTxtFilter;
        protected JTree mTreeDevices;
        protected ATreeModel mTreeModel = new ATreeModel();
        protected ArrayList<Device> mAllDevices;
        protected JLabel mLblStatus;
        protected ActionListener mUpdateFilteredDataTask = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.updateFilteredData();
            }
        };
        protected Runnable mDoUpdateFilteredData = new Runnable(){

            @Override
            public void run() {
                this.updateFilteredData();
            }
        };
        protected LinkedHashSet<DeviceListener> mDeviceListeners = new LinkedHashSet();
        protected LinkedHashSet<DeviceContextMenuListener> mDeviceContextMenuListeners = new LinkedHashSet();
        protected MouseListener mDeviceMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && this.getSelectedDevice() != null) {
                    this.fireDeviceActivated(this.getSelectedDevice());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.fireDevicePopup(this.getSelectedDevice());
                }
            }
        };
        protected TreeSelectionListener mTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                this.fireDeviceSelected(this.getSelectedDevice());
            }
        };
        protected KeyListener mKeyListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 && this.getSelectedDevice() != null) {
                    this.fireDeviceActivated(this.getSelectedDevice());
                }
            }
        };

        public DCPanel() {
            this(false);
        }

        public DCPanel(boolean selectPath) {
            this.mSelectPath = selectPath;
            GridBagManager l = new GridBagManager((Container)this);
            l.add((Component)this.mCustomTopPnl, (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mCustomTopPnl.setVisible(false);
            l.newline();
            this.mCboFilterProp = new JComboBox();
            this.mCboFilterProp.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int idx, boolean selected, boolean hasFocus) {
                    super.getListCellRendererComponent(list, (Object)null, idx, selected, hasFocus);
                    if (value instanceof Selector.Property) {
                        Selector.Property prop = (Selector.Property)value;
                        this.setText(prop.getUserName());
                    } else {
                        this.setText("<INVALID>");
                    }
                    return this;
                }
            });
            l.add("Filter by:");
            l.add(this.mCboFilterProp, (GridBagConstraints)GridBagManager.FILLX);
            this.mCboFilterProp.addActionListener(this.mUpdateFilteredDataTask);
            l.newline();
            JLabel lblFilterPattern = l.add("Filter pattern:");
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX.noInsets());
            this.mTxtFilter = new ATextField(6);
            l.add((Component)this.mTxtFilter, (GridBagConstraints)GridBagManager.FILLX);
            lblFilterPattern.setLabelFor(this.mTxtFilter);
            this.mTxtFilter.setActionHandler(this.mDoUpdateFilteredData);
            this.mTxtFilter.setInvokeActionOnTextUpdate(true);
            this.mPhbHelpPattern = new APatternHelpButton();
            l.add((Component)this.mPhbHelpPattern, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            l.newline();
            this.mTreeDevices = new JTree();
            JScrollPane spDeviceList = new JScrollPane(this.mTreeDevices);
            l.add((Component)spDeviceList, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mTreeDevices.setCellRenderer((TreeCellRenderer)new ATreeCellRenderer(){

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    Object selFilterItem = mCboFilterProp.getSelectedItem();
                    if (value instanceof DCTreeModel.DeviceNode) {
                        Selector.Property prop;
                        String props;
                        DCTreeModel.DeviceNode node = (DCTreeModel.DeviceNode)((Object)value);
                        Device device = node.getDevice();
                        String keyStr = device.getKeyStr();
                        this.setToolTipText(keyStr);
                        if (selFilterItem != Selectors.PropDeviceName && selFilterItem instanceof Selector.Property && (props = (String)AStream.of((Iterator)(prop = (Selector.Property)selFilterItem).getValues((DbObject)device, node.getDevicePath())).collect(Collectors.joining(", "))).length() > 0) {
                            this.setText(String.format("<html><b>%s</b> (%s)", this.getText(), props));
                        }
                    }
                    return this;
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this.mTreeDevices);
            this.mTreeDevices.setRootVisible(false);
            l.newline();
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            this.mLblStatus.setVisible(false);
            this.setSelectionMode(1);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mTreeDevices.addMouseListener(this.mDeviceMouseListener);
            this.mTreeDevices.getSelectionModel().addTreeSelectionListener(this.mTreeSelectionListener);
            this.mTreeDevices.addKeyListener(this.mKeyListener);
        }

        @Override
        public void removeNotify() {
            this.mTreeDevices.removeKeyListener(this.mKeyListener);
            this.mTreeDevices.getSelectionModel().removeTreeSelectionListener(this.mTreeSelectionListener);
            this.mTreeDevices.removeMouseListener(this.mDeviceMouseListener);
            super.removeNotify();
        }

        public void setSelectionMode(int mode) {
            this.mTreeDevices.getSelectionModel().setSelectionMode(mode);
        }

        public void setSelectPath(boolean selectPath) {
            this.mSelectPath = selectPath;
        }

        public void setDb(Db db) {
            this.mDb = db;
            Selectors.DeviceSelector.Descriptor.getProperties(this.mDb).forEach(p -> this.mCboFilterProp.addItem((Selector.Property<Device>)p));
            this.mCboFilterProp.addItem((Selector.Property<Device>)Selectors.DevicePropPersonalityName);
            this.updateAllDevices();
        }

        public void setInitialDevice(Device device) {
            this.mInitialDevice = device;
        }

        public void setSpecial(Device d) {
            this.mSpecial = d;
        }

        public void setDeviceFilter(DeviceFilters.DeviceFilter filter) {
            this.mDeviceFilter = filter;
            if (this.mAllDevices != null) {
                this.updateAllDevices();
            }
        }

        public void setDeviceListSupplier(Function<Db, ArrayList<Device>> supplier) {
            this.mDeviceListSupplier = supplier;
            if (this.mAllDevices != null) {
                this.updateAllDevices();
            }
        }

        public void setFilter(String prop, String filter) {
            this.mCboFilterProp.setSelectedItem(prop);
            this.mTxtFilter.setText(filter);
            this.updateFilteredData();
        }

        public APair<String, String> getFilter() {
            Object o = this.mCboFilterProp.getSelectedItem();
            if (o instanceof String) {
                String prop = (String)this.mCboFilterProp.getSelectedItem();
                String txt = this.mTxtFilter.getText();
                return new APair((Object)prop, (Object)txt);
            }
            return null;
        }

        public JPanel getCustomTopPanel() {
            return this.mCustomTopPnl;
        }

        public IterableIterator<Object> getSelectedValues() {
            final TreePath[] s = this.mTreeDevices.getSelectionPaths();
            if (s == null) {
                return AEmptyItr.create();
            }
            return new IterableIterator<Object>(){
                int nextItem = 0;

                public boolean hasNext() {
                    return this.nextItem < s.length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return s[this.nextItem++].getLastPathComponent();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Iterator<Object> iterator() {
                    return this;
                }
            };
        }

        public Device getSelectedDevice() {
            TreePath tp = this.mTreeDevices.getSelectionPath();
            if (tp == null) {
                return null;
            }
            Object o = tp.getLastPathComponent();
            this.mSelectedDevice = o instanceof DCTreeModel.DeviceNode ? ((DCTreeModel.DeviceNode)((Object)o)).mDevice : (o instanceof DCTreeModel.PathNode ? ((DCTreeModel.PathNode)((Object)o)).mPath.getLast() : null);
            return this.mSelectedDevice;
        }

        public DevicePath getSelectedDevicePath() {
            TreePath tp = this.mTreeDevices.getSelectionPath();
            if (tp == null) {
                return null;
            }
            Object o = tp.getLastPathComponent();
            if (o instanceof DCTreeModel.DeviceNode) {
                DCTreeModel.DeviceNode dn = (DCTreeModel.DeviceNode)((Object)o);
                if (dn.mDevicePath != null) {
                    return dn.mDevicePath;
                }
            } else if (o instanceof DCTreeModel.PathNode) {
                return ((DCTreeModel.PathNode)((Object)o)).mPath;
            }
            return null;
        }

        public void updateAllDevices() {
            this.mAllDevices = this.mDeviceListSupplier != null ? this.mDeviceListSupplier.apply(this.mDb) : (this.mDeviceFilter == null ? (ArrayList)this.mDb.getObjects(Device.class).parallelStream().sorted().collect(Collectors.toList()) : (ArrayList)this.mDb.getObjects(Device.class).parallelStream().filter(d -> this.mDeviceFilter.includeDevice(d)).sorted().collect(Collectors.toList()));
            if (this.mSpecial != null) {
                this.mAllDevices.add(0, this.mSpecial);
            }
            this.updateFilteredData();
        }

        protected void updateFilteredData() {
            Object selFilterItem;
            if (!this.mTxtFilter.isEnabled()) {
                return;
            }
            Object filter = this.mTxtFilter.getText();
            if (((String)filter).length() == 0) {
                this.mTreeDevices.setModel((TreeModel)((Object)new DCTreeModel(this.mAllDevices, this.mSelectPath)));
                this.setStatus("");
                return;
            }
            if (!(((String)filter).contains("\\") || ((String)filter).contains(".") || ((String)filter).contains("["))) {
                filter = (String)filter + ".*";
            }
            Selector.Property prop = (selFilterItem = this.mCboFilterProp.getSelectedItem()) instanceof Selector.Property ? (Selector.Property)selFilterItem : null;
            try {
                Pattern pattern = Pattern.compile((String)filter);
                ArrayList<Device> filteredData = new ArrayList<Device>(this.mAllDevices.size());
                for (Device d : this.mAllDevices) {
                    if (d == this.mSpecial || prop == null) {
                        filteredData.add(d);
                        continue;
                    }
                    boolean match = AStream.of((Iterator)prop.getValues((DbObject)d, null)).anyMatch(pval -> pattern.matcher((CharSequence)pval).matches());
                    if (!match) continue;
                    filteredData.add(d);
                }
                this.mTreeDevices.setModel((TreeModel)((Object)new DCTreeModel(filteredData, this.mSelectPath)));
                this.setStatus("List filtered.");
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid pattern, all data displayed.");
                this.mTreeDevices.setModel((TreeModel)((Object)new DCTreeModel(this.mAllDevices, this.mSelectPath)));
                this.mTxtFilter.requestFocus();
                return;
            }
        }

        protected void setStatus(String text) {
            this.mLblStatus.setVisible(text != null && text.length() > 0);
            this.mLblStatus.setText(text);
        }

        public void addDeviceListener(DeviceListener l) {
            this.mDeviceListeners.add(l);
        }

        public void removeDeviceListener(DeviceListener l) {
            this.mDeviceListeners.remove(l);
        }

        public void addDeviceContextMenuListener(DeviceContextMenuListener l) {
            this.mDeviceContextMenuListeners.add(l);
        }

        public void removeDeviceContextMenuListener(DeviceContextMenuListener l) {
            this.mDeviceContextMenuListeners.remove(l);
        }

        protected void fireDeviceActivated(Device d) {
            for (DeviceListener l : this.mDeviceListeners) {
                l.deviceActivated(this.getSelectedDevice());
            }
        }

        protected void fireDeviceSelected(Device d) {
            for (DeviceListener l : this.mDeviceListeners) {
                l.deviceSelected(this.getSelectedDevice());
            }
        }

        protected void fireDevicePopup(Device d) {
            for (DeviceContextMenuListener l : this.mDeviceContextMenuListeners) {
                l.deviceShowPopup(this.getSelectedDevice());
            }
        }

        public void addTreeMouseListener(MouseAdapter mouseListener) {
            this.mTreeDevices.addMouseListener(mouseListener);
        }

        public static interface DeviceContextMenuListener {
            public void deviceShowPopup(Device var1);
        }

        public static interface DeviceListener {
            public void deviceSelected(Device var1);

            public void deviceActivated(Device var1);
        }
    }

    public static class DCDialog
    extends ADialog {
        protected DCPanel mChooserPnl;
        protected JLabel mLblStatus;
        protected JButton mBtnOk;
        protected DCPanel.DeviceListener mDeviceListener = new DCPanel.DeviceListener(this){
            final /* synthetic */ DCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void deviceSelected(Device d) {
                this.this$0.mBtnOk.setEnabled(this.this$0.mChooserPnl.mSelectPath ? this.this$0.getSelectedDevicePath() != null : d != null);
            }

            @Override
            public void deviceActivated(Device l) {
                if (!this.this$0.mChooserPnl.mSelectPath || this.this$0.mChooserPnl.getSelectedDevicePath() != null) {
                    this.this$0.mOk.actionPerformed(null);
                }
            }
        };
        protected WindowListener mDialogListener = new WindowAdapter(this){
            final /* synthetic */ DCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void windowClosed(WindowEvent e) {
                this.this$0.removeWindowListener(this);
                this.this$0.mChooserPnl.removeDeviceListener(this.this$0.mDeviceListener);
            }
        };
        protected ActionListener mOk = new ActionListener(this){
            final /* synthetic */ DCDialog this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.this$0.mChooserPnl.getSelectedDevice() == null) {
                    JOptionPane.showMessageDialog((Component)((Object)this.this$0), "You must select a device to continue.", DeviceChooser.TITLE_SELECT_DEVICE, 0);
                    return;
                }
                UIUtil.closeWindow((Window)((Object)this.this$0));
            }
        };

        public DCDialog() throws HeadlessException {
            this.init();
        }

        public DCDialog(Component owner) throws HeadlessException {
            super(owner);
            this.init();
        }

        public void setDb(Db db) {
            this.mChooserPnl.setDb(db);
        }

        public void setInitialDevice(Device initDevice) {
            this.mChooserPnl.setInitialDevice(initDevice);
        }

        public void setSpecial(Device specialDevice) {
            this.mChooserPnl.setSpecial(specialDevice);
        }

        public Device getSelectedDevice() {
            return this.mChooserPnl.getSelectedDevice();
        }

        public DevicePath getSelectedDevicePath() {
            return this.mChooserPnl.getSelectedDevicePath();
        }

        protected void init() {
            this.setTitle(DeviceChooser.TITLE_SELECT_DEVICE);
            GridBagManager l = new GridBagManager(this.getContentPane());
            this.mChooserPnl = new DCPanel(){

                @Override
                protected void setStatus(String text) {
                    mLblStatus.setText(text);
                }
            };
            l.add((Component)this.mChooserPnl, (GridBagConstraints)GridBagManager.FILLALL.noInsets());
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX.noInsets());
            this.mLblStatus = new JLabel("");
            l.add((Component)this.mLblStatus, (GridBagConstraints)GridBagManager.FILLX);
            this.mBtnOk = (JButton)l.add((Component)new JButton("OK"), (GridBagConstraints)GridBagManager.RIGHT);
            this.mBtnOk.addActionListener(this.mOk);
            this.mBtnOk.setEnabled(false);
            JButton btnCancel = new JButton("Cancel");
            l.add((Component)btnCancel, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            this.mChooserPnl.addDeviceListener(this.mDeviceListener);
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)this.mBtnOk);
            this.pack();
            UIUtil.center((Component)((Object)this));
            this.addWindowListener(this.mDialogListener);
            if (this.mChooserPnl.mTxtFilter != null && this.mChooserPnl.mTxtFilter.isVisible()) {
                this.mChooserPnl.mTxtFilter.requestFocus();
            }
        }
    }

    public static interface InitHook {
        public void initDeviceChooser(DCPanel var1);
    }
}

