/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.geom.AGeomUtil;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class DeviceDimensionUI {
    protected Device mDevice;
    protected boolean mShowDeviceDimension = false;
    protected DimensionOverlayMode mDimensionOverlay = null;
    protected HashSet<PinInstance> mPorts = new HashSet();
    protected HashMap<PinInstance, HashMap<PinInstance, AdjacentPortPair>> mAdjacentLines = new HashMap();
    protected static final long ARROWWIDTH = Design.getDefaultUnitDist().fromUser(400.0);
    protected static final int MIN_ARROWWIDTH = 1;
    protected static final int MAX_ARROWWIDTH = 4;
    protected static final long LINESPACING = Design.getDefaultUnitDist().fromUser(200.0);
    protected static final int MIN_LINESPACING = 0;
    protected static final int MAX_LINESPACING = 10;
    protected static final long ARROWHEIGHT = Design.getDefaultUnitDist().fromUser(1200.0);
    protected static final int MIN_ARROWHEIGHT = 1;
    protected static final int MAX_ARROWHEIGHT = 8;
    protected static final long ARROWLINELEN = Design.getDefaultUnitDist().fromUser(2000.0);
    protected static final int MIN_ARROWLINELEN = 0;
    protected static final int MAX_ARROWLINELEN = 12;

    public static DeviceDimensionUI createInstance(AAppView view, Device device) {
        if (view == null) {
            return null;
        }
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, device);
        if (ui != null) {
            return ui;
        }
        if (view instanceof DesignView2D) {
            DimensionMode2D mode2D = new DimensionMode2D((DesignView2D)view);
            ui = new DeviceDimensionUI(mode2D, device);
        } else assert (false);
        return ui;
    }

    public static DeviceDimensionUI getDimensionUI(AAppView view, Device device) {
        if (view == null) {
            return null;
        }
        if (view instanceof DesignView2D) {
            int ll;
            DesignView2D view2D = (DesignView2D)view;
            int hl = view2D.highestLayer();
            for (int l = ll = view2D.lowestLayer(); l <= hl; ++l) {
                Component[] cs;
                for (Component c : cs = view2D.getComponentsInLayer(l)) {
                    DeviceDimensionUI ui;
                    if (!(c instanceof DimensionOverlay) || (ui = ((DimensionOverlay)c).mUI) == null || ui.mDevice != device) continue;
                    return ui;
                }
            }
        }
        return null;
    }

    public static boolean removeDimension(AAppView view, Device device) {
        if (view == null) {
            return false;
        }
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, device);
        if (ui == null) {
            return true;
        }
        if (view instanceof DesignView2D) {
            DesignView2D view2D = (DesignView2D)view;
            view2D.removeOverlay(ui.mDimensionOverlay.getOverlay());
        } else assert (false);
        return true;
    }

    public static boolean isShowDeviceDimension(AAppView view, Device device) {
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, device);
        if (ui == null) {
            return false;
        }
        return ui.isShowDeviceDimension();
    }

    public static boolean isShowPortDimensions(AAppView view, Device device, Iterator<PinInstance> ports) {
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, device);
        if (ui == null) {
            return false;
        }
        return ui.isShowPortDimensions(ports);
    }

    public static boolean isShowPortDimensions(AAppView view, PinInstance port) {
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, port.getDevice());
        if (ui == null) {
            return false;
        }
        return ui.isShowPortDimensions(port);
    }

    public static boolean isShowAdjacentDimensions(AAppView view, Device device, Iterator<PinInstance> ports) {
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, device);
        if (ui == null) {
            return false;
        }
        return ui.isShowAdjacentDimensions(ports);
    }

    public static boolean isShowAdjacentDimensions(AAppView view, PinInstance port) {
        DeviceDimensionUI ui = DeviceDimensionUI.getDimensionUI(view, port.getDevice());
        if (ui == null) {
            return false;
        }
        return ui.isShowAdjacentDimensions(port);
    }

    public static Iterator<PinInstance> getSelectedPorts(Device device) {
        Selection sel = Design.getSelection((Db)device.getDb());
        ArrayList<PinInstance> ports = new ArrayList<PinInstance>();
        for (PinInstance port : sel.get(PinInstance.class)) {
            if (port.getDevice() != device) continue;
            ports.add(port);
        }
        return ports.iterator();
    }

    public static int microToPixel(DesignView2D view, long micro, int minValue, int maxValue) {
        DesignCanvas2D.XForm xForm = view.getCanvas().getXForm();
        int v = xForm.getScreenLength(micro);
        if (minValue > 0 && v < minValue) {
            v = minValue;
        }
        if (maxValue > 0 && v > maxValue) {
            v = maxValue;
        }
        return v;
    }

    protected DeviceDimensionUI(DimensionOverlayMode dimension, Device device) {
        this.mDevice = device;
        this.mDimensionOverlay = dimension;
        this.mDimensionOverlay.assignDimensionUI(this);
    }

    public void setVisible(boolean visible) {
        if (this.mDimensionOverlay != null) {
            this.mDimensionOverlay.setVisiable(visible);
        }
    }

    public void drawDeviceDimension(boolean drawFlag) {
        this.mShowDeviceDimension = drawFlag;
        this.repaintOverlay(false);
    }

    public void drawPortDimension(Iterator<PinInstance> ports, boolean drawFlag) {
        while (ports.hasNext()) {
            PinInstance p = ports.next();
            this.drawPortDimension(p, drawFlag);
        }
    }

    public void drawPortDimension(PinInstance port, boolean drawFlag) {
        if (drawFlag) {
            this.mPorts.add(port);
        } else {
            this.mPorts.remove(port);
        }
        this.repaintOverlay(false);
    }

    public void drawAdjacentDimension(PinInstance port, boolean drawFlag) {
        this.drawAdjacentDimension(port, DIMELINEPOS.PIN_CENTER, drawFlag);
    }

    public void drawAdjacentDimension(PinInstance port, DIMELINEPOS pos, boolean drawFlag) {
        AdjacentPortPair pair = this.getAdjacentPair(port, pos);
        if (pair != null) {
            if (drawFlag) {
                this.addAdjacentPortPair(pair);
            } else {
                this.removeAdjacentPortPair(pair);
            }
            this.repaintOverlay(false);
        }
    }

    public void drawAdjacentDimension(Iterator<PinInstance> ports, boolean drawFlag) {
        this.drawAdjacentDimension(ports, DIMELINEPOS.PIN_CENTER, drawFlag);
    }

    public void drawAdjacentDimension(Iterator<PinInstance> ports, DIMELINEPOS pos, boolean drawFlag) {
        while (ports.hasNext()) {
            PinInstance p = ports.next();
            this.drawAdjacentDimension(p, pos, drawFlag);
        }
    }

    public void repaintOverlay(boolean immediate) {
        this.mDimensionOverlay.repaintOverlay(immediate);
    }

    public Device getDevice() {
        return this.mDevice;
    }

    public boolean isShowDeviceDimension() {
        return this.mShowDeviceDimension;
    }

    public boolean isShowPortDimensions(Iterator<PinInstance> ports) {
        if (this.mDevice == null) {
            return false;
        }
        boolean bFound = false;
        while (ports.hasNext()) {
            if (!this.mPorts.contains(ports.next())) {
                return false;
            }
            if (bFound) continue;
            bFound = true;
        }
        return bFound;
    }

    public boolean isShowPortDimensions(PinInstance port) {
        if (this.mDevice == null) {
            return false;
        }
        return this.mPorts.contains(port);
    }

    public boolean isShowAdjacentDimensions(Iterator<PinInstance> ports) {
        if (this.mDevice == null) {
            return false;
        }
        boolean bFound = false;
        while (ports.hasNext()) {
            PinInstance port = ports.next();
            AdjacentPortPair pair = this.getAdjacentPair(port);
            if (pair == null) continue;
            HashMap<PinInstance, AdjacentPortPair> m = this.mAdjacentLines.get(pair.mPort0);
            if (m == null) {
                return false;
            }
            if (!m.containsKey(pair.mPort1)) {
                return false;
            }
            if (bFound) continue;
            bFound = true;
        }
        return bFound;
    }

    public boolean isShowAdjacentDimensions(PinInstance port) {
        if (this.mDevice == null) {
            return false;
        }
        AdjacentPortPair pair = this.getAdjacentPair(port);
        return pair != null && this.mAdjacentLines.containsKey(pair.mPort0);
    }

    public Set<PinInstance> getPorts() {
        return this.mPorts;
    }

    protected void addAdjacentPortPair(AdjacentPortPair pair) {
        HashMap<Object, AdjacentPortPair> m = this.mAdjacentLines.get(pair.mPort0);
        if (m == null) {
            m = new HashMap();
            this.mAdjacentLines.put(pair.mPort0, m);
        }
        m.put(pair.mPort1, pair);
    }

    protected void removeAdjacentPortPair(AdjacentPortPair pair) {
        HashMap<PinInstance, AdjacentPortPair> m = this.mAdjacentLines.get(pair.mPort0);
        if (m != null) {
            m.remove(pair.mPort1);
        }
    }

    protected AdjacentPortPair getAdjacentPair(PinInstance port) {
        return this.getAdjacentPair(port, DIMELINEPOS.PIN_CENTER);
    }

    protected ALine getAdjacentPair(PinInstance port1, PinInstance port2, DIMELINEPOS pos) {
        return null;
    }

    protected AdjacentPortPair getAdjacentPair(PinInstance port, DIMELINEPOS pos) {
        Net net = port.getNet();
        if (net == null) {
            return null;
        }
        APoint2D loc1 = port.getLocalLoc();
        APoint2D loc2 = null;
        long minDist = Long.MAX_VALUE;
        PinInstance adjacentPort = null;
        for (PinInstance p : net.getPinInstances()) {
            long dy;
            if (p == port) continue;
            loc2 = p.getLocalLoc();
            long dx = loc1.getX() - loc2.getX();
            long dist = (long)Math.sqrt((double)dx * (double)dx + (double)(dy = loc1.getY() - loc2.getY()) * (double)dy);
            if (dist >= minDist) continue;
            adjacentPort = p;
            minDist = dist;
        }
        if (adjacentPort == null) {
            return null;
        }
        AdjacentPortPair pair = null;
        loc2 = adjacentPort.getLocalLoc();
        pair = loc1.getX() < loc2.getX() || loc1.getX() == loc2.getX() && loc1.getY() < loc2.getY() ? new AdjacentPortPair(port, adjacentPort) : new AdjacentPortPair(adjacentPort, port);
        loc1 = pair.mPort0.getLoc();
        loc2 = pair.mPort1.getLoc();
        if (pos == DIMELINEPOS.PIN_CENTER) {
            pair.mLine = new ALine(loc1, loc2);
        } else {
            DevicePath path0 = pair.mPort0.getDevice().getADevicePath();
            DevicePath path1 = pair.mPort1.getDevice().getADevicePath();
            ARect rc1 = pair.mPort0.getWorldBounds(path0);
            ARect rc2 = pair.mPort1.getWorldBounds(path1);
            if (pos == DIMELINEPOS.PIN_EDGE_LEFT) {
                pair.mLine = new ALine(loc1.getX() - rc1.width() / 2L, loc1.getY(), loc2.getX() - rc2.width() / 2L, loc2.getY());
            } else if (pos == DIMELINEPOS.PIN_EDGE_RIGHT) {
                pair.mLine = new ALine(loc1.getX() + rc1.width() / 2L, loc1.getY(), loc2.getX() + rc2.width() / 2L, loc2.getY());
            } else if (pos == DIMELINEPOS.PIN_EDGE_TOP) {
                pair.mLine = new ALine(loc1.getX(), loc1.getY() + rc1.height() / 2L, loc2.getX(), loc2.getY() + rc2.height() / 2L);
            } else if (pos == DIMELINEPOS.PIN_EDGE_BOTTOM) {
                pair.mLine = new ALine(loc1.getX(), loc1.getY() - rc1.height() / 2L, loc2.getX(), loc2.getY() - rc2.height() / 2L);
            } else assert (false);
        }
        return pair;
    }

    public static class DimensionMode2D
    implements DimensionOverlayMode {
        protected DesignView2D mView;
        protected DeviceDimensionUI mDimensionUI = null;
        protected DimensionOverlay mOverlay = new DimensionOverlay(){
            {
                this.setDoubleBuffered(true);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                Graphics2D g = (Graphics2D)graphics;
                Rectangle bounds = UIUtil.getBoundsMinusInsets((JComponent)mOverlay);
                bounds = SwingUtilities.convertRectangle(this, bounds, mOverlay);
                g.setClip(bounds);
                this.paintOverlay(g, bounds);
                g.dispose();
            }
        };

        public DimensionMode2D(DesignView2D view) {
            this.mView = view;
            this.mView.addOverlay(this.mOverlay);
            this.mOverlay.setVisible(false);
        }

        @Override
        public DimensionOverlay getOverlay() {
            return this.mOverlay;
        }

        @Override
        public void assignDimensionUI(DeviceDimensionUI dimensionUI) {
            this.mOverlay.mUI = dimensionUI;
            this.mDimensionUI = dimensionUI;
            this.setVisiable(true);
        }

        @Override
        public DeviceDimensionUI getDimensionUI() {
            return this.mDimensionUI;
        }

        @Override
        public void setVisiable(boolean visiable) {
            this.mOverlay.setVisible(visiable && this.mOverlay.mUI.mDevice != null);
        }

        @Override
        public void repaintOverlay(boolean immediate) {
            if (immediate) {
                this.mOverlay.paintImmediately(this.mOverlay.getBounds());
            } else {
                this.mOverlay.repaint();
            }
        }

        protected void paintOverlay(Graphics2D g, Rectangle bounds) {
            if (this.mDimensionUI == null) {
                return;
            }
            g.setXORMode(Color.WHITE);
            DevicePath path = this.mDimensionUI.mDevice.getADevicePath();
            AffineTransform transform = path.getTransform();
            if (this.mDimensionUI.mShowDeviceDimension) {
                ARect bb = this.mDimensionUI.mDevice.getUntransformedShape().getBounds();
                this.drawDimensionLine(g, transform, new APoint2D(bb.getLL().getX(), bb.getLL().getY()), new APoint2D(bb.getLL().getX(), bb.getUR().getY()));
                this.drawDimensionLine(g, transform, new APoint2D(bb.getLL().getX(), bb.getLL().getY()), new APoint2D(bb.getUR().getX(), bb.getLL().getY()));
            }
            for (HashMap<PinInstance, AdjacentPortPair> paires : this.mDimensionUI.mAdjacentLines.values()) {
                for (AdjacentPortPair pair : paires.values()) {
                    ALine line = pair.mLine;
                    if (pair.mPort0.getDevice() != pair.mPort1.getDevice()) continue;
                    this.drawDimensionLine(g, transform, line.getP0(), line.getP1());
                }
            }
            g.setPaintMode();
            this.drawPortDimension(g, transform);
        }

        public static Font selectFitFont(Graphics2D g, Rectangle bounds, String str) {
            int oldSize = g.getFont().getSize();
            float fsize = UIUtil.getFontSizeToFitText((Graphics2D)g, (String)str, (Rectangle2D)bounds);
            Font oldFont = null;
            if (fsize >= 6.0f) {
                fsize = Math.min((float)oldSize, fsize);
                Font f = g.getFont();
                f = f.deriveFont(fsize);
                oldFont = g.getFont();
                g.setFont(f);
            }
            return oldFont;
        }

        protected void drawLine(Graphics2D g, AffineTransform transform, APoint2D p1, APoint2D p2) {
            assert (this.mDimensionUI != null);
            p1 = p1.transform(transform);
            p2 = p2.transform(transform);
            DesignCanvas2D.XForm screenForm = this.mView.getCanvas().getXForm();
            Point pt1 = screenForm.getScreenPt(p1);
            Point pt2 = screenForm.getScreenPt(p2);
            g.drawLine((int)pt1.getX(), (int)pt1.getY(), (int)pt2.getX(), (int)pt2.getY());
        }

        public void drawDimensionLine(Graphics2D g, AffineTransform transform, APoint2D p1, APoint2D p2) {
            assert (this.mDimensionUI != null);
            DimensionMode2D.drawDimLine(g, transform, p1, p2, this.mView, this.mDimensionUI.mDevice.getDb());
        }

        public static void drawDimLine(Graphics2D g, AffineTransform transform, APoint2D p1, APoint2D p2, DesignView2D view, Db db) {
            DimensionMode2D.drawDimLine(g, transform, p1, p2, view, db, false, null, null);
        }

        public static void drawDimLine(Graphics2D g, AffineTransform transform, APoint2D p1, APoint2D p2, DesignView2D view, Db db, boolean noShift, Color color, Font font) {
            int yLine;
            Font oldFont;
            if (transform != null) {
                p1 = p1.transform(transform);
                p2 = p2.transform(transform);
            }
            DesignCanvas2D.XForm screenForm = view.getCanvas().getXForm();
            Point pt1 = screenForm.getScreenPt(p1);
            Point pt2 = screenForm.getScreenPt(p2);
            if (pt1.x > pt2.x) {
                Point pt3 = (Point)pt1.clone();
                pt1.setLocation(pt2);
                pt2.setLocation(pt3);
            }
            long dx = p2.getX() - p1.getX();
            long dy = p2.getY() - p1.getY();
            Design design = Design.getDesign((Db)db);
            if (design == null) {
                return;
            }
            String microLen = String.format("%.02f", Math.sqrt((double)dx * (double)dx + (double)dy * (double)dy) / (double)((int)design.getInternalPerMicron()));
            dx = (int)(pt2.getX() - pt1.getX());
            dy = (int)(pt2.getY() - pt1.getY());
            int pixelLen = (int)Math.sqrt((double)dx * (double)dx + (double)dy * (double)dy);
            double at = dx != 0L ? Math.atan((double)dy / (double)dx) : (dy < 0L ? -1.5707963267948966 : 1.5707963267948966);
            g.setColor(color != null ? color : Color.RED);
            if (font != null) {
                g.setFont(font);
            }
            g.rotate(at, (int)pt1.getX(), (int)pt1.getY());
            pt2 = new Point((int)pt1.getX() + pixelLen, (int)pt1.getY());
            FontMetrics metrics = g.getFontMetrics();
            int capHeight = metrics.getHeight();
            int capWidth = metrics.charsWidth(microLen.toCharArray(), 0, microLen.length());
            int lenAH = DeviceDimensionUI.microToPixel(view, ARROWHEIGHT, 1, 8);
            int lenALine = DeviceDimensionUI.microToPixel(view, ARROWLINELEN, 0, 12);
            boolean changeDirec = capWidth + lenAH * 2 + 2 > pixelLen;
            Font font2 = oldFont = changeDirec ? DimensionMode2D.selectFitFont(g, new Rectangle(0, 0, pixelLen, capHeight), microLen) : null;
            if (oldFont != null) {
                metrics = g.getFontMetrics();
                capHeight = metrics.getHeight();
                capWidth = metrics.charsWidth(microLen.toCharArray(), 0, microLen.length());
            }
            int xCaption = (int)pt1.getX() + (pixelLen - capWidth) / 2;
            int yCaption = (int)pt1.getY();
            int n = yLine = noShift ? pt1.y : yCaption - capHeight / 2;
            if (!changeDirec) {
                int l = changeDirec ? 1 : lenAH + lenALine + 1;
                g.drawLine(pt1.x + l, yLine, xCaption, yLine);
                g.drawLine(xCaption + capWidth, yLine, pt2.x - l, yLine);
            }
            if (!changeDirec || changeDirec && oldFont != null) {
                g.drawString(microLen, xCaption, yCaption);
            }
            Point ptArrow1 = new Point(pt1.x, yLine);
            Point ptArrow2 = new Point(pt2.x, yLine);
            DesignCanvas2D.drawArrow(view, g, ptArrow1, changeDirec ? AGeomUtil.Orient.E : AGeomUtil.Orient.W);
            DesignCanvas2D.drawArrow(view, g, ptArrow2, changeDirec ? AGeomUtil.Orient.W : AGeomUtil.Orient.E);
            g.rotate(-at, (int)pt1.getX(), (int)pt1.getY());
            if (oldFont != null) {
                g.setFont(oldFont);
            }
        }

        protected void drawPortDimension(Graphics2D g, AffineTransform transform) {
            DesignCanvas2D.XForm xForm = this.mView.getCanvas().getXForm();
            FontMetrics metrics = g.getFontMetrics();
            long lineSpace = LINESPACING;
            long capHeight = xForm.getWorldLength(metrics.getHeight());
            long dimeSpace = lineSpace + capHeight;
            HashSet<Long> setCols = new HashSet<Long>();
            HashSet<Long> setRows = new HashSet<Long>();
            for (PinInstance p : this.mDimensionUI.mPorts) {
                APoint2D pt = p.getLoc();
                if (pt == null) continue;
                setCols.add(pt.getX());
                setRows.add(pt.getY());
            }
            Object[] arrayCols = setCols.toArray();
            Object[] arrayRows = setRows.toArray();
            Arrays.sort(arrayCols);
            Arrays.sort(arrayRows);
            if (this.mDimensionUI == null || this.mDimensionUI.mDevice == null || this.mDimensionUI.mDevice.getUntransformedShape() == null) {
                return;
            }
            ARect rcDevice = this.mDimensionUI.mDevice.getUntransformedShape().getBounds();
            APoint2D ptUr = rcDevice.getUR();
            int colIndex = 0;
            for (Object o : arrayCols) {
                long c = (Long)o;
                long r = Long.MAX_VALUE;
                for (PinInstance p : this.mDimensionUI.mPorts) {
                    APoint2D loc = p.getLoc();
                    long x = loc.getX();
                    if (!setCols.contains(x) || x != c || r <= loc.getY()) continue;
                    r = loc.getY();
                }
                APoint2D pt1 = new APoint2D(c, r);
                long space = lineSpace + dimeSpace * (long)(arrayCols.length - colIndex);
                APoint2D pt2 = new APoint2D(pt1.getX(), ptUr.getY() + space);
                this.drawLine(g, transform, pt1, pt2);
                APoint2D pt3 = new APoint2D(ptUr.getX(), pt2.getY());
                if (colIndex == 0) {
                    this.drawLine(g, transform, ptUr, pt3);
                }
                ++colIndex;
                this.drawDimensionLine(g, transform, pt2, pt3);
            }
            int rowIndex = 0;
            for (Object o : arrayRows) {
                long r = (Long)o;
                long c = Long.MAX_VALUE;
                for (PinInstance p : this.mDimensionUI.mPorts) {
                    APoint2D loc = p.getLoc();
                    long y = loc.getY();
                    if (!setRows.contains(y) || y != r || c <= loc.getX()) continue;
                    c = loc.getX();
                }
                APoint2D pt1 = new APoint2D(c, r);
                long space = lineSpace + dimeSpace * (long)(arrayRows.length - rowIndex);
                APoint2D pt2 = new APoint2D(ptUr.getX() + space, pt1.getY());
                this.drawLine(g, transform, pt1, pt2);
                APoint2D pt3 = new APoint2D(pt2.getX(), ptUr.getY());
                if (rowIndex == 0) {
                    this.drawLine(g, transform, ptUr, pt3);
                }
                ++rowIndex;
                this.drawDimensionLine(g, transform, pt2, pt3);
            }
        }
    }

    public static class DimensionOverlay
    extends JComponent {
        DeviceDimensionUI mUI = null;

        public DimensionOverlay() {
        }

        public DimensionOverlay(DeviceDimensionUI ui) {
            this.mUI = ui;
        }
    }

    protected static class AdjacentPortPair {
        protected PinInstance mPort0;
        protected PinInstance mPort1;
        protected ALine mLine = null;

        public AdjacentPortPair(PinInstance port0, PinInstance port1) {
            this.mPort0 = port0;
            this.mPort1 = port1;
        }

        public int hashCode() {
            return this.mPort0 != null ? this.mPort0.hashCode() : 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdjacentPortPair)) {
                return false;
            }
            AdjacentPortPair o = (AdjacentPortPair)obj;
            return Objects.equals(this.mPort0, o.mPort0) && Objects.equals(this.mPort1, o.mPort1) && Objects.equals(this.mLine, o.mLine);
        }
    }

    public static interface DimensionOverlayMode {
        public DimensionOverlay getOverlay();

        public void repaintOverlay(boolean var1);

        public void assignDimensionUI(DeviceDimensionUI var1);

        public DeviceDimensionUI getDimensionUI();

        public void setVisiable(boolean var1);
    }

    public static enum DIMELINEPOS {
        PIN_CENTER,
        PIN_EDGE_LEFT,
        PIN_EDGE_TOP,
        PIN_EDGE_RIGHT,
        PIN_EDGE_BOTTOM;

    }
}

