/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class DeviceListCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    protected boolean mIndicateMultiplePaths = false;
    protected HashMap<Icon, Icon> mMultiInstIcons = new HashMap();
    protected Icon mMultiIcon = UIUtil.ICON_MORE;

    public DeviceListCellRenderer() {
        this(false);
    }

    public DeviceListCellRenderer(boolean indicateMultiplePaths) {
        this.mIndicateMultiplePaths = indicateMultiplePaths;
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Device d;
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        if (!(value instanceof Device) && !(value instanceof DevicePath)) {
            this.setText(value.toString());
            return this;
        }
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        if (value instanceof DevicePath) {
            DevicePath p = (DevicePath)value;
            d = p.getLast();
            this.setToolTipText(p.toString());
            this.setText(d.getName());
            if (d.getIsFixed()) {
                this.setEnabled(false);
            }
        } else {
            d = (Device)value;
            this.setText(d.getName());
        }
        Icon icon = DbExplorerPanel.getIconForDevice(d);
        if (this.mIndicateMultiplePaths) {
            int count = 0;
            for (DevicePath inst : d.getHierarchicalInstances()) {
                if (++count <= 1) continue;
                break;
            }
            if (count > 1) {
                icon = this.getMultiInstIcon(icon);
            }
        }
        this.setIcon(icon);
        this.setOpaque(true);
        return this;
    }

    protected Icon getMultiInstIcon(Icon in) {
        Icon out = this.mMultiInstIcons.get(in);
        if (out == null) {
            out = new ADecoratedIcon(in, this.mMultiIcon);
            this.mMultiInstIcons.put(in, out);
        }
        return out;
    }
}

