/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeLeaf;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.orbit.DeviceFilters;
import com.sigrity.orbit.DevicePath;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DevicePathChooser {
    private DevicePathChooser() {
    }

    public static class DeviceTree
    extends ATree {
        protected DeviceFilters.DeviceFilter mDeviceFilter;

        public DeviceTree(ATreeModel model) {
            super(model);
            this.setShowsRootHandles(true);
        }

        public void setDeviceFilter(DeviceFilters.DeviceFilter deviceFilter) {
            this.mDeviceFilter = deviceFilter;
        }

        public class DeviceNode
        extends ALazyTreeNode
        implements DbExplorerPanel.HasDevice {
            protected Device mDevice;

            public DeviceNode(ATreeNode parent, Device device) {
                super(parent);
                this.mDevice = device;
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<DeviceNode> children = new ArrayList<DeviceNode>();
                for (Device child : this.mDevice.getChildren()) {
                    if (DeviceTree.this.mDeviceFilter != null && !DeviceTree.this.mDeviceFilter.includeDevice(child)) continue;
                    children.add(new DeviceNode((ATreeNode)this, child));
                }
                return children;
            }

            public String getText() {
                return this.mDevice.getName();
            }

            public Icon getIcon() {
                return DbExplorerPanel.getIconForDevice(this.mDevice);
            }

            @Override
            public Device getDevice() {
                return this.mDevice;
            }
        }

        public class DesignNode
        extends ALazyTreeNode {
            protected Design mDesign;

            public DesignNode(ATreeModel model, Design design) {
                super(model);
                this.mDesign = design;
            }

            public ArrayList<? extends ATreeNode> populateChildren() {
                ArrayList<DeviceNode> children = new ArrayList<DeviceNode>();
                for (Device child : this.mDesign.getChildren()) {
                    if (DeviceTree.this.mDeviceFilter != null && !DeviceTree.this.mDeviceFilter.includeDevice(child)) continue;
                    children.add(new DeviceNode((ATreeNode)this, child));
                }
                return children;
            }

            public String getText() {
                return this.mDesign.getUserName();
            }
        }
    }

    public static class Panel
    extends JPanel {
        protected static final String[] FilterProps = new String[]{"name", "template", "personality"};
        protected Db mDb = null;
        protected DeviceTree mDeviceTree;
        protected ATreeModel mTreeModel = new ATreeModel();
        protected LinkedHashSet<ChooserListener> mChooserListeners = new LinkedHashSet();
        protected LinkedHashSet<ContextMenuListener> mDeviceContextMenuListeners = new LinkedHashSet();
        protected MouseListener mDeviceMouseListener = new MouseAdapter(this){
            final /* synthetic */ Panel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && this.this$0.getSelectedPath() != null) {
                    this.this$0.fireDeviceActivated(this.this$0.getSelectedPath());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            protected void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.this$0.fireDevicePopup(this.this$0.getSelectedPath(), e);
                }
            }
        };
        protected TreeSelectionListener mTreeSelectionListener = e -> this.fireDeviceSelected(this.getSelectedPath());
        protected KeyListener mKeyListener = new KeyAdapter(this){
            final /* synthetic */ Panel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10 && this.this$0.getSelectedPath() != null) {
                    this.this$0.fireDeviceActivated(this.this$0.getSelectedPath());
                }
            }
        };

        public Panel(Db db) {
            this.mDb = db;
            this.initializePanel();
        }

        public Panel(Db db, DeviceFilters.DeviceFilter deviceFilter) {
            this.mDb = db;
            this.initializePanel(deviceFilter);
        }

        protected void initializePanel() {
            this.initializePanel(null);
        }

        protected void initializePanel(DeviceFilters.DeviceFilter deviceFilter) {
            GridBagManager l = new GridBagManager((Container)this);
            this.mDeviceTree = new DeviceTree(this.mTreeModel);
            this.mDeviceTree.setDeviceFilter(deviceFilter);
            JScrollPane spDeviceList = new JScrollPane((Component)((Object)this.mDeviceTree));
            l.add((Component)spDeviceList, (GridBagConstraints)GridBagManager.FILLALL_REMAINX.noInsets());
            this.mDeviceTree.setRootVisible(false);
            this.updateAllDevices();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.mDeviceTree.addMouseListener(this.mDeviceMouseListener);
            TreeSelectionModel tsm = this.mDeviceTree.getSelectionModel();
            tsm.setSelectionMode(1);
            tsm.addTreeSelectionListener(this.mTreeSelectionListener);
            this.mDeviceTree.addKeyListener(this.mKeyListener);
        }

        @Override
        public void removeNotify() {
            this.mDeviceTree.removeKeyListener(this.mKeyListener);
            this.mDeviceTree.getSelectionModel().removeTreeSelectionListener(this.mTreeSelectionListener);
            this.mDeviceTree.removeMouseListener(this.mDeviceMouseListener);
            super.removeNotify();
        }

        public void setDb(Db db) {
            this.mDb = db;
            this.updateAllDevices();
        }

        public void setDeviceFilter(DeviceFilters.DeviceFilter deviceFilter) {
            this.mDeviceTree.setDeviceFilter(deviceFilter);
            this.updateAllDevices();
        }

        public void setSelectedPath(DevicePath devPath) {
            TreeNode curNode = (TreeNode)this.mTreeModel.getRoot();
            TreePath treePath = new TreePath(curNode);
            DevicePath findPath = new DevicePath(devPath);
            while (!findPath.isEmpty()) {
                boolean find = false;
                Enumeration<? extends TreeNode> e = curNode.children();
                while (e.hasMoreElements()) {
                    DeviceTree.DeviceNode deviceNode;
                    TreeNode childNode = e.nextElement();
                    if (!(childNode instanceof DeviceTree.DeviceNode) || (deviceNode = (DeviceTree.DeviceNode)((Object)childNode)).getDevice() != findPath.getFirst()) continue;
                    curNode = childNode;
                    findPath.removeFirst();
                    treePath = treePath.pathByAddingChild(childNode);
                    find = true;
                    break;
                }
                if (find) continue;
                break;
            }
            this.mDeviceTree.setSelectionPath(treePath);
            this.mDeviceTree.scrollPathToVisible(treePath);
        }

        public DevicePath getSelectedPath() {
            TreeSelectionModel tsm = this.mDeviceTree.getSelectionModel();
            TreePath tp = tsm.getSelectionPath();
            if (tp == null) {
                return null;
            }
            DevicePath result = new DevicePath();
            for (Object n : tp.getPath()) {
                if (!(n instanceof DeviceTree.DeviceNode)) continue;
                result.add(((DeviceTree.DeviceNode)n).getDevice());
            }
            return result;
        }

        public void updateAllDevices() {
            Design design = Design.getDesign((Db)this.mDb);
            if (design == null) {
                this.mTreeModel.setRoot((TreeNode)new ATreeLeaf(this.mTreeModel){

                    public String getText() {
                        return "No Design in database";
                    }
                });
                return;
            }
            DeviceTree deviceTree = this.mDeviceTree;
            Objects.requireNonNull(deviceTree);
            this.mTreeModel.setRoot((TreeNode)((Object)deviceTree.new DeviceTree.DesignNode(this.mTreeModel, design)));
            int defaultOpenLevels = (Integer)Settings.getSettings((String)"UserPreferences").getSetting("DfltHiearchyExplorerLevels", (Object)-1);
            if (defaultOpenLevels > 0 || defaultOpenLevels == -1) {
                DbExplorerPanel.expandHierLevels((JTree)((Object)this.mDeviceTree), new TreePath(this.mTreeModel.getRoot()), defaultOpenLevels);
            }
        }

        public void addChooserListener(ChooserListener l) {
            this.mChooserListeners.add(l);
        }

        public void removeChooserListener(ChooserListener l) {
            this.mChooserListeners.remove(l);
        }

        protected void fireDeviceActivated(DevicePath p) {
            for (ChooserListener l : this.mChooserListeners) {
                l.pathActivated(p);
            }
        }

        protected void fireDeviceSelected(DevicePath p) {
            for (ChooserListener l : this.mChooserListeners) {
                l.pathSelected(p);
            }
        }

        public void addContextMenuListener(ContextMenuListener l) {
            this.mDeviceContextMenuListeners.add(l);
        }

        public void removeContextMenuListener(ContextMenuListener l) {
            this.mDeviceContextMenuListeners.remove(l);
        }

        protected void fireDevicePopup(DevicePath path, MouseEvent e) {
            for (ContextMenuListener l : this.mDeviceContextMenuListeners) {
                l.pathShowPopup(path, e);
            }
        }

        public static interface ContextMenuListener {
            public void pathShowPopup(DevicePath var1, MouseEvent var2);
        }

        public static interface ChooserListener {
            public void pathSelected(DevicePath var1);

            public void pathActivated(DevicePath var1);
        }
    }

    public static class Dialog
    extends ADialog {
        DevicePath mRoot = null;
        private ActionListener mOkListener = ae -> UIUtil.closeWindow((Window)((Object)this));

        public static DevicePath createDialog(Window owner, Db db) {
            Dialog dlg = new Dialog(owner, db);
            return dlg.mRoot;
        }

        private Dialog(Window owner, Db db) {
            super(owner, "Select Root");
            Panel chooser = new Panel(db, DeviceFilters.FILTER_SUBSTRATE){

                @Override
                protected void fireDeviceSelected(DevicePath p) {
                    super.fireDeviceSelected(p);
                    mRoot = p;
                }
            };
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            JScrollPane scrollPane = new JScrollPane(chooser, 20, 30);
            l.add((Component)scrollPane, (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOK = (JButton)l.add((Component)new JButton("OK"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            btnOK.addActionListener(this.mOkListener);
            btnCancel.addActionListener(e -> {
                this.mRoot = null;
            });
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.setModal(true);
            this.setVisible(true);
        }
    }
}

