/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AStream;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.automation.NetTable;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DevicePinMappingDlg
extends AFileChooser {
    static final AFileFilter CVS_FILE_FILTER = AFileFilter.CSV;

    public static void showMe(String devicePathString) {
        DevicePinMappingDlg fc = new DevicePinMappingDlg();
        fc.setFileFilter((FileFilter)CVS_FILE_FILTER);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle("Export Device Pin Mapping");
        fc.initi(devicePathString);
    }

    protected void initi(String devicePathString) {
        DevicePath pathExport;
        PinMappingExportOptionsPanel options = new PinMappingExportOptionsPanel();
        this.setAccessory(options);
        if (this.showSaveDialog(OrbitIO.getMainWindow()) != 0) {
            return;
        }
        File f = this.getSelectedFile();
        Object filepath = f.getPath();
        if (!f.getName().contains(".csv")) {
            filepath = (String)filepath + ".csv";
        }
        if ((pathExport = options.getSelectedDevicePath()) == null) {
            return;
        }
        String childParam = this.toStringArrayParam(options.getSelectedChildDevices().iterator());
        Cp.exec((String)"OrbitIO.exportDevicePinMapping(%s, \"%s\", %s, %s);", (Object[])new Object[]{Cp.getFileAsArgument((String)filepath), devicePathString, childParam, options.exportSeparateDeviceName()});
    }

    protected String toStringArrayParam(Iterator<?> i) {
        StringBuilder param = new StringBuilder("new String[] {");
        boolean firstItem = true;
        while (i.hasNext()) {
            if (!firstItem) {
                param.append(",");
            } else {
                firstItem = false;
            }
            param.append("\"" + i.next().toString() + "\"");
        }
        param.append("}");
        return param.toString();
    }

    protected class PinMappingExportOptionsPanel
    extends JPanel {
        protected JCheckBox mSeparateDeviceName;
        protected DefaultMutableTreeNode mRoot = new DefaultMutableTreeNode("Substrates");
        protected JTree mSubstrateTree = new JTree(this.mRoot);
        protected AList<AList.AListItem> mChildDevices = new AList();
        protected TreeSelectionListener mTreeListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                PinMappingExportOptionsPanel.this.createChildNodes();
            }
        };

        public PinMappingExportOptionsPanel() {
            this.init();
        }

        public DevicePath getSelectedDevicePath() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.mSubstrateTree.getLastSelectedPathComponent();
            if (node == null) {
                return null;
            }
            SimpleDevicePathName n = (SimpleDevicePathName)node.getUserObject();
            return n.mDevicepath;
        }

        public List<DevicePath> getSelectedChildDevices() {
            LinkedList<DevicePath> ds = new LinkedList<DevicePath>();
            ListModel m = this.mChildDevices.getModel();
            for (int i = 0; i < m.getSize(); ++i) {
                AList.AListItem item = (AList.AListItem)m.getElementAt(i);
                if (!item.getIsSelected()) continue;
                Device d = (Device)item.getKey();
                ds.add(d.getADevicePath());
            }
            return ds;
        }

        protected void init() {
            this.mSubstrateTree.setCellRenderer(new IconRender());
            this.createNodes(this.mRoot, null);
            this.expandAll(new TreePath(this.mRoot));
            if (this.mRoot.getChildCount() > 0) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.mRoot.getFirstChild();
                this.mSubstrateTree.setSelectionPath(new TreePath(n.getPath()));
            }
            this.mSubstrateTree.setRootVisible(false);
            this.mSubstrateTree.addTreeSelectionListener(this.mTreeListener);
            GridBagManager l = new GridBagManager((Container)this);
            l.pushFill("Substrate device");
            JScrollPane spSub = new JScrollPane(this.mSubstrateTree);
            spSub.setPreferredSize(new Dimension(200, 150));
            l.add((Component)spSub, (GridBagConstraints)GridBagManager.FILLALL);
            l.popNl();
            l.pushFill("Direct child devices :");
            l.newline();
            this.mChildDevices.setShowCheckBoxes(true);
            JScrollPane spChild = new JScrollPane(this.mChildDevices);
            spChild.setPreferredSize(new Dimension(200, 150));
            l.add((Component)spChild, (GridBagConstraints)GridBagManager.FILLALL);
            l.popNl();
            this.mSeparateDeviceName = new JCheckBox("Separate Device Name");
            l.add((Component)this.mSeparateDeviceName);
            l.newline();
            this.createChildNodes();
        }

        protected void expandAll(TreePath parent) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(path);
                }
            }
            this.mSubstrateTree.expandPath(parent);
        }

        protected void createNodes(DefaultMutableTreeNode root, Device device) {
            Db db = OrbitIO.getApp().getCurrentDb();
            if (device == null) {
                Design design = Design.getDesign((Db)db);
                design.getRootDevices().stream().sorted().forEach(d -> {
                    if (NetTable.isSubstrate(d)) {
                        this.createNodes(root, (Device)d);
                    }
                });
            } else {
                SimpleDevicePathName name = new SimpleDevicePathName(device.getADevicePath());
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(name);
                root.add(node);
                device.getChildren().stream().filter(cd -> NetTable.isSubstrate(cd)).sorted().forEach(cd -> this.createNodes(node, (Device)cd));
            }
        }

        protected void createChildNodes() {
            this.mChildDevices.removeAll();
            DevicePath path = this.getSelectedDevicePath();
            if (path == null) {
                return;
            }
            Vector v = new Vector();
            AStream.of((Iterable)path.getLast().getDescendants()).filter(NetTable::isSubstrate).sorted().forEach(d -> {
                Icon icon = DbExplorerPanel.getIconForTemplate(d.getTemplate());
                AList.AListItem i = new AList.AListItem(d.getName(), icon, d);
                i.setIsSelected(true);
                v.add(i);
            });
            this.mChildDevices.setListData(v);
            this.mChildDevices.updateUI();
        }

        public boolean exportSeparateDeviceName() {
            return this.mSeparateDeviceName.isSelected();
        }

        protected class SimpleDevicePathName {
            protected DevicePath mDevicepath;

            SimpleDevicePathName(DevicePath path) {
                this.mDevicepath = path;
            }

            public String toString() {
                if (this.mDevicepath == null) {
                    return null;
                }
                String name = this.mDevicepath.toString();
                int i = name.lastIndexOf("/");
                return name.substring(i + 1);
            }
        }

        protected class IconRender
        extends DefaultTreeCellRenderer {
            protected IconRender() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Object o = node.getUserObject();
                if (o instanceof SimpleDevicePathName) {
                    SimpleDevicePathName nodeInfo = (SimpleDevicePathName)o;
                    Icon icon = DbExplorerPanel.getIconForTemplate(nodeInfo.mDevicepath.getLast().getTemplate());
                    this.setIcon(icon);
                }
                return this;
            }
        }
    }
}

