/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.ui;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.APatternHelpButton;
import com.sigrity.acl.ui.ATextField;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DbObjectKeyComparator;
import com.sigrity.tools.dbexplorer.DbExplorerPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;

public class DeviceTemplateChooser {
    protected static final int COLS_FILTER = 6;

    public static DeviceTemplate choose(Component owner, Db db) {
        return DeviceTemplateChooser.choose(owner, db, null);
    }

    public static DeviceTemplate choose(Component owner, Db db, DeviceTemplate initialDevice) {
        return DeviceTemplateChooser.choose(owner, db, initialDevice, null);
    }

    public static DeviceTemplate choose(Component owner, Db db, DeviceTemplate initialDevice, String title) {
        DTCDlg dlg = new DTCDlg(db, owner);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getSelectedTemplate();
    }

    public static DeviceTemplate choose(Component owner, Db db, DeviceTemplate initialDevice, String title, Function<DeviceTemplate, Boolean> filter) {
        DTCDlg dlg = new DTCDlg(db, owner, filter);
        if (title != null) {
            dlg.setTitle(title);
        }
        dlg.setModal(true);
        dlg.setVisible(true);
        return dlg.getSelectedTemplate();
    }

    public static class DTComponent
    extends JPanel {
        protected Db mDb;
        protected DeviceTemplate mTemplate;
        protected String mUserFilter = null;
        protected JTextField mTxtDisplay;
        protected JButton mBtnBrowse;
        GridBagManager.GridBagConstraintsEx FILLX_NOLEFTINSET;
        GridBagManager.GridBagConstraintsEx RIGHT_NORIGHTINSET;
        protected ActionListener mBrowse;
        protected LinkedHashSet<UpdateListener> mUpdateListeners;

        public DTComponent(Db db) {
            this.FILLX_NOLEFTINSET = GridBagManager.FILLX.insets(GridBagManager.FILLX.insets.top, 0, GridBagManager.FILLX.insets.bottom, GridBagManager.FILLX.insets.right);
            this.RIGHT_NORIGHTINSET = GridBagManager.RIGHT.insets(GridBagManager.RIGHT.insets.top, GridBagManager.RIGHT.insets.left, GridBagManager.RIGHT.insets.bottom, 0);
            this.mBrowse = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.fireInitBrowse();
                    DTCDlg dlg = new DTCDlg(mDb, this);
                    dlg.setTitle("Choose Template");
                    dlg.setModal(true);
                    dlg.setUserFilter(mUserFilter);
                    dlg.setVisible(true);
                    mUserFilter = dlg.getUserFilter();
                    DeviceTemplate selected = dlg.getSelectedTemplate();
                    if (selected != null && mTemplate != selected) {
                        this.setDeviceTemplate(selected);
                    }
                }
            };
            this.mUpdateListeners = new LinkedHashSet();
            this.mDb = db;
            GridBagManager l = GridBagManager.layout((Container)this);
            this.mTxtDisplay = (JTextField)l.add((Component)new JTextField(30), (GridBagConstraints)this.FILLX_NOLEFTINSET);
            this.mTxtDisplay.setEditable(false);
            this.mBtnBrowse = (JButton)l.add((Component)new JButton("Browse"), (GridBagConstraints)this.RIGHT_NORIGHTINSET);
            this.mBtnBrowse.addActionListener(this.mBrowse);
            this.setMinimumSize(this.getPreferredSize());
            this.setDeviceTemplate(null);
        }

        public void setDeviceTemplate(DeviceTemplate t) {
            this.mTemplate = t;
            this.mTxtDisplay.setText(this.mTemplate == null ? "" : this.mTemplate.getName());
            this.fireUpdate();
        }

        public DeviceTemplate getDeviceTemplate() {
            return this.mTemplate;
        }

        public void setUserFilter(String userFilter) {
            this.mUserFilter = userFilter;
        }

        public String getUserFilter() {
            return this.mUserFilter;
        }

        public void addUpdateListener(UpdateListener l) {
            this.mUpdateListeners.add(l);
        }

        public void removeUpdateListener(UpdateListener l) {
            this.mUpdateListeners.remove(l);
        }

        protected void fireUpdate() {
            for (UpdateListener l : this.mUpdateListeners) {
                l.templateUpdated(this);
            }
        }

        protected void fireInitBrowse() {
            for (UpdateListener l : this.mUpdateListeners) {
                l.initBrowse(this);
            }
        }

        public static interface UpdateListener {
            public void initBrowse(DTComponent var1);

            public void templateUpdated(DTComponent var1);
        }
    }

    public static class DTCPanel
    extends JPanel {
        protected JPanel mTemplatePanel;
        protected ATextField mTxtFilter;
        protected JList<DeviceTemplate> mList;
        protected JLabel mLblStatus;
        protected DeviceTemplate mSpecial = null;
        protected Filter mFilter = null;
        protected Supplier<Stream<DeviceTemplate>> mAllTemplatesSupplier;
        protected ArrayList<DeviceTemplate> mAllTemplates;
        protected Runnable mDoUpdateFilteredData = new Runnable(){

            @Override
            public void run() {
                this.updateFilteredData();
            }
        };
        protected ListCellRenderer<Object> mListCellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)null, index, isSelected, cellHasFocus);
                if (value instanceof DeviceTemplate) {
                    DeviceTemplate dt = (DeviceTemplate)value;
                    Object text = dt.getName();
                    Substrate subst = dt.getSubstrate();
                    if (subst != null) {
                        text = (String)text + String.format(" (%s)", subst.getName());
                    }
                    this.setText((String)text);
                    this.setIcon(DbExplorerPanel.getIconForTemplate(dt));
                } else {
                    this.setText("<INVALID>");
                    this.setIcon(null);
                }
                return this;
            }
        };

        public DTCPanel(Db db) {
            this(() -> db.getObjects(DeviceTemplate.class).stream());
        }

        public DTCPanel(Supplier<Stream<DeviceTemplate>> availableTemplates) {
            this.mAllTemplatesSupplier = availableTemplates;
            GridBagManager l = GridBagManager.layout((Container)this);
            this.setBorder(BorderFactory.createTitledBorder("Device Templates"));
            this.mTxtFilter = new ATextField(6);
            l.add("Name filter:", (Component)this.mTxtFilter, (GridBagConstraints)GridBagManager.FILLX);
            this.mTxtFilter.setActionHandler(this.mDoUpdateFilteredData);
            this.mTxtFilter.setInvokeActionOnTextUpdate(true);
            l.add((Component)new APatternHelpButton(), (GridBagConstraints)GridBagManager.RIGHT);
            l.newline();
            this.mList = new JList();
            JScrollPane spList = new JScrollPane(this.mList);
            l.add((Component)spList, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mList.setSelectionMode(0);
            this.mList.setCellRenderer(this.mListCellRenderer);
            l.newline();
            this.mLblStatus = (JLabel)l.add((Component)new JLabel(), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        }

        public DeviceTemplate getSelectedTemplate() {
            DeviceTemplate o = this.mList.getSelectedValue();
            if (o instanceof DeviceTemplate) {
                return o;
            }
            return null;
        }

        public DeviceTemplate setSelectedTemplate(DeviceTemplate devT) {
            if (devT == null) {
                this.mList.clearSelection();
            } else {
                this.mList.setSelectedValue(devT, true);
            }
            return this.getSelectedTemplate();
        }

        public void updateAllTemplates() {
            Stream<DeviceTemplate> allTemplates = this.mAllTemplatesSupplier.get();
            if (this.mFilter != null) {
                allTemplates = allTemplates.filter(t -> this.mFilter.include((DeviceTemplate)t));
            }
            allTemplates = allTemplates.sorted(new DbObjectKeyComparator());
            if (this.mSpecial != null) {
                allTemplates = Stream.concat(Stream.of(this.mSpecial), allTemplates);
            }
            this.mAllTemplates = allTemplates.collect(Collectors.toCollection(ArrayList::new));
            this.updateFilteredData();
        }

        public void addDblClickTemplateListener(final ActionListener l) {
            this.mList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DeviceTemplate st = this.getSelectedTemplate();
                        l.actionPerformed(new ActionEvent(mList, 1001, st == null ? "" : st.getName()));
                    }
                }
            });
        }

        public void addSelectionListener(ListSelectionListener l) {
            this.mList.getSelectionModel().addListSelectionListener(l);
        }

        public void removeSelectionListener(ListSelectionListener l) {
            this.mList.getSelectionModel().removeListSelectionListener(l);
        }

        protected void updateFilteredData() {
            if (!this.mTxtFilter.isEnabled()) {
                return;
            }
            DeviceTemplate selected = this.mList.getSelectedValue();
            Object filter = this.mTxtFilter.getText();
            if (((String)filter).length() == 0) {
                this.mList.setModel(new DTListModel(this.mAllTemplates));
                this.setStatus("");
                return;
            }
            if (!(((String)filter).contains("\\") || ((String)filter).contains(".") || ((String)filter).contains("["))) {
                filter = (String)filter + ".*";
            }
            try {
                Pattern pattern = Pattern.compile((String)filter);
                ArrayList<DeviceTemplate> filteredData = new ArrayList<DeviceTemplate>(this.mAllTemplates.size());
                for (DeviceTemplate t : this.mAllTemplates) {
                    if (t == this.mSpecial) {
                        filteredData.add(t);
                        continue;
                    }
                    if (!pattern.matcher(t.getName()).matches()) continue;
                    filteredData.add(t);
                }
                this.mList.setModel(new DTListModel(filteredData));
                this.setStatus("List filtered.");
            }
            catch (PatternSyntaxException e) {
                this.setStatus("Invalid pattern, all templates displayed.");
                this.mList.setModel(new DTListModel(this.mAllTemplates));
                this.mTxtFilter.requestFocus();
                return;
            }
            this.mList.setSelectedValue(selected, true);
        }

        protected void setStatus(String text) {
            this.mLblStatus.setVisible(text != null && text.length() > 0);
            this.mLblStatus.setText(text);
        }

        @Override
        public void addNotify() {
            this.updateAllTemplates();
            super.addNotify();
        }

        protected class DTListModel
        extends AbstractListModel<DeviceTemplate> {
            protected ArrayList<DeviceTemplate> mData;

            public DTListModel(ArrayList<DeviceTemplate> templates) {
                this.mData = templates;
            }

            @Override
            public DeviceTemplate getElementAt(int index) {
                return this.mData.get(index);
            }

            @Override
            public int getSize() {
                return this.mData.size();
            }
        }
    }

    public static class DTCDlg
    extends DbDialog {
        protected DTCPanel mChooserPanel;
        protected DeviceTemplate mSelectedTemplate = null;
        protected ActionListener mOkListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                mSelectedTemplate = mChooserPanel.getSelectedTemplate();
                if (mSelectedTemplate == null) {
                    JOptionPane.showConfirmDialog((Component)((Object)this), "No template selected.", "Error", 0, 0);
                    return;
                }
                UIUtil.closeWindow((Window)((Object)this));
            }
        };

        public DTCDlg(Db db, Component owner) {
            this(db, owner, x -> true);
        }

        public DTCDlg(Db db, Component owner, Function<DeviceTemplate, Boolean> filter) {
            super(db, owner, "Select Device Template");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            this.mChooserPanel = (DTCPanel)l.add((Component)new DTCPanel(() -> db.getObjects(DeviceTemplate.class).stream().filter(x -> filter == null || (Boolean)filter.apply((DeviceTemplate)x) != false)), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mChooserPanel.addDblClickTemplateListener(this.mOkListener);
            l.newline();
            l.addFillX();
            JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
            btnOk.addActionListener(this.mOkListener);
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnCancel, (JButton)btnOk);
        }

        public DeviceTemplate getSelectedTemplate() {
            return this.mSelectedTemplate;
        }

        public String getUserFilter() {
            if (this.mChooserPanel == null || this.mChooserPanel.mTxtFilter == null) {
                return null;
            }
            return this.mChooserPanel.mTxtFilter.getText();
        }

        public void setUserFilter(String filter) {
            if (this.mChooserPanel == null || this.mChooserPanel.mTxtFilter == null) {
                return;
            }
            this.mChooserPanel.mTxtFilter.setText(filter);
        }

        public void addNotify() {
            super.addNotify();
            this.pack();
            UIUtil.center((Component)((Object)this));
        }
    }

    public static interface Filter {
        public boolean include(DeviceTemplate var1);
    }
}

